/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk.migration;

import java.io.Serializable;
import java.util.Collection;
import kafka.security.authorizer.AclAuthorizer;
import kafka.security.authorizer.AclEntry;
import kafka.security.authorizer.AclEntry$;
import kafka.zk.migration.ZkMigrationTestHarness;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.metadata.AccessControlEntryRecord;
import org.apache.kafka.common.metadata.RemoveAccessControlEntryRecord;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.metadata.migration.KRaftMigrationZkWriter;
import org.apache.kafka.metadata.migration.MigrationClient;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Set;
import scala.collection.SetOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005md\u0001B\b\u0011\u0001]AQ\u0001\b\u0001\u0005\u0002uAQa\b\u0001\u0005\u0002\u0001BQa\u0013\u0001\u0005\u00021CQ\u0001\u001c\u0001\u0005\u00025DQ\u0001\u001d\u0001\u0005\u0002EDQ! \u0001\u0005\u0002EDaa \u0001\u0005\u0002\u0005\u0005\u0001BB!\u0001\t\u0003\tY\u0001C\u0005\u0002L\u0001\t\n\u0011\"\u0001\u0002N!I\u00111\r\u0001\u0012\u0002\u0013\u0005\u0011Q\r\u0005\n\u0003S\u0002\u0011\u0013!C\u0001\u0003WBa!a\u001c\u0001\t\u0003\t\bBBA:\u0001\u0011\u0005\u0011\u000f\u0003\u0004\u0002x\u0001!\t!\u001d\u0002\u00195.\f5\r\\'jOJ\fG/[8o\u00072LWM\u001c;UKN$(BA\t\u0013\u0003%i\u0017n\u001a:bi&|gN\u0003\u0002\u0014)\u0005\u0011!p\u001b\u0006\u0002+\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u0019!\tI\"$D\u0001\u0011\u0013\tY\u0002C\u0001\f[W6KwM]1uS>tG+Z:u\u0011\u0006\u0014h.Z:t\u0003\u0019a\u0014N\\5u}Q\ta\u0004\u0005\u0002\u001a\u0001\u0005!R.[4sCR,\u0017i\u00197t\u0003:$g+\u001a:jMf$2!I\u00141!\t\u0011S%D\u0001$\u0015\u0005!\u0013!B:dC2\f\u0017B\u0001\u0014$\u0005\u0011)f.\u001b;\t\u000b!\u0012\u0001\u0019A\u0015\u0002\u0015\u0005,H\u000f[8sSj,'\u000f\u0005\u0002+]5\t1F\u0003\u0002)Y)\u0011Q\u0006F\u0001\tg\u0016\u001cWO]5us&\u0011qf\u000b\u0002\u000e\u0003\u000ed\u0017)\u001e;i_JL'0\u001a:\t\u000bE\u0012\u0001\u0019\u0001\u001a\u0002\t\u0005\u001cGn\u001d\t\u0004gmrdB\u0001\u001b:\u001d\t)\u0004(D\u00017\u0015\t9d#\u0001\u0004=e>|GOP\u0005\u0002I%\u0011!hI\u0001\ba\u0006\u001c7.Y4f\u0013\taTHA\u0002TKFT!AO\u0012\u0011\u0005}JU\"\u0001!\u000b\u0005\u0005\u0013\u0015aA1dY*\u00111\tR\u0001\u0007G>lWn\u001c8\u000b\u0005U)%B\u0001$H\u0003\u0019\t\u0007/Y2iK*\t\u0001*A\u0002pe\u001eL!A\u0013!\u0003\u0015\u0005\u001bGNQ5oI&tw-\u0001\u0011sKBd\u0017mY3BG2\u001c\u0018I\u001c3SK\u0006$w+\u001b;i\u0003V$\bn\u001c:ju\u0016\u0014H#B'V-z#\u0007c\u0001(S}9\u0011q\n\u0015\t\u0003k\rJ!!U\u0012\u0002\rA\u0013X\rZ3g\u0013\t\u0019FKA\u0002TKRT!!U\u0012\t\u000b!\u001a\u0001\u0019A\u0015\t\u000b]\u001b\u0001\u0019\u0001-\u0002\u001fI,7o\\;sG\u0016\u0004\u0016\r\u001e;fe:\u0004\"!\u0017/\u000e\u0003iS!a\u0017\"\u0002\u0011I,7o\\;sG\u0016L!!\u0018.\u0003\u001fI+7o\\;sG\u0016\u0004\u0016\r\u001e;fe:DQaX\u0002A\u0002\u0001\fA!Y2fgB\u00191gO1\u0011\u0005}\u0012\u0017BA2A\u0005I\t5mY3tg\u000e{g\u000e\u001e:pY\u0016sGO]=\t\u000b\u0015\u001c\u0001\u0019\u00014\u0002\tA\u0014X\r\u001a\t\u0005E\u001dl\u0015.\u0003\u0002iG\tIa)\u001e8di&|g.\r\t\u0003E)L!a[\u0012\u0003\u000f\t{w\u000e\\3b]\u0006\u0019C-\u001a7fi\u0016\u0014Vm]8ve\u000e,\u0017I\u001c3SK\u0006$w+\u001b;i\u0003V$\bn\u001c:ju\u0016\u0014HcA\u0011o_\")\u0001\u0006\u0002a\u0001S!)q\u000b\u0002a\u00011\u0006YB/Z:u\u0003\u000ed7/T5he\u0006$X-\u00118e\tV\fGn\u0016:ji\u0016$\u0012!\t\u0015\u0003\u000bM\u0004\"\u0001^>\u000e\u0003UT!A^<\u0002\u0007\u0005\u0004\u0018N\u0003\u0002ys\u00069!.\u001e9ji\u0016\u0014(B\u0001>H\u0003\u0015QWO\\5u\u0013\taXO\u0001\u0003UKN$\u0018!\u0007;fgR\f5\r\\:DQ\u0006tw-Z:J]Ns\u0017\r]:i_RD#AB:\u0002\tU\u001cXM\u001d\u000b\u0005\u0003\u0007\tI\u0001E\u0002O\u0003\u000bI1!a\u0002U\u0005\u0019\u0019FO]5oO\"1qp\u0002a\u0001\u0003\u0007!\u0002#!\u0004\u0002\u001a\u0005u\u0011qEA\u0018\u0003g\t9$!\u0011\u0011\t\u0005=\u0011QC\u0007\u0003\u0003#Q1!a\u0005C\u0003!iW\r^1eCR\f\u0017\u0002BA\f\u0003#\u0011\u0001$Q2dKN\u001c8i\u001c8ue>dWI\u001c;ssJ+7m\u001c:e\u0011\u001d\tY\u0002\u0003a\u0001\u0003\u0007\tAB]3t_V\u00148-\u001a(b[\u0016Dq!a\b\t\u0001\u0004\t\t#\u0001\u0007sKN|WO]2f)f\u0004X\rE\u0002Z\u0003GI1!!\n[\u00051\u0011Vm]8ve\u000e,G+\u001f9f\u0011\u00199\u0006\u00021\u0001\u0002*A\u0019\u0011,a\u000b\n\u0007\u00055\"LA\u0006QCR$XM\u001d8UsB,\u0007bBA\u0019\u0011\u0001\u0007\u00111A\u0001\naJLgnY5qC2D\u0011\"!\u000e\t!\u0003\u0005\r!a\u0001\u0002\t!|7\u000f\u001e\u0005\n\u0003sA\u0001\u0013!a\u0001\u0003w\t\u0011b\u001c9fe\u0006$\u0018n\u001c8\u0011\u0007}\ni$C\u0002\u0002@\u0001\u0013A\"Q2m\u001fB,'/\u0019;j_:D\u0011\"a\u0011\t!\u0003\u0005\r!!\u0012\u0002\u001dA,'/\\5tg&|g\u000eV=qKB\u0019q(a\u0012\n\u0007\u0005%\u0003IA\tBG2\u0004VM]7jgNLwN\u001c+za\u0016\fQ\"Y2mI\u0011,g-Y;mi\u0012*TCAA(U\u0011\t\u0019!!\u0015,\u0005\u0005M\u0003\u0003BA+\u0003?j!!a\u0016\u000b\t\u0005e\u00131L\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u0018$\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003C\n9FA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fQ\"Y2mI\u0011,g-Y;mi\u00122TCAA4U\u0011\tY$!\u0015\u0002\u001b\u0005\u001cG\u000e\n3fM\u0006,H\u000e\u001e\u00138+\t\tiG\u000b\u0003\u0002F\u0005E\u0013A\u0006;fgR$U\r\\3uK>sW-Q2m\u001f\u001al\u0015M\\=)\u00051\u0019\u0018A\u0006;fgR\f5\r\\+qI\u0006$X-\u00118e\t\u0016dW\r^3)\u00055\u0019\u0018\u0001\u000b;fgR\f5\r\\+qI\u0006$X-\u00118e\t\u0016dW\r^3XSRD7\t\\;ti\u0016\u0014H*\u001b8l\u0013\u0012\u001c\bF\u0001\bt\u0001")
public class ZkAclMigrationClientTest
extends ZkMigrationTestHarness {
    public void migrateAclsAndVerify(AclAuthorizer authorizer, Seq<AclBinding> acls) {
        authorizer.createAcls(null, CollectionConverters$.MODULE$.SeqHasAsJava(acls).asJava());
        ArrayBuffer batches = new ArrayBuffer();
        this.migrationClient().migrateAcls(batch -> batches.append((Object)CollectionConverters$.MODULE$.ListHasAsScala(batch).asScala()));
        ArrayBuffer records = (ArrayBuffer)((StrictOptimizedIterableOps)batches.flatten(Predef$.MODULE$.$conforms())).map((Function1 & Serializable)x$1 -> (AccessControlEntryRecord)x$1.message());
        Assertions.assertEquals((int)acls.size(), (int)records.size(), (String)"Expected one record for each ACLBinding");
    }

    /*
     * WARNING - void declaration
     */
    public scala.collection.immutable.Set<AclBinding> replaceAclsAndReadWithAuthorizer(AclAuthorizer authorizer, ResourcePattern resourcePattern, Seq<AccessControlEntry> aces, Function1<scala.collection.immutable.Set<AclBinding>, Object> pred) {
        void var7_11;
        Tuple2 tuple2;
        AclBindingFilter resourceFilter = new AclBindingFilter(new ResourcePatternFilter(resourcePattern.resourceType(), resourcePattern.name(), resourcePattern.patternType()), AclBindingFilter.ANY.entryFilter());
        this.migrationState_$eq(this.migrationClient().aclClient().writeResourceAcls(resourcePattern, (Collection)CollectionConverters$.MODULE$.SeqHasAsJava(aces).asJava(), this.migrationState()));
        long l = 100L;
        long computeUntilTrue_waitTime = 15000L;
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            scala.collection.immutable.Set computeUntilTrue_result;
            if (BoxesRunTime.unboxToBoolean((Object)pred.apply((Object)(computeUntilTrue_result = ZkAclMigrationClientTest.$anonfun$replaceAclsAndReadWithAuthorizer$1(authorizer, resourceFilter))))) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        Object var14_9 = null;
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        scala.collection.immutable.Set acls = (scala.collection.immutable.Set)tuple22._1();
        Assertions.assertTrue((boolean)tuple22._2$mcZ$sp());
        return var7_11;
    }

    /*
     * WARNING - void declaration
     */
    public void deleteResourceAndReadWithAuthorizer(AclAuthorizer authorizer, ResourcePattern resourcePattern) {
        void var5_9;
        Tuple2 tuple2;
        AclBindingFilter resourceFilter = new AclBindingFilter(new ResourcePatternFilter(resourcePattern.resourceType(), resourcePattern.name(), resourcePattern.patternType()), AclBindingFilter.ANY.entryFilter());
        this.migrationState_$eq(this.migrationClient().aclClient().deleteResource(resourcePattern, this.migrationState()));
        long l = 100L;
        long computeUntilTrue_waitTime = 15000L;
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            scala.collection.immutable.Set computeUntilTrue_result;
            if ((computeUntilTrue_result = ZkAclMigrationClientTest.$anonfun$deleteResourceAndReadWithAuthorizer$1(authorizer, resourceFilter)).isEmpty()) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        Object var12_7 = null;
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        boolean ok = tuple22._2$mcZ$sp();
        Assertions.assertTrue((boolean)var5_9);
    }

    @Test
    public void testAclsMigrateAndDualWrite() {
        ResourcePattern resource1 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("foo-").append(Uuid.randomUuid()).toString(), PatternType.LITERAL);
        ResourcePattern resource2 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("bar-").append(Uuid.randomUuid()).toString(), PatternType.LITERAL);
        ResourcePattern resource3 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("baz-").append(Uuid.randomUuid()).toString(), PatternType.LITERAL);
        ResourcePattern resource4 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(5).append("test-").append(Uuid.randomUuid()).toString(), PatternType.LITERAL);
        ResourcePattern prefixedResource = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("bar-").append(Uuid.randomUuid()).toString(), PatternType.PREFIXED);
        String username = "alice";
        KafkaPrincipal principal = new KafkaPrincipal("User", username);
        KafkaPrincipal wildcardPrincipal = SecurityUtils.parseKafkaPrincipal((String)AclEntry$.MODULE$.WildcardPrincipalString());
        AccessControlEntry ace1 = new AccessControlEntry(principal.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        AclBinding acl1 = new AclBinding(resource1, ace1);
        AccessControlEntry ace2 = new AccessControlEntry(principal.toString(), "192.168.0.1", AclOperation.WRITE, AclPermissionType.ALLOW);
        AclBinding acl2 = new AclBinding(resource1, ace2);
        AclBinding acl3 = new AclBinding(resource2, new AccessControlEntry(principal.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.DESCRIBE, AclPermissionType.ALLOW));
        AclBinding acl4 = new AclBinding(prefixedResource, new AccessControlEntry(wildcardPrincipal.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW));
        try (AclAuthorizer authorizer = new AclAuthorizer();){
            authorizer.configure(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"zookeeper.connect"), (Object)this.zkConnect())}))).asJava());
            this.migrateAclsAndVerify(authorizer, (Seq<AclBinding>)new .colon.colon((Object)acl1, (List)new .colon.colon((Object)acl2, (List)new .colon.colon((Object)acl3, (List)new .colon.colon((Object)acl4, (List)Nil$.MODULE$)))));
            Assertions.assertTrue((boolean)this.replaceAclsAndReadWithAuthorizer(authorizer, resource1, (Seq<AccessControlEntry>)new .colon.colon((Object)ace1, (List)Nil$.MODULE$), (Function1<scala.collection.immutable.Set<AclBinding>, Object>)(Function1 & Serializable)acls -> BoxesRunTime.boxToBoolean((boolean)ZkAclMigrationClientTest.$anonfun$testAclsMigrateAndDualWrite$1(acls))).contains((Object)acl1));
            this.deleteResourceAndReadWithAuthorizer(authorizer, resource1);
            AccessControlEntry newAce1 = new AccessControlEntry(principal.toString(), "10.0.0.1", AclOperation.WRITE, AclPermissionType.ALLOW);
            Assertions.assertTrue((boolean)((SetOps)this.replaceAclsAndReadWithAuthorizer(authorizer, resource1, (Seq<AccessControlEntry>)new .colon.colon((Object)newAce1, (List)Nil$.MODULE$), (Function1<scala.collection.immutable.Set<AclBinding>, Object>)(Function1 & Serializable)acls -> BoxesRunTime.boxToBoolean((boolean)ZkAclMigrationClientTest.$anonfun$testAclsMigrateAndDualWrite$2(acls))).map((Function1 & Serializable)x$4 -> x$4.entry())).contains((Object)newAce1));
            AccessControlEntry newAce2 = new AccessControlEntry(principal.toString(), "10.0.0.1", AclOperation.WRITE, AclPermissionType.ALLOW);
            Assertions.assertTrue((boolean)((SetOps)this.replaceAclsAndReadWithAuthorizer(authorizer, resource2, (Seq<AccessControlEntry>)new .colon.colon((Object)acl3.entry(), (List)new .colon.colon((Object)newAce2, (List)Nil$.MODULE$)), (Function1<scala.collection.immutable.Set<AclBinding>, Object>)(Function1 & Serializable)acls -> BoxesRunTime.boxToBoolean((boolean)ZkAclMigrationClientTest.$anonfun$testAclsMigrateAndDualWrite$4(acls))).map((Function1 & Serializable)x$5 -> x$5.entry())).subsetOf((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl3.entry(), newAce2}))));
            Uuid linkId1 = Uuid.randomUuid();
            Uuid linkId2 = Uuid.randomUuid();
            AccessControlEntry linkedAce1 = new AccessControlEntry(principal.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW, (Collection)CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Uuid[]{Uuid.ZERO_UUID, linkId1}))).asJava());
            scala.collection.immutable.Set<AclBinding> resource3Acls = this.replaceAclsAndReadWithAuthorizer(authorizer, resource3, (Seq<AccessControlEntry>)new .colon.colon((Object)linkedAce1, (List)Nil$.MODULE$), (Function1<scala.collection.immutable.Set<AclBinding>, Object>)(Function1 & Serializable)acls -> BoxesRunTime.boxToBoolean((boolean)ZkAclMigrationClientTest.$anonfun$testAclsMigrateAndDualWrite$6(acls)));
            Assertions.assertEquals((Object)linkedAce1, (Object)((AclBinding)resource3Acls.head()).entry());
            AccessControlEntry linkedAce2 = new AccessControlEntry(principal.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW, (Collection)CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Uuid[]{linkId2}))).asJava());
            scala.collection.immutable.Set<AclBinding> resource4Acls = this.replaceAclsAndReadWithAuthorizer(authorizer, resource4, (Seq<AccessControlEntry>)new .colon.colon((Object)linkedAce2, (List)Nil$.MODULE$), (Function1<scala.collection.immutable.Set<AclBinding>, Object>)(Function1 & Serializable)acls -> BoxesRunTime.boxToBoolean((boolean)ZkAclMigrationClientTest.$anonfun$testAclsMigrateAndDualWrite$7(acls)));
            Assertions.assertEquals((Object)linkedAce2, (Object)((AclBinding)resource4Acls.head()).entry());
            resource3Acls = this.replaceAclsAndReadWithAuthorizer(authorizer, resource3, (Seq<AccessControlEntry>)new .colon.colon((Object)SecurityUtils.aceWithoutLinkId((AccessControlEntry)linkedAce1), (List)Nil$.MODULE$), (Function1<scala.collection.immutable.Set<AclBinding>, Object>)(Function1 & Serializable)acls -> BoxesRunTime.boxToBoolean((boolean)ZkAclMigrationClientTest.$anonfun$testAclsMigrateAndDualWrite$8(linkedAce1, acls)));
            Assertions.assertEquals((Object)SecurityUtils.aceWithoutLinkId((AccessControlEntry)linkedAce1), (Object)((AclBinding)resource3Acls.head()).entry());
            this.deleteResourceAndReadWithAuthorizer(authorizer, resource4);
        }
    }

    @Test
    public void testAclsChangesInSnapshot() {
        ResourcePattern resource1 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("foo-").append(Uuid.randomUuid()).toString(), PatternType.LITERAL);
        ResourcePattern resource2 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("bar-").append(Uuid.randomUuid()).toString(), PatternType.LITERAL);
        ResourcePattern resource3 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("baz-").append(Uuid.randomUuid()).toString(), PatternType.LITERAL);
        String username1 = "alice";
        String username2 = "blah";
        KafkaPrincipal principal1 = new KafkaPrincipal("User", username1);
        KafkaPrincipal principal2 = new KafkaPrincipal("User", username2);
        AclEntry acl1Resource1 = new AclEntry(new AccessControlEntry(principal1.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.WRITE, AclPermissionType.ALLOW), resource1);
        AclEntry acl1Resource2 = new AclEntry(new AccessControlEntry(principal2.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW), resource2);
        this.zkClient().createAclPaths();
        this.zkClient().createAclsForResourceIfNotExists(resource1, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclEntry[]{acl1Resource1})));
        this.zkClient().createAclsForResourceIfNotExists(resource2, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclEntry[]{acl1Resource2})));
        MetadataDelta delta = new MetadataDelta.Builder().setImage(MetadataImage.EMPTY).build();
        AccessControlEntryRecord acl1Resource3 = new AccessControlEntryRecord().setId(Uuid.randomUuid()).setHost("192.168.10.1").setOperation(AclOperation.READ.code()).setPrincipal(AclEntry$.MODULE$.WildcardPrincipalString()).setPermissionType(AclPermissionType.ALLOW.code()).setPatternType(resource3.patternType().code()).setResourceName(resource3.name()).setResourceType(resource3.resourceType().code());
        delta.replay(acl1Resource3);
        AccessControlEntryRecord acl2Resource1 = new AccessControlEntryRecord().setId(Uuid.randomUuid()).setHost("192.168.15.1").setOperation(AclOperation.WRITE.code()).setPrincipal(principal1.toString()).setPermissionType(AclPermissionType.ALLOW.code()).setPatternType(resource1.patternType().code()).setResourceName(resource1.name()).setResourceType(resource1.resourceType().code());
        delta.replay(acl2Resource1);
        MetadataImage image = delta.apply(MetadataProvenance.EMPTY);
        new KRaftMigrationZkWriter((MigrationClient)this.migrationClient(), x$6 -> Assertions.fail((String)x$6)).handleSnapshot(image, (x$7, x$8, operation) -> this.migrationState_$eq(operation.apply(this.migrationState())));
        scala.collection.immutable.Set resource1AclsInZk = this.zkClient().getVersionedAclsForResource(resource1).acls();
        Assertions.assertEquals((int)1, (int)resource1AclsInZk.size());
        Assertions.assertEquals((Object)new AccessControlEntry(acl2Resource1.principal(), acl2Resource1.host(), AclOperation.fromCode((byte)acl2Resource1.operation()), AclPermissionType.fromCode((byte)acl2Resource1.permissionType())), (Object)((AclEntry)resource1AclsInZk.head()).ace());
        Assertions.assertTrue((boolean)this.zkClient().getVersionedAclsForResource(resource2).acls().isEmpty());
        scala.collection.immutable.Set resource3AclsInZk = this.zkClient().getVersionedAclsForResource(resource3).acls();
        Assertions.assertEquals((Object)new AccessControlEntry(acl1Resource3.principal(), acl1Resource3.host(), AclOperation.fromCode((byte)acl1Resource3.operation()), AclPermissionType.fromCode((byte)acl1Resource3.permissionType())), (Object)((AclEntry)resource3AclsInZk.head()).ace());
    }

    public String user(String user) {
        return new KafkaPrincipal("User", user).toString();
    }

    public AccessControlEntryRecord acl(String resourceName, ResourceType resourceType, PatternType resourcePattern, String principal, String host, AclOperation operation, AclPermissionType permissionType) {
        return new AccessControlEntryRecord().setId(Uuid.randomUuid()).setHost(host).setOperation(operation.code()).setPrincipal(principal).setPermissionType(permissionType.code()).setPatternType(resourcePattern.code()).setResourceName(resourceName).setResourceType(resourceType.code());
    }

    public String acl$default$5() {
        return "*";
    }

    public AclOperation acl$default$6() {
        return AclOperation.READ;
    }

    public AclPermissionType acl$default$7() {
        return AclPermissionType.ALLOW;
    }

    @Test
    public void testDeleteOneAclOfMany() {
        this.zkClient().createAclPaths();
        String topicName = new StringBuilder(6).append("topic-").append(Uuid.randomUuid()).toString();
        ResourcePattern resource = new ResourcePattern(ResourceType.TOPIC, topicName, PatternType.LITERAL);
        MetadataDelta delta = new MetadataDelta.Builder().build();
        AccessControlEntryRecord acl1 = this.acl(topicName, ResourceType.TOPIC, PatternType.LITERAL, this.user("alice"), this.acl$default$5(), this.acl$default$6(), this.acl$default$7());
        AccessControlEntryRecord acl2 = this.acl(topicName, ResourceType.TOPIC, PatternType.LITERAL, this.user("bob"), this.acl$default$5(), this.acl$default$6(), this.acl$default$7());
        AccessControlEntryRecord acl3 = this.acl(topicName, ResourceType.TOPIC, PatternType.LITERAL, this.user("carol"), this.acl$default$5(), this.acl$default$6(), this.acl$default$7());
        delta.replay(acl1);
        delta.replay(acl2);
        delta.replay(acl3);
        MetadataImage image = delta.apply(MetadataProvenance.EMPTY);
        Buffer errorLogs = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        KRaftMigrationZkWriter kraftMigrationZkWriter = new KRaftMigrationZkWriter((MigrationClient)this.migrationClient(), msg -> errorLogs.append(msg));
        kraftMigrationZkWriter.handleSnapshot(image, (x$9, x$10, operation) -> this.migrationState_$eq(operation.apply(this.migrationState())));
        scala.collection.immutable.Set aclsInZk = this.zkClient().getVersionedAclsForResource(resource).acls();
        Assertions.assertEquals((int)3, (int)aclsInZk.size());
        MetadataDelta delta2 = new MetadataDelta.Builder().setImage(image).build();
        delta2.replay(new RemoveAccessControlEntryRecord().setId(acl3.id()));
        MetadataImage image2 = delta2.apply(MetadataProvenance.EMPTY);
        kraftMigrationZkWriter.handleDelta(image, image2, delta2, (x$11, x$12, operation) -> this.migrationState_$eq(operation.apply(this.migrationState())));
        scala.collection.immutable.Set aclsInZk2 = this.zkClient().getVersionedAclsForResource(resource).acls();
        Assertions.assertEquals((int)2, (int)aclsInZk2.size());
        Assertions.assertEquals((int)0, (int)errorLogs.size());
        AccessControlEntryRecord acl4 = this.acl(topicName, ResourceType.TOPIC, PatternType.LITERAL, this.user("carol"), this.acl$default$5(), this.acl$default$6(), this.acl$default$7());
        delta2.replay(acl4);
        MetadataImage image3 = delta2.apply(MetadataProvenance.EMPTY);
        kraftMigrationZkWriter.handleDelta(image3, image3, delta2, (x$13, x$14, operation) -> this.migrationState_$eq(operation.apply(this.migrationState())));
        scala.collection.immutable.Set aclsInZk3 = this.zkClient().getVersionedAclsForResource(resource).acls();
        Assertions.assertEquals((int)3, (int)aclsInZk3.size());
        Assertions.assertEquals((int)1, (int)errorLogs.size());
        Assertions.assertEquals((Object)new StringBuilder(69).append("Cannot delete ACL ").append(acl3.id()).append(" from ZK since it is missing from previous AclImage").toString(), (Object)errorLogs.head());
    }

    @Test
    public void testAclUpdateAndDelete() {
        this.zkClient().createAclPaths();
        Buffer errorLogs = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        KRaftMigrationZkWriter kraftMigrationZkWriter = new KRaftMigrationZkWriter((MigrationClient)this.migrationClient(), msg -> errorLogs.append(msg));
        String topicName = new StringBuilder(6).append("topic-").append(Uuid.randomUuid()).toString();
        String otherName = new StringBuilder(6).append("other-").append(Uuid.randomUuid()).toString();
        ResourcePattern literalResource = new ResourcePattern(ResourceType.TOPIC, topicName, PatternType.LITERAL);
        ResourcePattern prefixedResource = new ResourcePattern(ResourceType.TOPIC, topicName, PatternType.PREFIXED);
        ResourcePattern otherResource = new ResourcePattern(ResourceType.TOPIC, otherName, PatternType.LITERAL);
        AccessControlEntryRecord acl1 = this.acl(topicName, ResourceType.TOPIC, PatternType.LITERAL, this.user("alice"), this.acl$default$5(), this.acl$default$6(), this.acl$default$7());
        AccessControlEntryRecord acl2 = this.acl(topicName, ResourceType.TOPIC, PatternType.LITERAL, this.user("bob"), this.acl$default$5(), this.acl$default$6(), this.acl$default$7());
        AccessControlEntryRecord acl3 = this.acl(topicName, ResourceType.TOPIC, PatternType.LITERAL, this.user("carol"), this.acl$default$5(), this.acl$default$6(), this.acl$default$7());
        AccessControlEntryRecord acl4 = this.acl(topicName, ResourceType.TOPIC, PatternType.LITERAL, this.user("dave"), this.acl$default$5(), this.acl$default$6(), this.acl$default$7());
        MetadataDelta delta1 = new MetadataDelta.Builder().build();
        delta1.replay(acl1);
        delta1.replay(acl2);
        delta1.replay(acl3);
        delta1.replay(acl4);
        MetadataImage image1 = delta1.apply(MetadataProvenance.EMPTY);
        kraftMigrationZkWriter.handleDelta(MetadataImage.EMPTY, image1, delta1, (x$15, x$16, operation) -> this.migrationState_$eq(operation.apply(this.migrationState())));
        Assertions.assertEquals((int)4, (int)this.zkClient().getVersionedAclsForResource(literalResource).acls().size());
        Assertions.assertEquals((int)0, (int)this.zkClient().getVersionedAclsForResource(prefixedResource).acls().size());
        Assertions.assertEquals((int)0, (int)this.zkClient().getVersionedAclsForResource(otherResource).acls().size());
        Assertions.assertEquals((int)0, (int)errorLogs.size());
        AccessControlEntryRecord acl5 = this.acl(topicName, ResourceType.TOPIC, PatternType.PREFIXED, this.user("alice"), this.acl$default$5(), this.acl$default$6(), this.acl$default$7());
        AccessControlEntryRecord acl6 = this.acl(topicName, ResourceType.TOPIC, PatternType.PREFIXED, this.user("bob"), this.acl$default$5(), this.acl$default$6(), this.acl$default$7());
        AccessControlEntryRecord acl7 = this.acl(otherName, ResourceType.TOPIC, PatternType.LITERAL, this.user("carol"), this.acl$default$5(), this.acl$default$6(), this.acl$default$7());
        AccessControlEntryRecord acl8 = this.acl(otherName, ResourceType.TOPIC, PatternType.LITERAL, this.user("dave"), this.acl$default$5(), this.acl$default$6(), this.acl$default$7());
        MetadataDelta delta2 = new MetadataDelta.Builder().setImage(image1).build();
        delta2.replay(acl5);
        delta2.replay(acl6);
        delta2.replay(acl7);
        delta2.replay(acl8);
        delta2.replay(new RemoveAccessControlEntryRecord().setId(acl1.id()));
        MetadataImage image2 = delta2.apply(MetadataProvenance.EMPTY);
        kraftMigrationZkWriter.handleDelta(image1, image2, delta2, (x$17, x$18, operation) -> this.migrationState_$eq(operation.apply(this.migrationState())));
        Assertions.assertEquals((int)3, (int)this.zkClient().getVersionedAclsForResource(literalResource).acls().size());
        Assertions.assertEquals((int)2, (int)this.zkClient().getVersionedAclsForResource(prefixedResource).acls().size());
        Assertions.assertEquals((int)2, (int)this.zkClient().getVersionedAclsForResource(otherResource).acls().size());
        Assertions.assertEquals((int)0, (int)errorLogs.size());
        AccessControlEntryRecord acl9 = this.acl(otherName, ResourceType.TOPIC, PatternType.LITERAL, this.user("eve"), this.acl$default$5(), this.acl$default$6(), this.acl$default$7());
        MetadataDelta delta3 = new MetadataDelta.Builder().setImage(image2).build();
        delta3.replay(acl1);
        delta3.replay(new RemoveAccessControlEntryRecord().setId(acl2.id()));
        delta3.replay(new RemoveAccessControlEntryRecord().setId(acl5.id()));
        delta3.replay(new RemoveAccessControlEntryRecord().setId(acl6.id()));
        delta3.replay(acl9);
        MetadataImage image3 = delta3.apply(MetadataProvenance.EMPTY);
        kraftMigrationZkWriter.handleDelta(image2, image3, delta3, (x$19, x$20, operation) -> this.migrationState_$eq(operation.apply(this.migrationState())));
        Assertions.assertEquals((int)3, (int)this.zkClient().getVersionedAclsForResource(literalResource).acls().size());
        Assertions.assertEquals((int)0, (int)this.zkClient().getVersionedAclsForResource(prefixedResource).acls().size());
        Assertions.assertEquals((int)3, (int)this.zkClient().getVersionedAclsForResource(otherResource).acls().size());
        Assertions.assertEquals((int)0, (int)errorLogs.size());
    }

    @Test
    public void testAclUpdateAndDeleteWithClusterLinkIds() {
        this.zkClient().createAclPaths();
        Buffer errorLogs = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        KRaftMigrationZkWriter kraftMigrationZkWriter = new KRaftMigrationZkWriter((MigrationClient)this.migrationClient(), msg -> errorLogs.append(msg));
        String topicName = new StringBuilder(6).append("topic-").append(Uuid.randomUuid()).toString();
        ResourcePattern literalResource = new ResourcePattern(ResourceType.TOPIC, topicName, PatternType.LITERAL);
        Uuid linkA = Uuid.randomUuid();
        Uuid linkB = Uuid.randomUuid();
        AccessControlEntryRecord acl1a = this.acl(topicName, ResourceType.TOPIC, PatternType.LITERAL, this.user("alice"), this.acl$default$5(), this.acl$default$6(), this.acl$default$7()).setClusterLinkId(linkA);
        AccessControlEntryRecord acl1b = this.acl(topicName, ResourceType.TOPIC, PatternType.LITERAL, this.user("alice"), this.acl$default$5(), this.acl$default$6(), this.acl$default$7()).setClusterLinkId(linkB);
        AccessControlEntryRecord acl2 = this.acl(topicName, ResourceType.TOPIC, PatternType.LITERAL, this.user("bob"), this.acl$default$5(), this.acl$default$6(), this.acl$default$7()).setClusterLinkId(linkA);
        AccessControlEntryRecord acl3a = this.acl(topicName, ResourceType.TOPIC, PatternType.LITERAL, this.user("carol"), this.acl$default$5(), this.acl$default$6(), this.acl$default$7()).setClusterLinkId(linkA);
        AccessControlEntryRecord acl3b = this.acl(topicName, ResourceType.TOPIC, PatternType.LITERAL, this.user("carol"), this.acl$default$5(), this.acl$default$6(), this.acl$default$7()).setClusterLinkId(linkB);
        MetadataDelta delta1 = new MetadataDelta.Builder().build();
        delta1.replay(acl1a);
        delta1.replay(acl1b);
        delta1.replay(acl2);
        delta1.replay(acl3a);
        delta1.replay(acl3b);
        MetadataImage image1 = delta1.apply(MetadataProvenance.EMPTY);
        kraftMigrationZkWriter.handleDelta(MetadataImage.EMPTY, image1, delta1, (x$21, x$22, operation) -> this.migrationState_$eq(operation.apply(this.migrationState())));
        Assertions.assertEquals((int)3, (int)this.zkClient().getVersionedAclsForResource(literalResource).acls().size());
        this.zkClient().getVersionedAclsForResource(literalResource).acls().foreach((Function1 & Serializable)acl -> {
            ZkAclMigrationClientTest.$anonfun$testAclUpdateAndDeleteWithClusterLinkIds$3(this, literalResource, linkA, linkB, acl);
            return BoxedUnit.UNIT;
        });
        MetadataDelta delta2 = new MetadataDelta.Builder().setImage(image1).build();
        delta2.replay(new RemoveAccessControlEntryRecord().setId(acl1a.id()));
        delta2.replay(new RemoveAccessControlEntryRecord().setId(acl2.id()));
        MetadataImage image2 = delta2.apply(image1.provenance());
        kraftMigrationZkWriter.handleDelta(image1, image2, delta2, (x$23, x$24, operation) -> this.migrationState_$eq(operation.apply(this.migrationState())));
        Assertions.assertEquals((int)2, (int)this.zkClient().getVersionedAclsForResource(literalResource).acls().size());
        this.zkClient().getVersionedAclsForResource(literalResource).acls().foreach((Function1 & Serializable)acl -> {
            ZkAclMigrationClientTest.$anonfun$testAclUpdateAndDeleteWithClusterLinkIds$5(this, literalResource, linkB, linkA, acl);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)0, (int)errorLogs.size());
    }

    public static final /* synthetic */ scala.collection.immutable.Set $anonfun$replaceAclsAndReadWithAuthorizer$1(AclAuthorizer authorizer$1, AclBindingFilter resourceFilter$1) {
        return CollectionConverters$.MODULE$.IterableHasAsScala(authorizer$1.acls(resourceFilter$1)).asScala().toSet();
    }

    public static final /* synthetic */ scala.collection.immutable.Set $anonfun$deleteResourceAndReadWithAuthorizer$1(AclAuthorizer authorizer$2, AclBindingFilter resourceFilter$2) {
        return CollectionConverters$.MODULE$.IterableHasAsScala(authorizer$2.acls(resourceFilter$2)).asScala().toSet();
    }

    public static final /* synthetic */ boolean $anonfun$testAclsMigrateAndDualWrite$1(scala.collection.immutable.Set acls) {
        return acls.size() == 1;
    }

    public static final /* synthetic */ boolean $anonfun$testAclsMigrateAndDualWrite$2(scala.collection.immutable.Set acls) {
        return acls.size() == 1;
    }

    public static final /* synthetic */ boolean $anonfun$testAclsMigrateAndDualWrite$4(scala.collection.immutable.Set acls) {
        return acls.size() == 2;
    }

    public static final /* synthetic */ boolean $anonfun$testAclsMigrateAndDualWrite$6(scala.collection.immutable.Set acls) {
        return acls.size() == 1;
    }

    public static final /* synthetic */ boolean $anonfun$testAclsMigrateAndDualWrite$7(scala.collection.immutable.Set acls) {
        return acls.size() == 1;
    }

    public static final /* synthetic */ boolean $anonfun$testAclsMigrateAndDualWrite$8(AccessControlEntry linkedAce1$1, scala.collection.immutable.Set acls) {
        if (acls.size() == 1) {
            AccessControlEntry accessControlEntry = ((AclBinding)acls.head()).entry();
            AccessControlEntry accessControlEntry2 = SecurityUtils.aceWithoutLinkId((AccessControlEntry)linkedAce1$1);
            if (!(accessControlEntry != null ? !accessControlEntry.equals(accessControlEntry2) : accessControlEntry2 != null)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ void $anonfun$testAclUpdateAndDeleteWithClusterLinkIds$3(ZkAclMigrationClientTest $this, ResourcePattern literalResource$1, Uuid linkA$1, Uuid linkB$1, AclEntry acl) {
        AclBinding binding = acl.aclBinding();
        Assertions.assertEquals((Object)literalResource$1, (Object)binding.pattern());
        if (binding.entry().principal().equals($this.user("alice"))) {
            Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Uuid[]{linkA$1, linkB$1})), (Object)CollectionConverters$.MODULE$.CollectionHasAsScala(binding.entry().clusterLinkIds()).asScala().toSet());
            return;
        }
        if (binding.entry().principal().equals($this.user("bob"))) {
            Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Uuid[]{linkA$1})), (Object)CollectionConverters$.MODULE$.CollectionHasAsScala(binding.entry().clusterLinkIds()).asScala().toSet());
            return;
        }
        if (binding.entry().principal().equals($this.user("carol"))) {
            Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Uuid[]{linkA$1, linkB$1})), (Object)CollectionConverters$.MODULE$.CollectionHasAsScala(binding.entry().clusterLinkIds()).asScala().toSet());
            return;
        }
        Assertions.fail((String)new StringBuilder(18).append("Invalid principal ").append(binding.entry().principal()).toString());
    }

    public static final /* synthetic */ void $anonfun$testAclUpdateAndDeleteWithClusterLinkIds$5(ZkAclMigrationClientTest $this, ResourcePattern literalResource$1, Uuid linkB$1, Uuid linkA$1, AclEntry acl) {
        AclBinding binding = acl.aclBinding();
        Assertions.assertEquals((Object)literalResource$1, (Object)binding.pattern());
        if (binding.entry().principal().equals($this.user("alice"))) {
            Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Uuid[]{linkB$1})), (Object)CollectionConverters$.MODULE$.CollectionHasAsScala(binding.entry().clusterLinkIds()).asScala().toSet());
            return;
        }
        if (binding.entry().principal().equals($this.user("carol"))) {
            Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Uuid[]{linkA$1, linkB$1})), (Object)CollectionConverters$.MODULE$.CollectionHasAsScala(binding.entry().clusterLinkIds()).asScala().toSet());
            return;
        }
        Assertions.fail((String)new StringBuilder(18).append("Invalid principal ").append(binding.entry().principal()).toString());
    }

    public static final /* synthetic */ Object $anonfun$deleteResourceAndReadWithAuthorizer$2$adapted(scala.collection.immutable.Set x$3) {
        return BoxesRunTime.boxToBoolean((boolean)x$3.isEmpty());
    }
}

