/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk.migration;

import java.io.Serializable;
import java.util.ArrayList;
import kafka.cluster.Broker$;
import kafka.cluster.EndPoint;
import kafka.zk.BrokerInfo;
import kafka.zk.BrokerInfo$;
import kafka.zk.migration.ZkMigrationTestHarness;
import org.apache.kafka.clients.admin.BrokerComponent;
import org.apache.kafka.clients.admin.DegradedBrokerComponent;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.feature.Features;
import org.apache.kafka.common.metadata.BrokerRegistrationChangeRecord;
import org.apache.kafka.common.metadata.MetadataRecordType;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.metadata.BrokerRegistration;
import org.apache.kafka.metadata.DegradedBrokerHealthState;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005Ub\u0001B\u0007\u000f\u0001UAQA\u0007\u0001\u0005\u0002mAQ!\b\u0001\u0005\u0002yAQA\r\u0001\u0005\u0002yAQ\u0001\u000e\u0001\u0005\u0002yAQA\u000e\u0001\u0005\u0002yAQ\u0001\u000f\u0001\u0005\u0002yAQA\u000f\u0001\u0005\u0002yAQ\u0001\u0010\u0001\u0005\u0002yAQA\u0010\u0001\u0005\n}BQA\u001c\u0001\u0005\n=DQA\u001e\u0001\u0005\n]Dq!a\t\u0001\t\u0013\t)CA\u000e[W\n\u0013xn[3s\u0011\u0016\fG\u000e\u001e5NS\u001e\u0014\u0018\r^5p]R+7\u000f\u001e\u0006\u0003\u001fA\t\u0011\"\\5he\u0006$\u0018n\u001c8\u000b\u0005E\u0011\u0012A\u0001>l\u0015\u0005\u0019\u0012!B6bM.\f7\u0001A\n\u0003\u0001Y\u0001\"a\u0006\r\u000e\u00039I!!\u0007\b\u0003-i[W*[4sCRLwN\u001c+fgRD\u0015M\u001d8fgN\fa\u0001P5oSRtD#\u0001\u000f\u0011\u0005]\u0001\u0011\u0001\b;fgRl\u0015n\u001a:bi\u0016,U\u000e\u001d;z\u0005J|7.\u001a:IK\u0006dG\u000f\u001b\u000b\u0002?A\u0011\u0001eI\u0007\u0002C)\t!%A\u0003tG\u0006d\u0017-\u0003\u0002%C\t!QK\\5uQ\t\u0011a\u0005\u0005\u0002(a5\t\u0001F\u0003\u0002*U\u0005\u0019\u0011\r]5\u000b\u0005-b\u0013a\u00026va&$XM\u001d\u0006\u0003[9\nQA[;oSRT\u0011aL\u0001\u0004_J<\u0017BA\u0019)\u0005\u0011!Vm\u001d;\u0002/Q,7\u000f^'jOJ\fG/\u001a\"s_.,'\u000fS3bYRD\u0007FA\u0002'\u0003\u0011\"Xm\u001d;NS\u001e\u0014\u0018\r^3Ce>\\WM\u001d%fC2$\bNR8s\t><hN\u0011:pW\u0016\u0014\bF\u0001\u0003'\u0003-\"Xm\u001d;NS\u001e\u0014\u0018\r^3Ce>\\WM\u001d%fC2$\bNR8s\u001d>tW\t_5ti\u0016tGO\u0011:pW\u0016\u0014\bFA\u0003'\u00031\"Xm\u001d;NS\u001e\u0014\u0018\r^3Ce>\\WM\u001d%fC2$\bnV5uQB\u0013\u0018n\u001c:EK\u001e\u0014\u0018\rZ1uS>t7\u000f\u000b\u0002\u0007M\u00051B/Z:u+B$\u0017\r^3Ce>\\WM\u001d%fC2$\b\u000e\u000b\u0002\bM\u0005\u0019C/Z:u+B$\u0017\r^3Ce>\\WM\u001d%fC2$\bnV5mY>3XM]<sSR,\u0007F\u0001\u0005'\u0003\u0015\n7o]3siJ+7m\u001c:eg6\u000bGo\u00195FqB,7\r^3e\u0011\u0016\fG\u000e\u001e5Ti\u0006$X\rF\u0002 \u0001\u0006DQ!Q\u0005A\u0002\t\u000b\u0011C\u0019:pW\u0016\u0014\b*Z1mi\"\u001cF/\u0019;f!\u0011\u0019e\tS&\u000e\u0003\u0011S!!R\u0011\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002H\t\n\u0019Q*\u00199\u0011\u0005\u0001J\u0015B\u0001&\"\u0005\rIe\u000e\u001e\t\u0004\u0019N3fBA'R!\tq\u0015%D\u0001P\u0015\t\u0001F#\u0001\u0004=e>|GOP\u0005\u0003%\u0006\na\u0001\u0015:fI\u00164\u0017B\u0001+V\u0005\r\u0019V\r\u001e\u0006\u0003%\u0006\u0002\"aV0\u000e\u0003aS!!\u0017.\u0002\u000b\u0005$W.\u001b8\u000b\u0005mc\u0016aB2mS\u0016tGo\u001d\u0006\u0003'uS!A\u0018\u0018\u0002\r\u0005\u0004\u0018m\u00195f\u0013\t\u0001\u0007LA\fEK\u001e\u0014\u0018\rZ3e\u0005J|7.\u001a:D_6\u0004xN\\3oi\")!-\u0003a\u0001G\u0006I\"/Z4jgR\u0014\u0018\r^5p]\u000eC\u0017M\\4f%\u0016\u001cwN\u001d3t!\r\u0019EMZ\u0005\u0003K\u0012\u00131aU3r!\t9G.D\u0001i\u0015\tI'.\u0001\u0005nKR\fG-\u0019;b\u0015\tYG,\u0001\u0004d_6lwN\\\u0005\u0003[\"\u0014aD\u0011:pW\u0016\u0014(+Z4jgR\u0014\u0018\r^5p]\u000eC\u0017M\\4f%\u0016\u001cwN\u001d3\u0002!\r\u0014X-\u0019;f\u0005J|7.\u001a:J]\u001a|GC\u00019u!\t\t(/D\u0001\u0011\u0013\t\u0019\bC\u0001\u0006Ce>\\WM]%oM>DQ!\u001e\u0006A\u0002!\u000b!!\u001b3\u0002%\t\u0014xn[3s%\u0016<\u0017n\u001d;sCRLwN\u001c\u000b\u0005qv\fy\u0001\u0005\u0002zw6\t!P\u0003\u0002j9&\u0011AP\u001f\u0002\u0013\u0005J|7.\u001a:SK\u001eL7\u000f\u001e:bi&|g\u000eC\u0003\u007f\u0017\u0001\u0007q0\u0001\u0005ce>\\WM]%e!\u0011\t\t!a\u0003\u000e\u0005\u0005\r!\u0002BA\u0003\u0003\u000f\tA\u0001\\1oO*\u0011\u0011\u0011B\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u000e\u0005\r!aB%oi\u0016<WM\u001d\u0005\b\u0003#Y\u0001\u0019AA\n\u00031!Wm\u001a:bI\u0006$\u0018n\u001c8t!\u0019\t)\"a\u0007\u0002\u001e5\u0011\u0011q\u0003\u0006\u0005\u00033\t9!\u0001\u0003vi&d\u0017b\u0001+\u0002\u0018A\u0019\u00110a\b\n\u0007\u0005\u0005\"PA\rEK\u001e\u0014\u0018\rZ3e\u0005J|7.\u001a:IK\u0006dG\u000f[*uCR,\u0017a\u00052s_.,'OU3hSN$(/\u0019;j_:\u001cHCBA\u0014\u0003W\ty\u0003\u0005\u0004\u0002\u0016\u0005%r\u0010_\u0005\u0004\u000f\u0006]\u0001BBA\u0017\u0019\u0001\u0007\u0001*\u0001\u0006ok6\u0014%o\\6feNDq!!\u0005\r\u0001\u0004\t\t\u0004E\u0003D\r\"\u000b\u0019\u0004\u0005\u0003M'\u0006u\u0001")
public class ZkBrokerHealthMigrationTest
extends ZkMigrationTestHarness {
    @Test
    public void testMigrateEmptyBrokerHealth() {
        this.zkClient().registerBroker(this.createBrokerInfo(0));
        this.zkClient().registerBroker(this.createBrokerInfo(1));
        this.zkClient().registerBroker(this.createBrokerInfo(2));
        ArrayList batches = new ArrayList();
        this.migrationClient().migrateBrokerHealth(batch -> batches.add(batch), this.brokerRegistrations(3, (Map<Object, scala.collection.immutable.Set<DegradedBrokerHealthState>>)((Map)scala.collection.Map$.MODULE$.empty())));
        Assertions.assertEquals((int)0, (int)batches.size());
    }

    @Test
    public void testMigrateBrokerHealth() {
        this.zkClient().registerBroker(this.createBrokerInfo(0));
        this.zkClient().registerBroker(this.createBrokerInfo(1));
        this.zkClient().registerBroker(this.createBrokerInfo(2));
        DegradedBrokerComponent brokerComponent1 = new DegradedBrokerComponent("rcca-123", BrokerComponent.UNSPECIFIED.id());
        DegradedBrokerComponent brokerComponent2 = new DegradedBrokerComponent("rcca-123", BrokerComponent.STORAGE.id());
        DegradedBrokerComponent brokerComponent3 = new DegradedBrokerComponent("rcca-234", BrokerComponent.UNSPECIFIED.id());
        Map brokerHealthState = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DegradedBrokerComponent[]{brokerComponent1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DegradedBrokerComponent[]{brokerComponent1, brokerComponent2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DegradedBrokerComponent[]{brokerComponent3})))}));
        this.zkClient().setBrokerHealthState(brokerHealthState);
        ArrayList batches = new ArrayList();
        this.migrationClient().migrateBrokerHealth(batch -> batches.add(batch), this.brokerRegistrations(3, (Map<Object, scala.collection.immutable.Set<DegradedBrokerHealthState>>)((Map)scala.collection.Map$.MODULE$.empty())));
        Assertions.assertEquals((int)1, (int)batches.size());
        scala.collection.immutable.Seq registrationChangeRecords = ((IterableOnceOps)((IterableOps)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)batches.get(0)).asScala().map((Function1 & Serializable)x$1 -> x$1.message())).filter((Function1 & Serializable)message -> BoxesRunTime.boxToBoolean((boolean)ZkBrokerHealthMigrationTest.$anonfun$testMigrateBrokerHealth$3(message)))).map((Function1 & Serializable)x$2 -> (BrokerRegistrationChangeRecord)x$2)).toSeq();
        this.assertRecordsMatchExpectedHealthState((Map<Object, scala.collection.immutable.Set<DegradedBrokerComponent>>)brokerHealthState, (Seq<BrokerRegistrationChangeRecord>)registrationChangeRecords);
    }

    @Test
    public void testMigrateBrokerHealthForDownBroker() {
        this.zkClient().registerBroker(this.createBrokerInfo(0));
        this.zkClient().registerBroker(this.createBrokerInfo(1));
        DegradedBrokerComponent brokerComponent1 = new DegradedBrokerComponent("rcca-123", BrokerComponent.UNSPECIFIED.id());
        DegradedBrokerComponent brokerComponent2 = new DegradedBrokerComponent("rcca-123", BrokerComponent.STORAGE.id());
        DegradedBrokerComponent brokerComponent3 = new DegradedBrokerComponent("rcca-234", BrokerComponent.UNSPECIFIED.id());
        Map brokerHealthState = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DegradedBrokerComponent[]{brokerComponent1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DegradedBrokerComponent[]{brokerComponent1, brokerComponent2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DegradedBrokerComponent[]{brokerComponent3})))}));
        this.zkClient().setBrokerHealthState(brokerHealthState);
        ArrayList batches = new ArrayList();
        this.migrationClient().migrateBrokerHealth(batch -> batches.add(batch), this.brokerRegistrations(3, (Map<Object, scala.collection.immutable.Set<DegradedBrokerHealthState>>)((Map)scala.collection.Map$.MODULE$.empty())));
        Assertions.assertEquals((int)1, (int)batches.size());
        scala.collection.immutable.Seq registrationChangeRecords = ((IterableOnceOps)((IterableOps)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)batches.get(0)).asScala().map((Function1 & Serializable)x$3 -> x$3.message())).filter((Function1 & Serializable)message -> BoxesRunTime.boxToBoolean((boolean)ZkBrokerHealthMigrationTest.$anonfun$testMigrateBrokerHealthForDownBroker$3(message)))).map((Function1 & Serializable)x$4 -> (BrokerRegistrationChangeRecord)x$4)).toSeq();
        this.assertRecordsMatchExpectedHealthState((Map<Object, scala.collection.immutable.Set<DegradedBrokerComponent>>)brokerHealthState, (Seq<BrokerRegistrationChangeRecord>)registrationChangeRecords);
    }

    @Test
    public void testMigrateBrokerHealthForNonExistentBroker() {
        this.zkClient().registerBroker(this.createBrokerInfo(0));
        this.zkClient().registerBroker(this.createBrokerInfo(1));
        DegradedBrokerComponent brokerComponent1 = new DegradedBrokerComponent("rcca-123", BrokerComponent.UNSPECIFIED.id());
        DegradedBrokerComponent brokerComponent2 = new DegradedBrokerComponent("rcca-123", BrokerComponent.STORAGE.id());
        DegradedBrokerComponent brokerComponent3 = new DegradedBrokerComponent("rcca-234", BrokerComponent.UNSPECIFIED.id());
        scala.collection.mutable.Map brokerHealthState = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DegradedBrokerComponent[]{brokerComponent1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DegradedBrokerComponent[]{brokerComponent1, brokerComponent2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DegradedBrokerComponent[]{brokerComponent3})))}));
        scala.collection.mutable.Map expectedBrokerHealthState = (scala.collection.mutable.Map)brokerHealthState.clone();
        expectedBrokerHealthState.remove((Object)BoxesRunTime.boxToInteger((int)2));
        this.zkClient().setBrokerHealthState((Map)brokerHealthState);
        ArrayList batches = new ArrayList();
        this.migrationClient().migrateBrokerHealth(batch -> batches.add(batch), this.brokerRegistrations(2, (Map<Object, scala.collection.immutable.Set<DegradedBrokerHealthState>>)((Map)scala.collection.Map$.MODULE$.empty())));
        Assertions.assertEquals((int)1, (int)batches.size());
        scala.collection.immutable.Seq registrationChangeRecords = ((IterableOnceOps)((IterableOps)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)batches.get(0)).asScala().map((Function1 & Serializable)x$5 -> x$5.message())).filter((Function1 & Serializable)message -> BoxesRunTime.boxToBoolean((boolean)ZkBrokerHealthMigrationTest.$anonfun$testMigrateBrokerHealthForNonExistentBroker$3(message)))).map((Function1 & Serializable)x$6 -> (BrokerRegistrationChangeRecord)x$6)).toSeq();
        this.assertRecordsMatchExpectedHealthState((Map<Object, scala.collection.immutable.Set<DegradedBrokerComponent>>)expectedBrokerHealthState, (Seq<BrokerRegistrationChangeRecord>)registrationChangeRecords);
    }

    @Test
    public void testMigrateBrokerHealthWithPriorDegradations() {
        this.zkClient().registerBroker(this.createBrokerInfo(0));
        this.zkClient().registerBroker(this.createBrokerInfo(1));
        this.zkClient().registerBroker(this.createBrokerInfo(2));
        DegradedBrokerComponent brokerComponent1 = new DegradedBrokerComponent("rcca-123", BrokerComponent.UNSPECIFIED.id());
        DegradedBrokerComponent brokerComponent2 = new DegradedBrokerComponent("rcca-123", BrokerComponent.STORAGE.id());
        DegradedBrokerComponent brokerComponent3 = new DegradedBrokerComponent("rcca-234", BrokerComponent.UNSPECIFIED.id());
        scala.collection.mutable.Map brokerHealthState = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DegradedBrokerComponent[]{brokerComponent1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DegradedBrokerComponent[]{brokerComponent1, brokerComponent2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DegradedBrokerComponent[]{brokerComponent3})))}));
        this.zkClient().setBrokerHealthState((Map)brokerHealthState);
        ArrayList batches = new ArrayList();
        this.migrationClient().migrateBrokerHealth(batch -> batches.add(batch), this.brokerRegistrations(3, (Map<Object, scala.collection.immutable.Set<DegradedBrokerHealthState>>)((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DegradedBrokerHealthState[]{new DegradedBrokerHealthState("rcca-345", BrokerComponent.NETWORK)})))})))));
        Assertions.assertEquals((int)1, (int)batches.size());
        scala.collection.immutable.Seq registrationChangeRecords = ((IterableOnceOps)((IterableOps)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)batches.get(0)).asScala().map((Function1 & Serializable)x$7 -> x$7.message())).filter((Function1 & Serializable)message -> BoxesRunTime.boxToBoolean((boolean)ZkBrokerHealthMigrationTest.$anonfun$testMigrateBrokerHealthWithPriorDegradations$3(message)))).map((Function1 & Serializable)x$8 -> (BrokerRegistrationChangeRecord)x$8)).toSeq();
        this.assertRecordsMatchExpectedHealthState((Map<Object, scala.collection.immutable.Set<DegradedBrokerComponent>>)brokerHealthState, (Seq<BrokerRegistrationChangeRecord>)registrationChangeRecords);
    }

    @Test
    public void testUpdateBrokerHealth() {
        Assertions.assertEquals((int)0, (int)this.migrationState().migrationZkVersion());
        DegradedBrokerComponent brokerComponent1 = new DegradedBrokerComponent("rcca-123", BrokerComponent.UNSPECIFIED.id());
        DegradedBrokerComponent brokerComponent2 = new DegradedBrokerComponent("rcca-123", BrokerComponent.STORAGE.id());
        DegradedBrokerComponent brokerComponent3 = new DegradedBrokerComponent("rcca-234", BrokerComponent.UNSPECIFIED.id());
        java.util.Map brokerHealthState = CollectionConverters$.MODULE$.MapHasAsJava((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DegradedBrokerComponent[]{brokerComponent1}))).asJava()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DegradedBrokerComponent[]{brokerComponent1, brokerComponent2}))).asJava()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DegradedBrokerComponent[]{brokerComponent3}))).asJava())}))).asJava();
        this.migrationState_$eq(this.migrationClient().brokerHealthClient().writeBrokerHealthState(brokerHealthState, this.migrationState()));
        Assertions.assertEquals((int)1, (int)this.migrationState().migrationZkVersion());
        Map brokerHealthFromZk = this.zkClient().getBrokerHealthState();
        Assertions.assertEquals((int)3, (int)brokerHealthFromZk.size());
        brokerHealthFromZk.foreach((Function1 & Serializable)x0$1 -> {
            ZkBrokerHealthMigrationTest.$anonfun$testUpdateBrokerHealth$1(brokerHealthState, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testUpdateBrokerHealthWillOverwrite() {
        Assertions.assertEquals((int)0, (int)this.migrationState().migrationZkVersion());
        DegradedBrokerComponent brokerComponent = new DegradedBrokerComponent("rcca-123", BrokerComponent.UNSPECIFIED.id());
        this.zkClient().setBrokerHealthState((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DegradedBrokerComponent[]{brokerComponent})))})));
        java.util.Map brokerHealthState = CollectionConverters$.MODULE$.MapHasAsJava((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DegradedBrokerComponent[]{brokerComponent}))).asJava())}))).asJava();
        this.migrationState_$eq(this.migrationClient().brokerHealthClient().writeBrokerHealthState(brokerHealthState, this.migrationState()));
        Assertions.assertEquals((int)1, (int)this.migrationState().migrationZkVersion());
        Map brokerHealthFromZk = this.zkClient().getBrokerHealthState();
        Assertions.assertEquals((int)1, (int)brokerHealthFromZk.size());
        Assertions.assertEquals(brokerHealthState.get(BoxesRunTime.boxToInteger((int)2)), (Object)CollectionConverters$.MODULE$.SetHasAsJava((Set)brokerHealthFromZk.apply((Object)BoxesRunTime.boxToInteger((int)2))).asJava());
        java.util.Map emptyBrokerHealthState = CollectionConverters$.MODULE$.MapHasAsJava((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)).asJava();
        this.migrationState_$eq(this.migrationClient().brokerHealthClient().writeBrokerHealthState(emptyBrokerHealthState, this.migrationState()));
        Assertions.assertEquals((int)2, (int)this.migrationState().migrationZkVersion());
        brokerHealthFromZk = this.zkClient().getBrokerHealthState();
        Assertions.assertEquals((int)0, (int)brokerHealthFromZk.size());
    }

    private void assertRecordsMatchExpectedHealthState(Map<Object, scala.collection.immutable.Set<DegradedBrokerComponent>> brokerHealthState, Seq<BrokerRegistrationChangeRecord> registrationChangeRecords) {
        Assertions.assertEquals((int)brokerHealthState.size(), (int)registrationChangeRecords.size(), (String)new StringBuilder(51).append("Expected number of brokers with degradations to be ").append(brokerHealthState.size()).toString());
        registrationChangeRecords.foreach((Function1 & Serializable)record -> {
            ZkBrokerHealthMigrationTest.$anonfun$assertRecordsMatchExpectedHealthState$1(brokerHealthState, record);
            return BoxedUnit.UNIT;
        });
    }

    private BrokerInfo createBrokerInfo(int id) {
        return BrokerInfo$.MODULE$.apply(Broker$.MODULE$.apply(id, (Seq)new .colon.colon((Object)new EndPoint(new StringBuilder(9).append("test.host").append(Integer.toString(id)).toString(), 9000 + id, ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), SecurityProtocol.PLAINTEXT), (List)Nil$.MODULE$), (Option)None$.MODULE$, Features.emptySupportedFeatures()), MetadataVersion.latestTesting(), 9010 + id);
    }

    private BrokerRegistration brokerRegistration(Integer brokerId, java.util.Set<DegradedBrokerHealthState> degradations) {
        return new BrokerRegistration.Builder().setId(Predef$.MODULE$.Integer2int(brokerId)).setEpoch(1L).setIncarnationId(Uuid.randomUuid()).setInControlledShutdown(true).setIsMigratingZkBroker(true).setDegradedComponents(degradations).build();
    }

    private java.util.Map<Integer, BrokerRegistration> brokerRegistrations(int numBrokers, Map<Object, scala.collection.immutable.Set<DegradedBrokerHealthState>> degradations) {
        return CollectionConverters$.MODULE$.MapHasAsJava((Map)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numBrokers).map((Function1 & Serializable)b -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.unboxToInt((Object)b)), (Object)this.brokerRegistration(Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)b)), CollectionConverters$.MODULE$.SetHasAsJava((Set)degradations.getOrElse((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)b)), (Function0 & Serializable)() -> (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$))).asJava()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava();
    }

    public static final /* synthetic */ boolean $anonfun$testMigrateBrokerHealth$3(ApiMessage message) {
        return MetadataRecordType.fromId((short)message.apiKey()).equals((Object)MetadataRecordType.BROKER_REGISTRATION_CHANGE_RECORD);
    }

    public static final /* synthetic */ boolean $anonfun$testMigrateBrokerHealthForDownBroker$3(ApiMessage message) {
        return MetadataRecordType.fromId((short)message.apiKey()).equals((Object)MetadataRecordType.BROKER_REGISTRATION_CHANGE_RECORD);
    }

    public static final /* synthetic */ boolean $anonfun$testMigrateBrokerHealthForNonExistentBroker$3(ApiMessage message) {
        return MetadataRecordType.fromId((short)message.apiKey()).equals((Object)MetadataRecordType.BROKER_REGISTRATION_CHANGE_RECORD);
    }

    public static final /* synthetic */ boolean $anonfun$testMigrateBrokerHealthWithPriorDegradations$3(ApiMessage message) {
        return MetadataRecordType.fromId((short)message.apiKey()).equals((Object)MetadataRecordType.BROKER_REGISTRATION_CHANGE_RECORD);
    }

    public static final /* synthetic */ void $anonfun$testUpdateBrokerHealth$1(java.util.Map brokerHealthState$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            int brokerId = x0$1._1$mcI$sp();
            scala.collection.immutable.Set degradedBrokerComponent = (scala.collection.immutable.Set)x0$1._2();
            Assertions.assertEquals(brokerHealthState$1.get(BoxesRunTime.boxToInteger((int)brokerId)), (Object)CollectionConverters$.MODULE$.SetHasAsJava((Set)degradedBrokerComponent).asJava());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$assertRecordsMatchExpectedHealthState$1(Map brokerHealthState$2, BrokerRegistrationChangeRecord record) {
        Assertions.assertTrue((boolean)brokerHealthState$2.contains((Object)BoxesRunTime.boxToInteger((int)record.brokerId())));
        java.util.List expectedBrokerHealth = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)((IterableOps)brokerHealthState$2.apply((Object)BoxesRunTime.boxToInteger((int)record.brokerId()))).map((Function1 & Serializable)component -> new BrokerRegistrationChangeRecord.DegradedComponent().setReason(component.reason()).setComponentCode(component.brokerComponent().id()))).toList()).asJava();
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.ListHasAsScala(expectedBrokerHealth).asScala().toSet(), (Object)CollectionConverters$.MODULE$.ListHasAsScala(record.degradedComponents()).asScala().toSet());
    }
}

