/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk.migration;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.api.PartitionLinkState;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.ReplicaAssignment;
import kafka.security.authorizer.AclAuthorizer;
import kafka.security.authorizer.AclEntry$;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.ClusterLinkTopicState$;
import kafka.server.link.TopicLinkMirror$;
import kafka.server.link.TopicLinkState;
import kafka.utils.CoreUtils$;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import kafka.zk.ClusterLinkData;
import kafka.zk.migration.ZkMigrationTestHarness;
import org.apache.kafka.common.MirrorTopicError;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.metadata.ConfigRecord;
import org.apache.kafka.common.metadata.InstallMetadataEncryptorRecord;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.metadata.ClusterLink;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.metadata.MirrorTopic;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005A2A!\u0002\u0004\u0001\u001b!)!\u0003\u0001C\u0001'!9Q\u0003\u0001b\u0001\n\u00031\u0002BB\u000f\u0001A\u0003%q\u0003C\u0003\u001f\u0001\u0011\u0005qD\u0001\u000e[W\u000ecWo\u001d;fe2Kgn['jOJ\fG/[8o)\u0016\u001cHO\u0003\u0002\b\u0011\u0005IQ.[4sCRLwN\u001c\u0006\u0003\u0013)\t!A_6\u000b\u0003-\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u001dA\u0011q\u0002E\u0007\u0002\r%\u0011\u0011C\u0002\u0002\u00175.l\u0015n\u001a:bi&|g\u000eV3ti\"\u000b'O\\3tg\u00061A(\u001b8jiz\"\u0012\u0001\u0006\t\u0003\u001f\u0001\tQcQ(O\r&;uLU#D\u001fJ#u,\u0011)J?.+\u0015,F\u0001\u0018!\tA2$D\u0001\u001a\u0015\u0005Q\u0012!B:dC2\f\u0017B\u0001\u000f\u001a\u0005\u0015\u0019\u0006n\u001c:u\u0003Y\u0019uJ\u0014$J\u000f~\u0013ViQ(S\t~\u000b\u0005+S0L\u000bf\u0003\u0013A\n;fgR\u001cE.^:uKJd\u0015N\\6B]\u0012l\u0015N\u001d:peR{\u0007/[2NS\u001e\u0014\u0018\r^5p]R\t\u0001\u0005\u0005\u0002\u0019C%\u0011!%\u0007\u0002\u0005+:LG\u000f\u000b\u0002\u0005IA\u0011QEL\u0007\u0002M)\u0011q\u0005K\u0001\u0004CBL'BA\u0015+\u0003\u001dQW\u000f]5uKJT!a\u000b\u0017\u0002\u000b),h.\u001b;\u000b\u00035\n1a\u001c:h\u0013\tycE\u0001\u0003UKN$\b")
public class ZkClusterLinkMigrationTest
extends ZkMigrationTestHarness {
    private final short CONFIG_RECORD_API_KEY = (short)4;

    public short CONFIG_RECORD_API_KEY() {
        return this.CONFIG_RECORD_API_KEY;
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testClusterLinkAndMirrorTopicMigration() {
        HashSet brokers = new HashSet();
        ArrayList<java.util.List> batches = new ArrayList<java.util.List>();
        ClusterLinkData link1 = new ClusterLinkData("link1", Uuid.randomUuid(), (Option)new Some((Object)"cluster1"), (Option)None$.MODULE$, false);
        Properties linkConfigs1 = new Properties();
        linkConfigs1.put("link.mode", "destination");
        linkConfigs1.put("ssl.keystore.password", "test");
        ClusterLinkData link2 = new ClusterLinkData("link2", Uuid.randomUuid(), (Option)new Some((Object)"cluster2"), (Option)None$.MODULE$, false);
        Properties linkConfigs2 = new Properties();
        linkConfigs2.put("cluster.link.prefix", "migration");
        ClusterLinkData deletedLink = new ClusterLinkData("deletedLink", Uuid.randomUuid(), (Option)new Some((Object)"cluster3"), (Option)None$.MODULE$, true);
        Properties deletedConfigs = new Properties();
        deletedConfigs.put("cluster.link.prefix", "migration2");
        deletedConfigs.put("link.mode", "destination");
        this.adminZkClient().createClusterLink(link1, this.zkLinkConfigEncoder().encode(linkConfigs1));
        this.adminZkClient().createClusterLink(link2, this.zkLinkConfigEncoder().encode(linkConfigs2));
        this.adminZkClient().createClusterLink(deletedLink, this.zkLinkConfigEncoder().encode(deletedConfigs));
        Map partitionReplicaAssignment = (Map)((MapOps)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 0, 1})))}))).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                int k = x0$1._1$mcI$sp();
                Seq v = (Seq)x0$1._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)k)), (Object)new ReplicaAssignment(v, (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$, (Option)None$.MODULE$));
            }
            throw new MatchError(null);
        });
        String mirrorTopic1 = "mirrorTopic1";
        String mirrorTopic2 = "migrationmirrorTopic2";
        String mirrorTopic3 = "migration2mirrorTopic3";
        ClusterLinkTopicState.Mirror mirrorState1 = new ClusterLinkTopicState.Mirror(link1.linkName(), link1.linkId(), Uuid.randomUuid(), Time.SYSTEM.milliseconds(), (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{1L, 2L, 3L})));
        ClusterLinkTopicState.PausedMirror mirrorState2 = new ClusterLinkTopicState.PausedMirror(link2.linkName(), link2.linkId(), Uuid.randomUuid(), false, true, (TopicLinkState)TopicLinkMirror$.MODULE$, null, MirrorTopicError.NO_ERROR, Time.SYSTEM.milliseconds(), ClusterLinkTopicState.PausedMirror$.MODULE$.apply$default$10());
        ClusterLinkTopicState.Mirror mirrorState3 = new ClusterLinkTopicState.Mirror(deletedLink.linkName(), deletedLink.linkId(), Uuid.randomUuid(), Time.SYSTEM.milliseconds(), (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{1L, 2L, 3L})));
        AdminZkClient qual$1 = this.adminZkClient();
        Properties x$2 = new Properties();
        Some x$5 = new Some((Object)mirrorState1);
        boolean x$6 = qual$1.createTopicWithAssignment$default$4();
        boolean x$7 = qual$1.createTopicWithAssignment$default$6();
        qual$1.createTopicWithAssignment(mirrorTopic1, x$2, partitionReplicaAssignment, x$6, true, x$7, (Option)x$5);
        AdminZkClient qual$2 = this.adminZkClient();
        Properties x$9 = new Properties();
        Some x$12 = new Some((Object)mirrorState2);
        boolean x$13 = qual$2.createTopicWithAssignment$default$4();
        boolean x$14 = qual$2.createTopicWithAssignment$default$6();
        qual$2.createTopicWithAssignment(mirrorTopic2, x$9, partitionReplicaAssignment, x$13, true, x$14, (Option)x$12);
        AdminZkClient qual$3 = this.adminZkClient();
        Properties x$16 = new Properties();
        Some x$19 = new Some((Object)mirrorState3);
        boolean x$20 = qual$3.createTopicWithAssignment$default$4();
        boolean x$21 = qual$3.createTopicWithAssignment$default$6();
        qual$3.createTopicWithAssignment(mirrorTopic3, x$16, partitionReplicaAssignment, x$20, true, x$21, (Option)x$19);
        Map leaderAndIsrs1 = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(mirrorTopic1, 0)), (Object)new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(0, 5, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), LeaderRecoveryState.RECOVERED, -1, (Option)new Some((Object)new PartitionLinkState(5, false, MirrorTopicError.NO_ERROR))), 1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(mirrorTopic1, 1)), (Object)new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(1, 5, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 0})), LeaderRecoveryState.RECOVERED, -1, (Option)new Some((Object)new PartitionLinkState(5, false, MirrorTopicError.NO_ERROR))), 1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(mirrorTopic1, 2)), (Object)new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(1, 5, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 0, 1})), LeaderRecoveryState.RECOVERED, -1, (Option)new Some((Object)new PartitionLinkState(5, false, MirrorTopicError.NO_ERROR))), 1))}));
        Map leaderAndIsrs2 = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(mirrorTopic2, 0)), (Object)new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(0, 5, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), LeaderRecoveryState.RECOVERED, -1, (Option)new Some((Object)new PartitionLinkState(5, false, MirrorTopicError.NO_ERROR))), 1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(mirrorTopic2, 1)), (Object)new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(1, 5, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 0})), LeaderRecoveryState.RECOVERED, -1, (Option)new Some((Object)new PartitionLinkState(5, false, MirrorTopicError.NO_ERROR))), 1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(mirrorTopic2, 2)), (Object)new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(1, 5, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 0, 1})), LeaderRecoveryState.RECOVERED, -1, (Option)new Some((Object)new PartitionLinkState(5, false, MirrorTopicError.NO_ERROR))), 1))}));
        Map leaderAndIsrs3 = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(mirrorTopic3, 0)), (Object)new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(0, 5, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), LeaderRecoveryState.RECOVERED, -1, (Option)new Some((Object)new PartitionLinkState(5, false, MirrorTopicError.NO_ERROR))), 1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(mirrorTopic3, 1)), (Object)new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(1, 5, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 0})), LeaderRecoveryState.RECOVERED, -1, (Option)new Some((Object)new PartitionLinkState(5, false, MirrorTopicError.NO_ERROR))), 1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(mirrorTopic3, 2)), (Object)new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(1, 5, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 0, 1})), LeaderRecoveryState.RECOVERED, -1, (Option)new Some((Object)new PartitionLinkState(5, false, MirrorTopicError.NO_ERROR))), 1))}));
        this.zkClient().createTopicPartitionStatesRaw(leaderAndIsrs1, 0);
        this.zkClient().createTopicPartitionStatesRaw(leaderAndIsrs2, 0);
        this.zkClient().createTopicPartitionStatesRaw(leaderAndIsrs3, 0);
        ResourcePattern resource1 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("foo-").append(UUID.randomUUID()).toString(), PatternType.LITERAL);
        String username = "alice";
        KafkaPrincipal principal = new KafkaPrincipal("User", username);
        AccessControlEntry ace1 = new AccessControlEntry(principal.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW, (Collection)CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Uuid[]{link1.linkId(), link2.linkId(), deletedLink.linkId(), Uuid.ZERO_UUID}))).asJava());
        AclBinding acl1 = new AclBinding(resource1, ace1);
        AccessControlEntry ace2 = new AccessControlEntry(principal.toString(), "192.168.0.1", AclOperation.WRITE, AclPermissionType.ALLOW, (Collection)CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Uuid[]{deletedLink.linkId()}))).asJava());
        AclBinding acl2 = new AclBinding(resource1, ace2);
        try (AclAuthorizer authorizer = new AclAuthorizer();){
            authorizer.configure(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"zookeeper.connect"), (Object)this.zkConnect())}))).asJava());
            authorizer.createAcls(null, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)acl1, (List)new .colon.colon((Object)acl2, (List)Nil$.MODULE$))).asJava());
            scala.collection.immutable.Map expectedMirrorStatesAfterMigration = (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)mirrorTopic1), (Object)mirrorState1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)mirrorTopic2), (Object)mirrorState2)}));
            scala.collection.immutable.Map expectedLeaderAndIsrAfterMigration = (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)mirrorTopic1), (Object)leaderAndIsrs1.map((Function1 & Serializable)x0$2 -> {
                if (x0$2 != null) {
                    TopicPartition tp = (TopicPartition)x0$2._1();
                    LeaderIsrAndControllerEpoch lisr = (LeaderIsrAndControllerEpoch)x0$2._2();
                    return new Tuple2((Object)tp, (Object)new LeaderIsrAndControllerEpoch(lisr.leaderAndIsr().withPartitionEpoch(lisr.leaderAndIsr().partitionEpoch() + 1), lisr.controllerEpoch()));
                }
                throw new MatchError(null);
            })), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)mirrorTopic2), (Object)leaderAndIsrs2.map((Function1 & Serializable)x0$3 -> {
                if (x0$3 != null) {
                    TopicPartition tp = (TopicPartition)x0$3._1();
                    LeaderIsrAndControllerEpoch lisr = (LeaderIsrAndControllerEpoch)x0$3._2();
                    return new Tuple2((Object)tp, (Object)new LeaderIsrAndControllerEpoch(lisr.leaderAndIsr().withPartitionEpoch(lisr.leaderAndIsr().partitionEpoch() + 1), lisr.controllerEpoch()));
                }
                throw new MatchError(null);
            })), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)mirrorTopic3), (Object)leaderAndIsrs3.map((Function1 & Serializable)x0$4 -> {
                if (x0$4 != null) {
                    TopicPartition tp = (TopicPartition)x0$4._1();
                    LeaderIsrAndControllerEpoch lisr = (LeaderIsrAndControllerEpoch)x0$4._2();
                    return new Tuple2((Object)tp, (Object)new LeaderIsrAndControllerEpoch(lisr.leaderAndIsr().newEpochWithoutLinkLeader().withPartitionEpoch(lisr.leaderAndIsr().partitionEpoch() + 2), this.migrationState().kraftControllerEpoch()));
                }
                throw new MatchError(null);
            }))}));
            this.migrationClient().cleanAndMigrateAllMetadata(batch -> batches.add((java.util.List)batch), brokerId -> brokers.add(brokerId), (x$1, operation) -> this.migrationState_$eq(operation.apply(this.migrationState())), new HashMap(), this.kraftEncryptorFactory().activeIdFromLegacyConfig(), MetadataVersion.latestTesting());
            AclBindingFilter resourceFilter = new AclBindingFilter(new ResourcePatternFilter(resource1.resourceType(), resource1.name(), resource1.patternType()), AclBindingFilter.ANY.entryFilter());
            AccessControlEntry ace12 = new AccessControlEntry(principal.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW, (Collection)CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Uuid[]{link1.linkId(), link2.linkId(), Uuid.ZERO_UUID}))).asJava());
            AccessControlEntry ace22 = new AccessControlEntry(principal.toString(), "192.168.0.1", AclOperation.WRITE, AclPermissionType.ALLOW);
            scala.collection.immutable.Set expectedAclsAfterMigration = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{ace12, ace22}));
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long waitUntilTrue_waitTimeMs = TestUtils$.MODULE$.waitUntilTrue$default$3();
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!ZkClusterLinkMigrationTest.$anonfun$testClusterLinkAndMirrorTopicMigration$8(expectedAclsAfterMigration, authorizer, resourceFilter)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"ACLs are not updated in the authorizer");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            scala.collection.immutable.Set expectedLinksAfterMigration = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClusterLinkData[]{link1, link2}));
            scala.collection.immutable.Set linksFromZk = this.zkClient().getAllClusterLinks();
            Assertions.assertEquals((Object)expectedLinksAfterMigration, (Object)linksFromZk);
            Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{CoreUtils$.MODULE$.toJavaUUID(link1.linkId()).toString(), CoreUtils$.MODULE$.toJavaUUID(link2.linkId()).toString()})), (Object)this.zkClient().getAllEntitiesWithConfig("cluster-links").toSet());
            scala.collection.immutable.Map mirrorStatesFromZk = ((IterableOnceOps)((IterableOps)this.zkClient().getReplicaAssignmentAndTopicIdForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{mirrorTopic1, mirrorTopic2, mirrorTopic3}))).map((Function1 & Serializable)assignment -> new Tuple2((Object)assignment.topic(), (Object)assignment.clusterLink()))).collect((PartialFunction)new Serializable(null){
                private static final long serialVersionUID = 0L;

                public final <A1 extends Tuple2<String, Option<ClusterLinkTopicState>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    if (x1 != null) {
                        String topic = (String)x1._1();
                        Option stateOpt = (Option)x1._2();
                        if (stateOpt.isDefined()) {
                            return (B1)new Tuple2((Object)topic, stateOpt.get());
                        }
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Tuple2<String, Option<ClusterLinkTopicState>> x1) {
                    return x1 != null && ((Option)x1._2()).isDefined();
                }
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            Assertions.assertEquals((Object)expectedMirrorStatesAfterMigration, (Object)mirrorStatesFromZk);
            expectedLeaderAndIsrAfterMigration.foreach((Function1 & Serializable)x0$5 -> {
                ZkClusterLinkMigrationTest.$anonfun$testClusterLinkAndMirrorTopicMigration$12(this, x0$5);
                return BoxedUnit.UNIT;
            });
            Assertions.assertEquals((int)3, (int)brokers.size());
            Assertions.assertEquals((int)6, (int)batches.size());
            MetadataDelta delta = new MetadataDelta.Builder().setMetadataEncryptorFactory(this.kraftEncryptorFactory()).build();
            delta.replay(new InstallMetadataEncryptorRecord().setKeyId(this.kraftEncryptorFactory().activeIdFromLegacyConfig()));
            CollectionConverters$.MODULE$.ListHasAsScala(batches).asScala().foreach((Function1 & Serializable)batch -> {
                ZkClusterLinkMigrationTest.$anonfun$testClusterLinkAndMirrorTopicMigration$13(delta, batch);
                return BoxedUnit.UNIT;
            });
            MetadataImage image = delta.apply(MetadataProvenance.EMPTY);
            scala.collection.immutable.Set linksFromImage = ((MapOps)CollectionConverters$.MODULE$.MapHasAsScala(image.clusterLinks().linksByName()).asScala().map((Function1 & Serializable)x0$6 -> {
                if (x0$6 != null) {
                    String name = (String)x0$6._1();
                    ClusterLink link = (ClusterLink)x0$6._2();
                    return new Tuple2((Object)name, (Object)new ClusterLinkData(link.linkName(), link.linkId(), (Option)new Some((Object)link.remoteClusterId()), OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(link.tenantPrefix())), false));
                }
                throw new MatchError(null);
            })).values().toSet();
            Assertions.assertTrue((boolean)image.configs().configProperties(new ConfigResource(ConfigResource.Type.CLUSTER_LINK, deletedLink.linkId().toString())).isEmpty());
            Properties actualLinkConfigs1 = image.configs().configProperties(new ConfigResource(ConfigResource.Type.CLUSTER_LINK, link1.linkId().toString()));
            Assertions.assertEquals((Object)linkConfigs1, (Object)actualLinkConfigs1);
            Properties actualLinkConfigs2 = image.configs().configProperties(new ConfigResource(ConfigResource.Type.CLUSTER_LINK, link2.linkId().toString()));
            Assertions.assertEquals((Object)linkConfigs2, (Object)actualLinkConfigs2);
            IntRef encryptedRecords = IntRef.create((int)0);
            batches.forEach(batch -> batch.forEach(record -> {
                if (record.message().apiKey() == this.CONFIG_RECORD_API_KEY()) {
                    if (((ConfigRecord)record.message()).name().equals("ssl.keystore.password")) {
                        Assertions.fail((String)"Found CL sensitive config in plain text among metadata records");
                        return;
                    }
                    return;
                }
                if (record.message().apiKey() == this.ENCRYPTED_ENVELOPE_RECORD_API_KEY()) {
                    ++encryptedRecords$1.elem;
                    return;
                }
            }));
            Assertions.assertEquals((int)1, (int)encryptedRecords.elem);
            scala.collection.mutable.Map mirrorStatesFromImage = (scala.collection.mutable.Map)((MapOps)CollectionConverters$.MODULE$.MapHasAsScala((java.util.Map)image.topics().topicsByName()).asScala().map((Function1 & Serializable)x0$7 -> {
                if (x0$7 != null) {
                    String topic = (String)x0$7._1();
                    TopicImage topicImage = (TopicImage)x0$7._2();
                    return new Tuple2((Object)topic, (Object)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(topicImage.mirrorTopic())));
                }
                throw new MatchError(null);
            })).collect((PartialFunction)new Serializable(null){
                private static final long serialVersionUID = 0L;

                public final <A1 extends Tuple2<String, Option<MirrorTopic>>, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    if (x2 != null) {
                        String topic = (String)x2._1();
                        Option mirrorImage = (Option)x2._2();
                        if (mirrorImage.isDefined()) {
                            return (B1)new Tuple2((Object)topic, (Object)ClusterLinkTopicState$.MODULE$.apply((MirrorTopic)mirrorImage.get()));
                        }
                    }
                    return (B1)function1.apply(x2);
                }

                public final boolean isDefinedAt(Tuple2<String, Option<MirrorTopic>> x2) {
                    return x2 != null && ((Option)x2._2()).isDefined();
                }
            });
            Assertions.assertEquals((Object)expectedMirrorStatesAfterMigration, (Object)mirrorStatesFromImage);
            expectedLeaderAndIsrAfterMigration.foreach((Function1 & Serializable)x0$8 -> {
                ZkClusterLinkMigrationTest.$anonfun$testClusterLinkAndMirrorTopicMigration$19(image, x0$8);
                return BoxedUnit.UNIT;
            });
            Assertions.assertEquals((Object)expectedLinksAfterMigration, (Object)linksFromImage);
            Uuid mirrorTopicId1 = image.topics().getTopic(mirrorTopic1).id();
            java.util.Map mirrorTopicPartitions1 = image.topics().getTopic(mirrorTopic1).partitions();
            this.migrationState_$eq(this.migrationClient().topicClient().updateTopic(mirrorTopic1, mirrorTopicId1, mirrorTopicPartitions1, Optional.empty(), this.migrationState()));
            Assertions.assertTrue((boolean)this.zkClient().getClusterLinkForTopic(mirrorTopic1).isEmpty());
            java.util.Map newMirrorTopicPartitions = CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(mirrorTopicPartitions1).asScala().map((Function1 & Serializable)x0$11 -> {
                if (x0$11 != null) {
                    Integer tp = (Integer)x0$11._1();
                    PartitionRegistration registration = (PartitionRegistration)x0$11._2();
                    return new Tuple2((Object)tp, (Object)registration.unlink());
                }
                throw new MatchError(null);
            })).asJava();
            this.migrationState_$eq(this.migrationClient().topicClient().updateTopicPartitions(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)mirrorTopic1), (Object)newMirrorTopicPartitions)}))).asJava(), this.migrationState()));
            this.zkClient().getTopicPartitionStates((Seq)leaderAndIsrs1.keys().toSeq()).values().foreach((Function1 & Serializable)lisr -> {
                ZkClusterLinkMigrationTest.$anonfun$testClusterLinkAndMirrorTopicMigration$23(lisr);
                return BoxedUnit.UNIT;
            });
            scala.collection.mutable.Map newLinkConfigs = CollectionConverters$.MODULE$.PropertiesHasAsScala(actualLinkConfigs1).asScala();
            newLinkConfigs.put((Object)"ssl.keystore.password", (Object)"test2");
            ConfigResource configResource = new ConfigResource(ConfigResource.Type.CLUSTER_LINK, link1.linkId().toString());
            this.migrationClient().configClient().writeConfigs(configResource, CollectionConverters$.MODULE$.MutableMapHasAsJava(newLinkConfigs).asJava(), this.migrationState(), false);
            Properties actualEncryptedConfigs = this.zkClient().getEntityConfigs("cluster-links", CoreUtils$.MODULE$.toJavaUUID(link1.linkId()).toString());
            Properties expectedConfigs = new Properties();
            expectedConfigs.putAll((java.util.Map<?, ?>)CollectionConverters$.MODULE$.MutableMapHasAsJava(newLinkConfigs).asJava());
            Assertions.assertNotEquals((Object)expectedConfigs, (Object)actualEncryptedConfigs);
            Properties actualDecryptedConfigs = this.zkLinkConfigEncoder().decode(actualEncryptedConfigs);
            Assertions.assertEquals((Object)expectedConfigs, (Object)actualDecryptedConfigs);
        }
    }

    public static final /* synthetic */ boolean $anonfun$testClusterLinkAndMirrorTopicMigration$8(scala.collection.immutable.Set expectedAclsAfterMigration$1, AclAuthorizer authorizer$1, AclBindingFilter resourceFilter$1) {
        scala.collection.immutable.Set set = expectedAclsAfterMigration$1;
        scala.collection.immutable.Set set2 = ((IterableOnceOps)CollectionConverters$.MODULE$.IterableHasAsScala(authorizer$1.acls(resourceFilter$1)).asScala().map((Function1 & Serializable)x$2 -> x$2.entry())).toSet();
        return !(set != null ? !set.equals(set2) : set2 != null);
    }

    public static final /* synthetic */ String $anonfun$testClusterLinkAndMirrorTopicMigration$10() {
        return "ACLs are not updated in the authorizer";
    }

    public static final /* synthetic */ void $anonfun$testClusterLinkAndMirrorTopicMigration$12(ZkClusterLinkMigrationTest $this, Tuple2 x0$5) {
        if (x0$5 != null) {
            Map lisrs = (Map)x0$5._2();
            Assertions.assertEquals((Object)lisrs, (Object)$this.zkClient().getTopicPartitionStates((Seq)lisrs.keys().toSeq()));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testClusterLinkAndMirrorTopicMigration$13(MetadataDelta delta$1, java.util.List batch) {
        CollectionConverters$.MODULE$.ListHasAsScala(batch).asScala().foreach((Function1 & Serializable)record -> {
            delta$1.replay(record.message(), record.version());
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testClusterLinkAndMirrorTopicMigration$21(scala.collection.mutable.Map actualPartitionStates$1, Tuple2 x0$10) {
        if (x0$10 != null) {
            TopicPartition tp = (TopicPartition)x0$10._1();
            LeaderIsrAndControllerEpoch expectedPartition = (LeaderIsrAndControllerEpoch)x0$10._2();
            Assertions.assertTrue((boolean)expectedPartition.leaderAndIsr().equalsAllowStalePartitionEpoch((LeaderAndIsr)actualPartitionStates$1.apply((Object)tp)), (String)new StringBuilder(37).append("For partition ").append(tp).append(": Expected : ").append(expectedPartition.leaderAndIsr()).append(", ").append("Actual: ").append(actualPartitionStates$1.apply((Object)tp)).toString());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testClusterLinkAndMirrorTopicMigration$19(MetadataImage image$1, Tuple2 x0$8) {
        if (x0$8 != null) {
            String topic = (String)x0$8._1();
            Map lisrs = (Map)x0$8._2();
            scala.collection.mutable.Map actualPartitionStates = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(((TopicImage)image$1.topics().topicsByName().get((Object)topic)).partitions()).asScala().map((Function1 & Serializable)x0$9 -> {
                if (x0$9 != null) {
                    None$ none$;
                    Integer partition = (Integer)x0$9._1();
                    PartitionRegistration registration = (PartitionRegistration)x0$9._2();
                    TopicPartition topicPartition = new TopicPartition(topic, Predef$.MODULE$.Integer2int(partition));
                    int n = registration.leader;
                    int n2 = registration.leaderEpoch;
                    List list = Predef$.MODULE$.wrapIntArray(registration.isr).toList();
                    LeaderRecoveryState leaderRecoveryState = registration.leaderRecoveryState;
                    int n3 = registration.partitionEpoch;
                    PartitionRegistration.LinkState linkState = registration.linkState;
                    PartitionRegistration.LinkState linkState2 = PartitionRegistration.LinkState.NOT_MIRROR;
                    if (linkState == null ? linkState2 != null : !linkState.equals(linkState2)) {
                        PartitionRegistration.LinkState linkState3 = registration.linkState;
                        PartitionRegistration.LinkState linkState4 = PartitionRegistration.LinkState.FAILED;
                        boolean bl = !(linkState3 != null ? !linkState3.equals(linkState4) : linkState4 != null);
                        none$ = new Some((Object)new PartitionLinkState(registration.linkedLeaderEpoch, bl, MirrorTopicError.NO_ERROR));
                    } else {
                        none$ = None$.MODULE$;
                    }
                    return new Tuple2((Object)topicPartition, (Object)LeaderAndIsr$.MODULE$.apply(n, n2, list, leaderRecoveryState, n3, (Option)none$));
                }
                throw new MatchError(null);
            });
            Assertions.assertEquals((int)lisrs.size(), (int)actualPartitionStates.size());
            Assertions.assertEquals((Object)lisrs.keySet(), (Object)actualPartitionStates.keySet());
            lisrs.foreach((Function1 & Serializable)x0$10 -> {
                ZkClusterLinkMigrationTest.$anonfun$testClusterLinkAndMirrorTopicMigration$21(actualPartitionStates, x0$10);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testClusterLinkAndMirrorTopicMigration$23(LeaderIsrAndControllerEpoch lisr) {
        Assertions.assertTrue((boolean)lisr.leaderAndIsr().clusterLinkState().isEmpty());
    }
}

