/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk.migration;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.ReplicaAssignment;
import kafka.controller.ReplicaAssignment$;
import kafka.coordinator.transaction.ZkProducerIdManager;
import kafka.coordinator.transaction.ZkProducerIdManager$;
import kafka.server.KafkaConfig$;
import kafka.utils.Logging;
import kafka.zk.AdminZkClient;
import kafka.zk.KafkaZkClient;
import kafka.zk.TopicZNode;
import kafka.zk.migration.ZkMigrationTestHarness;
import org.apache.kafka.common.DirectoryId;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.errors.ControllerMovedException;
import org.apache.kafka.common.metadata.ConfigRecord;
import org.apache.kafka.common.metadata.EncryptedEnvelopeRecord;
import org.apache.kafka.common.metadata.MetadataRecordType;
import org.apache.kafka.common.metadata.PartitionRecord;
import org.apache.kafka.common.metadata.ProducerIdsRecord;
import org.apache.kafka.common.metadata.TopicRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.metadata.migration.KRaftMigrationZkWriter;
import org.apache.kafka.metadata.migration.MigrationClient;
import org.apache.kafka.metadata.migration.ZkMigrationLeadershipState;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.common.ProducerIdsBlock;
import org.apache.zookeeper.data.Stat;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u000554AAG\u000e\u0001E!)q\u0005\u0001C\u0001Q!)!\u0006\u0001C\u0001W!)q\b\u0001C\u0001W!)\u0011\t\u0001C\u0001W!)1\t\u0001C\u0001W!)Q\t\u0001C\u0001W!)q\t\u0001C\u0001W!)\u0011\n\u0001C\u0001W!)1\n\u0001C\u0001W!)Q\n\u0001C\u0001W!)q\n\u0001C\u0001W!)\u0011\u000b\u0001C\u0001W!)1\u000b\u0001C\u0001W!)Q\u000b\u0001C\u0001W!)q\u000b\u0001C\u0001W!)\u0011\f\u0001C\u0001W!)1\f\u0001C\u0001W!)Q\f\u0001C\u0001W!)q\f\u0001C\u0001W!)\u0011\r\u0001C\u0001W!)1\r\u0001C\u0001W!)Q\r\u0001C\u0001W!)q\r\u0001C\u0001W!)\u0011\u000e\u0001C\u0001W!)1\u000e\u0001C\u0001W\t)\"l['jOJ\fG/[8o\u00072LWM\u001c;UKN$(B\u0001\u000f\u001e\u0003%i\u0017n\u001a:bi&|gN\u0003\u0002\u001f?\u0005\u0011!p\u001b\u0006\u0002A\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001$!\t!S%D\u0001\u001c\u0013\t13D\u0001\f[W6KwM]1uS>tG+Z:u\u0011\u0006\u0014h.Z:t\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0006\u0005\u0002%\u0001\u0005\u0011B/Z:u\u001b&<'/\u0019;f\u000b6\u0004H/\u001f.l)\u0005a\u0003CA\u00171\u001b\u0005q#\"A\u0018\u0002\u000bM\u001c\u0017\r\\1\n\u0005Er#\u0001B+oSRD#AA\u001a\u0011\u0005QjT\"A\u001b\u000b\u0005Y:\u0014aA1qS*\u0011\u0001(O\u0001\bUV\u0004\u0018\u000e^3s\u0015\tQ4(A\u0003kk:LGOC\u0001=\u0003\ry'oZ\u0005\u0003}U\u0012A\u0001V3ti\u0006QB/Z:u\u001b&<'/\u0019;j_:\u0014%o\\6fe\u000e{gNZ5hg\"\u00121aM\u0001\u000fi\u0016\u001cH/R7qif<&/\u001b;fQ\t!1'\u0001\u000fuKN$X\u000b\u001d3bi\u0016,\u00050[:uS:<\u0007+\u0019:uSRLwN\\:)\u0005\u0015\u0019\u0014A\u0005;fgR\u001c%/Z1uK:+w\u000fV8qS\u000eD#AB\u001a\u00025Q,7\u000f^%eK6\u0004x\u000e^3oi\u000e\u0013X-\u0019;f)>\u0004\u0018nY:)\u0005\u001d\u0019\u0014!\u0007;fgR\u001cE.Y5n\u0003\n\u001cXM\u001c;D_:$(o\u001c7mKJD#\u0001C\u001a\u0002AQ,7\u000f^#ySN$\u0018N\\4L%\u00064GoQ8oiJ|G\u000e\\3s\u00072\f\u0017.\u001c\u0015\u0003\u0013M\n1\u0004^3ti:{g.\u00138de\u0016\f7/\u001b8h\u0017J\u000bg\r^#q_\u000eD\u0007F\u0001\u00064\u0003\u0015\"Xm\u001d;DY\u0006LW.\u00118e%\u0016dW-Y:f\u000bbL7\u000f^5oO\u000e{g\u000e\u001e:pY2,'\u000f\u000b\u0002\fg\u0005\tC/Z:u%\u0016\fG-T5he\u0006$X-\u00118e/JLG/\u001a)s_\u0012,8-\u001a:JI\"\u0012AbM\u0001\u0018i\u0016\u001cH/T5he\u0006$X\rV8qS\u000e\u001cuN\u001c4jOND#!D\u001a\u0002_Q,7\u000f\u001e+pa&\u001c\u0017I\u001c3Ce>\\WM]\"p]\u001aLwm]'jOJ\fG/[8o/&$\bn\u00158baNDw\u000e^:)\u00059\u0019\u0014A\r;fgR,\u0006\u000fZ1uK\u0016C\u0018n\u001d;j]\u001e$v\u000e]5d/&$\bNT3x\u0003:$7\t[1oO\u0016$\u0007+\u0019:uSRLwN\\:)\u0005=\u0019\u0014\u0001\u0007;fgR<&/\u001b;f\u001d\u0016<Hk\u001c9jG\u000e{gNZ5hg\"\u0012\u0001cM\u0001\u001ei\u0016\u001cHo\u0016:ji\u0016,\u00050[:uS:<Gk\u001c9jG\u000e{gNZ5hg\"\u0012\u0011cM\u0001\u0016i\u0016\u001cHo\u0011:fCR,g*Z<Ne\u000e$v\u000e]5dQ\t\u00112'\u0001\u0013uKN$8I]3bi\u0016l%o\u0019+pa&\u001cG)\u001e:j]\u001e\u0014V-Y:tS\u001etW.\u001a8uQ\t\u00192'A\u0014uKN$8I]3bi\u0016tuN\\'sGR{\u0007/[2EkJLgn\u001a*fCN\u001c\u0018n\u001a8nK:$\bF\u0001\u000b4\u0003a!Xm\u001d;De\u0016\fG/\u001a(fo:{g.\u0014:d)>\u0004\u0018n\u0019\u0015\u0003+M\n1\u0003^3ti6KwM]1uK6\u00138\rV8qS\u000eD#AF\u001a\u0002-Q,7\u000f^'jOJ\fG/\u001a(p]6\u00138\rV8qS\u000eD#aF\u001a\u0002KQ,7\u000f^'jOJ\fG/Z'sGR{\u0007/[2EkJLgn\u001a*fCN\u001c\u0018n\u001a8nK:$\bF\u0001\r4\u0003!\"Xm\u001d;NS\u001e\u0014\u0018\r^3O_:l%o\u0019+pa&\u001cG)\u001e:j]\u001e\u0014V-Y:tS\u001etW.\u001a8uQ\tI2\u0007")
public class ZkMigrationClientTest
extends ZkMigrationTestHarness {
    @Test
    public void testMigrateEmptyZk() {
        ArrayList brokers = new ArrayList();
        ArrayList batches = new ArrayList();
        this.migrationClient().cleanAndMigrateAllMetadata(batch -> batches.add(batch), brokerId -> brokers.add(brokerId), (x$1, operation) -> this.migrationState_$eq(operation.apply(this.migrationState())), Collections.emptyMap(), this.kraftEncryptor().id(), MetadataVersion.latestTesting());
        Assertions.assertEquals((int)0, (int)brokers.size());
        Assertions.assertEquals((int)0, (int)batches.size());
    }

    @Test
    public void testMigrationBrokerConfigs() {
        ArrayList brokers = new ArrayList();
        ArrayList batches = new ArrayList();
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.DefaultReplicationFactorProp(), "1");
        props.put(KafkaConfig$.MODULE$.SslKeystorePasswordProp(), this.encoder().encode(new Password(this.SECRET())));
        this.zkClient().setOrCreateEntityConfigs("brokers", "1", props);
        this.migrationClient().cleanAndMigrateAllMetadata(batch -> batches.add(batch), brokerId -> brokers.add(brokerId), (x$2, operation) -> this.migrationState_$eq(operation.apply(this.migrationState())), Collections.emptyMap(), this.kraftEncryptor().id(), MetadataVersion.latestTesting());
        Assertions.assertEquals((int)1, (int)brokers.size());
        Assertions.assertEquals((int)1, (int)batches.size());
        Assertions.assertEquals((int)2, (int)((java.util.List)batches.get(0)).size());
        ((Iterable)batches.get(0)).forEach(record -> {
            ConfigRecord message = (ConfigRecord)(record.message().apiKey() == this.ENCRYPTED_ENVELOPE_RECORD_API_KEY() ? this.kraftEncryptor().decrypt((EncryptedEnvelopeRecord)record.message()) : record).message();
            String name = message.name();
            String value = message.value();
            Assertions.assertTrue((boolean)props.containsKey(name));
            String string = name;
            String string2 = KafkaConfig$.MODULE$.SslKeystorePasswordProp();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                Assertions.assertEquals((Object)this.SECRET(), (Object)value);
                return;
            }
            Assertions.assertEquals((Object)props.getProperty(name), (Object)value);
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testEmptyWrite() {
        void var3_3;
        void var2_2;
        Tuple2 tuple2 = this.zkClient().retryMigrationRequestsUntilConnected((Seq)Nil$.MODULE$, this.migrationState());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int zkVersion = tuple2._1$mcI$sp();
        Seq responses = (Seq)tuple2._2();
        Assertions.assertEquals((int)this.migrationState().migrationZkVersion(), (int)var2_2);
        Assertions.assertTrue((boolean)var3_3.isEmpty());
    }

    @Test
    public void testUpdateExistingPartitions() {
        scala.collection.immutable.Map assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("test", 0)), (Object)new ReplicaAssignment((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$, (Option)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("test", 1)), (Object)new ReplicaAssignment((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$, (Option)None$.MODULE$))}));
        this.zkClient().createTopicAssignment("test", (Option)new Some((Object)Uuid.randomUuid()), (Option)None$.MODULE$, (Map)assignment, (Option)None$.MODULE$);
        scala.collection.immutable.Map leaderAndIsrs = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("test", 0)), (Object)new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(0, 5, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), LeaderRecoveryState.RECOVERED, -1, (Option)None$.MODULE$), 1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("test", 1)), (Object)new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(1, 5, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, -1, (Option)None$.MODULE$), 1))}));
        this.zkClient().createTopicPartitionStatesRaw((Map)leaderAndIsrs, 0);
        Assertions.assertEquals((int)0, (int)this.migrationState().migrationZkVersion());
        java.util.Map partitions = CollectionConverters$.MODULE$.MapHasAsJava((Map)((MapOps)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)new PartitionRegistration.Builder().setReplicas(new int[]{0, 1, 2}).setDirectories(DirectoryId.migratingArray((int)3)).setIsr(new int[]{1, 2}).setLeader(Predef$.MODULE$.int2Integer(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Predef$.MODULE$.int2Integer(6)).setPartitionEpoch(Predef$.MODULE$.int2Integer(-1)).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3}).setDirectories(DirectoryId.migratingArray((int)3)).setIsr(new int[]{3}).setLeader(Predef$.MODULE$.int2Integer(3)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Predef$.MODULE$.int2Integer(7)).setPartitionEpoch(Predef$.MODULE$.int2Integer(-1)).build())}))).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                int k = x0$1._1$mcI$sp();
                PartitionRegistration v = (PartitionRegistration)x0$1._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v);
            }
            throw new MatchError(null);
        })).asJava();
        this.migrationState_$eq(this.migrationClient().topicClient().updateTopicPartitions(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test"), (Object)partitions)}))).asJava(), this.migrationState()));
        Assertions.assertEquals((int)1, (int)this.migrationState().migrationZkVersion());
        LeaderAndIsr partition0 = ((LeaderIsrAndControllerEpoch)this.zkClient().getTopicPartitionState(new TopicPartition("test", 0)).get()).leaderAndIsr();
        Assertions.assertEquals((int)1, (int)partition0.leader());
        Assertions.assertEquals((int)6, (int)partition0.leaderEpoch());
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)partition0.isr());
        LeaderAndIsr partition1 = ((LeaderIsrAndControllerEpoch)this.zkClient().getTopicPartitionState(new TopicPartition("test", 1)).get()).leaderAndIsr();
        Assertions.assertEquals((int)3, (int)partition1.leader());
        Assertions.assertEquals((int)7, (int)partition1.leaderEpoch());
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3})), (Object)partition1.isr());
        this.migrationState_$eq(this.migrationClient().topicClient().deleteTopic("test", this.migrationState()));
        Assertions.assertEquals((int)2, (int)this.migrationState().migrationZkVersion());
    }

    @Test
    public void testCreateNewTopic() {
        Assertions.assertEquals((int)0, (int)this.migrationState().migrationZkVersion());
        java.util.Map partitions = CollectionConverters$.MODULE$.MapHasAsJava((Map)((MapOps)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)new PartitionRegistration.Builder().setReplicas(new int[]{0, 1, 2}).setDirectories(DirectoryId.unassignedArray((int)3)).setIsr(new int[]{0, 1, 2}).setLeader(Predef$.MODULE$.int2Integer(0)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Predef$.MODULE$.int2Integer(0)).setPartitionEpoch(Predef$.MODULE$.int2Integer(-1)).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3}).setDirectories(DirectoryId.unassignedArray((int)3)).setIsr(new int[]{1, 2, 3}).setLeader(Predef$.MODULE$.int2Integer(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Predef$.MODULE$.int2Integer(0)).setPartitionEpoch(Predef$.MODULE$.int2Integer(-1)).build())}))).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                int k = x0$1._1$mcI$sp();
                PartitionRegistration v = (PartitionRegistration)x0$1._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v);
            }
            throw new MatchError(null);
        })).asJava();
        this.migrationState_$eq(this.migrationClient().topicClient().createTopic("test", Uuid.randomUuid(), partitions, this.migrationState()));
        Assertions.assertEquals((int)1, (int)this.migrationState().migrationZkVersion());
        LeaderAndIsr partition0 = ((LeaderIsrAndControllerEpoch)this.zkClient().getTopicPartitionState(new TopicPartition("test", 0)).get()).leaderAndIsr();
        Assertions.assertEquals((int)0, (int)partition0.leader());
        Assertions.assertEquals((int)0, (int)partition0.leaderEpoch());
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Object)partition0.isr());
        LeaderAndIsr partition1 = ((LeaderIsrAndControllerEpoch)this.zkClient().getTopicPartitionState(new TopicPartition("test", 1)).get()).leaderAndIsr();
        Assertions.assertEquals((int)1, (int)partition1.leader());
        Assertions.assertEquals((int)0, (int)partition1.leaderEpoch());
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Object)partition1.isr());
    }

    @Test
    public void testIdempotentCreateTopics() {
        Assertions.assertEquals((int)0, (int)this.migrationState().migrationZkVersion());
        java.util.Map partitions = CollectionConverters$.MODULE$.MapHasAsJava((Map)((MapOps)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)new PartitionRegistration.Builder().setReplicas(new int[]{0, 1, 2}).setDirectories(DirectoryId.unassignedArray((int)3)).setIsr(new int[]{0, 1, 2}).setLeader(Predef$.MODULE$.int2Integer(0)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Predef$.MODULE$.int2Integer(0)).setPartitionEpoch(Predef$.MODULE$.int2Integer(-1)).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3}).setDirectories(DirectoryId.unassignedArray((int)3)).setIsr(new int[]{1, 2, 3}).setLeader(Predef$.MODULE$.int2Integer(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Predef$.MODULE$.int2Integer(0)).setPartitionEpoch(Predef$.MODULE$.int2Integer(-1)).build())}))).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                int k = x0$1._1$mcI$sp();
                PartitionRegistration v = (PartitionRegistration)x0$1._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v);
            }
            throw new MatchError(null);
        })).asJava();
        Uuid topicId = Uuid.randomUuid();
        this.migrationState_$eq(this.migrationClient().topicClient().createTopic("test", topicId, partitions, this.migrationState()));
        Assertions.assertEquals((int)1, (int)this.migrationState().migrationZkVersion());
        this.migrationState_$eq(this.migrationClient().topicClient().createTopic("test", topicId, partitions, this.migrationState()));
        Assertions.assertEquals((int)1, (int)this.migrationState().migrationZkVersion());
    }

    @Test
    public void testClaimAbsentController() {
        Assertions.assertEquals((int)0, (int)this.migrationState().migrationZkVersion());
        this.migrationState_$eq(this.migrationClient().claimControllerLeadership(this.migrationState()));
        Assertions.assertEquals((int)1, (int)this.migrationState().zkControllerEpochZkVersion());
    }

    @Test
    public void testExistingKRaftControllerClaim() {
        Assertions.assertEquals((int)0, (int)this.migrationState().migrationZkVersion());
        this.migrationState_$eq(this.migrationClient().claimControllerLeadership(this.migrationState()));
        Assertions.assertEquals((int)1, (int)this.migrationState().zkControllerEpochZkVersion());
        ZkMigrationLeadershipState otherNodeState = ZkMigrationLeadershipState.EMPTY.withNewKRaftController(3001, 43).withKRaftMetadataOffsetAndEpoch(100L, 42);
        otherNodeState = this.migrationClient().claimControllerLeadership(otherNodeState);
        Assertions.assertEquals((int)2, (int)otherNodeState.zkControllerEpochZkVersion());
        Assertions.assertEquals((int)3001, (int)otherNodeState.kraftControllerId());
        Assertions.assertEquals((int)43, (int)otherNodeState.kraftControllerEpoch());
    }

    @Test
    public void testNonIncreasingKRaftEpoch() {
        Assertions.assertEquals((int)0, (int)this.migrationState().migrationZkVersion());
        this.migrationState_$eq(this.migrationState().withNewKRaftController(3001, this.InitialControllerEpoch()));
        this.migrationState_$eq(this.migrationClient().claimControllerLeadership(this.migrationState()));
        Assertions.assertEquals((int)1, (int)this.migrationState().zkControllerEpochZkVersion());
        this.migrationState_$eq(this.migrationState().withNewKRaftController(3001, this.InitialControllerEpoch() - 1));
        ControllerMovedException t1 = (ControllerMovedException)Assertions.assertThrows(ControllerMovedException.class, () -> this.migrationClient().claimControllerLeadership(this.migrationState()));
        Assertions.assertEquals((Object)"Cannot register KRaft controller 3001 with epoch 41 as the current controller register in ZK has the same or newer epoch 42.", (Object)t1.getMessage());
        this.migrationState_$eq(this.migrationState().withNewKRaftController(3001, this.InitialControllerEpoch()));
        ControllerMovedException t2 = (ControllerMovedException)Assertions.assertThrows(ControllerMovedException.class, () -> this.migrationClient().claimControllerLeadership(this.migrationState()));
        Assertions.assertEquals((Object)"Cannot register KRaft controller 3001 with epoch 42 as the current controller register in ZK has the same or newer epoch 42.", (Object)t2.getMessage());
        this.migrationState_$eq(this.migrationState().withNewKRaftController(3001, 100));
        this.migrationState_$eq(this.migrationClient().claimControllerLeadership(this.migrationState()));
        Assertions.assertEquals((int)this.migrationState().kraftControllerEpoch(), (int)100);
        Assertions.assertEquals((int)this.migrationState().kraftControllerId(), (int)3001);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testClaimAndReleaseExistingController() {
        void var10_10;
        void var9_9;
        Tuple2 tuple2;
        void var3_3;
        void var2_2;
        Assertions.assertEquals((int)0, (int)this.migrationState().migrationZkVersion());
        Tuple2 tuple22 = this.zkClient().registerControllerAndIncrementControllerEpoch(100);
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        int epoch = tuple22._1$mcI$sp();
        int zkVersion = tuple22._2$mcI$sp();
        Assertions.assertEquals((int)var2_2, (int)2);
        Assertions.assertEquals((int)var3_3, (int)1);
        this.migrationState_$eq(this.migrationClient().claimControllerLeadership(this.migrationState()));
        Assertions.assertEquals((int)2, (int)this.migrationState().zkControllerEpochZkVersion());
        Option option = this.zkClient().getControllerEpoch();
        if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
            int zkEpoch = tuple2._1$mcI$sp();
            Stat stat = (Stat)tuple2._2();
            Assertions.assertEquals((int)3, (int)zkEpoch);
            Assertions.assertEquals((int)2, (int)stat.getVersion());
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail();
        } else {
            throw new MatchError((Object)option);
        }
        Assertions.assertEquals((int)3000, (int)BoxesRunTime.unboxToInt((Object)this.zkClient().getControllerId().get()));
        Assertions.assertThrows(ControllerMovedException.class, () -> this.zkClient().registerControllerAndIncrementControllerEpoch(100));
        this.migrationState_$eq(this.migrationClient().releaseControllerLeadership(this.migrationState()));
        Tuple2 tuple23 = this.zkClient().registerControllerAndIncrementControllerEpoch(100);
        if (tuple23 == null) {
            throw new MatchError(null);
        }
        int epoch1 = tuple23._1$mcI$sp();
        int zkVersion1 = tuple23._2$mcI$sp();
        Assertions.assertEquals((int)var9_9, (int)4);
        Assertions.assertEquals((int)var10_10, (int)3);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testReadMigrateAndWriteProducerId() {
        long l;
        void zk_zkClient;
        ZkProducerIdManager$.MODULE$.getNewProducerIdBlock(1, this.zkClient(), (Logging)this);
        ZkProducerIdManager$.MODULE$.getNewProducerIdBlock(2, this.zkClient(), (Logging)this);
        ProducerIdsBlock block = ZkProducerIdManager$.MODULE$.getNewProducerIdBlock(3, this.zkClient(), (Logging)this);
        ArrayList records = new ArrayList();
        this.migrationClient().migrateProducerId(batch -> records.add(batch));
        Assertions.assertEquals((int)1, (int)records.size());
        Assertions.assertEquals((int)1, (int)((java.util.List)records.get(0)).size());
        ProducerIdsRecord record = (ProducerIdsRecord)((ApiMessageAndVersion)((java.util.List)records.get(0)).get(0)).message();
        Assertions.assertEquals((long)block.nextBlockFirstId(), (long)record.nextProducerId());
        this.migrationState_$eq(this.migrationClient().writeProducerId(6000L, this.migrationState()));
        Assertions.assertEquals((int)1, (int)this.migrationState().migrationZkVersion());
        KafkaZkClient kafkaZkClient = this.zkClient();
        int zk_brokerId = 1;
        kafkaZkClient = null;
        Try try_ = new ZkProducerIdManager(zk_brokerId, (KafkaZkClient)zk_zkClient).generateProducerId();
        if (try_ instanceof Failure) {
            Throwable e = ((Failure)try_).exception();
            l = BoxesRunTime.unboxToLong((Object)Assertions.fail((String)"Encountered error when generating producer id", (Throwable)e));
        } else if (try_ instanceof Success) {
            l = BoxesRunTime.unboxToLong((Object)((Success)try_).value());
        } else {
            throw new MatchError((Object)try_);
        }
        long producerId = l;
        Assertions.assertEquals((long)7000L, (long)producerId);
    }

    @Test
    public void testMigrateTopicConfigs() {
        Properties props = new Properties();
        props.put("flush.ms", "60000");
        props.put("retention.ms", "300000");
        scala.collection.immutable.Map partitionReplicaAssignment = (scala.collection.immutable.Map)((MapOps)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 0, 1})))}))).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                int k = x0$1._1$mcI$sp();
                Seq v = (Seq)x0$1._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)k)), (Object)new ReplicaAssignment(v, (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$, (Option)None$.MODULE$));
            }
            throw new MatchError(null);
        });
        AdminZkClient qual$1 = this.adminZkClient();
        None$ x$62 = None$.MODULE$;
        boolean x$72 = qual$1.createTopicWithAssignment$default$4();
        qual$1.createTopicWithAssignment("test", props, (Map)partitionReplicaAssignment, x$72, true, false, (Option)x$62);
        ArrayList brokers = new ArrayList();
        ArrayList batches = new ArrayList();
        this.migrationClient().cleanAndMigrateAllMetadata(batch -> batches.add(batch), brokerId -> brokers.add(brokerId), (x$6, operation) -> this.migrationState_$eq(operation.apply(this.migrationState())), Collections.emptyMap(), this.kraftEncryptor().id(), MetadataVersion.latestTesting());
        Assertions.assertEquals((int)1, (int)batches.size());
        scala.collection.immutable.Map configs = ((IterableOnceOps)((IterableOps)((IterableOps)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)batches.get(0)).asScala().map((Function1 & Serializable)x$7 -> x$7.message())).filter((Function1 & Serializable)message -> BoxesRunTime.boxToBoolean((boolean)ZkMigrationClientTest.$anonfun$testMigrateTopicConfigs$6(message)))).map((Function1 & Serializable)x$8 -> (ConfigRecord)x$8)).map((Function1 & Serializable)record -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)record.name()), (Object)record.value()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Assertions.assertEquals((int)2, (int)configs.size());
        Assertions.assertTrue((boolean)configs.contains((Object)"flush.ms"));
        Assertions.assertEquals((Object)"60000", (Object)configs.apply((Object)"flush.ms"));
        Assertions.assertTrue((boolean)configs.contains((Object)"retention.ms"));
        Assertions.assertEquals((Object)"300000", (Object)configs.apply((Object)"retention.ms"));
    }

    @Test
    public void testTopicAndBrokerConfigsMigrationWithSnapshots() {
        KRaftMigrationZkWriter kraftWriter = new KRaftMigrationZkWriter((MigrationClient)this.migrationClient(), x$9 -> Assertions.fail((String)x$9));
        String topicName = "testTopic";
        int partition = 0;
        TopicPartition tp = new TopicPartition(topicName, partition);
        int leaderPartition = 1;
        int leaderEpoch = 100;
        int partitionEpoch = 10;
        String brokerId = "1";
        java.util.List replicas = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))).map((Function1 & Serializable)x -> Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)x)))).asJava();
        Uuid topicId = Uuid.randomUuid();
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.DefaultReplicationFactorProp(), "1");
        props.put(KafkaConfig$.MODULE$.SslKeystorePasswordProp(), this.SECRET());
        MetadataDelta delta = new MetadataDelta.Builder().setImage(MetadataImage.EMPTY).build();
        delta.replay(new TopicRecord().setTopicId(topicId).setName(topicName));
        delta.replay(new PartitionRecord().setTopicId(topicId).setIsr(replicas).setLeader(leaderPartition).setReplicas(replicas).setAddingReplicas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().empty()).asJava()).setRemovingReplicas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().empty()).asJava()).setLeaderEpoch(leaderEpoch).setPartitionEpoch(partitionEpoch).setPartitionId(partition).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED.value()));
        CollectionConverters$.MODULE$.PropertiesHasAsScala(props).asScala().foreach((Function1 & Serializable)x0$1 -> {
            ZkMigrationClientTest.$anonfun$testTopicAndBrokerConfigsMigrationWithSnapshots$3(delta, topicName, brokerId, x0$1);
            return BoxedUnit.UNIT;
        });
        MetadataImage image = delta.apply(MetadataProvenance.EMPTY);
        kraftWriter.handleSnapshot(image, (x$10, x$11, operation) -> this.migrationState_$eq(operation.apply(this.migrationState())));
        Set topicIdReplicaAssignment = this.zkClient().getReplicaAssignmentAndTopicIdForTopics((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topicName})));
        Assertions.assertEquals((int)1, (int)topicIdReplicaAssignment.size());
        topicIdReplicaAssignment.foreach((Function1 & Serializable)assignment -> {
            ZkMigrationClientTest.$anonfun$testTopicAndBrokerConfigsMigrationWithSnapshots$5(topicName, topicId, tp, replicas, assignment);
            return BoxedUnit.UNIT;
        });
        Option topicPartitionState = this.zkClient().getTopicPartitionState(tp);
        Assertions.assertTrue((boolean)topicPartitionState.isDefined());
        topicPartitionState.foreach((Function1 & Serializable)state -> {
            ZkMigrationClientTest.$anonfun$testTopicAndBrokerConfigsMigrationWithSnapshots$7(leaderPartition, leaderEpoch, replicas, state);
            return BoxedUnit.UNIT;
        });
        Properties brokerProps = this.zkClient().getEntityConfigs("brokers", brokerId);
        Properties topicProps = this.zkClient().getEntityConfigs("topics", topicName);
        Assertions.assertEquals((int)2, (int)brokerProps.size());
        CollectionConverters$.MODULE$.PropertiesHasAsScala(brokerProps).asScala().foreach((Function1 & Serializable)x0$2 -> {
            ZkMigrationClientTest.$anonfun$testTopicAndBrokerConfigsMigrationWithSnapshots$9(this, props, x0$2);
            return BoxedUnit.UNIT;
        });
        CollectionConverters$.MODULE$.PropertiesHasAsScala(topicProps).asScala().foreach((Function1 & Serializable)x0$3 -> {
            ZkMigrationClientTest.$anonfun$testTopicAndBrokerConfigsMigrationWithSnapshots$10(this, props, x0$3);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testUpdateExistingTopicWithNewAndChangedPartitions() {
        Assertions.assertEquals((int)0, (int)this.migrationState().migrationZkVersion());
        Uuid topicId = Uuid.randomUuid();
        java.util.Map partitions = CollectionConverters$.MODULE$.MapHasAsJava((Map)((MapOps)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)new PartitionRegistration.Builder().setReplicas(new int[]{0, 1, 2}).setDirectories(DirectoryId.unassignedArray((int)3)).setIsr(new int[]{0, 1, 2}).setLeader(Predef$.MODULE$.int2Integer(0)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Predef$.MODULE$.int2Integer(0)).setPartitionEpoch(Predef$.MODULE$.int2Integer(-1)).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3}).setDirectories(DirectoryId.unassignedArray((int)3)).setIsr(new int[]{1, 2, 3}).setLeader(Predef$.MODULE$.int2Integer(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Predef$.MODULE$.int2Integer(0)).setPartitionEpoch(Predef$.MODULE$.int2Integer(-1)).build())}))).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                int k = x0$1._1$mcI$sp();
                PartitionRegistration v = (PartitionRegistration)x0$1._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v);
            }
            throw new MatchError(null);
        })).asJava();
        this.migrationState_$eq(this.migrationClient().topicClient().createTopic("test", topicId, partitions, this.migrationState()));
        Assertions.assertEquals((int)1, (int)this.migrationState().migrationZkVersion());
        java.util.Map changedPartitions = CollectionConverters$.MODULE$.MapHasAsJava((Map)((MapOps)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3}).setDirectories(DirectoryId.unassignedArray((int)3)).setIsr(new int[]{1, 2, 3}).setLeader(Predef$.MODULE$.int2Integer(0)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Predef$.MODULE$.int2Integer(0)).setPartitionEpoch(Predef$.MODULE$.int2Integer(-1)).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)new PartitionRegistration.Builder().setReplicas(new int[]{0, 1, 2}).setDirectories(DirectoryId.unassignedArray((int)3)).setIsr(new int[]{0, 1, 2}).setLeader(Predef$.MODULE$.int2Integer(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Predef$.MODULE$.int2Integer(0)).setPartitionEpoch(Predef$.MODULE$.int2Integer(-1)).build())}))).map((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                int k = x0$2._1$mcI$sp();
                PartitionRegistration v = (PartitionRegistration)x0$2._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v);
            }
            throw new MatchError(null);
        })).asJava();
        this.migrationState_$eq(this.migrationClient().topicClient().updateTopic("test", topicId, changedPartitions, Optional.empty(), this.migrationState()));
        Assertions.assertEquals((int)2, (int)this.migrationState().migrationZkVersion());
        Set topicReplicaAssignmentFromZk = this.zkClient().getReplicaAssignmentAndTopicIdForTopics((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test"})));
        Assertions.assertEquals((int)1, (int)topicReplicaAssignmentFromZk.size());
        Assertions.assertEquals((Object)new Some((Object)topicId), (Object)((TopicZNode.TopicIdReplicaAssignment)topicReplicaAssignmentFromZk.head()).topicId());
        ((TopicZNode.TopicIdReplicaAssignment)topicReplicaAssignmentFromZk.head()).assignment().foreach((Function1 & Serializable)x0$3 -> {
            ZkMigrationClientTest.$anonfun$testUpdateExistingTopicWithNewAndChangedPartitions$3(changedPartitions, x0$3);
            return BoxedUnit.UNIT;
        });
        java.util.Map newPartition = CollectionConverters$.MODULE$.MapHasAsJava((Map)((MapOps)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)new PartitionRegistration.Builder().setReplicas(new int[]{2, 3, 4}).setDirectories(DirectoryId.unassignedArray((int)3)).setIsr(new int[]{2, 3, 4}).setLeader(Predef$.MODULE$.int2Integer(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Predef$.MODULE$.int2Integer(0)).setPartitionEpoch(Predef$.MODULE$.int2Integer(-1)).build())}))).map((Function1 & Serializable)x0$4 -> {
            if (x0$4 != null) {
                int k = x0$4._1$mcI$sp();
                PartitionRegistration v = (PartitionRegistration)x0$4._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Predef$.MODULE$.int2Integer(k)), (Object)v);
            }
            throw new MatchError(null);
        })).asJava();
        this.migrationState_$eq(this.migrationClient().topicClient().createTopicPartitions(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test"), (Object)newPartition)}))).asJava(), this.migrationState()));
        Assertions.assertEquals((int)3, (int)this.migrationState().migrationZkVersion());
        Option newPartitionFromZk = this.zkClient().getTopicPartitionState(new TopicPartition("test", 2));
        Assertions.assertTrue((boolean)newPartitionFromZk.isDefined());
        newPartitionFromZk.foreach((Function1 & Serializable)part -> {
            ZkMigrationClientTest.$anonfun$testUpdateExistingTopicWithNewAndChangedPartitions$5(newPartition, part);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testWriteNewTopicConfigs() {
        this.migrationState_$eq(this.migrationClient().configClient().writeConfigs(new ConfigResource(ConfigResource.Type.TOPIC, "test"), Collections.singletonMap("segment.ms", "100000"), this.migrationState(), true));
        Assertions.assertEquals((int)1, (int)this.migrationState().migrationZkVersion());
        Properties newProps = this.zkClient().getEntityConfigs("topics", "test");
        Assertions.assertEquals((int)1, (int)newProps.size());
        Assertions.assertEquals((Object)"100000", (Object)newProps.getProperty("segment.ms"));
    }

    @Test
    public void testWriteExistingTopicConfigs() {
        Properties props = new Properties();
        props.put("flush.ms", "60000");
        props.put("retention.ms", "300000");
        this.zkClient().setOrCreateEntityConfigs("topics", "test", props);
        this.migrationState_$eq(this.migrationClient().configClient().writeConfigs(new ConfigResource(ConfigResource.Type.TOPIC, "test"), Collections.singletonMap("segment.ms", "100000"), this.migrationState(), true));
        Assertions.assertEquals((int)1, (int)this.migrationState().migrationZkVersion());
        Properties newProps = this.zkClient().getEntityConfigs("topics", "test");
        Assertions.assertEquals((int)1, (int)newProps.size());
        Assertions.assertEquals((Object)"100000", (Object)newProps.getProperty("segment.ms"));
    }

    @Test
    public void testCreateNewMrcTopic() {
        Assertions.assertEquals((int)0, (int)this.migrationState().migrationZkVersion());
        int[] syncReplicas = new int[]{0, 1};
        int[] observers = new int[]{5, 6};
        int[] replicas = (int[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.intArrayOps(syncReplicas), (Object)observers, (ClassTag)ClassTag$.MODULE$.Int());
        java.util.Map partitions = CollectionConverters$.MODULE$.MapHasAsJava((Map)((MapOps)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)new PartitionRegistration.Builder().setReplicas(replicas).setDirectories(DirectoryId.migratingArray((int)4)).setObservers(observers).setIsr(syncReplicas).setLeader(Predef$.MODULE$.int2Integer(0)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Predef$.MODULE$.int2Integer(0)).setPartitionEpoch(Predef$.MODULE$.int2Integer(0)).build())}))).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                int k = x0$1._1$mcI$sp();
                PartitionRegistration v = (PartitionRegistration)x0$1._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v);
            }
            throw new MatchError(null);
        })).asJava();
        String topic = "mrc-topic-1";
        this.migrationState_$eq(this.migrationClient().topicClient().createTopic(topic, Uuid.randomUuid(), partitions, this.migrationState()));
        Assertions.assertEquals((int)1, (int)this.migrationState().migrationZkVersion());
        Option partitionOpt = this.zkClient().getFullReplicaAssignmentForTopics((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic}))).get((Object)new TopicPartition(topic, 0));
        Assertions.assertTrue((boolean)partitionOpt.isDefined());
        ReplicaAssignment partition = (ReplicaAssignment)partitionOpt.get();
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 5, 6})), (Object)partition.replicas());
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{5, 6})), (Object)partition.observers());
        Assertions.assertTrue((boolean)partition.addingReplicas().isEmpty());
        Assertions.assertTrue((boolean)partition.removingReplicas().isEmpty());
        Assertions.assertTrue((boolean)partition.targetObservers().isEmpty());
    }

    @Test
    public void testCreateMrcTopicDuringReassignment() {
        Assertions.assertEquals((int)0, (int)this.migrationState().migrationZkVersion());
        int[] replicas = new int[]{2, 3, 0, 1, 7, 8, 5, 6};
        int[] observers = new int[]{7, 8, 5, 6};
        int[] addingReplicas = new int[]{2, 3, 7, 8};
        int[] removingReplicas = new int[]{0, 1, 5, 6};
        int[] addingObservers = new int[]{7, 8};
        int[] removingObservers = new int[]{5, 6};
        int[] isr = new int[]{2, 3, 0, 1};
        java.util.Map partitions = CollectionConverters$.MODULE$.MapHasAsJava((Map)((MapOps)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)new PartitionRegistration.Builder().setReplicas(replicas).setDirectories(DirectoryId.migratingArray((int)8)).setObservers(observers).setIsr(isr).setRemovingReplicas(removingReplicas).setAddingReplicas(addingReplicas).setRemovingObservers(removingObservers).setAddingObservers(addingObservers).setLeader(Predef$.MODULE$.int2Integer(0)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Predef$.MODULE$.int2Integer(0)).setPartitionEpoch(Predef$.MODULE$.int2Integer(0)).build())}))).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                int k = x0$1._1$mcI$sp();
                PartitionRegistration v = (PartitionRegistration)x0$1._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v);
            }
            throw new MatchError(null);
        })).asJava();
        String topic = "mrc-topic-1";
        this.migrationState_$eq(this.migrationClient().topicClient().createTopic(topic, Uuid.randomUuid(), partitions, this.migrationState()));
        Assertions.assertEquals((int)1, (int)this.migrationState().migrationZkVersion());
        Option partitionOpt = this.zkClient().getFullReplicaAssignmentForTopics((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic}))).get((Object)new TopicPartition(topic, 0));
        Assertions.assertTrue((boolean)partitionOpt.isDefined());
        ReplicaAssignment partition = (ReplicaAssignment)partitionOpt.get();
        Assertions.assertEquals((Object)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.intArrayOps(replicas)), (Object)partition.replicas());
        Assertions.assertEquals((Object)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.intArrayOps(addingReplicas)), (Object)partition.addingReplicas());
        Assertions.assertEquals((Object)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.intArrayOps(removingReplicas)), (Object)partition.removingReplicas());
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{5, 6})), (Object)partition.observers());
        Assertions.assertEquals((Object)new Some((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{7, 8}))), (Object)partition.targetObservers());
    }

    @Test
    public void testCreateNonMrcTopicDuringReassignment() {
        Assertions.assertEquals((int)0, (int)this.migrationState().migrationZkVersion());
        int[] replicas = new int[]{3, 4, 5, 0, 1, 2};
        int[] addingReplicas = new int[]{3, 4, 5};
        int[] removingReplicas = new int[]{0, 1, 2};
        int[] isr = new int[]{3, 4, 5, 0, 1, 2};
        java.util.Map partitions = CollectionConverters$.MODULE$.MapHasAsJava((Map)((MapOps)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)new PartitionRegistration.Builder().setReplicas(replicas).setDirectories(DirectoryId.migratingArray((int)6)).setIsr(isr).setRemovingReplicas(removingReplicas).setAddingReplicas(addingReplicas).setLeader(Predef$.MODULE$.int2Integer(0)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Predef$.MODULE$.int2Integer(0)).setPartitionEpoch(Predef$.MODULE$.int2Integer(0)).build())}))).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                int k = x0$1._1$mcI$sp();
                PartitionRegistration v = (PartitionRegistration)x0$1._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v);
            }
            throw new MatchError(null);
        })).asJava();
        String topic = "topic-1";
        this.migrationState_$eq(this.migrationClient().topicClient().createTopic(topic, Uuid.randomUuid(), partitions, this.migrationState()));
        Assertions.assertEquals((int)1, (int)this.migrationState().migrationZkVersion());
        Option partitionOpt = this.zkClient().getFullReplicaAssignmentForTopics((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic}))).get((Object)new TopicPartition(topic, 0));
        Assertions.assertTrue((boolean)partitionOpt.isDefined());
        ReplicaAssignment partition = (ReplicaAssignment)partitionOpt.get();
        Assertions.assertEquals((Object)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.intArrayOps(replicas)), (Object)partition.replicas());
        Assertions.assertEquals((Object)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.intArrayOps(addingReplicas)), (Object)partition.addingReplicas());
        Assertions.assertEquals((Object)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.intArrayOps(removingReplicas)), (Object)partition.removingReplicas());
        Assertions.assertTrue((boolean)partition.observers().isEmpty());
        Assertions.assertEquals((Object)new Some((Object)Nil$.MODULE$), (Object)partition.targetObservers());
    }

    @Test
    public void testCreateNewNonMrcTopic() {
        Assertions.assertEquals((int)0, (int)this.migrationState().migrationZkVersion());
        int[] replicas = new int[]{0, 1, 2};
        java.util.Map partitions = CollectionConverters$.MODULE$.MapHasAsJava((Map)((MapOps)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)new PartitionRegistration.Builder().setReplicas(replicas).setDirectories(DirectoryId.migratingArray((int)3)).setIsr(replicas).setLeader(Predef$.MODULE$.int2Integer(0)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Predef$.MODULE$.int2Integer(0)).setPartitionEpoch(Predef$.MODULE$.int2Integer(0)).build())}))).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                int k = x0$1._1$mcI$sp();
                PartitionRegistration v = (PartitionRegistration)x0$1._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v);
            }
            throw new MatchError(null);
        })).asJava();
        String topic = "topic-1";
        this.migrationState_$eq(this.migrationClient().topicClient().createTopic(topic, Uuid.randomUuid(), partitions, this.migrationState()));
        Assertions.assertEquals((int)1, (int)this.migrationState().migrationZkVersion());
        Option partitionOpt = this.zkClient().getFullReplicaAssignmentForTopics((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic}))).get((Object)new TopicPartition(topic, 0));
        Assertions.assertTrue((boolean)partitionOpt.isDefined());
        ReplicaAssignment partition = (ReplicaAssignment)partitionOpt.get();
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Object)partition.replicas());
        Assertions.assertTrue((boolean)partition.observers().isEmpty());
        Assertions.assertTrue((boolean)partition.addingReplicas().isEmpty());
        Assertions.assertTrue((boolean)partition.removingReplicas().isEmpty());
        Assertions.assertTrue((boolean)partition.targetObservers().isEmpty());
    }

    @Test
    public void testMigrateMrcTopic() {
        String topicPlacementJson = "{\"version\":2,\"replicas\":[{\"count\":2,\"constraints\":{\"rack\": \"us-east-1\"}}],\"observers\":[{\"count\":2,\"constraints\":{\"rack\": \"us-west-2:\"}}]}";
        Properties props = new Properties();
        props.put("confluent.placement.constraints", topicPlacementJson);
        Seq syncReplicas = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1}));
        Seq observers = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{5, 6}));
        ReplicaAssignment assignment = ReplicaAssignment$.MODULE$.fromAssignment(new ReplicaAssignment.Assignment((Seq)syncReplicas.$plus$plus((IterableOnce)observers), observers));
        Seq expectedReplicas = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 5, 6}));
        Seq expectedObservers = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{5, 6}));
        String topic = "mrc-topic-1";
        scala.collection.immutable.Map assignmentMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)assignment)}));
        AdminZkClient qual$1 = this.adminZkClient();
        None$ x$6 = None$.MODULE$;
        boolean x$7 = qual$1.createTopicWithAssignment$default$4();
        qual$1.createTopicWithAssignment(topic, props, (Map)assignmentMap, x$7, true, false, (Option)x$6);
        ArrayList brokers = new ArrayList();
        ArrayList batches = new ArrayList();
        this.migrationClient().migrateTopics(batch -> batches.add(batch), brokerId -> brokers.add(brokerId), Predef$.MODULE$.Map().empty(), MetadataVersion.latestTesting());
        Assertions.assertEquals((int)1, (int)batches.size());
        Buffer messages = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)batches.get(0)).asScala().map((Function1 & Serializable)x$12 -> x$12.message());
        scala.collection.immutable.Seq configs = ((IterableOnceOps)((IterableOps)messages.filter((Function1 & Serializable)message -> BoxesRunTime.boxToBoolean((boolean)ZkMigrationClientTest.$anonfun$testMigrateMrcTopic$4(message)))).map((Function1 & Serializable)x$13 -> (ConfigRecord)x$13)).toSeq();
        Assertions.assertEquals((int)1, (int)configs.size());
        ConfigRecord configRecord = (ConfigRecord)configs.head();
        Assertions.assertEquals((Object)"confluent.placement.constraints", (Object)configRecord.name());
        Assertions.assertEquals((Object)topicPlacementJson, (Object)configRecord.value());
        scala.collection.immutable.Seq partitions = ((IterableOnceOps)((IterableOps)messages.filter((Function1 & Serializable)message -> BoxesRunTime.boxToBoolean((boolean)ZkMigrationClientTest.$anonfun$testMigrateMrcTopic$6(message)))).map((Function1 & Serializable)x$14 -> (PartitionRecord)x$14)).toSeq();
        Assertions.assertEquals((int)1, (int)partitions.size());
        PartitionRecord partitionRecord = (PartitionRecord)partitions.head();
        Assertions.assertEquals((Object)expectedReplicas, (Object)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(partitionRecord.replicas()).asScala().map((Function1 & Serializable)x$15 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$15)))).toSeq());
        Assertions.assertEquals((Object)expectedObservers, (Object)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(partitionRecord.observers()).asScala().map((Function1 & Serializable)x$16 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$16)))).toSeq());
        Assertions.assertTrue((boolean)partitionRecord.addingReplicas().isEmpty());
        Assertions.assertTrue((boolean)partitionRecord.removingReplicas().isEmpty());
        Assertions.assertTrue((boolean)partitionRecord.addingObservers().isEmpty());
        Assertions.assertTrue((boolean)partitionRecord.removingObservers().isEmpty());
    }

    @Test
    public void testMigrateNonMrcTopic() {
        ReplicaAssignment assignment = ReplicaAssignment$.MODULE$.fromAssignment(new ReplicaAssignment.Assignment((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Seq)Seq$.MODULE$.empty()));
        String topic = "topic-1";
        scala.collection.immutable.Map assignmentMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)assignment)}));
        AdminZkClient qual$1 = this.adminZkClient();
        Properties x$2 = new Properties();
        None$ x$6 = None$.MODULE$;
        boolean x$7 = qual$1.createTopicWithAssignment$default$4();
        qual$1.createTopicWithAssignment(topic, x$2, (Map)assignmentMap, x$7, true, false, (Option)x$6);
        ArrayList brokers = new ArrayList();
        ArrayList batches = new ArrayList();
        this.migrationClient().migrateTopics(batch -> batches.add(batch), brokerId -> brokers.add(brokerId), Predef$.MODULE$.Map().empty(), MetadataVersion.latestTesting());
        Assertions.assertEquals((int)1, (int)batches.size());
        Buffer messages = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)batches.get(0)).asScala().map((Function1 & Serializable)x$17 -> x$17.message());
        scala.collection.immutable.Seq configs = ((IterableOnceOps)((IterableOps)messages.filter((Function1 & Serializable)message -> BoxesRunTime.boxToBoolean((boolean)ZkMigrationClientTest.$anonfun$testMigrateNonMrcTopic$4(message)))).map((Function1 & Serializable)x$18 -> (ConfigRecord)x$18)).toSeq();
        Assertions.assertEquals((int)0, (int)configs.size());
        scala.collection.immutable.Seq partitions = ((IterableOnceOps)((IterableOps)messages.filter((Function1 & Serializable)message -> BoxesRunTime.boxToBoolean((boolean)ZkMigrationClientTest.$anonfun$testMigrateNonMrcTopic$6(message)))).map((Function1 & Serializable)x$19 -> (PartitionRecord)x$19)).toSeq();
        Assertions.assertEquals((int)1, (int)partitions.size());
        PartitionRecord partitionRecord = (PartitionRecord)partitions.head();
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Object)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(partitionRecord.replicas()).asScala().map((Function1 & Serializable)x$20 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$20)))).toSeq());
        Assertions.assertTrue((boolean)partitionRecord.observers().isEmpty());
        Assertions.assertTrue((boolean)partitionRecord.addingReplicas().isEmpty());
        Assertions.assertTrue((boolean)partitionRecord.removingReplicas().isEmpty());
        Assertions.assertTrue((boolean)partitionRecord.addingObservers().isEmpty());
        Assertions.assertTrue((boolean)partitionRecord.removingObservers().isEmpty());
    }

    @Test
    public void testMigrateMrcTopicDuringReassignment() {
        String topicPlacementJson = "{\"version\":2,\"replicas\":[{\"count\":2,\"constraints\":{\"rack\": \"us-east-1\"}}],\"observers\":[{\"count\":2,\"constraints\":{\"rack\": \"us-west-2:\"}}]}";
        Properties props = new Properties();
        props.put("confluent.placement.constraints", topicPlacementJson);
        Seq originalSyncReplicas = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1}));
        Seq originalObservers = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{5, 6}));
        ReplicaAssignment originalAssignment = ReplicaAssignment$.MODULE$.fromAssignment(new ReplicaAssignment.Assignment((Seq)originalSyncReplicas.$plus$plus((IterableOnce)originalObservers), originalObservers));
        Seq targetSyncReplicas = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3}));
        Seq targetObservers = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{7, 8}));
        ReplicaAssignment.Assignment targetAssignment = new ReplicaAssignment.Assignment((Seq)targetSyncReplicas.$plus$plus((IterableOnce)targetObservers), targetObservers);
        Seq expectedReplicas = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3, 0, 1, 7, 8, 5, 6}));
        Seq expectedObservers = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{7, 8, 5, 6}));
        Seq expectedAddingReplicas = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3, 7, 8}));
        Seq expectedRemovingReplicas = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 5, 6}));
        Seq expectedAddingObservers = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{7, 8}));
        Seq expectedRemovingObservers = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{5, 6}));
        String topic = "mrc-topic-1";
        ReplicaAssignment assignment = originalAssignment.reassignTo(targetAssignment);
        scala.collection.immutable.Map assignmentMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)assignment)}));
        AdminZkClient qual$1 = this.adminZkClient();
        None$ x$6 = None$.MODULE$;
        boolean x$7 = qual$1.createTopicWithAssignment$default$4();
        qual$1.createTopicWithAssignment(topic, props, (Map)assignmentMap, x$7, true, false, (Option)x$6);
        ArrayList brokers = new ArrayList();
        ArrayList batches = new ArrayList();
        this.migrationClient().migrateTopics(batch -> batches.add(batch), brokerId -> brokers.add(brokerId), Predef$.MODULE$.Map().empty(), MetadataVersion.latestTesting());
        Assertions.assertEquals((int)1, (int)batches.size());
        Buffer messages = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)batches.get(0)).asScala().map((Function1 & Serializable)x$21 -> x$21.message());
        scala.collection.immutable.Seq configs = ((IterableOnceOps)((IterableOps)messages.filter((Function1 & Serializable)message -> BoxesRunTime.boxToBoolean((boolean)ZkMigrationClientTest.$anonfun$testMigrateMrcTopicDuringReassignment$4(message)))).map((Function1 & Serializable)x$22 -> (ConfigRecord)x$22)).toSeq();
        Assertions.assertEquals((int)1, (int)configs.size());
        ConfigRecord configRecord = (ConfigRecord)configs.head();
        Assertions.assertEquals((Object)"confluent.placement.constraints", (Object)configRecord.name());
        Assertions.assertEquals((Object)topicPlacementJson, (Object)configRecord.value());
        scala.collection.immutable.Seq partitions = ((IterableOnceOps)((IterableOps)messages.filter((Function1 & Serializable)message -> BoxesRunTime.boxToBoolean((boolean)ZkMigrationClientTest.$anonfun$testMigrateMrcTopicDuringReassignment$6(message)))).map((Function1 & Serializable)x$23 -> (PartitionRecord)x$23)).toSeq();
        Assertions.assertEquals((int)1, (int)partitions.size());
        PartitionRecord partitionRecord = (PartitionRecord)partitions.head();
        Assertions.assertEquals((Object)expectedReplicas, (Object)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(partitionRecord.replicas()).asScala().map((Function1 & Serializable)x$24 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$24)))).toSeq());
        Assertions.assertEquals((Object)expectedObservers, (Object)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(partitionRecord.observers()).asScala().map((Function1 & Serializable)x$25 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$25)))).toSeq());
        Assertions.assertEquals((Object)expectedAddingReplicas, (Object)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(partitionRecord.addingReplicas()).asScala().map((Function1 & Serializable)x$26 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$26)))).toSeq());
        Assertions.assertEquals((Object)expectedRemovingReplicas, (Object)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(partitionRecord.removingReplicas()).asScala().map((Function1 & Serializable)x$27 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$27)))).toSeq());
        Assertions.assertEquals((Object)expectedAddingObservers, (Object)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(partitionRecord.addingObservers()).asScala().map((Function1 & Serializable)x$28 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$28)))).toSeq());
        Assertions.assertEquals((Object)expectedRemovingObservers, (Object)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(partitionRecord.removingObservers()).asScala().map((Function1 & Serializable)x$29 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$29)))).toSeq());
    }

    @Test
    public void testMigrateNonMrcTopicDuringReassignment() {
        ReplicaAssignment originalAssignment = ReplicaAssignment$.MODULE$.fromAssignment(new ReplicaAssignment.Assignment((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Seq)Seq$.MODULE$.empty()));
        ReplicaAssignment.Assignment targetAssignment = new ReplicaAssignment.Assignment((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4, 5})), (Seq)Seq$.MODULE$.empty());
        Seq expectedReplicas = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4, 5, 0, 1, 2}));
        Seq expectedAddingReplicas = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4, 5}));
        Seq expectedRemovingReplicas = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        String topic = "topic-1";
        ReplicaAssignment assignment = originalAssignment.reassignTo(targetAssignment);
        scala.collection.immutable.Map assignmentMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)assignment)}));
        AdminZkClient qual$1 = this.adminZkClient();
        Properties x$2 = new Properties();
        None$ x$6 = None$.MODULE$;
        boolean x$7 = qual$1.createTopicWithAssignment$default$4();
        qual$1.createTopicWithAssignment(topic, x$2, (Map)assignmentMap, x$7, true, false, (Option)x$6);
        ArrayList brokers = new ArrayList();
        ArrayList batches = new ArrayList();
        this.migrationClient().migrateTopics(batch -> batches.add(batch), brokerId -> brokers.add(brokerId), Predef$.MODULE$.Map().empty(), MetadataVersion.latestTesting());
        Assertions.assertEquals((int)1, (int)batches.size());
        Buffer messages = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)batches.get(0)).asScala().map((Function1 & Serializable)x$30 -> x$30.message());
        scala.collection.immutable.Seq configs = ((IterableOnceOps)((IterableOps)messages.filter((Function1 & Serializable)message -> BoxesRunTime.boxToBoolean((boolean)ZkMigrationClientTest.$anonfun$testMigrateNonMrcTopicDuringReassignment$4(message)))).map((Function1 & Serializable)x$31 -> (ConfigRecord)x$31)).toSeq();
        Assertions.assertEquals((int)0, (int)configs.size());
        scala.collection.immutable.Seq partitions = ((IterableOnceOps)((IterableOps)messages.filter((Function1 & Serializable)message -> BoxesRunTime.boxToBoolean((boolean)ZkMigrationClientTest.$anonfun$testMigrateNonMrcTopicDuringReassignment$6(message)))).map((Function1 & Serializable)x$32 -> (PartitionRecord)x$32)).toSeq();
        Assertions.assertEquals((int)1, (int)partitions.size());
        PartitionRecord partitionRecord = (PartitionRecord)partitions.head();
        Assertions.assertEquals((Object)expectedReplicas, (Object)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(partitionRecord.replicas()).asScala().map((Function1 & Serializable)x$33 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$33)))).toSeq());
        Assertions.assertTrue((boolean)partitionRecord.observers().isEmpty());
        Assertions.assertEquals((Object)expectedAddingReplicas, (Object)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(partitionRecord.addingReplicas()).asScala().map((Function1 & Serializable)x$34 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$34)))).toSeq());
        Assertions.assertEquals((Object)expectedRemovingReplicas, (Object)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(partitionRecord.removingReplicas()).asScala().map((Function1 & Serializable)x$35 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$35)))).toSeq());
        Assertions.assertTrue((boolean)partitionRecord.addingObservers().isEmpty());
        Assertions.assertTrue((boolean)partitionRecord.removingObservers().isEmpty());
    }

    public static final /* synthetic */ boolean $anonfun$testMigrateTopicConfigs$6(ApiMessage message) {
        return MetadataRecordType.fromId((short)message.apiKey()).equals((Object)MetadataRecordType.CONFIG_RECORD);
    }

    public static final /* synthetic */ void $anonfun$testTopicAndBrokerConfigsMigrationWithSnapshots$3(MetadataDelta delta$1, String topicName$1, String brokerId$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            String key = (String)x0$1._1();
            String value = (String)x0$1._2();
            delta$1.replay(new ConfigRecord().setName(key).setValue(value).setResourceName(topicName$1).setResourceType(ConfigResource.Type.TOPIC.id()));
            delta$1.replay(new ConfigRecord().setName(key).setValue(value).setResourceName(brokerId$1).setResourceType(ConfigResource.Type.BROKER.id()));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testTopicAndBrokerConfigsMigrationWithSnapshots$5(String topicName$1, Uuid topicId$1, TopicPartition tp$1, java.util.List replicas$1, TopicZNode.TopicIdReplicaAssignment assignment) {
        Assertions.assertEquals((Object)topicName$1, (Object)assignment.topic());
        Assertions.assertEquals((Object)new Some((Object)topicId$1), (Object)assignment.topicId());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp$1), (Object)ReplicaAssignment$.MODULE$.fromAssignment(new ReplicaAssignment.Assignment((Seq)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(replicas$1).asScala().map((Function1 & Serializable)x -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x)))).toSeq(), (Seq)Seq$.MODULE$.empty())))})), (Object)assignment.assignment());
    }

    public static final /* synthetic */ void $anonfun$testTopicAndBrokerConfigsMigrationWithSnapshots$7(int leaderPartition$1, int leaderEpoch$1, java.util.List replicas$1, LeaderIsrAndControllerEpoch state) {
        Assertions.assertEquals((int)leaderPartition$1, (int)state.leaderAndIsr().leader());
        Assertions.assertEquals((int)leaderEpoch$1, (int)state.leaderAndIsr().leaderEpoch());
        Assertions.assertEquals((Object)LeaderRecoveryState.RECOVERED, (Object)state.leaderAndIsr().leaderRecoveryState());
        Assertions.assertEquals((Object)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(replicas$1).asScala().map((Function1 & Serializable)x -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x)))).toList(), (Object)state.leaderAndIsr().isr());
    }

    public static final /* synthetic */ void $anonfun$testTopicAndBrokerConfigsMigrationWithSnapshots$9(ZkMigrationClientTest $this, Properties props$2, Tuple2 x0$2) {
        if (x0$2 != null) {
            String key = (String)x0$2._1();
            String value = (String)x0$2._2();
            String string = key;
            String string2 = KafkaConfig$.MODULE$.SslKeystorePasswordProp();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                Assertions.assertEquals((Object)$this.SECRET(), (Object)$this.encoder().decode(value).value());
                return;
            }
            Assertions.assertEquals((Object)props$2.getProperty(key), (Object)value);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testTopicAndBrokerConfigsMigrationWithSnapshots$10(ZkMigrationClientTest $this, Properties props$2, Tuple2 x0$3) {
        if (x0$3 != null) {
            String key = (String)x0$3._1();
            String value = (String)x0$3._2();
            String string = key;
            String string2 = KafkaConfig$.MODULE$.SslKeystorePasswordProp();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                Assertions.assertEquals((Object)$this.SECRET(), (Object)$this.encoder().decode(value).value());
                return;
            }
            Assertions.assertEquals((Object)props$2.getProperty(key), (Object)value);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testUpdateExistingTopicWithNewAndChangedPartitions$3(java.util.Map changedPartitions$1, Tuple2 x0$3) {
        if (x0$3 != null) {
            TopicPartition tp = (TopicPartition)x0$3._1();
            ReplicaAssignment assignment = (ReplicaAssignment)x0$3._2();
            int n = tp.partition();
            switch (n) {
                default: 
            }
            if (n <= 1) {
                Assertions.assertEquals((Object)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.intArrayOps(((PartitionRegistration)changedPartitions$1.get((Object)BoxesRunTime.boxToInteger((int)n))).replicas)), (Object)assignment.replicas());
                Assertions.assertEquals((Object)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.intArrayOps(((PartitionRegistration)changedPartitions$1.get((Object)BoxesRunTime.boxToInteger((int)n))).addingReplicas)), (Object)assignment.addingReplicas());
                Assertions.assertEquals((Object)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.intArrayOps(((PartitionRegistration)changedPartitions$1.get((Object)BoxesRunTime.boxToInteger((int)n))).removingReplicas)), (Object)assignment.removingReplicas());
                return;
            }
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)new StringBuilder(24).append("Found unknown partition ").append(n).toString());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testUpdateExistingTopicWithNewAndChangedPartitions$5(java.util.Map newPartition$1, LeaderIsrAndControllerEpoch part) {
        PartitionRegistration expectedPartition = (PartitionRegistration)newPartition$1.get(BoxesRunTime.boxToInteger((int)2));
        Assertions.assertEquals((int)expectedPartition.leader, (int)part.leaderAndIsr().leader());
        Assertions.assertEquals((int)(expectedPartition.partitionEpoch + 1), (int)part.leaderAndIsr().partitionEpoch());
        Assertions.assertEquals((int)expectedPartition.leaderEpoch, (int)part.leaderAndIsr().leaderEpoch());
        Assertions.assertEquals((Object)expectedPartition.leaderRecoveryState, (Object)part.leaderAndIsr().leaderRecoveryState());
        Assertions.assertEquals((Object)Predef$.MODULE$.wrapIntArray(expectedPartition.isr).toList(), (Object)part.leaderAndIsr().isr());
    }

    public static final /* synthetic */ boolean $anonfun$testMigrateMrcTopic$4(ApiMessage message) {
        return MetadataRecordType.fromId((short)message.apiKey()).equals((Object)MetadataRecordType.CONFIG_RECORD);
    }

    public static final /* synthetic */ boolean $anonfun$testMigrateMrcTopic$6(ApiMessage message) {
        return MetadataRecordType.fromId((short)message.apiKey()).equals((Object)MetadataRecordType.PARTITION_RECORD);
    }

    public static final /* synthetic */ boolean $anonfun$testMigrateNonMrcTopic$4(ApiMessage message) {
        return MetadataRecordType.fromId((short)message.apiKey()).equals((Object)MetadataRecordType.CONFIG_RECORD);
    }

    public static final /* synthetic */ boolean $anonfun$testMigrateNonMrcTopic$6(ApiMessage message) {
        return MetadataRecordType.fromId((short)message.apiKey()).equals((Object)MetadataRecordType.PARTITION_RECORD);
    }

    public static final /* synthetic */ boolean $anonfun$testMigrateMrcTopicDuringReassignment$4(ApiMessage message) {
        return MetadataRecordType.fromId((short)message.apiKey()).equals((Object)MetadataRecordType.CONFIG_RECORD);
    }

    public static final /* synthetic */ boolean $anonfun$testMigrateMrcTopicDuringReassignment$6(ApiMessage message) {
        return MetadataRecordType.fromId((short)message.apiKey()).equals((Object)MetadataRecordType.PARTITION_RECORD);
    }

    public static final /* synthetic */ boolean $anonfun$testMigrateNonMrcTopicDuringReassignment$4(ApiMessage message) {
        return MetadataRecordType.fromId((short)message.apiKey()).equals((Object)MetadataRecordType.CONFIG_RECORD);
    }

    public static final /* synthetic */ boolean $anonfun$testMigrateNonMrcTopicDuringReassignment$6(ApiMessage message) {
        return MetadataRecordType.fromId((short)message.apiKey()).equals((Object)MetadataRecordType.PARTITION_RECORD);
    }
}

