/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk.migration;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import kafka.cluster.Broker$;
import kafka.cluster.EndPoint;
import kafka.utils.CoreUtils$;
import kafka.zk.BrokerInfo;
import kafka.zk.BrokerInfo$;
import kafka.zk.migration.ZkMigrationTestHarness;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.feature.Features;
import org.apache.kafka.common.metadata.BrokerReplicaExclusionRecord;
import org.apache.kafka.common.metadata.MetadataRecordType;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.metadata.BrokerRegistration;
import org.apache.kafka.metadata.BrokerReplicaExclusion;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005b\u0001B\u0007\u000f\u0001UAQA\u0007\u0001\u0005\u0002mAQ!\b\u0001\u0005\u0002yAQA\r\u0001\u0005\u0002yAQ\u0001\u000e\u0001\u0005\u0002yAQA\u000e\u0001\u0005\u0002yAQ\u0001\u000f\u0001\u0005\u0002yAQA\u000f\u0001\u0005\u0002yAQ\u0001\u0010\u0001\u0005\nuBQ\u0001\u0010\u0001\u0005\n!DQ!\u001d\u0001\u0005\nIDQ\u0001 \u0001\u0005\nuDq!a\u0005\u0001\t\u0013\t)BA\u0010[WJ+\u0007\u000f\\5dC\u0016C8\r\\;tS>tW*[4sCRLwN\u001c+fgRT!a\u0004\t\u0002\u00135LwM]1uS>t'BA\t\u0013\u0003\tQ8NC\u0001\u0014\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\f\u0011\u0005]AR\"\u0001\b\n\u0005eq!A\u0006.l\u001b&<'/\u0019;j_:$Vm\u001d;ICJtWm]:\u0002\rqJg.\u001b;?)\u0005a\u0002CA\f\u0001\u0003\u0005\"Xm\u001d;NS\u001e\u0014\u0018\r^3F[B$\u0018PU3qY&\u001c\u0017-\u0012=dYV\u001c\u0018n\u001c8t)\u0005y\u0002C\u0001\u0011$\u001b\u0005\t#\"\u0001\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0011\n#\u0001B+oSRD#A\u0001\u0014\u0011\u0005\u001d\u0002T\"\u0001\u0015\u000b\u0005%R\u0013aA1qS*\u00111\u0006L\u0001\bUV\u0004\u0018\u000e^3s\u0015\tic&A\u0003kk:LGOC\u00010\u0003\ry'oZ\u0005\u0003c!\u0012A\u0001V3ti\u0006aB/Z:u\u001b&<'/\u0019;f%\u0016\u0004H.[2b\u000bb\u001cG.^:j_:\u001c\bFA\u0002'\u0003%\"Xm\u001d;NS\u001e\u0014\u0018\r^3SKBd\u0017nY1Fq\u000edWo]5p]N4uN\u001d#po:\u0014%o\\6fe\"\u0012AAJ\u00011i\u0016\u001cH/T5he\u0006$XMU3qY&\u001c\u0017-\u0012=dYV\u001c\u0018n\u001c8t\r>\u0014hj\u001c8Fq&\u001cH/\u001a8u\u0005J|7.\u001a:)\u0005\u00151\u0013a\u0007;fgR,\u0006\u000fZ1uKJ+\u0007\u000f\\5dC\u0016C8\r\\;tS>t7\u000f\u000b\u0002\u0007M\u0005AC/Z:u+B$\u0017\r^3SKBd\u0017nY1Fq\u000edWo]5p]N<\u0016\u000e\u001c7Pm\u0016\u0014xO]5uK\"\u0012qAJ\u0001\u0019CN\u001cXM\u001d;Fq\u000edWo]5p]N\f%/Z#rk\u0006dGcA\u0010?#\")q\b\u0003a\u0001\u0001\u0006\u0011R\r\u001f9fGR,G-\u0012=dYV\u001c\u0018n\u001c8t!\r\t\u0005j\u0013\b\u0003\u0005\u001a\u0003\"aQ\u0011\u000e\u0003\u0011S!!\u0012\u000b\u0002\rq\u0012xn\u001c;?\u0013\t9\u0015%\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0013*\u00131aU3u\u0015\t9\u0015\u0005\u0005\u0002M\u001f6\tQJ\u0003\u0002O%\u000511m\\7n_:L!\u0001U'\u0003-\t\u0013xn[3s%\u0016\u0004H.[2b\u000bb\u001cG.^:j_:DQA\u0015\u0005A\u0002M\u000b\u0001#Y2uk\u0006dW\t_2mkNLwN\\:\u0011\u0007QK6,D\u0001V\u0015\t1v+\u0001\u0003vi&d'\"\u0001-\u0002\t)\fg/Y\u0005\u00035V\u0013A\u0001T5tiB\u0011AL\u001a\b\u0003;\u0012l\u0011A\u0018\u0006\u0003?\u0002\f\u0001\"\\3uC\u0012\fG/\u0019\u0006\u0003\u001d\u0006T!a\u00052\u000b\u0005\rt\u0013AB1qC\u000eDW-\u0003\u0002f=\u0006a\"I]8lKJ\u0014V\r\u001d7jG\u0006,\u0005p\u00197vg&|gNU3d_J$\u0017B\u0001)h\u0015\t)g\fF\u0002 SBDQaP\u0005A\u0002)\u00042\u0001V6m\u0013\tIU\u000b\u0005\u0002n_6\taN\u0003\u0002`C&\u0011\u0001K\u001c\u0005\u0006%&\u0001\r\u0001Q\u0001\u0011GJ,\u0017\r^3Ce>\\WM]%oM>$\"a]<\u0011\u0005Q,X\"\u0001\t\n\u0005Y\u0004\"A\u0003\"s_.,'/\u00138g_\")\u0001P\u0003a\u0001s\u0006\u0011\u0011\u000e\u001a\t\u0003AiL!a_\u0011\u0003\u0007%sG/\u0001\nce>\\WM\u001d*fO&\u001cHO]1uS>tGc\u0001@\u0002\u0004A\u0011Qn`\u0005\u0004\u0003\u0003q'A\u0005\"s_.,'OU3hSN$(/\u0019;j_:Dq!!\u0002\f\u0001\u0004\t9!\u0001\u0005ce>\\WM]%e!\u0011\tI!a\u0004\u000e\u0005\u0005-!bAA\u0007/\u0006!A.\u00198h\u0013\u0011\t\t\"a\u0003\u0003\u000f%sG/Z4fe\u0006\u0019\"M]8lKJ\u0014VmZ5tiJ\fG/[8ogR!\u0011qCA\u000f!\u0019!\u0016\u0011DA\u0004}&\u0019\u00111D+\u0003\u00075\u000b\u0007\u000f\u0003\u0004\u0002 1\u0001\r!_\u0001\u000b]Vl'I]8lKJ\u001c\b")
public class ZkReplicaExclusionMigrationTest
extends ZkMigrationTestHarness {
    @Test
    public void testMigrateEmptyReplicaExclusions() {
        this.zkClient().registerBroker(this.createBrokerInfo(0));
        this.zkClient().registerBroker(this.createBrokerInfo(1));
        this.zkClient().registerBroker(this.createBrokerInfo(2));
        ArrayList batches = new ArrayList();
        this.migrationClient().migrateReplicaExclusions(batch -> batches.add(batch), this.brokerRegistrations(3));
        Assertions.assertEquals((int)0, (int)batches.size());
    }

    @Test
    public void testMigrateReplicaExclusions() {
        String clusterId = CoreUtils$.MODULE$.generateUuidAsBase64();
        this.zkClient().createOrGetClusterId(clusterId);
        this.zkClient().registerBroker(this.createBrokerInfo(0));
        this.zkClient().registerBroker(this.createBrokerInfo(1));
        this.zkClient().registerBroker(this.createBrokerInfo(2));
        scala.collection.immutable.Set replicaExclusions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new kafka.common.BrokerReplicaExclusion[]{new kafka.common.BrokerReplicaExclusion(0, "rcca-123"), new kafka.common.BrokerReplicaExclusion(2, "rcca-234")}));
        this.zkClient().setOrCreateReplicaExclusions(replicaExclusions, 0);
        ArrayList batches = new ArrayList();
        this.migrationClient().migrateReplicaExclusions(batch -> batches.add(batch), this.brokerRegistrations(3));
        Assertions.assertEquals((int)1, (int)batches.size());
        scala.collection.immutable.Seq replicaExclusionRecords = ((IterableOnceOps)((IterableOps)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)batches.get(0)).asScala().map((Function1 & Serializable)x$1 -> x$1.message())).filter((Function1 & Serializable)message -> BoxesRunTime.boxToBoolean((boolean)ZkReplicaExclusionMigrationTest.$anonfun$testMigrateReplicaExclusions$3(message)))).map((Function1 & Serializable)x$2 -> (BrokerReplicaExclusionRecord)x$2)).toSeq();
        Assertions.assertEquals((int)1, (int)replicaExclusionRecords.size());
        this.assertExclusionsAreEqual((scala.collection.immutable.Set<kafka.common.BrokerReplicaExclusion>)replicaExclusions, ((BrokerReplicaExclusionRecord)replicaExclusionRecords.head()).brokerExclusions());
    }

    @Test
    public void testMigrateReplicaExclusionsForDownBroker() {
        String clusterId = CoreUtils$.MODULE$.generateUuidAsBase64();
        this.zkClient().createOrGetClusterId(clusterId);
        this.zkClient().registerBroker(this.createBrokerInfo(0));
        this.zkClient().registerBroker(this.createBrokerInfo(1));
        scala.collection.immutable.Set replicaExclusions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new kafka.common.BrokerReplicaExclusion[]{new kafka.common.BrokerReplicaExclusion(0, "rcca-123"), new kafka.common.BrokerReplicaExclusion(2, "rcca-234")}));
        this.zkClient().setOrCreateReplicaExclusions(replicaExclusions, 0);
        ArrayList batches = new ArrayList();
        this.migrationClient().migrateReplicaExclusions(batch -> batches.add(batch), this.brokerRegistrations(3));
        Assertions.assertEquals((int)1, (int)batches.size());
        scala.collection.immutable.Seq replicaExclusionRecords = ((IterableOnceOps)((IterableOps)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)batches.get(0)).asScala().map((Function1 & Serializable)x$3 -> x$3.message())).filter((Function1 & Serializable)message -> BoxesRunTime.boxToBoolean((boolean)ZkReplicaExclusionMigrationTest.$anonfun$testMigrateReplicaExclusionsForDownBroker$3(message)))).map((Function1 & Serializable)x$4 -> (BrokerReplicaExclusionRecord)x$4)).toSeq();
        Assertions.assertEquals((int)1, (int)replicaExclusionRecords.size());
        this.assertExclusionsAreEqual((scala.collection.immutable.Set<kafka.common.BrokerReplicaExclusion>)replicaExclusions, ((BrokerReplicaExclusionRecord)replicaExclusionRecords.head()).brokerExclusions());
    }

    @Test
    public void testMigrateReplicaExclusionsForNonExistentBroker() {
        String clusterId = CoreUtils$.MODULE$.generateUuidAsBase64();
        this.zkClient().createOrGetClusterId(clusterId);
        this.zkClient().registerBroker(this.createBrokerInfo(0));
        this.zkClient().registerBroker(this.createBrokerInfo(1));
        scala.collection.immutable.Set replicaExclusions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new kafka.common.BrokerReplicaExclusion[]{new kafka.common.BrokerReplicaExclusion(0, "rcca-123"), new kafka.common.BrokerReplicaExclusion(2, "rcca-234")}));
        this.zkClient().setOrCreateReplicaExclusions(replicaExclusions, 0);
        ArrayList batches = new ArrayList();
        this.migrationClient().migrateReplicaExclusions(batch -> batches.add(batch), this.brokerRegistrations(2));
        Assertions.assertEquals((int)1, (int)batches.size());
        scala.collection.immutable.Seq replicaExclusionRecords = ((IterableOnceOps)((IterableOps)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)batches.get(0)).asScala().map((Function1 & Serializable)x$5 -> x$5.message())).filter((Function1 & Serializable)message -> BoxesRunTime.boxToBoolean((boolean)ZkReplicaExclusionMigrationTest.$anonfun$testMigrateReplicaExclusionsForNonExistentBroker$3(message)))).map((Function1 & Serializable)x$6 -> (BrokerReplicaExclusionRecord)x$6)).toSeq();
        Assertions.assertEquals((int)1, (int)replicaExclusionRecords.size());
        this.assertExclusionsAreEqual((scala.collection.immutable.Set<kafka.common.BrokerReplicaExclusion>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new kafka.common.BrokerReplicaExclusion[]{new kafka.common.BrokerReplicaExclusion(0, "rcca-123")}))), ((BrokerReplicaExclusionRecord)replicaExclusionRecords.head()).brokerExclusions());
    }

    @Test
    public void testUpdateReplicaExclusions() {
        String clusterId = CoreUtils$.MODULE$.generateUuidAsBase64();
        this.zkClient().createOrGetClusterId(clusterId);
        Assertions.assertEquals((int)0, (int)this.migrationState().migrationZkVersion());
        java.util.Set replicaExclusions = CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new BrokerReplicaExclusion[]{new BrokerReplicaExclusion(0, "rcca-123"), new BrokerReplicaExclusion(2, "rcca-234")}))).asJava();
        this.migrationState_$eq(this.migrationClient().replicaExclusionClient().writeReplicaExclusions(replicaExclusions, this.migrationState(), true));
        Assertions.assertEquals((int)1, (int)this.migrationState().migrationZkVersion());
        scala.collection.immutable.Set replicaExclusionsFromZk = (scala.collection.immutable.Set)this.zkClient().getReplicaExclusions().get();
        Assertions.assertEquals((int)2, (int)replicaExclusionsFromZk.size());
        this.assertExclusionsAreEqual(replicaExclusions, (scala.collection.immutable.Set<kafka.common.BrokerReplicaExclusion>)replicaExclusionsFromZk);
    }

    @Test
    public void testUpdateReplicaExclusionsWillOverwrite() {
        String clusterId = CoreUtils$.MODULE$.generateUuidAsBase64();
        this.zkClient().createOrGetClusterId(clusterId);
        Assertions.assertEquals((int)0, (int)this.migrationState().migrationZkVersion());
        scala.collection.immutable.Set replicaExclusion = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new kafka.common.BrokerReplicaExclusion[]{new kafka.common.BrokerReplicaExclusion(0, "rcca-123")}));
        this.zkClient().setOrCreateReplicaExclusions(replicaExclusion, 0);
        java.util.Set updatedReplicaExclusion = CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new BrokerReplicaExclusion[]{new BrokerReplicaExclusion(2, "rcca-234")}))).asJava();
        this.migrationState_$eq(this.migrationClient().replicaExclusionClient().writeReplicaExclusions(updatedReplicaExclusion, this.migrationState(), false));
        Assertions.assertEquals((int)1, (int)this.migrationState().migrationZkVersion());
        scala.collection.immutable.Set replicaExclusionsFromZk = (scala.collection.immutable.Set)this.zkClient().getReplicaExclusions().get();
        Assertions.assertEquals((int)1, (int)replicaExclusionsFromZk.size());
        this.assertExclusionsAreEqual(updatedReplicaExclusion, (scala.collection.immutable.Set<kafka.common.BrokerReplicaExclusion>)replicaExclusionsFromZk);
        HashSet emptyReplicaExclusions = new HashSet();
        this.migrationState_$eq(this.migrationClient().replicaExclusionClient().writeReplicaExclusions(emptyReplicaExclusions, this.migrationState(), false));
        Assertions.assertEquals((int)2, (int)this.migrationState().migrationZkVersion());
        replicaExclusionsFromZk = (scala.collection.immutable.Set)this.zkClient().getReplicaExclusions().get();
        Assertions.assertEquals((int)0, (int)replicaExclusionsFromZk.size());
    }

    private void assertExclusionsAreEqual(scala.collection.immutable.Set<kafka.common.BrokerReplicaExclusion> expectedExclusions, java.util.List<BrokerReplicaExclusionRecord.BrokerReplicaExclusion> actualExclusions) {
        scala.collection.immutable.Set actual = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(actualExclusions).asScala().map((Function1 & Serializable)exclusion -> new kafka.common.BrokerReplicaExclusion(exclusion.brokerId(), exclusion.reason()))).toSet();
        Assertions.assertEquals(expectedExclusions, (Object)actual);
    }

    private void assertExclusionsAreEqual(java.util.Set<BrokerReplicaExclusion> expectedExclusions, scala.collection.immutable.Set<kafka.common.BrokerReplicaExclusion> actualExclusions) {
        Assertions.assertEquals((Object)((scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala(expectedExclusions).asScala().map((Function1 & Serializable)exclusion -> new kafka.common.BrokerReplicaExclusion(exclusion.getBrokerId(), exclusion.getReason()))), actualExclusions);
    }

    private BrokerInfo createBrokerInfo(int id) {
        return BrokerInfo$.MODULE$.apply(Broker$.MODULE$.apply(id, (Seq)new .colon.colon((Object)new EndPoint(new StringBuilder(9).append("test.host").append(Integer.toString(id)).toString(), 9000 + id, ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), SecurityProtocol.PLAINTEXT), (List)Nil$.MODULE$), (Option)None$.MODULE$, Features.emptySupportedFeatures()), MetadataVersion.latestTesting(), 9010 + id);
    }

    private BrokerRegistration brokerRegistration(Integer brokerId) {
        return new BrokerRegistration.Builder().setId(Predef$.MODULE$.Integer2int(brokerId)).setEpoch(1L).setIncarnationId(Uuid.randomUuid()).setFenced(false).setInControlledShutdown(true).setIsMigratingZkBroker(true).build();
    }

    private java.util.Map<Integer, BrokerRegistration> brokerRegistrations(int numBrokers) {
        return CollectionConverters$.MODULE$.MapHasAsJava((Map)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numBrokers).map((Function1 & Serializable)b -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.unboxToInt((Object)b)), (Object)this.brokerRegistration(Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)b))))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava();
    }

    public static final /* synthetic */ boolean $anonfun$testMigrateReplicaExclusions$3(ApiMessage message) {
        return MetadataRecordType.fromId((short)message.apiKey()).equals((Object)MetadataRecordType.BROKER_REPLICA_EXCLUSION_RECORD);
    }

    public static final /* synthetic */ boolean $anonfun$testMigrateReplicaExclusionsForDownBroker$3(ApiMessage message) {
        return MetadataRecordType.fromId((short)message.apiKey()).equals((Object)MetadataRecordType.BROKER_REPLICA_EXCLUSION_RECORD);
    }

    public static final /* synthetic */ boolean $anonfun$testMigrateReplicaExclusionsForNonExistentBroker$3(ApiMessage message) {
        return MetadataRecordType.fromId((short)message.apiKey()).equals((Object)MetadataRecordType.BROKER_REPLICA_EXCLUSION_RECORD);
    }
}

