/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import com.stumbleupon.async.Callback;
import com.stumbleupon.async.Deferred;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kudu.Common;
import org.apache.kudu.client.AsyncKuduClient;
import org.apache.kudu.client.ConnectToClusterResponse;
import org.apache.kudu.client.ConnectToMasterRequest;
import org.apache.kudu.client.Connection;
import org.apache.kudu.client.KuduRpc;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.NoLeaderFoundException;
import org.apache.kudu.client.NonRecoverableException;
import org.apache.kudu.client.ProtobufHelper;
import org.apache.kudu.client.RpcProxy;
import org.apache.kudu.client.RpcRemoteException;
import org.apache.kudu.client.Status;
import org.apache.kudu.consensus.Metadata;
import org.apache.kudu.master.Master;
import org.apache.kudu.rpc.RpcHeader;
import org.apache.kudu.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.kudu.shaded.com.google.common.base.Functions;
import org.apache.kudu.shaded.com.google.common.base.Joiner;
import org.apache.kudu.shaded.com.google.common.base.Preconditions;
import org.apache.kudu.shaded.com.google.common.collect.Lists;
import org.apache.kudu.shaded.com.google.common.net.HostAndPort;
import org.apache.kudu.util.NetUtil;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
final class ConnectToCluster {
    private static final Logger LOG = LoggerFactory.getLogger(ConnectToCluster.class);
    private final List<HostAndPort> masterAddrs;
    private final Deferred<ConnectToClusterResponse> responseD;
    private final int numMasters;
    private final AtomicBoolean responseDCalled = new AtomicBoolean(false);
    private final AtomicInteger countResponsesReceived = new AtomicInteger(0);
    private final List<Exception> exceptionsReceived = Collections.synchronizedList(new ArrayList());
    private AtomicReference<List<Common.HostPortPB>> knownMasters = new AtomicReference();

    ConnectToCluster(List<HostAndPort> masterAddrs) {
        this.masterAddrs = masterAddrs;
        this.responseD = new Deferred();
        this.numMasters = masterAddrs.size();
    }

    @VisibleForTesting
    public Deferred<ConnectToClusterResponse> getDeferred() {
        return this.responseD;
    }

    private static Deferred<Master.ConnectToMasterResponsePB> connectToMaster(KuduTable masterTable, final RpcProxy masterProxy, KuduRpc<?> parentRpc, long defaultTimeoutMs) {
        final ConnectToMasterRequest rpc = new ConnectToMasterRequest(masterTable);
        if (parentRpc != null) {
            rpc.setTimeoutMillis(parentRpc.deadlineTracker.getMillisBeforeDeadline());
            rpc.setParentRpc(parentRpc);
        } else {
            rpc.setTimeoutMillis(defaultTimeoutMs);
        }
        Deferred d = rpc.getDeferred();
        ++rpc.attempt;
        masterProxy.sendRpc(rpc);
        d.addErrback((Callback)new Callback<Deferred<Master.ConnectToMasterResponsePB>, Exception>(){

            public Deferred<Master.ConnectToMasterResponsePB> call(Exception result) throws Exception {
                RpcRemoteException rre;
                if (result instanceof RpcRemoteException && (rre = (RpcRemoteException)result).getErrPB().getCode() == RpcHeader.ErrorStatusPB.RpcErrorCodePB.ERROR_INVALID_REQUEST && rre.getErrPB().getUnsupportedFeatureFlagsCount() > 0) {
                    AsyncKuduClient.LOG.debug("Falling back to GetMasterRegistration() RPC to connect to server running Kudu < 1.3.");
                    Deferred newAttempt = Preconditions.checkNotNull(rpc.getDeferred());
                    rpc.setUseOldMethod();
                    masterProxy.sendRpc(rpc);
                    return newAttempt;
                }
                return Deferred.fromError((Exception)result);
            }
        });
        return d;
    }

    public static Deferred<ConnectToClusterResponse> run(KuduTable masterTable, List<HostAndPort> masterAddresses, KuduRpc<?> parentRpc, long defaultTimeoutMs, Connection.CredentialsPolicy credentialsPolicy) {
        ConnectToCluster connector = new ConnectToCluster(masterAddresses);
        for (HostAndPort hostAndPort : masterAddresses) {
            Deferred d;
            RpcProxy proxy = masterTable.getAsyncClient().newMasterRpcProxy(hostAndPort, credentialsPolicy);
            if (proxy != null) {
                d = ConnectToCluster.connectToMaster(masterTable, proxy, parentRpc, defaultTimeoutMs);
            } else {
                String message = "Couldn't resolve this master's address " + hostAndPort.toString();
                LOG.warn(message);
                Status statusIOE = Status.IOError(message);
                d = Deferred.fromError((Exception)new NonRecoverableException(statusIOE));
            }
            d.addCallbacks(connector.callbackForNode(hostAndPort), connector.errbackForNode(hostAndPort));
        }
        return connector.responseD;
    }

    @VisibleForTesting
    Callback<Void, Master.ConnectToMasterResponsePB> callbackForNode(HostAndPort hostAndPort) {
        return new ConnectToMasterCB(hostAndPort);
    }

    @VisibleForTesting
    Callback<Void, Exception> errbackForNode(HostAndPort hostAndPort) {
        return new ConnectToMasterErrCB(hostAndPort);
    }

    private void incrementCountAndCheckExhausted() {
        if (this.countResponsesReceived.incrementAndGet() == this.numMasters && this.responseDCalled.compareAndSet(false, true)) {
            boolean allUnrecoverable = true;
            if (this.exceptionsReceived.size() == this.countResponsesReceived.get()) {
                for (Exception ex : this.exceptionsReceived) {
                    if (ex instanceof NonRecoverableException) continue;
                    allUnrecoverable = false;
                    break;
                }
            } else {
                allUnrecoverable = false;
            }
            String allHosts = NetUtil.hostsAndPortsToString(this.masterAddrs);
            if (allUnrecoverable) {
                String msg = String.format("Couldn't find a valid master in (%s). Exceptions received: [%s]", allHosts, Joiner.on(", ").join(Lists.transform(this.exceptionsReceived, Functions.toStringFunction())));
                Status s = Status.ServiceUnavailable(msg);
                this.responseD.callback((Object)new NonRecoverableException(s));
            } else {
                NoLeaderFoundException ex;
                List<Common.HostPortPB> knownMastersLocal = this.knownMasters.get();
                if (knownMastersLocal != null && knownMastersLocal.size() != this.numMasters) {
                    String msg = String.format("Could not connect to a leader master. Client configured with %s master(s) (%s) but cluster indicates it expects %s master(s) (%s)", this.numMasters, allHosts, knownMastersLocal.size(), ProtobufHelper.hostPortPbListToString(knownMastersLocal));
                    LOG.warn(msg);
                    NonRecoverableException e = new NonRecoverableException(Status.ConfigurationError(msg));
                    if (!LOG.isDebugEnabled()) {
                        e.setStackTrace(new StackTraceElement[0]);
                    }
                    this.responseD.callback((Object)e);
                    return;
                }
                String message = String.format("Master config (%s) has no leader.", allHosts);
                if (this.exceptionsReceived.isEmpty()) {
                    LOG.warn("None of the provided masters {} is a leader; will retry", (Object)allHosts);
                    ex = new NoLeaderFoundException(Status.ServiceUnavailable(message));
                } else {
                    LOG.warn("Unable to find the leader master {}; will retry", (Object)allHosts);
                    String joinedMsg = message + " Exceptions received: " + Joiner.on(",").join(Lists.transform(this.exceptionsReceived, Functions.toStringFunction()));
                    Status s = Status.ServiceUnavailable(joinedMsg);
                    ex = new NoLeaderFoundException(s, this.exceptionsReceived.get(this.exceptionsReceived.size() - 1));
                }
                this.responseD.callback((Object)ex);
            }
        }
    }

    private void recordKnownMasters(Master.ConnectToMasterResponsePB r) {
        if (r.getMasterAddrsCount() == 0) {
            return;
        }
        this.knownMasters.compareAndSet(null, r.getMasterAddrsList());
    }

    final class ConnectToMasterErrCB
    implements Callback<Void, Exception> {
        private final HostAndPort hostAndPort;

        public ConnectToMasterErrCB(HostAndPort hostAndPort) {
            this.hostAndPort = hostAndPort;
        }

        public Void call(Exception e) throws Exception {
            LOG.warn("Error receiving response from {}", (Object)this.hostAndPort, (Object)e);
            ConnectToCluster.this.exceptionsReceived.add(e);
            ConnectToCluster.this.incrementCountAndCheckExhausted();
            return null;
        }

        public String toString() {
            return "ConnectToMasterErrCB for " + this.hostAndPort.toString();
        }
    }

    final class ConnectToMasterCB
    implements Callback<Void, Master.ConnectToMasterResponsePB> {
        private final HostAndPort hostAndPort;

        public ConnectToMasterCB(HostAndPort hostAndPort) {
            this.hostAndPort = hostAndPort;
        }

        public Void call(Master.ConnectToMasterResponsePB r) throws Exception {
            ConnectToCluster.this.recordKnownMasters(r);
            if (!r.getRole().equals(Metadata.RaftPeerPB.Role.LEADER)) {
                ConnectToCluster.this.incrementCountAndCheckExhausted();
                return null;
            }
            if (!ConnectToCluster.this.responseDCalled.compareAndSet(false, true)) {
                LOG.debug("Callback already invoked, discarding response({}) from {}", (Object)r, (Object)this.hostAndPort);
                return null;
            }
            ConnectToCluster.this.responseD.callback((Object)new ConnectToClusterResponse(this.hostAndPort, r));
            return null;
        }

        public String toString() {
            return "ConnectToMasterCB for " + this.hostAndPort.toString();
        }
    }
}

