/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.sandbox.search;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.sandbox.search.QueryProfilerBreakdown;
import org.apache.lucene.sandbox.search.QueryProfilerScorer;
import org.apache.lucene.sandbox.search.QueryProfilerTimer;
import org.apache.lucene.sandbox.search.QueryProfilerTimingType;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.FilterWeight;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.Weight;

class QueryProfilerWeight
extends FilterWeight {
    private final QueryProfilerBreakdown profile;

    public QueryProfilerWeight(Weight subQueryWeight, QueryProfilerBreakdown profile) {
        super(subQueryWeight);
        this.profile = profile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int count(LeafReaderContext context) throws IOException {
        QueryProfilerTimer timer = this.profile.getTimer(QueryProfilerTimingType.COUNT);
        timer.start();
        try {
            int n = this.in.count(context);
            return n;
        }
        finally {
            timer.stop();
        }
    }

    public Scorer scorer(LeafReaderContext context) throws IOException {
        ScorerSupplier supplier = this.scorerSupplier(context);
        if (supplier == null) {
            return null;
        }
        return supplier.get(Long.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
        ScorerSupplier subQueryScorerSupplier;
        final QueryProfilerTimer timer = this.profile.getTimer(QueryProfilerTimingType.BUILD_SCORER);
        timer.start();
        try {
            subQueryScorerSupplier = this.in.scorerSupplier(context);
        }
        finally {
            timer.stop();
        }
        if (subQueryScorerSupplier == null) {
            return null;
        }
        final QueryProfilerWeight weight = this;
        return new ScorerSupplier(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Scorer get(long loadCost) throws IOException {
                timer.start();
                try {
                    QueryProfilerScorer queryProfilerScorer = new QueryProfilerScorer(weight, subQueryScorerSupplier.get(loadCost), QueryProfilerWeight.this.profile);
                    return queryProfilerScorer;
                }
                finally {
                    timer.stop();
                }
            }

            public long cost() {
                timer.start();
                try {
                    long l = subQueryScorerSupplier.cost();
                    return l;
                }
                finally {
                    timer.stop();
                }
            }
        };
    }

    public BulkScorer bulkScorer(LeafReaderContext context) throws IOException {
        return super.bulkScorer(context);
    }

    public boolean isCacheable(LeafReaderContext ctx) {
        return false;
    }
}

