/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.geo3d;

import org.apache.lucene.geo3d.Bounds;
import org.apache.lucene.geo3d.DistanceStyle;
import org.apache.lucene.geo3d.GeoBBox;
import org.apache.lucene.geo3d.GeoBBoxFactory;
import org.apache.lucene.geo3d.GeoBaseBBox;
import org.apache.lucene.geo3d.GeoPoint;
import org.apache.lucene.geo3d.GeoShape;
import org.apache.lucene.geo3d.Membership;
import org.apache.lucene.geo3d.Plane;
import org.apache.lucene.geo3d.PlanetModel;
import org.apache.lucene.geo3d.SidedPlane;
import org.apache.lucene.geo3d.Vector;

public class GeoLongitudeSlice
extends GeoBaseBBox {
    protected final double leftLon;
    protected final double rightLon;
    protected final SidedPlane leftPlane;
    protected final SidedPlane rightPlane;
    protected final GeoPoint[] planePoints;
    protected final GeoPoint centerPoint;
    protected final GeoPoint[] edgePoints;

    public GeoLongitudeSlice(PlanetModel planetModel, double leftLon, double rightLon) {
        super(planetModel);
        if (leftLon < -Math.PI || leftLon > Math.PI) {
            throw new IllegalArgumentException("Left longitude out of range");
        }
        if (rightLon < -Math.PI || rightLon > Math.PI) {
            throw new IllegalArgumentException("Right longitude out of range");
        }
        double extent = rightLon - leftLon;
        if (extent < 0.0) {
            extent += Math.PI * 2;
        }
        if (extent > Math.PI) {
            throw new IllegalArgumentException("Width of rectangle too great");
        }
        this.leftLon = leftLon;
        this.rightLon = rightLon;
        double sinLeftLon = Math.sin(leftLon);
        double cosLeftLon = Math.cos(leftLon);
        double sinRightLon = Math.sin(rightLon);
        double cosRightLon = Math.cos(rightLon);
        while (leftLon > rightLon) {
            rightLon += Math.PI * 2;
        }
        double middleLon = (leftLon + rightLon) * 0.5;
        this.centerPoint = new GeoPoint(planetModel, 0.0, middleLon);
        this.leftPlane = new SidedPlane((Vector)this.centerPoint, cosLeftLon, sinLeftLon);
        this.rightPlane = new SidedPlane((Vector)this.centerPoint, cosRightLon, sinRightLon);
        this.planePoints = new GeoPoint[]{planetModel.NORTH_POLE, planetModel.SOUTH_POLE};
        this.edgePoints = new GeoPoint[]{planetModel.NORTH_POLE};
    }

    @Override
    public GeoBBox expand(double angle) {
        double currentLonSpan = this.rightLon - this.leftLon;
        if (currentLonSpan < 0.0) {
            currentLonSpan += Math.PI * 2;
        }
        double newLeftLon = this.leftLon - angle;
        double newRightLon = this.rightLon + angle;
        if (currentLonSpan + 2.0 * angle >= Math.PI * 2) {
            newLeftLon = -Math.PI;
            newRightLon = Math.PI;
        }
        return GeoBBoxFactory.makeGeoBBox(this.planetModel, 1.5707963267948966, -1.5707963267948966, newLeftLon, newRightLon);
    }

    @Override
    public boolean isWithin(double x, double y, double z) {
        return this.leftPlane.isWithin(x, y, z) && this.rightPlane.isWithin(x, y, z);
    }

    @Override
    public double getRadius() {
        double extent = this.rightLon - this.leftLon;
        if (extent < 0.0) {
            extent += Math.PI * 2;
        }
        return Math.max(1.5707963267948966, extent * 0.5);
    }

    @Override
    public GeoPoint getCenter() {
        return this.centerPoint;
    }

    @Override
    public GeoPoint[] getEdgePoints() {
        return this.edgePoints;
    }

    @Override
    public boolean intersects(Plane p, GeoPoint[] notablePoints, Membership ... bounds) {
        return p.intersects(this.planetModel, this.leftPlane, notablePoints, this.planePoints, bounds, this.rightPlane) || p.intersects(this.planetModel, this.rightPlane, notablePoints, this.planePoints, bounds, this.leftPlane);
    }

    @Override
    public void getBounds(Bounds bounds) {
        super.getBounds(bounds);
        bounds.addVerticalPlane(this.planetModel, this.leftLon, this.leftPlane, this.rightPlane).addVerticalPlane(this.planetModel, this.rightLon, this.rightPlane, this.leftPlane).addPoint(this.planetModel.NORTH_POLE).addPoint(this.planetModel.SOUTH_POLE);
    }

    @Override
    public int getRelationship(GeoShape path) {
        int insideRectangle = this.isShapeInsideBBox(path);
        if (insideRectangle == 1) {
            return 2;
        }
        boolean insideShape = path.isWithin(this.planetModel.NORTH_POLE);
        if (insideRectangle == 0 && insideShape) {
            return 2;
        }
        if (path.intersects(this.leftPlane, this.planePoints, this.rightPlane) || path.intersects(this.rightPlane, this.planePoints, this.leftPlane)) {
            return 2;
        }
        if (insideRectangle == 0) {
            return 1;
        }
        if (insideShape) {
            return 0;
        }
        return 3;
    }

    @Override
    protected double outsideDistance(DistanceStyle distanceStyle, double x, double y, double z) {
        double leftDistance = distanceStyle.computeDistance(this.planetModel, (Plane)this.leftPlane, x, y, z, this.rightPlane);
        double rightDistance = distanceStyle.computeDistance(this.planetModel, (Plane)this.rightPlane, x, y, z, this.leftPlane);
        double northDistance = distanceStyle.computeDistance(this.planetModel.NORTH_POLE, x, y, z);
        double southDistance = distanceStyle.computeDistance(this.planetModel.SOUTH_POLE, x, y, z);
        return Math.min(Math.min(northDistance, southDistance), Math.min(leftDistance, rightDistance));
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof GeoLongitudeSlice)) {
            return false;
        }
        GeoLongitudeSlice other = (GeoLongitudeSlice)o;
        return super.equals(other) && other.leftLon == this.leftLon && other.rightLon == this.rightLon;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        long temp = Double.doubleToLongBits(this.leftLon);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.rightLon);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return "GeoLongitudeSlice: {planetmodel=" + this.planetModel + ", leftlon=" + this.leftLon + "(" + this.leftLon * 180.0 / Math.PI + "), rightlon=" + this.rightLon + "(" + this.rightLon * 180.0 / Math.PI + ")}";
    }
}

