/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.util.BitSet;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.MockAnalyzer;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.RandomIndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FilteredQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryWrapperFilter;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util._TestUtil;
import org.apache.lucene.util.automaton.BasicAutomata;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;
import org.junit.AfterClass;
import org.junit.BeforeClass;

public abstract class SearchEquivalenceTestBase
extends LuceneTestCase {
    protected static IndexSearcher s1;
    protected static IndexSearcher s2;
    protected static Directory directory;
    protected static IndexReader reader;
    protected static Analyzer analyzer;
    protected static String stopword;

    @BeforeClass
    public static void beforeClass() throws Exception {
        Random random = SearchEquivalenceTestBase.random();
        directory = SearchEquivalenceTestBase.newDirectory();
        stopword = "" + SearchEquivalenceTestBase.randomChar();
        CharacterRunAutomaton stopset = new CharacterRunAutomaton(BasicAutomata.makeString((String)stopword));
        analyzer = new MockAnalyzer(random, MockTokenizer.WHITESPACE, false, stopset, true);
        RandomIndexWriter iw = new RandomIndexWriter(random, directory, analyzer);
        Document doc = new Document();
        StringField id = new StringField("id", "", Field.Store.NO);
        TextField field = new TextField("field", "", Field.Store.NO);
        doc.add((IndexableField)id);
        doc.add((IndexableField)field);
        int numDocs = SearchEquivalenceTestBase.atLeast(1000);
        for (int i = 0; i < numDocs; ++i) {
            id.setStringValue(Integer.toString(i));
            field.setStringValue(SearchEquivalenceTestBase.randomFieldContents());
            iw.addDocument(doc);
        }
        int numDeletes = numDocs / 20;
        for (int i = 0; i < numDeletes; ++i) {
            Term toDelete = new Term("id", Integer.toString(random.nextInt(numDocs)));
            if (random.nextBoolean()) {
                iw.deleteDocuments(toDelete);
                continue;
            }
            iw.deleteDocuments((Query)new TermQuery(toDelete));
        }
        reader = iw.getReader();
        s1 = SearchEquivalenceTestBase.newSearcher(reader);
        s2 = SearchEquivalenceTestBase.newSearcher(reader);
        iw.close();
    }

    @AfterClass
    public static void afterClass() throws Exception {
        reader.close();
        directory.close();
        analyzer.close();
        reader = null;
        directory = null;
        analyzer = null;
        s2 = null;
        s1 = null;
    }

    static String randomFieldContents() {
        StringBuilder sb = new StringBuilder();
        int numTerms = SearchEquivalenceTestBase.random().nextInt(15);
        for (int i = 0; i < numTerms; ++i) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(SearchEquivalenceTestBase.randomChar());
        }
        return sb.toString();
    }

    static char randomChar() {
        return (char)_TestUtil.nextInt(SearchEquivalenceTestBase.random(), 97, 122);
    }

    protected Term randomTerm() {
        return new Term("field", "" + SearchEquivalenceTestBase.randomChar());
    }

    protected Filter randomFilter() {
        return new QueryWrapperFilter((Query)TermRangeQuery.newStringRange((String)"field", (String)"a", (String)("" + SearchEquivalenceTestBase.randomChar()), (boolean)true, (boolean)true));
    }

    public void assertSameSet(Query q1, Query q2) throws Exception {
        this.assertSubsetOf(q1, q2);
        this.assertSubsetOf(q2, q1);
    }

    public void assertSubsetOf(Query q1, Query q2) throws Exception {
        this.assertSubsetOf(q1, q2, null);
        this.assertSubsetOf(q1, q2, this.randomFilter());
    }

    protected void assertSubsetOf(Query q1, Query q2, Filter filter) throws Exception {
        int i;
        if (filter != null && SearchEquivalenceTestBase.random().nextBoolean()) {
            final boolean q1RandomAccess = SearchEquivalenceTestBase.random().nextBoolean();
            final boolean q2RandomAccess = SearchEquivalenceTestBase.random().nextBoolean();
            q1 = new FilteredQuery((Query)q1, filter){

                protected boolean useRandomAccess(Bits bits, int firstFilterDoc) {
                    return q1RandomAccess;
                }
            };
            q2 = new FilteredQuery((Query)q2, filter){

                protected boolean useRandomAccess(Bits bits, int firstFilterDoc) {
                    return q2RandomAccess;
                }
            };
            filter = null;
        }
        TopDocs td1 = s1.search(q1, filter, reader.maxDoc());
        TopDocs td2 = s2.search(q2, filter, reader.maxDoc());
        SearchEquivalenceTestBase.assertTrue((td1.totalHits <= td2.totalHits ? 1 : 0) != 0);
        BitSet bitset = new BitSet();
        for (i = 0; i < td2.scoreDocs.length; ++i) {
            bitset.set(td2.scoreDocs[i].doc);
        }
        for (i = 0; i < td1.scoreDocs.length; ++i) {
            SearchEquivalenceTestBase.assertTrue((boolean)bitset.get(td1.scoreDocs[i].doc));
        }
    }
}

