/*
 * $Id$
 */

package org.apache.maven.model;

/**
 * 
 *         
 *         Contains the plugins informations for the project.
 *         
 *       
 * 
 * @version $Revision$ $Date$
 */
public class PluginContainer implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field plugins
     */
    private java.util.List plugins;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addPlugin
     * 
     * @param plugin
     */
    public void addPlugin(Plugin plugin)
    {
        getPlugins().add( plugin );
    } //-- void addPlugin(Plugin) 

    /**
     * Method getPlugins
     */
    public java.util.List getPlugins()
    {
        if ( this.plugins == null )
        {
            this.plugins = new java.util.ArrayList();
        }
        
        return this.plugins;
    } //-- java.util.List getPlugins() 

    /**
     * Method removePlugin
     * 
     * @param plugin
     */
    public void removePlugin(Plugin plugin)
    {
        getPlugins().remove( plugin );
    } //-- void removePlugin(Plugin) 

    /**
     * Set The list of plugins to use.
     * 
     * @param plugins
     */
    public void setPlugins(java.util.List plugins)
    {
        this.plugins = plugins;
    } //-- void setPlugins(java.util.List) 


            
    java.util.Map pluginMap;

    /**
     * Reset the <code>pluginsMap</code> field to <code>null</code>
     */
    public void flushPluginMap()
    {
        this.pluginMap = null;
    }

    /**
     * @return a Map of plugins field with <code>Plugins#getKey()</code> as key
     * @see org.apache.maven.model.Plugin#getKey()
     */
    public java.util.Map getPluginsAsMap()
    {
        if ( pluginMap == null )
        {
            pluginMap = new java.util.HashMap();
            if ( plugins != null )
            {
                for ( java.util.Iterator it = plugins.iterator(); it.hasNext(); )
                {
                    Plugin plugin = (Plugin) it.next();
                    pluginMap.put( plugin.getKey(), plugin );
                }
            }
        }

        return pluginMap;
    }
            
          
    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }}
