/*
 * $Id$
 */

package org.apache.maven.profiles;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * 
 *         This is the property specification used to activate a
 * profile. If the value field is empty, 
 *         then the existence of the named property will activate
 * the profile, otherwise it does a case-sensitive
 *         match against the property value as well.
 *       
 * 
 * @version $Revision$ $Date$
 */
public class ActivationProperty implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * The name of the property to be used to activate a profile.
     */
    private String name;

    /**
     * The value of the property to be used to activate a profile.
     */
    private String value;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Get the name of the property to be used to activate a
     * profile.
     * 
     * @return String
     */
    public String getName()
    {
        return this.name;
    } //-- String getName() 

    /**
     * Get the value of the property to be used to activate a
     * profile.
     * 
     * @return String
     */
    public String getValue()
    {
        return this.value;
    } //-- String getValue() 

    /**
     * Set the name of the property to be used to activate a
     * profile.
     * 
     * @param name
     */
    public void setName( String name )
    {
        this.name = name;
    } //-- void setName( String ) 

    /**
     * Set the value of the property to be used to activate a
     * profile.
     * 
     * @param value
     */
    public void setValue( String value )
    {
        this.value = value;
    } //-- void setValue( String ) 


    private String modelEncoding = "UTF-8";

    /**
     * Set an encoding used for reading/writing the model.
     *
     * @param modelEncoding the encoding used when reading/writing the model.
     */
    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    /**
     * @return the current encoding used when reading/writing this model.
     */
    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
