/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.mercury.metadata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.mercury.artifact.ArtifactBasicMetadata;
import org.apache.maven.mercury.artifact.ArtifactMetadata;
import org.apache.maven.mercury.artifact.ArtifactScopeEnum;
import org.apache.maven.mercury.artifact.api.ArtifactListProcessor;
import org.apache.maven.mercury.artifact.version.VersionException;
import org.apache.maven.mercury.event.EventGenerator;
import org.apache.maven.mercury.event.EventManager;
import org.apache.maven.mercury.event.EventTypeEnum;
import org.apache.maven.mercury.event.GenericEvent;
import org.apache.maven.mercury.event.MercuryEvent;
import org.apache.maven.mercury.event.MercuryEventListener;
import org.apache.maven.mercury.logging.IMercuryLogger;
import org.apache.maven.mercury.logging.MercuryLoggerManager;
import org.apache.maven.mercury.metadata.ClassicDepthComparator;
import org.apache.maven.mercury.metadata.ClassicVersionComparator;
import org.apache.maven.mercury.metadata.DependencyBuilder;
import org.apache.maven.mercury.metadata.MetadataTreeArtifactFilter;
import org.apache.maven.mercury.metadata.MetadataTreeCircularDependencyException;
import org.apache.maven.mercury.metadata.MetadataTreeException;
import org.apache.maven.mercury.metadata.MetadataTreeNode;
import org.apache.maven.mercury.metadata.sat.DefaultSatSolver;
import org.apache.maven.mercury.metadata.sat.SatException;
import org.apache.maven.mercury.repository.api.ArtifactBasicResults;
import org.apache.maven.mercury.repository.api.Repository;
import org.apache.maven.mercury.repository.api.RepositoryException;
import org.apache.maven.mercury.repository.virtual.VirtualRepositoryReader;
import org.apache.maven.mercury.util.Util;
import org.codehaus.plexus.lang.DefaultLanguage;
import org.codehaus.plexus.lang.Language;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DependencyTreeBuilder
implements DependencyBuilder,
EventGenerator {
    private static final Language _lang = new DefaultLanguage(DependencyTreeBuilder.class);
    private static final IMercuryLogger _log = MercuryLoggerManager.getLogger(DependencyTreeBuilder.class);
    private Collection<MetadataTreeArtifactFilter> _filters;
    private List<Comparator<MetadataTreeNode>> _comparators;
    private Map<String, ArtifactListProcessor> _processors;
    private VirtualRepositoryReader _reader;
    private Map<String, MetadataTreeNode> _existingNodes;
    private EventManager _eventManager;

    protected DependencyTreeBuilder(Collection<Repository> repositories, Collection<MetadataTreeArtifactFilter> filters, List<Comparator<MetadataTreeNode>> comparators, Map<String, ArtifactListProcessor> processors) throws RepositoryException {
        this._filters = filters;
        this._comparators = comparators;
        if (this._comparators == null) {
            this._comparators = new ArrayList<Comparator<MetadataTreeNode>>(2);
            this._comparators.add(new ClassicDepthComparator());
            this._comparators.add(new ClassicVersionComparator());
        }
        if (processors != null) {
            this._processors = processors;
        }
        this._reader = new VirtualRepositoryReader(repositories);
    }

    @Override
    public MetadataTreeNode buildTree(ArtifactBasicMetadata startMD, ArtifactScopeEnum treeScope) throws MetadataTreeException {
        if (startMD == null) {
            throw new MetadataTreeException("null start point");
        }
        try {
            this._reader.setEventManager(this._eventManager);
            this._reader.setProcessors(this._processors);
            this._reader.init();
        }
        catch (RepositoryException e) {
            throw new MetadataTreeException(e);
        }
        this._existingNodes = new HashMap<String, MetadataTreeNode>(256);
        GenericEvent treeBuildEvent = new GenericEvent(EventTypeEnum.dependencyBuilder, "tree.build", startMD.getGAV());
        MetadataTreeNode root = this.createNode(startMD, null, startMD, treeScope);
        treeBuildEvent.stop();
        if (this._eventManager != null) {
            this._eventManager.fireEvent((MercuryEvent)treeBuildEvent);
        }
        MetadataTreeNode.reNumber(root, 1);
        return root;
    }

    private MetadataTreeNode buildTree(Collection<ArtifactBasicMetadata> startMDs, ArtifactScopeEnum treeScope) throws MetadataTreeException {
        return null;
    }

    private MetadataTreeNode createNode(ArtifactBasicMetadata nodeMD, MetadataTreeNode parent, ArtifactBasicMetadata nodeQuery, ArtifactScopeEnum globalScope) throws MetadataTreeException {
        GenericEvent nodeBuildEvent = null;
        if (this._eventManager != null) {
            nodeBuildEvent = new GenericEvent(EventTypeEnum.dependencyBuilder, "tree.node.build", nodeMD.getGAV());
        }
        try {
            this.checkForCircularDependency(nodeMD, parent);
            MetadataTreeNode existingNode = this._existingNodes.get(nodeQuery.toString());
            if (existingNode != null) {
                MetadataTreeNode metadataTreeNode = MetadataTreeNode.deepCopy(existingNode);
                return metadataTreeNode;
            }
            ArtifactMetadata mr = this._reader.readDependencies(nodeMD);
            if (mr == null) {
                throw new MetadataTreeException(_lang.getMessage("artifact.md.not.found", new String[]{nodeMD.toString()}));
            }
            MetadataTreeNode node = new MetadataTreeNode(mr, parent, nodeQuery);
            List allDependencies = mr.getDependencies();
            if (allDependencies == null || allDependencies.size() < 1) {
                MetadataTreeNode metadataTreeNode = node;
                return metadataTreeNode;
            }
            ArrayList<ArtifactBasicMetadata> dependencies = new ArrayList<ArtifactBasicMetadata>(allDependencies.size());
            if (globalScope != null) {
                for (ArtifactBasicMetadata md : allDependencies) {
                    ArtifactScopeEnum mdScope = md.getArtifactScope();
                    if (!globalScope.encloses(mdScope)) continue;
                    dependencies.add(md);
                }
            } else {
                dependencies.addAll(allDependencies);
            }
            if (Util.isEmpty(dependencies)) {
                MetadataTreeNode i$ = node;
                return i$;
            }
            ArtifactBasicResults res = this._reader.readVersions(dependencies);
            Map expandedDeps = res.getResults();
            for (ArtifactBasicMetadata md : dependencies) {
                List versions;
                if (_log.isDebugEnabled()) {
                    _log.debug("node " + nodeQuery + ", dep " + md);
                }
                if ((versions = (List)expandedDeps.get(md)) == null || versions.size() < 1) {
                    if (md.isOptional()) continue;
                    throw new MetadataTreeException("did not find non-optional artifact for " + md + " <== " + this.showPath(node));
                }
                boolean noGoodVersions = true;
                boolean noVersions = true;
                for (ArtifactBasicMetadata ver : versions) {
                    if (this.veto(ver, this._filters) || this.vetoInclusionsExclusions(node, ver)) {
                        noGoodVersions = false;
                        continue;
                    }
                    MetadataTreeNode kid = this.createNode(ver, node, md, globalScope);
                    node.addChild(kid);
                    noVersions = false;
                    noGoodVersions = false;
                }
                if (noVersions && !noGoodVersions) continue;
                if (noGoodVersions) {
                    if (md.isOptional()) continue;
                    throw new MetadataTreeException("did not find non-optional artifact for " + md);
                }
                node.addQuery(md);
            }
            this._existingNodes.put(nodeQuery.toString(), node);
            MetadataTreeNode metadataTreeNode = node;
            return metadataTreeNode;
        }
        catch (RepositoryException e) {
            if (this._eventManager != null) {
                nodeBuildEvent.setResult(e.getMessage());
            }
            throw new MetadataTreeException(e);
        }
        catch (VersionException e) {
            if (this._eventManager != null) {
                nodeBuildEvent.setResult(e.getMessage());
            }
            throw new MetadataTreeException(e);
        }
        catch (MetadataTreeException e) {
            if (this._eventManager != null) {
                nodeBuildEvent.setResult(e.getMessage());
            }
            throw e;
        }
        finally {
            if (this._eventManager != null) {
                nodeBuildEvent.stop();
                this._eventManager.fireEvent((MercuryEvent)nodeBuildEvent);
            }
        }
    }

    private void checkForCircularDependency(ArtifactBasicMetadata md, MetadataTreeNode parent) throws MetadataTreeCircularDependencyException {
        MetadataTreeNode p = parent;
        int count = 0;
        while (p != null) {
            ++count;
            if (md.sameGA((ArtifactBasicMetadata)p.md)) {
                p = parent;
                StringBuilder sb = new StringBuilder(128);
                sb.append(md.toString());
                while (p != null) {
                    sb.append(" <- " + p.md.toString());
                    if (md.sameGA((ArtifactBasicMetadata)p.md)) {
                        throw new MetadataTreeCircularDependencyException("circular dependency " + count + " levels up. " + sb.toString() + " <= " + (p.parent == null ? "no parent" : p.parent.md));
                    }
                    p = p.parent;
                }
            }
            p = p.parent;
        }
    }

    private boolean veto(ArtifactBasicMetadata md, Collection<MetadataTreeArtifactFilter> filters) {
        if (filters != null && filters.size() > 1) {
            for (MetadataTreeArtifactFilter filter : filters) {
                if (!filter.veto(md)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean vetoInclusionsExclusions(MetadataTreeNode node, ArtifactBasicMetadata ver) throws VersionException {
        for (MetadataTreeNode n = node; n != null; n = n.getParent()) {
            ArtifactBasicMetadata md = n.getQuery();
            if (md.allowDependency(ver)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<ArtifactMetadata> resolveConflicts(MetadataTreeNode root) throws MetadataTreeException {
        if (root == null) {
            throw new MetadataTreeException(_lang.getMessage("empty.tree", new String[0]));
        }
        try {
            DefaultSatSolver solver = new DefaultSatSolver(root, this._eventManager);
            solver.applyPolicies(this.getComparators());
            List<ArtifactMetadata> res = solver.solve();
            return res;
        }
        catch (SatException e) {
            throw new MetadataTreeException(e);
        }
    }

    @Override
    public MetadataTreeNode resolveConflictsAsTree(MetadataTreeNode root) throws MetadataTreeException {
        if (root == null) {
            throw new MetadataTreeException(_lang.getMessage("empty.tree", new String[0]));
        }
        try {
            DefaultSatSolver solver = new DefaultSatSolver(root, this._eventManager);
            solver.applyPolicies(this.getComparators());
            MetadataTreeNode res = solver.solveAsTree();
            return res;
        }
        catch (SatException e) {
            throw new MetadataTreeException(e);
        }
    }

    private List<Comparator<MetadataTreeNode>> getComparators() {
        if (Util.isEmpty(this._comparators)) {
            this._comparators = new ArrayList<Comparator<MetadataTreeNode>>(2);
        }
        if (this._comparators.size() < 1) {
            this._comparators.add(new ClassicDepthComparator());
            this._comparators.add(new ClassicVersionComparator());
        }
        return this._comparators;
    }

    protected List<ArtifactMetadata> resolveConflicts(List<ArtifactBasicMetadata> bmds) throws MetadataTreeException {
        if (Util.isEmpty(bmds)) {
            throw new MetadataTreeException(_lang.getMessage("empty.tree.collection", new String[0]));
        }
        String dummyGAV = "__fake:__fake:0.0.0";
        ArtifactBasicMetadata query = new ArtifactBasicMetadata(dummyGAV);
        ArtifactMetadata dummyMd = new ArtifactMetadata(query);
        dummyMd.setDependencies(bmds);
        MetadataTreeNode root = new MetadataTreeNode(dummyMd, null, query);
        try {
            DefaultSatSolver solver = new DefaultSatSolver(root, this._eventManager);
            solver.applyPolicies(this.getComparators());
            List<ArtifactMetadata> res = solver.solve();
            res.remove(dummyMd);
            return res;
        }
        catch (SatException e) {
            throw new MetadataTreeException(e);
        }
    }

    protected List<ArtifactMetadata> resolveConflicts(ArtifactBasicMetadata ... bmds) throws MetadataTreeException {
        if (Util.isEmpty((Object[])bmds)) {
            return null;
        }
        return this.resolveConflicts(Arrays.asList(bmds));
    }

    private String showPath(MetadataTreeNode node) throws MetadataTreeCircularDependencyException {
        StringBuilder sb = new StringBuilder(256);
        String comma = "";
        MetadataTreeNode p = node;
        while (p != null) {
            sb.append(comma + p.getMd().toString());
            comma = " <== ";
            p = p.parent;
        }
        return sb.toString();
    }

    @Override
    public void register(MercuryEventListener listener) {
        if (this._eventManager == null) {
            this._eventManager = new EventManager();
        }
        this._eventManager.register(listener);
    }

    @Override
    public void unRegister(MercuryEventListener listener) {
        if (this._eventManager != null) {
            this._eventManager.unRegister(listener);
        }
    }

    public void setEventManager(EventManager eventManager) {
        if (this._eventManager == null) {
            this._eventManager = eventManager;
        } else {
            this._eventManager.getListeners().addAll(eventManager.getListeners());
        }
    }
}

