/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.artifact.buildinfo;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.artifact.buildinfo.BuildInfoWriter;
import org.apache.maven.plugins.artifact.buildinfo.PluginUtil;
import org.apache.maven.plugins.artifact.buildinfo.ReferenceBuildinfoUtil;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.shared.utils.PropertyUtils;
import org.apache.maven.shared.utils.StringUtils;
import org.apache.maven.shared.utils.io.FileUtils;
import org.apache.maven.shared.utils.logging.MessageUtils;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;

@Mojo(name="buildinfo", defaultPhase=LifecyclePhase.VERIFY)
public class BuildinfoMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${reactorProjects}", required=true, readonly=true)
    private List<MavenProject> reactorProjects;
    @Parameter(defaultValue="${project.build.directory}/${project.artifactId}-${project.version}.buildinfo", required=true, readonly=true)
    private File buildinfoFile;
    @Parameter(property="buildinfo.ignoreJavadoc", defaultValue="true")
    private boolean ignoreJavadoc;
    @Parameter(property="buildinfo.ignore", defaultValue="")
    private Set<String> ignore;
    @Parameter(property="buildinfo.attach", defaultValue="true")
    private boolean attach;
    @Parameter(property="reference.repo")
    private String referenceRepo;
    @Parameter(property="reference.compare.save", defaultValue="false")
    private boolean referenceCompareSave;
    @Parameter(property="buildinfo.detect.skip", defaultValue="true")
    private boolean detectSkip;
    @Parameter(property="buildinfo.reproducible", defaultValue="false")
    private boolean reproducible;
    @Component
    private MavenProjectHelper projectHelper;
    @Component
    private ArtifactFactory artifactFactory;
    @Component
    private RepositorySystem repoSystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true)
    private List<RemoteRepository> remoteRepos;
    @Component
    private ArtifactRepositoryLayout artifactRepositoryLayout;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Component
    private ToolchainManager toolchainManager;

    public void execute() throws MojoExecutionException {
        boolean mono;
        boolean bl = mono = this.reactorProjects.size() == 1;
        if (!mono) {
            if (this.isSkip(this.project)) {
                this.getLog().info((CharSequence)"Skipping buildinfo for module that skips install and/or deploy");
                return;
            }
            MavenProject last = this.getLastProject();
            if (this.project != last) {
                this.getLog().info((CharSequence)("Skipping intermediate buildinfo, aggregate will be " + last.getArtifactId()));
                return;
            }
        }
        Map<Artifact, String> artifacts = this.generateBuildinfo(mono);
        this.getLog().info((CharSequence)("Saved " + (mono ? "" : "aggregate ") + "info on build to " + this.buildinfoFile));
        if (this.attach) {
            this.getLog().info((CharSequence)"Attaching buildinfo");
            this.projectHelper.attachArtifact(this.project, "buildinfo", this.buildinfoFile);
        } else {
            this.getLog().info((CharSequence)"NOT adding buildinfo to the list of attached artifacts.");
        }
        this.copyAggregateToRoot(this.buildinfoFile);
        if (this.referenceRepo != null) {
            this.getLog().info((CharSequence)("Checking against reference build from " + this.referenceRepo + "..."));
            this.checkAgainstReference(mono, artifacts);
        }
    }

    private void copyAggregateToRoot(File aggregate) throws MojoExecutionException {
        if (this.reactorProjects.size() == 1) {
            return;
        }
        MavenProject root = this.getExecutionRoot();
        String compare = aggregate.getName().endsWith(".compare") ? ".compare" : "";
        File rootCopy = new File(root.getBuild().getDirectory(), root.getArtifactId() + '-' + root.getVersion() + ".buildinfo" + compare);
        try {
            FileUtils.copyFile((File)aggregate, (File)rootCopy);
            this.getLog().info((CharSequence)("Aggregate buildinfo" + compare + " copied to " + rootCopy));
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Could not copy " + aggregate + "to " + rootCopy);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<Artifact, String> generateBuildinfo(boolean mono) throws MojoExecutionException {
        MavenProject root = mono ? this.project : this.getExecutionRoot();
        this.buildinfoFile.getParentFile().mkdirs();
        try (PrintWriter p = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.buildinfoFile), StandardCharsets.UTF_8)));){
            BuildInfoWriter bi = new BuildInfoWriter(this.getLog(), p, mono);
            bi.setIgnoreJavadoc(this.ignoreJavadoc);
            bi.setIgnore(this.ignore);
            bi.setToolchain(this.getToolchain());
            bi.printHeader(root, mono ? null : this.project, this.reproducible);
            if (mono) {
                bi.printArtifacts(this.project);
            } else {
                for (MavenProject project : this.reactorProjects) {
                    if (this.isSkip(project)) continue;
                    bi.printArtifacts(project);
                }
            }
            if (p.checkError()) {
                throw new MojoExecutionException("Write error to " + this.buildinfoFile);
            }
            Map<Artifact, String> map = bi.getArtifacts();
            return map;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error creating file " + this.buildinfoFile, (Exception)e);
        }
    }

    private void checkAgainstReference(boolean mono, Map<Artifact, String> artifacts) throws MojoExecutionException {
        MavenProject root = mono ? this.project : this.getExecutionRoot();
        File referenceDir = new File(root.getBuild().getDirectory(), "reference");
        referenceDir.mkdirs();
        File referenceBuildinfo = this.downloadOrCreateReferenceBuildinfo(mono, artifacts, referenceDir);
        this.compareWithReference(artifacts, referenceBuildinfo);
    }

    private File downloadOrCreateReferenceBuildinfo(boolean mono, Map<Artifact, String> artifacts, File referenceDir) throws MojoExecutionException {
        RemoteRepository repo = this.createReferenceRepo();
        ReferenceBuildinfoUtil rmb = new ReferenceBuildinfoUtil(this.getLog(), referenceDir, artifacts, this.artifactFactory, this.repoSystem, this.repoSession);
        return rmb.downloadOrCreateReferenceBuildinfo(repo, this.project, this.buildinfoFile, mono);
    }

    private void compareWithReference(Map<Artifact, String> artifacts, File referenceBuildinfo) throws MojoExecutionException {
        int missing;
        Properties actual = BuildInfoWriter.loadOutputProperties(this.buildinfoFile);
        Properties reference = BuildInfoWriter.loadOutputProperties(referenceBuildinfo);
        int ok = 0;
        ArrayList<String> okFilenames = new ArrayList<String>();
        ArrayList<String> koFilenames = new ArrayList<String>();
        ArrayList<String> diffoscopes = new ArrayList<String>();
        File referenceDir = referenceBuildinfo.getParentFile();
        for (Map.Entry<Artifact, String> entry : artifacts.entrySet()) {
            String prefix;
            Artifact artifact = entry.getKey();
            String diffoscope = this.checkArtifact(artifact, prefix = entry.getValue(), reference, actual, referenceDir);
            if (diffoscope == null) {
                ++ok;
                okFilenames.add(artifact.getFile().getName());
                continue;
            }
            koFilenames.add(artifact.getFile().getName());
            diffoscopes.add(diffoscope);
        }
        int ko = artifacts.size() - ok;
        if (ko + (missing = reference.size() / 3) > 0) {
            this.getLog().warn((CharSequence)("Reproducible Build output summary: " + MessageUtils.buffer().success((Object)(ok + " files ok")) + ", " + MessageUtils.buffer().failure((Object)(ko + " different")) + (missing == 0 ? "" : ", " + MessageUtils.buffer().warning((Object)(missing + " missing")))));
            this.getLog().warn((CharSequence)("see " + MessageUtils.buffer().project((Object)("diff " + this.relative(referenceBuildinfo) + " " + this.relative(this.buildinfoFile))).toString()));
            this.getLog().warn((CharSequence)"see also https://maven.apache.org/guides/mini/guide-reproducible-builds.html");
        } else {
            this.getLog().info((CharSequence)("Reproducible Build output summary: " + MessageUtils.buffer().success((Object)(ok + " files ok"))));
        }
        if (this.referenceCompareSave) {
            File compare = new File(this.buildinfoFile.getParentFile(), this.buildinfoFile.getName() + ".compare");
            try (PrintWriter p = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(compare), StandardCharsets.UTF_8)));){
                p.println("version=" + this.project.getVersion());
                p.println("ok=" + ok);
                p.println("ko=" + ko);
                p.println("okFiles=\"" + StringUtils.join(okFilenames.iterator(), (String)" ") + '\"');
                p.println("koFiles=\"" + StringUtils.join(koFilenames.iterator(), (String)" ") + '\"');
                Properties ref = PropertyUtils.loadOptionalProperties((File)referenceBuildinfo);
                String v = ref.getProperty("java.version");
                if (v != null) {
                    p.println("reference_java_version=" + v);
                }
                if ((v = ref.getProperty("os.name")) != null) {
                    p.println("reference_os_name=" + v);
                }
                for (String diffoscope : diffoscopes) {
                    p.print("# ");
                    p.println(diffoscope);
                }
                this.getLog().info((CharSequence)("Reproducible Build comparison saved to " + compare));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error creating file " + compare, (Exception)e);
            }
            this.copyAggregateToRoot(compare);
        }
    }

    private String checkArtifact(Artifact artifact, String prefix, Properties reference, Properties actual, File referenceDir) {
        String actualFilename = (String)actual.remove(prefix + ".filename");
        String actualLength = (String)actual.remove(prefix + ".length");
        String actualSha512 = (String)actual.remove(prefix + ".checksums.sha512");
        String referencePrefix = BuildinfoMojo.findPrefix(reference, actualFilename);
        String referenceLength = (String)reference.remove(referencePrefix + ".length");
        String referenceSha512 = (String)reference.remove(referencePrefix + ".checksums.sha512");
        String issue = null;
        if (!actualLength.equals(referenceLength)) {
            issue = "size";
        } else if (!actualSha512.equals(referenceSha512)) {
            issue = "sha512";
        }
        if (issue != null) {
            String diffoscope = this.diffoscope(artifact, referenceDir);
            this.getLog().warn((CharSequence)(issue + " mismatch " + MessageUtils.buffer().strong((Object)actualFilename) + ": investigate with " + MessageUtils.buffer().project((Object)diffoscope)));
            return diffoscope;
        }
        return null;
    }

    private String diffoscope(Artifact a, File referenceDir) {
        File actual = a.getFile();
        File reference = new File(referenceDir, this.getRepositoryFilename(a));
        return "diffoscope " + this.relative(reference) + " " + this.relative(actual);
    }

    private String getRepositoryFilename(Artifact a) {
        String path = this.artifactRepositoryLayout.pathOf(a);
        return path.substring(path.lastIndexOf(47));
    }

    private String relative(File file) {
        return file.getPath().substring(this.getExecutionRoot().getBasedir().getPath().length() + 1);
    }

    private static String findPrefix(Properties reference, String actualFilename) {
        for (String name : reference.stringPropertyNames()) {
            if (!name.endsWith(".filename") || !actualFilename.equals(reference.getProperty(name))) continue;
            reference.remove(name);
            return name.substring(0, name.length() - ".filename".length());
        }
        return null;
    }

    private RemoteRepository createReferenceRepo() throws MojoExecutionException {
        if (this.referenceRepo.contains("::")) {
            int index = this.referenceRepo.indexOf("::");
            String id = this.referenceRepo.substring(0, index);
            String url = this.referenceRepo.substring(index + 2);
            return BuildinfoMojo.createDeploymentArtifactRepository(id, url);
        }
        if (this.referenceRepo.contains(":")) {
            return BuildinfoMojo.createDeploymentArtifactRepository("reference", this.referenceRepo);
        }
        for (RemoteRepository repo : this.remoteRepos) {
            if (!this.referenceRepo.equals(repo.getId())) continue;
            return repo;
        }
        throw new MojoExecutionException("Could not find repository with id = " + this.referenceRepo);
    }

    private static RemoteRepository createDeploymentArtifactRepository(String id, String url) {
        return new RemoteRepository.Builder(id, "default", url).build();
    }

    private MavenProject getExecutionRoot() {
        for (MavenProject p : this.reactorProjects) {
            if (!p.isExecutionRoot()) continue;
            return p;
        }
        return null;
    }

    private MavenProject getLastProject() {
        int i = this.reactorProjects.size();
        while (i > 0) {
            MavenProject project;
            if (this.isSkip(project = this.reactorProjects.get(--i))) continue;
            return project;
        }
        return null;
    }

    private boolean isSkip(MavenProject project) {
        return this.detectSkip && PluginUtil.isSkip(project);
    }

    private Toolchain getToolchain() {
        Toolchain tc = null;
        if (this.toolchainManager != null) {
            tc = this.toolchainManager.getToolchainFromBuildContext("jdk", this.session);
        }
        return tc;
    }
}

