/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.artifact.buildinfo;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.artifact.buildinfo.BuildInfoWriter;
import org.apache.maven.plugins.artifact.buildinfo.PluginUtil;
import org.apache.maven.project.MavenProject;
import org.apache.maven.rtinfo.RuntimeInformation;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.eclipse.aether.artifact.Artifact;

public abstract class AbstractBuildinfoMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.build.directory}/${project.artifactId}-${project.version}.buildinfo", required=true, readonly=true)
    protected File buildinfoFile;
    @Parameter(property="buildinfo.ignoreJavadoc", defaultValue="true")
    private boolean ignoreJavadoc;
    @Parameter(property="buildinfo.ignore", defaultValue="")
    private List<String> ignore;
    @Parameter(property="buildinfo.detect.skip", defaultValue="true")
    private boolean detectSkip;
    @Parameter(property="buildinfo.skipModules")
    private List<String> skipModules;
    private List<PathMatcher> skipModulesMatcher = null;
    @Parameter(property="buildinfo.reproducible", defaultValue="false")
    private boolean reproducible;
    @Parameter(defaultValue="${project.build.outputTimestamp}")
    protected String outputTimestamp;
    @Parameter(property="diagnose", defaultValue="false")
    private boolean diagnose;
    private final ToolchainManager toolchainManager;
    protected final RuntimeInformation rtInformation;
    protected final MavenProject project;
    protected final MavenSession session;

    protected AbstractBuildinfoMojo(ToolchainManager toolchainManager, RuntimeInformation rtInformation, MavenProject project, MavenSession session) {
        this.toolchainManager = toolchainManager;
        this.rtInformation = rtInformation;
        this.project = project;
        this.session = session;
    }

    public void execute() throws MojoExecutionException {
        boolean mono = this.session.getProjects().size() == 1;
        AbstractBuildinfoMojo.hasBadOutputTimestamp(this.outputTimestamp, this.getLog(), this.project, this.session, this.diagnose);
        if (!mono) {
            if (this.detectSkip && PluginUtil.isSkip(this.project)) {
                this.getLog().info((CharSequence)"Auto-skipping goal because module skips install and/or deploy");
                return;
            }
            if (this.isSkipModule(this.project)) {
                this.getLog().info((CharSequence)"Skipping goal for module");
                return;
            }
            MavenProject last = this.getLastProject();
            if (this.project != last) {
                this.skip(last);
                return;
            }
        }
        Map<Artifact, String> artifacts = this.generateBuildinfo(mono);
        this.getLog().info((CharSequence)("Saved " + (mono ? "" : "aggregate ") + "info on build to " + this.buildinfoFile));
        this.copyAggregateToRoot(this.buildinfoFile);
        this.execute(artifacts);
    }

    static boolean hasBadOutputTimestamp(String outputTimestamp, Log log, MavenProject project, MavenSession session, boolean diagnose) {
        String effective;
        Instant timestamp = MavenArchiver.parseBuildOutputTimestamp((String)outputTimestamp).orElse(null);
        String string = effective = timestamp == null ? "disabled" : DateTimeFormatter.ISO_INSTANT.format(timestamp);
        if (diagnose) {
            AbstractBuildinfoMojo.diagnose(outputTimestamp, log, project, session, effective);
        }
        if (timestamp == null) {
            log.error((CharSequence)"Reproducible Build not activated by project.build.outputTimestamp property: see https://maven.apache.org/guides/mini/guide-reproducible-builds.html");
            String projectProperty = project.getProperties().getProperty("project.build.outputTimestamp");
            if (projectProperty != null && projectProperty.startsWith("${git.")) {
                log.error((CharSequence)("project.build.outputTimestamp = \"" + projectProperty + "\": isn't Git value set?"));
                log.error((CharSequence)"Did validate phase run and Git plugin set the value?");
                if (project.getPackaging().equals("pom")) {
                    log.error((CharSequence)"if using git-commit-id-plugin, <skipPoms>false</skipPoms> may solve the issue.");
                }
            }
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((CharSequence)("project.build.outputTimestamp = \"" + outputTimestamp + "\" => " + (effective.equals(outputTimestamp) ? "" : " => " + effective)));
        }
        boolean parentInReactor = false;
        MavenProject reactorParent = project;
        while (session.getProjects().contains(reactorParent.getParent())) {
            parentInReactor = true;
            reactorParent = reactorParent.getParent();
        }
        String prop = reactorParent.getOriginalModel().getProperties().getProperty("project.build.outputTimestamp");
        if (prop == null) {
            log.info((CharSequence)("<project.build.outputTimestamp> property (= " + outputTimestamp + ") is inherited" + (parentInReactor ? " from outside the reactor" : "") + ", you can override in " + (parentInReactor ? "parent POM from reactor " + reactorParent.getFile() : "pom.xml")));
            return false;
        }
        return false;
    }

    static void diagnose(String outputTimestamp, Log log, MavenProject project, MavenSession session, String effective) {
        if (session.getProjects().size() > 1) {
            MavenProject root = session.getTopLevelProject();
            MavenProject first = (MavenProject)session.getProjects().get(0);
            Path firstRelative = root.getBasedir().toPath().relativize(first.getFile().toPath());
            MavenProject firstParent = first.getParent();
            log.info((CharSequence)("reactor executionRoot = " + root.getId() + (root.equals((Object)project) ? " (current)" : "") + System.lineSeparator() + "       reactor first = " + (first.equals((Object)root) ? "executionRoot" : first.getId() + " @ " + firstRelative) + System.lineSeparator() + "               first.parent = " + (firstParent == null ? firstParent : firstParent.getId())));
            if (firstParent != null && session.getProjects().contains(firstParent)) {
                log.warn((CharSequence)("reactor first parent = " + firstParent.getId() + " is in reactor"));
            }
        }
        log.info((CharSequence)("outputTimestamp = " + outputTimestamp + (effective.equals(outputTimestamp) ? "" : " => " + effective)));
        String projectProperty = project.getProperties().getProperty("project.build.outputTimestamp");
        String modelProperty = project.getModel().getProperties().getProperty("project.build.outputTimestamp");
        String originalModelProperty = project.getOriginalModel().getProperties().getProperty("project.build.outputTimestamp");
        log.info((CharSequence)("plugin outputTimestamp parameter diagnostics:" + System.lineSeparator() + "        - plugin outputTimestamp parameter (defaultValue=\"${project.build.outputTimestamp}\") = " + outputTimestamp + System.lineSeparator() + "        - project.build.outputTimestamp property from project = " + projectProperty + System.lineSeparator() + "        - project.build.outputTimestamp property from project model = " + modelProperty + System.lineSeparator() + "        - project.build.outputTimestamp property from project original model = " + originalModelProperty));
        if (outputTimestamp == null) {
            return;
        }
        MavenProject parent = project.getParent();
        if (parent != null) {
            StringBuilder sb = new StringBuilder("Inheritance analysis for property:" + System.lineSeparator() + "        - current " + project.getId() + " property = " + projectProperty);
            while (parent != null) {
                String parentProperty = parent.getProperties().getProperty("project.build.outputTimestamp");
                sb.append(System.lineSeparator());
                sb.append("        - " + (session.getProjects().contains(parent) ? "reactor" : "external") + " parent " + parent.getId() + " property = " + parentProperty);
                if (!projectProperty.equals(parentProperty)) break;
                parent = parent.getParent();
            }
            log.info((CharSequence)sb.toString());
        }
    }

    abstract void execute(Map<Artifact, String> var1) throws MojoExecutionException;

    protected void skip(MavenProject last) throws MojoExecutionException {
        this.getLog().info((CharSequence)("Skipping intermediate goal run, aggregate will be " + last.getArtifactId()));
    }

    protected File copyAggregateToRoot(File aggregate) throws MojoExecutionException {
        if (this.session.getProjects().size() == 1) {
            return aggregate;
        }
        MavenProject root = this.session.getTopLevelProject();
        String extension = aggregate.getName().substring(aggregate.getName().lastIndexOf(46));
        File rootCopy = new File(root.getBuild().getDirectory(), root.getArtifactId() + '-' + root.getVersion() + extension);
        try {
            rootCopy.getParentFile().mkdirs();
            Files.copy(aggregate.toPath(), rootCopy.toPath(), LinkOption.NOFOLLOW_LINKS, StandardCopyOption.REPLACE_EXISTING);
            this.getLog().info((CharSequence)("Aggregate " + extension.substring(1) + " copied to " + this.relative(rootCopy)));
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Could not copy " + aggregate + " to " + rootCopy, (Exception)ioe);
        }
        return rootCopy;
    }

    protected BuildInfoWriter newBuildInfoWriter(PrintWriter p, boolean mono) {
        BuildInfoWriter bi = new BuildInfoWriter(this.getLog(), p, mono, this.rtInformation);
        bi.setIgnoreJavadoc(this.ignoreJavadoc);
        bi.setIgnore(this.ignore);
        bi.setToolchain(this.getToolchain());
        return bi;
    }

    protected Map<Artifact, String> generateBuildinfo(boolean mono) throws MojoExecutionException {
        MavenProject root = mono ? this.project : this.session.getTopLevelProject();
        this.buildinfoFile.getParentFile().mkdirs();
        PrintWriter p = new PrintWriter(new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(this.buildinfoFile.toPath(), new OpenOption[0]), StandardCharsets.UTF_8)));
        try {
            BuildInfoWriter bi = this.newBuildInfoWriter(p, mono);
            bi.printHeader(root, mono ? null : this.project, this.reproducible);
            if (mono) {
                bi.printArtifacts(this.project);
            } else {
                for (MavenProject project : this.session.getProjects()) {
                    if (this.isSkip(project)) continue;
                    bi.printArtifacts(project);
                }
            }
            if (p.checkError()) {
                throw new MojoExecutionException("Write error to " + this.buildinfoFile);
            }
            Map<Artifact, String> map = bi.getArtifacts();
            p.close();
            return map;
        }
        catch (Throwable throwable) {
            try {
                try {
                    p.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error creating file " + this.buildinfoFile, (Exception)e);
            }
        }
    }

    protected MavenProject getLastProject() {
        int i = this.session.getProjects().size();
        while (i > 0) {
            MavenProject project = (MavenProject)this.session.getProjects().get(--i);
            if (this.isSkip(project)) continue;
            return project;
        }
        return null;
    }

    protected boolean isSkip(MavenProject project) {
        return this.isSkipModule(project) || this.detectSkip && PluginUtil.isSkip(project);
    }

    protected boolean isSkipModule(MavenProject project) {
        if (this.skipModules == null || this.skipModules.isEmpty()) {
            return false;
        }
        if (this.skipModulesMatcher == null) {
            FileSystem fs = FileSystems.getDefault();
            this.skipModulesMatcher = this.skipModules.stream().map(i -> fs.getPathMatcher("glob:" + i)).collect(Collectors.toList());
        }
        Path path = Paths.get(project.getGroupId() + '/' + project.getArtifactId(), new String[0]);
        return this.skipModulesMatcher.stream().anyMatch(m -> m.matches(path));
    }

    private Toolchain getToolchain() {
        Toolchain tc = null;
        if (this.toolchainManager != null) {
            tc = this.toolchainManager.getToolchainFromBuildContext("jdk", this.session);
        }
        return tc;
    }

    protected String relative(File file) {
        File basedir = this.session.getTopLevelProject().getBasedir();
        int length = basedir.getPath().length();
        String path = file.getPath();
        return path.substring(length + 1);
    }
}

