/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly.resolved;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.assembly.InvalidAssemblerConfigurationException;
import org.apache.maven.plugin.assembly.archive.ArchiveCreationException;
import org.apache.maven.plugin.assembly.format.AssemblyFormattingException;
import org.apache.maven.plugin.assembly.model.Assembly;
import org.apache.maven.plugin.assembly.model.DependencySet;
import org.apache.maven.plugin.assembly.model.FileItem;
import org.apache.maven.plugin.assembly.model.FileSet;
import org.apache.maven.plugin.assembly.model.Repository;
import org.apache.maven.plugin.assembly.resolved.ResolvedModuleSet;
import org.apache.maven.plugin.assembly.resolved.functions.ResolvedModuleSetConsumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolvedAssembly {
    private final Assembly assembly;
    private final List<ResolvedModuleSet> resolvedModuleSets;
    private final Set<Artifact> dependencySetArtifacts;

    private ResolvedAssembly(Assembly assembly, List<ResolvedModuleSet> resolvedModuleSets, Set<Artifact> dependencySetArtifacts) {
        this.assembly = assembly;
        this.resolvedModuleSets = resolvedModuleSets;
        this.dependencySetArtifacts = dependencySetArtifacts;
    }

    public static ResolvedAssembly create(Assembly assembly) {
        return new ResolvedAssembly(assembly, null, null);
    }

    public ResolvedAssembly withResolvedModuleSets(Iterable<ResolvedModuleSet> resolvedModuleSets) {
        ArrayList<ResolvedModuleSet> resolvedModuleSets1 = new ArrayList<ResolvedModuleSet>();
        for (ResolvedModuleSet resolvedModuleSet : resolvedModuleSets) {
            resolvedModuleSets1.add(resolvedModuleSet);
        }
        return new ResolvedAssembly(this.assembly, resolvedModuleSets1, this.dependencySetArtifacts);
    }

    public void forEachResolvedModule(ResolvedModuleSetConsumer resolvedModuleSetConsumer) throws ArchiveCreationException, AssemblyFormattingException, InvalidAssemblerConfigurationException {
        if (this.resolvedModuleSets == null) {
            return;
        }
        for (ResolvedModuleSet resolvedModuleSet : this.resolvedModuleSets) {
            resolvedModuleSetConsumer.accept(resolvedModuleSet);
        }
    }

    public Set<Artifact> getResolvedDependencySetArtifacts() {
        return this.dependencySetArtifacts;
    }

    public List<DependencySet> getDependencySets() {
        return this.assembly.getDependencySets();
    }

    public List<FileItem> getFiles() {
        return this.assembly.getFiles();
    }

    public List<FileSet> getFileSets() {
        return this.assembly.getFileSets();
    }

    public List<Repository> getRepositories() {
        return this.assembly.getRepositories();
    }

    public ResolvedAssembly withDependencySetArtifacts(Set<Artifact> dependencySetArtifacts) {
        return new ResolvedAssembly(this.assembly, this.resolvedModuleSets, dependencySetArtifacts);
    }
}

