/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.compiler;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

final class ModuleDirectoryRemover
implements Closeable {
    private final Path mavenTarget;
    private final Path javacTarget;
    private final Path interTarget;

    private ModuleDirectoryRemover(Path outputDirectory, String moduleName) throws IOException {
        this.mavenTarget = outputDirectory;
        this.interTarget = Files.move(outputDirectory, outputDirectory.resolveSibling(moduleName), new CopyOption[0]);
        this.javacTarget = Files.createDirectory(outputDirectory, new FileAttribute[0]).resolve(moduleName);
        Files.move(this.interTarget, this.javacTarget, new CopyOption[0]);
    }

    static ModuleDirectoryRemover create(Path outputDirectory, String moduleName) throws IOException {
        return moduleName != null ? new ModuleDirectoryRemover(outputDirectory, moduleName) : null;
    }

    @Override
    public void close() throws IOException {
        Files.move(this.javacTarget, this.interTarget, new CopyOption[0]);
        Files.delete(this.mavenTarget);
        Files.move(this.interTarget, this.mavenTarget, new CopyOption[0]);
    }
}

