/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.docck;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.maven.model.IssueManagement;
import org.apache.maven.model.License;
import org.apache.maven.model.Organization;
import org.apache.maven.model.Prerequisites;
import org.apache.maven.model.Scm;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.docck.reports.DocumentationReporter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.util.FileSetManager;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractCheckDocumentationMojo
extends AbstractMojo {
    private static final int HTTP_STATUS_200 = 200;
    private List reactorProjects;
    private File output;
    protected String siteDirectory;
    private boolean offline;
    private Settings settings;
    private HttpClient httpClient;
    private FileSetManager fileSetManager = new FileSetManager();
    private List validUrls = new ArrayList();

    protected AbstractCheckDocumentationMojo() {
        String httpUserAgent = "maven-docck-plugin/1.x (Java " + System.getProperty("java.version") + "; " + System.getProperty("os.name") + " " + System.getProperty("os.version") + ")";
        this.httpClient = new HttpClient();
        int connectionTimeout = 5000;
        this.httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(5000);
        this.httpClient.getParams().setParameter("http.useragent", (Object)httpUserAgent);
    }

    protected List getReactorProjects() {
        return this.reactorProjects;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.setupProxy();
        if (this.output != null) {
            this.getLog().info((CharSequence)("Writing documentation check results to: " + this.output));
        }
        LinkedHashMap<MavenProject, DocumentationReporter> reporters = new LinkedHashMap<MavenProject, DocumentationReporter>();
        boolean hasErrors = false;
        Iterator it = this.reactorProjects.iterator();
        while (it.hasNext()) {
            MavenProject project = (MavenProject)it.next();
            if (this.approveProjectPackaging(project.getPackaging())) {
                this.getLog().info((CharSequence)("Checking project: " + project.getName()));
                DocumentationReporter reporter = new DocumentationReporter();
                this.checkProject(project, reporter);
                if (!hasErrors && reporter.hasErrors()) {
                    hasErrors = true;
                }
                reporters.put(project, reporter);
                continue;
            }
            this.getLog().info((CharSequence)("Skipping unsupported project: " + project.getName()));
        }
        String messages = this.buildErrorMessages(reporters);
        if (!hasErrors) {
            messages = messages + "No documentation errors were found.";
        }
        try {
            this.writeMessages(messages, hasErrors);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error writing results to output file: " + this.output);
        }
        if (hasErrors) {
            String logLocation = this.output == null ? "Please see the console output above for more information." : "Please see '" + this.output + "' for more information.";
            throw new MojoFailureException("Documentation problems were found. " + logLocation);
        }
    }

    private void setupProxy() {
        Proxy settingsProxy = this.settings.getActiveProxy();
        if (settingsProxy != null) {
            String proxyUsername = settingsProxy.getUsername();
            String proxyPassword = settingsProxy.getPassword();
            String proxyHost = settingsProxy.getHost();
            int proxyPort = settingsProxy.getPort();
            if (StringUtils.isNotEmpty((String)proxyHost)) {
                this.httpClient.getHostConfiguration().setProxy(proxyHost, proxyPort);
                this.getLog().info((CharSequence)("Using proxy [" + proxyHost + "] at port [" + proxyPort + "]."));
                if (StringUtils.isNotEmpty((String)proxyUsername)) {
                    this.getLog().info((CharSequence)("Using proxy user [" + proxyUsername + "]."));
                    UsernamePasswordCredentials creds = new UsernamePasswordCredentials(proxyUsername, proxyPassword);
                    this.httpClient.getState().setProxyCredentials(new AuthScope(proxyHost, proxyPort), (Credentials)creds);
                    this.httpClient.getParams().setAuthenticationPreemptive(true);
                }
            }
        }
    }

    private String buildErrorMessages(Map reporters) {
        String messages = "";
        StringBuffer buffer = new StringBuffer();
        Iterator it = reporters.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            MavenProject project = (MavenProject)entry.getKey();
            DocumentationReporter reporter = (DocumentationReporter)entry.getValue();
            if (reporter.getMessages().isEmpty()) continue;
            buffer.append("\no ").append(project.getName());
            buffer.append(" (");
            int numberOfErrors = reporter.getMessagesByType(3).size();
            buffer.append(numberOfErrors).append(" error").append(numberOfErrors == 1 ? "" : "s");
            buffer.append(", ");
            int numberOfWarnings = reporter.getMessagesByType(2).size();
            buffer.append(numberOfWarnings).append(" warning").append(numberOfWarnings == 1 ? "" : "s");
            buffer.append(")");
            buffer.append("\n");
            Iterator errorIterator = reporter.getMessages().iterator();
            while (errorIterator.hasNext()) {
                String error = (String)errorIterator.next();
                buffer.append("  ").append(error).append("\n");
            }
        }
        if (buffer.length() > 0) {
            messages = "The following documentation problems were found:\n" + buffer.toString();
        }
        return messages;
    }

    protected abstract boolean approveProjectPackaging(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMessages(String messages, boolean hasErrors) throws IOException {
        block5: {
            block4: {
                if (this.output == null) break block4;
                FileWriter writer = null;
                try {
                    writer = new FileWriter(this.output);
                    writer.write(messages);
                    writer.flush();
                }
                catch (Throwable throwable) {
                    IOUtil.close(writer);
                    throw throwable;
                }
                IOUtil.close((Writer)writer);
                break block5;
            }
            if (hasErrors) {
                this.getLog().error((CharSequence)messages);
            } else {
                this.getLog().info((CharSequence)messages);
            }
        }
    }

    private void checkProject(MavenProject project, DocumentationReporter reporter) {
        this.checkPomRequirements(project, reporter);
        this.checkPackagingSpecificDocumentation(project, reporter);
    }

    private void checkPomRequirements(MavenProject project, DocumentationReporter reporter) {
        this.checkProjectLicenses(project, reporter);
        if (StringUtils.isEmpty((String)project.getName())) {
            reporter.error("pom.xml is missing the <name> tag.");
        }
        if (StringUtils.isEmpty((String)project.getDescription())) {
            reporter.error("pom.xml is missing the <description> tag.");
        }
        if (StringUtils.isEmpty((String)project.getUrl())) {
            reporter.error("pom.xml is missing the <url> tag.");
        } else {
            this.checkURL(project.getUrl(), "project site", reporter);
        }
        if (project.getIssueManagement() == null) {
            reporter.error("pom.xml is missing the <issueManagement> tag.");
        } else {
            IssueManagement issueMngt = project.getIssueManagement();
            if (StringUtils.isEmpty((String)issueMngt.getUrl())) {
                reporter.error("pom.xml is missing the <url> tag in <issueManagement>.");
            } else {
                this.checkURL(issueMngt.getUrl(), "Issue Management", reporter);
            }
        }
        if (project.getPrerequisites() == null) {
            reporter.error("pom.xml is missing the <prerequisites> tag.");
        } else {
            Prerequisites prereq = project.getPrerequisites();
            if (StringUtils.isEmpty((String)prereq.getMaven())) {
                reporter.error("pom.xml is missing the <prerequisites>/<maven> tag.");
            }
        }
        if (StringUtils.isEmpty((String)project.getInceptionYear())) {
            reporter.error("pom.xml is missing the <inceptionYear> tag.");
        }
        if (project.getMailingLists().size() == 0) {
            reporter.warn("pom.xml has no <mailingLists>/<mailingList> specified.");
        }
        if (project.getScm() == null) {
            reporter.warn("pom.xml is missing the <scm> tag.");
        } else {
            Scm scm = project.getScm();
            if (StringUtils.isEmpty((String)scm.getConnection()) && StringUtils.isEmpty((String)scm.getDeveloperConnection()) && StringUtils.isEmpty((String)scm.getUrl())) {
                reporter.warn("pom.xml is missing the child tags under the <scm> tag.");
            } else if (scm.getUrl() != null) {
                this.checkURL(scm.getUrl(), "scm", reporter);
            }
        }
        if (project.getOrganization() == null) {
            reporter.error("pom.xml is missing the <organization> tag.");
        } else {
            Organization org = project.getOrganization();
            if (StringUtils.isEmpty((String)org.getName())) {
                reporter.error("pom.xml is missing the <organization>/<name> tag.");
            } else if (org.getUrl() != null) {
                this.checkURL(org.getUrl(), org.getName() + " site", reporter);
            }
        }
    }

    private void checkProjectLicenses(MavenProject project, DocumentationReporter reporter) {
        List licenses = project.getLicenses();
        if (licenses == null || licenses.isEmpty()) {
            reporter.error("pom.xml has no <licenses>/<license> specified.");
        } else {
            Iterator it = licenses.iterator();
            while (it.hasNext()) {
                License license = (License)it.next();
                if (StringUtils.isEmpty((String)license.getName())) {
                    reporter.error("pom.xml is missing the <licenses>/<license>/<name> tag.");
                    continue;
                }
                String url = license.getUrl();
                if (StringUtils.isEmpty((String)url)) {
                    reporter.error("pom.xml is missing the <licenses>/<license>/<url> tag for the license '" + license.getName() + "'.");
                    continue;
                }
                this.checkURL(url, "license '" + license.getName() + "'", reporter);
            }
        }
    }

    private String getURLProtocol(String url) throws MalformedURLException {
        URL licenseUrl = new URL(url);
        String protocol = licenseUrl.getProtocol();
        if (protocol != null) {
            protocol = protocol.toLowerCase();
        }
        return protocol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkURL(String url, String description, DocumentationReporter reporter) {
        block13: {
            try {
                String protocol = this.getURLProtocol(url);
                if (protocol.startsWith("http")) {
                    if (this.offline) {
                        reporter.warn("Cannot verify " + description + " in offline mode with URL: '" + url + "'.");
                        break block13;
                    }
                    if (this.validUrls.contains(url)) break block13;
                    HeadMethod headMethod = new HeadMethod(url);
                    headMethod.setFollowRedirects(true);
                    headMethod.setDoAuthentication(false);
                    try {
                        this.getLog().debug((CharSequence)("Verifying http url: " + url));
                        if (this.httpClient.executeMethod((HttpMethod)headMethod) != 200) {
                            reporter.error("Cannot reach " + description + " with URL: '" + url + "'.");
                        } else {
                            this.validUrls.add(url);
                        }
                        break block13;
                    }
                    catch (HttpException e) {
                        reporter.error("Cannot reach " + description + " with URL: '" + url + "'.\nError: " + e.getMessage());
                        break block13;
                    }
                    catch (IOException e) {
                        reporter.error("Cannot reach " + description + " with URL: '" + url + "'.\nError: " + e.getMessage());
                        break block13;
                    }
                    finally {
                        headMethod.releaseConnection();
                    }
                }
                reporter.warn("Non-HTTP " + description + " URL not verified.");
            }
            catch (MalformedURLException e) {
                reporter.warn("The " + description + " appears to have an invalid URL '" + url + "'." + " Message: '" + e.getMessage() + "'. Trying to access it as a file instead.");
                this.checkFile(url, description, reporter);
            }
        }
    }

    private void checkFile(String url, String description, DocumentationReporter reporter) {
        File licenseFile = new File(url);
        if (!licenseFile.exists()) {
            reporter.error("The " + description + " in file '" + licenseFile.getPath() + "' does not exist.");
        }
    }

    protected abstract void checkPackagingSpecificDocumentation(MavenProject var1, DocumentationReporter var2);

    protected boolean findFiles(File siteDirectory, String pattern) {
        FileSet fs = new FileSet();
        fs.setDirectory(siteDirectory.getAbsolutePath());
        fs.setFollowSymlinks(false);
        fs.addInclude("apt/" + pattern + ".apt");
        fs.addInclude("apt/" + pattern + ".apt.vm");
        fs.addInclude("xdoc/" + pattern + ".xml");
        fs.addInclude("xdoc/" + pattern + ".xml.vm");
        fs.addInclude("fml/" + pattern + ".fml");
        fs.addInclude("fml/" + pattern + ".fml.vm");
        fs.addInclude("resources/" + pattern + ".html");
        fs.addInclude("resources/" + pattern + ".html.vm");
        String[] includedFiles = this.fileSetManager.getIncludedFiles(fs);
        return includedFiles != null && includedFiles.length > 0;
    }
}

