/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.eclipse.writers.rad;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.eclipse.Messages;
import org.apache.maven.plugin.eclipse.writers.AbstractEclipseWriter;
import org.apache.maven.plugin.ide.JeeUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;

public class RadJ2EEWriter
extends AbstractEclipseWriter {
    private static final String J2EE_FILENAME = ".j2ee";
    private static final String J2EE_J2EESETTINGS = "j2eesettings";
    private static final String J2EE_MODULEVERSION = "moduleversion";
    private static final String J2EE_VERSION = "version";

    public void write() throws MojoExecutionException {
        String packaging = this.config.getProject().getPackaging();
        if ("war".equalsIgnoreCase(packaging) || "ejb".equalsIgnoreCase(packaging) || "ear".equalsIgnoreCase(packaging)) {
            FileWriter w;
            try {
                w = new FileWriter(new File(this.config.getEclipseProjectDirectory(), J2EE_FILENAME));
            }
            catch (IOException ex) {
                throw new MojoExecutionException(Messages.getString("EclipsePlugin.erroropeningfile"), (Exception)ex);
            }
            PrettyPrintXMLWriter writer = new PrettyPrintXMLWriter((Writer)w, "UTF-8", null);
            this.writeModuleTypeFacetCore((XMLWriter)writer, packaging);
            IOUtil.close((Writer)w);
        }
    }

    private void writeModuleTypeFacetCore(XMLWriter writer, String packaging) {
        writer.startElement(J2EE_J2EESETTINGS);
        writer.addAttribute(J2EE_VERSION, "600");
        writer.startElement(J2EE_MODULEVERSION);
        if ("war".equalsIgnoreCase(packaging)) {
            String servletVersion = JeeUtils.resolveServletVersion(this.config.getProject());
            writer.writeText("" + servletVersion.charAt(0) + servletVersion.charAt(2));
        } else if ("ejb".equalsIgnoreCase(packaging)) {
            String ejbVersion = JeeUtils.resolveEjbVersion(this.config.getProject());
            writer.writeText("" + ejbVersion.charAt(0) + ejbVersion.charAt(2));
        } else if ("ear".equalsIgnoreCase(packaging)) {
            String jeeVersion = JeeUtils.resolveJeeVersion(this.config.getProject());
            writer.writeText("" + jeeVersion.charAt(0) + jeeVersion.charAt(2));
        }
        writer.endElement();
        writer.endElement();
    }
}

