/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.osgi;

import aQute.lib.osgi.Analyzer;
import aQute.lib.osgi.Jar;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NuxeoAnalyzer
extends Analyzer {
    private static final Attributes.Name bUNDLEVENDORNAME = new Attributes.Name("Bundle-Vendor");
    private static final Attributes.Name nUXEOREQUIRENAME = new Attributes.Name("Nuxeo-Require");
    private static final Attributes.Name rEQUIREBUNDLENAME = new Attributes.Name("Require-Bundle");
    private static final Attributes.Name eXPORTPACKAGENAME = new Attributes.Name("Export-Package");
    private static final Attributes.Name iMPORTPACKAGENAME = new Attributes.Name("Export-Package");

    public void addExportsVersion() throws Exception {
        Manifest manifest = this.dot.getManifest();
        Attributes main = manifest.getMainAttributes();
        String version = this.getReplacer().process(main.getValue("Bundle-Version"));
        for (Map directives : this.exports.values()) {
            directives.put("version", version);
        }
        String clauses = NuxeoAnalyzer.printClauses((Map)this.exports, (String)"version:|uses:|include:|exclude:|mandatory:|-import:", (boolean)true);
        main.putValue("Export-Package", clauses);
    }

    public Map analyzeBundleClasspath() throws IOException {
        String bundleVersion = this.getProperty("Bundle-Version");
        Iterator it = this.contained.entrySet().iterator();
        while (it.hasNext()) {
            Map values;
            Map.Entry entry = it.next();
            String packageName = (String)entry.getKey();
            if (packageName.startsWith("META-INF.")) {
                it.remove();
            }
            if (bundleVersion == null || (values = (Map)entry.getValue()).get("version") != null) continue;
            values.put("version", bundleVersion);
        }
        return null;
    }

    public List<String> inventoryPackagesFromContent(Jar bundle) {
        ArrayList<String> pkgs = new ArrayList<String>();
        Map map = bundle.getDirectories();
        for (String directory : map.keySet()) {
            if (directory.equals("META-INF") || directory.startsWith("META-INF/") || directory.equals("OSGI-INF") || directory.startsWith("OSGI-INF/") || directory.equals("OSGI-OPT") || directory.startsWith("OSGI-OPT/") || directory.equals("/")) continue;
            if (directory.endsWith("/")) {
                directory = directory.substring(0, directory.length() - 1);
            }
            pkgs.add(directory.replace('/', '.'));
        }
        return pkgs;
    }

    public String calculateExportsFromContents(Jar bundle) {
        String ddel = "";
        StringBuffer sb = new StringBuffer();
        for (String pkg : this.inventoryPackagesFromContent(bundle)) {
            sb.append(ddel);
            sb.append(pkg);
            ddel = ",";
        }
        return sb.toString();
    }

    Map<String, Map<String, String>> addExportsToImports(Map<String, Map<String, String>> exports) {
        return NuxeoAnalyzer.newHashMap();
    }

    public void mergeManifest(Manifest manifest) throws IOException {
        Attributes attributes = manifest.getMainAttributes();
        if (this.isNuxeo(attributes)) {
            this.filterAttributes(attributes);
        }
        super.mergeManifest(manifest);
    }

    protected boolean isNuxeo(Attributes attributes) throws IOException {
        String vendor;
        return !attributes.containsKey(bUNDLEVENDORNAME) || (vendor = attributes.getValue(bUNDLEVENDORNAME)).toLowerCase().contains("nuxeo");
    }

    protected void filterAttributes(Attributes attributes) {
        if (attributes.containsKey(rEQUIREBUNDLENAME)) {
            attributes.put(nUXEOREQUIRENAME, attributes.get(rEQUIREBUNDLENAME));
            attributes.remove(rEQUIREBUNDLENAME);
        }
        if (attributes.containsKey(eXPORTPACKAGENAME)) {
            attributes.remove(eXPORTPACKAGENAME);
        }
        if (attributes.containsKey(iMPORTPACKAGENAME)) {
            attributes.remove(iMPORTPACKAGENAME);
        }
    }

    void merge(Manifest result, Manifest old) throws IOException {
        Attributes oldAttributes = old.getMainAttributes();
        if (this.isNuxeo(oldAttributes)) {
            this.filterAttributes(oldAttributes);
        }
        super.merge(result, old);
    }
}

