/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.eclipse;

import aQute.lib.osgi.Analyzer;
import aQute.lib.osgi.Builder;
import aQute.lib.osgi.Jar;
import aQute.lib.osgi.NuxeoAnalyzer;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.eclipse.writers.EclipseWriterConfig;
import org.apache.maven.plugin.ide.IdeDependency;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.shared.osgi.Maven2OsgiConverter;

public class OSGIfier {
    Log log;
    File ws;
    File dir;
    MavenProjectBuilder builder;
    Maven2OsgiConverter converter;
    File defaultDirectives;

    public OSGIfier(Log log, File dir, MavenProjectBuilder builder, Maven2OsgiConverter converter) {
        this.dir = dir;
        this.log = log;
        this.builder = builder;
        this.converter = converter;
    }

    public static File getDirectives(File dir, String filename) {
        File[] files;
        if (dir == null) {
            return null;
        }
        try {
            files = dir.listFiles((FileFilter)new NameFileFilter(filename));
        }
        catch (Throwable e) {
            throw new Error("Cannot list bndl dir " + dir.getPath(), e);
        }
        if (files == null || files.length == 0) {
            return OSGIfier.getDirectives(dir.getParentFile(), filename);
        }
        return files[0];
    }

    public File getDirectives(String filename) {
        return OSGIfier.getDirectives(this.dir, filename);
    }

    public File getDirectives(Artifact artifact) {
        return OSGIfier.getDirectives(this.dir, this.converter.getBundleFileName(artifact).replace(".jar", ".bnd"));
    }

    public void addDirectives(NuxeoAnalyzer analyzer, Artifact artifact, boolean optionalResolution) throws IOException {
        analyzer.setPedantic(true);
        Jar dot = analyzer.getJar();
        analyzer.setProperty("Import-Package", "*");
        if (!dot.getManifest().getMainAttributes().containsKey(new Attributes.Name("Bundle-SymbolicName"))) {
            analyzer.setProperty("Bundle-SymbolicName", this.converter.getBundleSymbolicName(artifact) + ";singleton:=true");
        }
        analyzer.setProperty("Export-Package", analyzer.calculateExportsFromContents(dot));
        analyzer.setProperty("Bundle-ClassPath", ".");
        analyzer.setProperty("Bundle-ActivationPolicy", "lazy");
        analyzer.setProperty("Bundle-Version", analyzer.getReplacer().process(this.converter.getVersion(artifact.getBaseVersion())));
        analyzer.setProperty("Bundle-RequiredExecutionEnvironment", "JavaSE-1.6");
        this.addDirectives(analyzer, this.getDirectives("default.bnd"));
        this.addDirectives(analyzer, this.getDirectives(artifact));
    }

    public void addDirectives(Analyzer analyzer, File file) {
        if (file == null) {
            return;
        }
        try {
            analyzer.addProperties(file);
        }
        catch (Exception e) {
            throw new Error("Cannot load directives from " + file.getPath(), e);
        }
        this.log.info((CharSequence)("Added directives  " + file.getPath()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void osgify(Artifact artifact) throws Exception {
        NuxeoAnalyzer analyzer = new NuxeoAnalyzer();
        try {
            analyzer.setJar(artifact.getFile());
            this.addDirectives(analyzer, this.defaultDirectives);
            this.addDirectives(analyzer, artifact, true);
            Jar dot = analyzer.getJar();
            analyzer.mergeManifest(dot.getManifest());
            String version = analyzer.getProperty("Bundle-Version");
            if (version != null) {
                version = Builder.cleanupVersion((String)version);
                analyzer.setProperty("Bundle-Version", version);
            }
            analyzer.calcManifest();
            analyzer.addExportsVersion();
            Jar jar = analyzer.getJar();
            File output = File.createTempFile("maven-bundle-", ".jar");
            output.deleteOnExit();
            jar.write(output);
            jar.close();
            artifact.setFile(output);
        }
        finally {
            analyzer.close();
        }
    }

    protected File[] getClasspath(EclipseWriterConfig config) {
        IdeDependency[] deps = config.getDeps();
        ArrayList<File> cp = new ArrayList<File>(deps.length);
        for (int i = 0; i < deps.length; ++i) {
            IdeDependency dep = deps[i];
            File file = dep.getFile();
            if (file == null) {
                this.log.warn((CharSequence)("No file given for " + dep));
                continue;
            }
            cp.add(file);
        }
        return cp.toArray(new File[cp.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void osgify(EclipseWriterConfig config) throws Exception {
        String version;
        File template;
        NuxeoAnalyzer analyzer = new NuxeoAnalyzer();
        MavenProject project = config.getProject();
        analyzer.setJar(new File(project.getBuild().getOutputDirectory()));
        analyzer.setClasspath(this.getClasspath(config));
        this.addDirectives(analyzer, project.getArtifact(), false);
        if (config.isPde() && (template = new File(config.getEclipseProjectDirectory().getPath() + "/src/main/resources/META-INF/MANIFEST.MF")).exists()) {
            FileInputStream is = new FileInputStream(template);
            analyzer.mergeManifest(new Manifest(is));
        }
        if ((version = analyzer.getProperty("Bundle-Version")) != null) {
            version = Builder.cleanupVersion((String)version);
            analyzer.setProperty("Bundle-Version", version);
        }
        try {
            Manifest manifest = analyzer.calcManifest();
            analyzer.addExportsVersion();
            File file = config.getManifest();
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            manifest.write(new FileOutputStream(config.getManifest()));
        }
        finally {
            analyzer.close();
        }
    }

    public boolean accept(Artifact artifact, Attributes attributes) {
        if (this.getDirectives(artifact) != null) {
            return true;
        }
        String bundleName = attributes.getValue("Bundle-Name");
        String symbolicName = attributes.getValue("Bundle-SymbolicName");
        return symbolicName == null || bundleName != null;
    }
}

