/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.ide;

import java.util.HashMap;
import java.util.Map;
import org.apache.maven.plugin.ide.IdeUtils;
import org.apache.maven.plugin.ide.JeeDescriptor;
import org.apache.maven.project.MavenProject;

public class JeeUtils {
    public static final String ARTIFACT_MAVEN_EAR_PLUGIN = "org.apache.maven.plugins:maven-ear-plugin";
    public static final String ARTIFACT_MAVEN_WAR_PLUGIN = "org.apache.maven.plugins:maven-war-plugin";
    private static final Map ejbMap = new HashMap();
    private static final Map jeeMap = new HashMap();
    private static final Map jspMap = new HashMap();
    private static final Map servletMap = new HashMap();

    public static final JeeDescriptor getJeeDescriptorFromEjbVersion(String ejbVersion) {
        if (ejbMap.containsKey(ejbVersion)) {
            return (JeeDescriptor)ejbMap.get(ejbVersion);
        }
        return null;
    }

    public static final JeeDescriptor getJeeDescriptorFromJeeVersion(String jeeVersion) {
        if (jeeMap.containsKey(jeeVersion)) {
            return (JeeDescriptor)jeeMap.get(jeeVersion);
        }
        return null;
    }

    public static final JeeDescriptor getJeeDescriptorFromJspVersion(String jspVersion) {
        if (jspMap.containsKey(jspVersion)) {
            return (JeeDescriptor)jspMap.get(jspVersion);
        }
        return null;
    }

    public static final JeeDescriptor getJeeDescriptorFromServletVersion(String servletVersion) {
        if (servletMap.containsKey(servletVersion)) {
            return (JeeDescriptor)servletMap.get(servletVersion);
        }
        return null;
    }

    public static String resolveEjbVersion(MavenProject project) {
        JeeDescriptor descriptor;
        String version = JeeUtils.findEjbVersionInDependencies(project);
        if (version == null && (descriptor = JeeUtils.getJeeDescriptorFromJeeVersion(JeeUtils.findJeeVersionInDependencies(project))) != null) {
            version = descriptor.getEjbVersion();
        }
        return version == null ? "2.1" : version;
    }

    public static String resolveJeeVersion(MavenProject project) {
        JeeDescriptor descriptor;
        String version = JeeUtils.findJeeVersionInDependencies(project);
        if (version == null && (descriptor = JeeUtils.getJeeDescriptorFromEjbVersion(JeeUtils.findEjbVersionInDependencies(project))) != null) {
            version = descriptor.getJeeVersion();
        }
        if (version == null && (descriptor = JeeUtils.getJeeDescriptorFromServletVersion(JeeUtils.findServletVersionInDependencies(project))) != null) {
            version = descriptor.getJeeVersion();
        }
        if (version == null && (descriptor = JeeUtils.getJeeDescriptorFromJspVersion(JeeUtils.findJspVersionInDependencies(project))) != null) {
            version = descriptor.getJeeVersion();
        }
        return version == null ? "1.4" : version;
    }

    public static String resolveJspVersion(MavenProject project) {
        JeeDescriptor descriptor;
        String version = JeeUtils.findJspVersionInDependencies(project);
        if (version == null && (descriptor = JeeUtils.getJeeDescriptorFromJeeVersion(JeeUtils.findJeeVersionInDependencies(project))) != null) {
            version = descriptor.getJspVersion();
        }
        if (version == null && (descriptor = JeeUtils.getJeeDescriptorFromServletVersion(JeeUtils.findServletVersionInDependencies(project))) != null) {
            version = descriptor.getJspVersion();
        }
        return version == null ? "2.0" : version;
    }

    public static String resolveServletVersion(MavenProject project) {
        JeeDescriptor descriptor;
        String version = JeeUtils.findServletVersionInDependencies(project);
        if (version == null && (descriptor = JeeUtils.getJeeDescriptorFromJeeVersion(JeeUtils.findJeeVersionInDependencies(project))) != null) {
            version = descriptor.getServletVersion();
        }
        return version == null ? "2.4" : version;
    }

    private static void addJEE(String jeeVersion, String ejbVersion, String servletVersion, String jspVersion) {
        JeeDescriptor descriptor = new JeeDescriptor(jeeVersion, ejbVersion, servletVersion, jspVersion);
        jeeMap.put(jeeVersion, descriptor);
        ejbMap.put(ejbVersion, descriptor);
        servletMap.put(servletVersion, descriptor);
        jspMap.put(jspVersion, descriptor);
    }

    private static String findEjbVersionInDependencies(MavenProject project) {
        String version = IdeUtils.getArtifactVersion(new String[]{"ejb", "ejb-api", "geronimo-spec-ejb"}, project.getDependencies(), 3);
        if (version == null && IdeUtils.getArtifactVersion(new String[]{"geronimo-ejb_2.1_spec"}, project.getDependencies(), 3) != null) {
            return "2.1";
        }
        if (version == null && IdeUtils.getArtifactVersion(new String[]{"geronimo-ejb_3.0_spec"}, project.getDependencies(), 3) != null) {
            return "3.0";
        }
        if (version == null) {
            for (Object key : project.getProjectReferences().keySet()) {
                MavenProject refProject = (MavenProject)project.getProjectReferences().get(key);
                version = JeeUtils.findEjbVersionInDependencies(refProject);
                if (version == null) continue;
                break;
            }
        }
        return version;
    }

    private static String findJeeVersionInDependencies(MavenProject project) {
        String version = IdeUtils.getArtifactVersion(new String[]{"javaee-api", "j2ee", "geronimo-spec-j2ee"}, project.getDependencies(), 3);
        if (version == null && IdeUtils.getArtifactVersion(new String[]{"geronimo-j2ee_1.4_spec"}, project.getDependencies(), 3) != null) {
            return "1.4";
        }
        if (version == null) {
            for (Object key : project.getProjectReferences().keySet()) {
                MavenProject refProject = (MavenProject)project.getProjectReferences().get(key);
                version = JeeUtils.findJeeVersionInDependencies(refProject);
                if (version == null) continue;
                break;
            }
        }
        return version;
    }

    private static String findJspVersionInDependencies(MavenProject project) {
        return null;
    }

    private static String findServletVersionInDependencies(MavenProject project) {
        String version = IdeUtils.getArtifactVersion(new String[]{"servlet-api", "servletapi", "geronimo-spec-servlet"}, project.getDependencies(), 3);
        if (version == null && IdeUtils.getArtifactVersion(new String[]{"geronimo-servlet_2.4_spec"}, project.getDependencies(), 3) != null) {
            return "2.4";
        }
        if (version == null && IdeUtils.getArtifactVersion(new String[]{"geronimo-servlet_2.5_spec"}, project.getDependencies(), 3) != null) {
            return "2.5";
        }
        if (version == null) {
            for (Object key : project.getProjectReferences().keySet()) {
                MavenProject refProject = (MavenProject)project.getProjectReferences().get(key);
                version = JeeUtils.findServletVersionInDependencies(refProject);
                if (version == null) continue;
                break;
            }
        }
        return version;
    }

    static {
        JeeUtils.addJEE("5.0", "3.0", "2.5", "2.1");
        JeeUtils.addJEE("1.4", "2.1", "2.4", "2.0");
        JeeUtils.addJEE("1.3", "2.0", "2.3", "1.2");
        JeeUtils.addJEE("1.2", "1.1", "2.2", "1.1");
    }
}

