package org.apache.maven.plugins.help;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/**
 * Display help information on maven-help-plugin.<br/> Call <pre>  mvn help:help -Ddetail=true -Dgoal=&lt;goal-name&gt;</pre> to display parameter details.
 *
 * @version generated on Tue Mar 23 13:13:08 EST 2010
 * @author org.apache.maven.tools.plugin.generator.PluginHelpGenerator (version 2.5.1)
 * @goal help
 * @requiresProject false
 */
public class HelpMojo
    extends AbstractMojo
{
    /**
     * If <code>true</code>, display all settable properties for each goal.
     * 
     * @parameter expression="${detail}" default-value="false"
     */
    private boolean detail;

    /**
     * The name of the goal for which to show help. If unspecified, all goals will be displayed.
     * 
     * @parameter expression="${goal}"
     */
    private java.lang.String goal;

    /**
     * The maximum length of a display line, should be positive.
     * 
     * @parameter expression="${lineLength}" default-value="80"
     */
    private int lineLength;

    /**
     * The number of spaces per indentation level, should be positive.
     * 
     * @parameter expression="${indentSize}" default-value="2"
     */
    private int indentSize;


    /** {@inheritDoc} */
    public void execute()
        throws MojoExecutionException
    {
        if ( lineLength <= 0 )
        {
            getLog().warn( "The parameter 'lineLength' should be positive, using '80' as default." );
            lineLength = 80;
        }
        if ( indentSize <= 0 )
        {
            getLog().warn( "The parameter 'indentSize' should be positive, using '2' as default." );
            indentSize = 2;
        }

        StringBuffer sb = new StringBuffer();

        append( sb, "org.apache.maven.plugins:maven-help-plugin:2.1.1", 0 );
        append( sb, "", 0 );

        append( sb, "Maven Help Plugin", 0 );
        append( sb, "The Maven Help plugin provides goals aimed at helping to make sense out of the build environment. It includes the ability to view the effective POM and settings files, after inheritance and active profiles have been applied, as well as a describe a particular plugin goal to give usage information.", 1 );
        append( sb, "", 0 );

        if ( goal == null || goal.length() <= 0 )
        {
            append( sb, "This plugin has 9 goals:", 0 );
            append( sb, "", 0 );
        }

        if ( goal == null || goal.length() <= 0 || "active-profiles".equals( goal ) )
        {
            append( sb, "help:active-profiles", 0 );
            append( sb, "Displays a list of the profiles which are currently active for this build.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "output", 2 );
                append( sb, "Optional parameter to write the output of this help in a given file, instead of writing to the console.\nNote: Could be a relative path.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "all-profiles".equals( goal ) )
        {
            append( sb, "help:all-profiles", 0 );
            append( sb, "Displays a list of available profiles under the current project.\nNote: it will list all profiles for a project. If a profile comes up with a status inactive then there might be a need to set profile activation switches/property.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "output", 2 );
                append( sb, "Optional parameter to write the output of this help in a given file, instead of writing to the console.\nNote: Could be a relative path.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "describe".equals( goal ) )
        {
            append( sb, "help:describe", 0 );
            append( sb, "Displays a list of the attributes for a Maven Plugin and/or goals (aka Mojo - Maven plain Old Java Object).", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "artifactId", 2 );
                append( sb, "The Maven Plugin artifactId to describe.\nNote: Should be used with groupId parameter.", 3 );
                append( sb, "", 0 );

                append( sb, "cmd", 2 );
                append( sb, "A Maven command like a single goal or a single phase following the Maven command line:\nmvn [options] [<goal(s)>] [<phase(s)>]", 3 );
                append( sb, "", 0 );

                append( sb, "detail (Default: false)", 2 );
                append( sb, "This flag specifies that a detailed (verbose) list of goal (Mojo) information should be given.", 3 );
                append( sb, "", 0 );

                append( sb, "goal", 2 );
                append( sb, "The goal name of a Mojo to describe within the specified Maven Plugin. If this parameter is specified, only the corresponding goal (Mojo) will be described, rather than the whole Plugin.", 3 );
                append( sb, "", 0 );

                append( sb, "groupId", 2 );
                append( sb, "The Maven Plugin groupId to describe.\nNote: Should be used with artifactId parameter.", 3 );
                append( sb, "", 0 );

                append( sb, "medium (Default: true)", 2 );
                append( sb, "This flag specifies that a medium list of goal (Mojo) information should be given.", 3 );
                append( sb, "", 0 );

                append( sb, "minimal (Default: false)", 2 );
                append( sb, "This flag specifies that a minimal list of goal (Mojo) information should be given.", 3 );
                append( sb, "", 0 );

                append( sb, "output", 2 );
                append( sb, "Optional parameter to write the output of this help in a given file, instead of writing to the console.\nNote: Could be a relative path.", 3 );
                append( sb, "", 0 );

                append( sb, "plugin", 2 );
                append( sb, "The Maven Plugin to describe. This must be specified in one of three ways:\n\n1.\tplugin-prefix, i.e. \'help\'\n2.\tgroupId:artifactId, i.e. \'org.apache.maven.plugins:maven-help-plugin\'\n3.\tgroupId:artifactId:version, i.e. \'org.apache.maven.plugins:maven-help-plugin:2.0\'\n", 3 );
                append( sb, "", 0 );

                append( sb, "version", 2 );
                append( sb, "The Maven Plugin version to describe.\nNote: Should be used with groupId/artifactId parameters.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "effective-pom".equals( goal ) )
        {
            append( sb, "help:effective-pom", 0 );
            append( sb, "Displays the effective POM as an XML for this build, with the active profiles factored in.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "output", 2 );
                append( sb, "Optional parameter to write the output of this help in a given file, instead of writing to the console.\nNote: Could be a relative path.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "effective-settings".equals( goal ) )
        {
            append( sb, "help:effective-settings", 0 );
            append( sb, "Displays the calculated settings as XML for this project, given any profile enhancement and the inheritance of the global settings into the user-level settings.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "output", 2 );
                append( sb, "Optional parameter to write the output of this help in a given file, instead of writing to the console.\nNote: Could be a relative path.", 3 );
                append( sb, "", 0 );

                append( sb, "showPasswords (Default: false)", 2 );
                append( sb, "For security reasons, all passwords are hidden by default. Set this to true to show all passwords.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "evaluate".equals( goal ) )
        {
            append( sb, "help:evaluate", 0 );
            append( sb, "Evaluates Maven expressions given by the user in an interactive mode.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "artifact", 2 );
                append( sb, "An artifact for evaluating Maven expressions.\nNote: Should respect the Maven format, i.e. groupId:artifactId[:version][:classifier].", 3 );
                append( sb, "", 0 );

                append( sb, "expression", 2 );
                append( sb, "An expression to evaluate instead of prompting. Note that this must not include the surrounding ${...}.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "expressions".equals( goal ) )
        {
            append( sb, "help:expressions", 0 );
            append( sb, "Displays the supported Plugin expressions used by Maven.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "output", 2 );
                append( sb, "Optional parameter to write the output of this help in a given file, instead of writing to the console.\nNote: Could be a relative path.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "help".equals( goal ) )
        {
            append( sb, "help:help", 0 );
            append( sb, "Display help information on maven-help-plugin.\nCall\n\u00a0\u00a0mvn\u00a0help:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "detail (Default: false)", 2 );
                append( sb, "If true, display all settable properties for each goal.", 3 );
                append( sb, "", 0 );

                append( sb, "goal", 2 );
                append( sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3 );
                append( sb, "", 0 );

                append( sb, "indentSize (Default: 2)", 2 );
                append( sb, "The number of spaces per indentation level, should be positive.", 3 );
                append( sb, "", 0 );

                append( sb, "lineLength (Default: 80)", 2 );
                append( sb, "The maximum length of a display line, should be positive.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "system".equals( goal ) )
        {
            append( sb, "help:system", 0 );
            append( sb, "Displays a list of the platform details like system properties and environment variables.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "output", 2 );
                append( sb, "Optional parameter to write the output of this help in a given file, instead of writing to the console.\nNote: Could be a relative path.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( getLog().isInfoEnabled() )
        {
            getLog().info( sb.toString() );
        }
    }

    /**
     * <p>Repeat a String <code>n</code> times to form a new string.</p>
     *
     * @param str String to repeat
     * @param repeat number of times to repeat str
     * @return String with repeated String
     * @throws NegativeArraySizeException if <code>repeat < 0</code>
     * @throws NullPointerException if str is <code>null</code>
     */
    private static String repeat( String str, int repeat )
    {
        StringBuffer buffer = new StringBuffer( repeat * str.length() );

        for ( int i = 0; i < repeat; i++ )
        {
            buffer.append( str );
        }

        return buffer.toString();
    }

    /** 
     * Append a description to the buffer by respecting the indentSize and lineLength parameters.
     * <b>Note</b>: The last character is always a new line.
     * 
     * @param sb The buffer to append the description, not <code>null</code>.
     * @param description The description, not <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     */
    private void append( StringBuffer sb, String description, int indent )
    {
        for ( Iterator it = toLines( description, indent, indentSize, lineLength ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( '\n' );
        }
    }

    /** 
     * Splits the specified text into lines of convenient display length.
     * 
     * @param text The text to split into lines, must not be <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     * @return The sequence of display lines, never <code>null</code>.
     * @throws NegativeArraySizeException if <code>indent < 0</code>
     */
    private static List toLines( String text, int indent, int indentSize, int lineLength )
    {
        List lines = new ArrayList();

        String ind = repeat( "\t", indent );
        String[] plainLines = text.split( "(\r\n)|(\r)|(\n)" );
        for ( int i = 0; i < plainLines.length; i++ )
        {
            toLines( lines, ind + plainLines[i], indentSize, lineLength );
        }

        return lines;
    }

    /** 
     * Adds the specified line to the output sequence, performing line wrapping if necessary.
     * 
     * @param lines The sequence of display lines, must not be <code>null</code>.
     * @param line The line to add, must not be <code>null</code>.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     */
    private static void toLines( List lines, String line, int indentSize, int lineLength )
    {
        int lineIndent = getIndentLevel( line );
        StringBuffer buf = new StringBuffer( 256 );
        String[] tokens = line.split( " +" );
        for ( int i = 0; i < tokens.length; i++ )
        {
            String token = tokens[i];
            if ( i > 0 )
            {
                if ( buf.length() + token.length() >= lineLength )
                {
                    lines.add( buf.toString() );
                    buf.setLength( 0 );
                    buf.append( repeat( " ", lineIndent * indentSize ) );
                }
                else
                {
                    buf.append( ' ' );
                }
            }
            for ( int j = 0; j < token.length(); j++ )
            {
                char c = token.charAt( j );
                if ( c == '\t' )
                {
                    buf.append( repeat( " ", indentSize - buf.length() % indentSize ) );
                }
                else if ( c == '\u00A0' )
                {
                    buf.append( ' ' );
                }
                else
                {
                    buf.append( c );
                }
            }
        }
        lines.add( buf.toString() );
    }

    /** 
     * Gets the indentation level of the specified line.
     * 
     * @param line The line whose indentation level should be retrieved, must not be <code>null</code>.
     * @return The indentation level of the line.
     */
    private static int getIndentLevel( String line )
    {
        int level = 0;
        for ( int i = 0; i < line.length() && line.charAt( i ) == '\t'; i++ )
        {
            level++;
        }
        for ( int i = level + 1; i <= level + 4 && i < line.length(); i++ )
        {
            if ( line.charAt( i ) == '\t' )
            {
                level++;
                break;
            }
        }
        return level;
    }
}
