/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.jlink;

import java.io.File;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.jlink.JLinkExecutor;
import org.apache.maven.project.MavenProject;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;

public abstract class AbstractJLinkMojo
extends AbstractMojo {
    @Parameter
    private Map<String, String> jdkToolchain;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Component
    private ToolchainManager toolchainManager;

    protected abstract String getClassifier();

    protected JLinkExecutor getJlinkExecutor() {
        return new JLinkExecutor(this.getToolchain().orElse(null), this.getLog());
    }

    protected Optional<Toolchain> getToolchain() {
        Toolchain tc = null;
        if (this.jdkToolchain != null) {
            try {
                Method getToolchainsMethod = this.toolchainManager.getClass().getMethod("getToolchains", MavenSession.class, String.class, Map.class);
                List tcs = (List)getToolchainsMethod.invoke((Object)this.toolchainManager, this.getSession(), "jdk", this.jdkToolchain);
                if (tcs != null && tcs.size() > 0) {
                    tc = (Toolchain)tcs.get(0);
                }
            }
            catch (IllegalArgumentException | ReflectiveOperationException | SecurityException exception) {
                // empty catch block
            }
        }
        if (tc == null) {
            tc = this.toolchainManager.getToolchainFromBuildContext("jdk", this.getSession());
        }
        return Optional.ofNullable(tc);
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected MavenSession getSession() {
        return this.session;
    }

    protected File getArchiveFile(File basedir, String finalName, String classifier, String archiveExt) {
        if (basedir == null) {
            throw new IllegalArgumentException("basedir is not allowed to be null");
        }
        if (finalName == null) {
            throw new IllegalArgumentException("finalName is not allowed to be null");
        }
        if (archiveExt == null) {
            throw new IllegalArgumentException("archiveExt is not allowed to be null");
        }
        if (finalName.isEmpty()) {
            throw new IllegalArgumentException("finalName is not allowed to be empty.");
        }
        if (archiveExt.isEmpty()) {
            throw new IllegalArgumentException("archiveExt is not allowed to be empty.");
        }
        StringBuilder fileName = new StringBuilder(finalName);
        if (this.hasClassifier(classifier)) {
            fileName.append("-").append(classifier);
        }
        fileName.append('.');
        fileName.append(archiveExt);
        return new File(basedir, fileName.toString());
    }

    protected boolean hasClassifier(String classifier) {
        boolean result = false;
        if (classifier != null && !classifier.isEmpty()) {
            result = true;
        }
        return result;
    }

    protected StringBuilder convertSeparatedModulePathToPlatformSeparatedModulePath(String pluginModulePath) {
        String[] splitModule;
        StringBuilder sb = new StringBuilder();
        for (String module : splitModule = pluginModulePath.split("[;:]")) {
            if (sb.length() > 0) {
                sb.append(File.pathSeparatorChar);
            }
            sb.append(module);
        }
        return sb;
    }

    protected String getPlatformDependSeparateList(Collection<String> modulePaths) {
        return String.join((CharSequence)Character.toString(File.pathSeparatorChar), modulePaths);
    }

    protected String getCommaSeparatedList(Collection<String> modules) {
        return String.join((CharSequence)",", modules);
    }
}

