package org.apache.maven.plugin.plugin;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/**
 * Display help information on maven-plugin-plugin. Call <pre>  mvn plugin:help -Ddetail=true -Dgoal=&lt;goal-name&gt;</pre> to display parameter details.
 *
 * @version generated on Thu Aug 14 07:41:39 EDT 2008
 * @goal help
 * @requiresProject false
 */
public class HelpMojo
    extends AbstractMojo
{
    /**
     * If <code>true</code>, display all settable properties for each goal.
     * 
     * @parameter expression="${detail}" default-value="false"
     */
    private boolean detail;

    /**
     * The name of the goal for which to show help. If unspecified, all goals will be displayed.
     * 
     * @parameter expression="${goal}"
     */
    private java.lang.String goal;

    /**
     * The maximum length of a display line.
     * 
     * @parameter expression="${lineLength}" default-value="80"
     */
    private int lineLength;

    /**
     * The number of spaces per indentation level.
     * 
     * @parameter expression="${indentSize}" default-value="2"
     */
    private int indentSize;


    /** {@inheritDoc} */
    public void execute()
        throws MojoExecutionException
    {
        StringBuffer sb = new StringBuffer();

        append( sb, "org.apache.maven.plugins:maven-plugin-plugin:2.4.3", 0 );
        append( sb, "", 0 );

        append( sb, "Maven Plugin Plugin 2.4.3", 0 );
        append( sb, "The Plugin Plugin is used to create a Maven plugin descriptor for any Mojo\'s found in the source tree, to include in the JAR. It is also used to generate Xdoc files for the Mojos as well as for updating the plugin registry, the artifact metadata and a generic help goal.", 1 );
        append( sb, "", 0 );

        if ( goal == null || goal.length() <= 0 )
        {
            append( sb, "This plugin has 7 goals:", 0 );
            append( sb, "", 0 );
        }

        if ( goal == null || goal.length() <= 0 || "addPluginArtifactMetadata".equals( goal ) )
        {
            append( sb, "plugin:addPluginArtifactMetadata", 0 );
            append( sb, "Inject any plugin-specific artifact metadata to the project\'s artifact, for subsequent installation and deployment. The first use-case for this is to add the LATEST metadata (which is plugin-specific) for shipping alongside the plugin\'s artifact.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "goalPrefix", 2 );
                append( sb, "The prefix for the plugin goal.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "descriptor".equals( goal ) )
        {
            append( sb, "plugin:descriptor", 0 );
            append( sb, "Generate a plugin descriptor.\nNote: Phase is after the \'compilation\' of any scripts.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "extractors", 2 );
                append( sb, "The names of extractors to use.\n>If not set, all extractors will be used. If set to an empty extractor name, no extractors will be used.\n\n>Example:\n\n>\n\n<!--\u00a0Use\u00a0all\u00a0extractors\u00a0-->\n<extractors/>\n<!--\u00a0Use\u00a0no\u00a0extractors\u00a0-->\n<extractors>\n<extractor/>\n</extractors>\n<!--\u00a0Use\u00a0only\u00a0bsh\u00a0extractor\u00a0-->\n<extractors>\n<extractor>bsh</extractor>\n</extractors>\n", 3 );
                append( sb, "", 0 );

                append( sb, "goalPrefix", 2 );
                append( sb, "The goal prefix that will appear before the \':\'.", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: ${project.build.outputDirectory}/META-INF/maven)", 2 );
                append( sb, "The directory where the generated plugin.xml file will be put.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "help".equals( goal ) )
        {
            append( sb, "plugin:help", 0 );
            append( sb, "Display help information on maven-plugin-plugin. Call\n\u00a0\u00a0mvn\u00a0plugin:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "detail (Default: false)", 2 );
                append( sb, "If true, display all settable properties for each goal.", 3 );
                append( sb, "", 0 );

                append( sb, "goal", 2 );
                append( sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3 );
                append( sb, "", 0 );

                append( sb, "lineLength (Default: 80)", 2 );
                append( sb, "The maximum length of a display line.", 3 );
                append( sb, "", 0 );

                append( sb, "indentSize (Default: 2)", 2 );
                append( sb, "The number of spaces per indentation level.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "helpmojo".equals( goal ) )
        {
            append( sb, "plugin:helpmojo", 0 );
            append( sb, "Generates a HelpMojo class.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "extractors", 2 );
                append( sb, "The names of extractors to use.\n>If not set, all extractors will be used. If set to an empty extractor name, no extractors will be used.\n\n>Example:\n\n>\n\n<!--\u00a0Use\u00a0all\u00a0extractors\u00a0-->\n<extractors/>\n<!--\u00a0Use\u00a0no\u00a0extractors\u00a0-->\n<extractors>\n<extractor/>\n</extractors>\n<!--\u00a0Use\u00a0only\u00a0bsh\u00a0extractor\u00a0-->\n<extractors>\n<extractor>bsh</extractor>\n</extractors>\n", 3 );
                append( sb, "", 0 );

                append( sb, "goalPrefix", 2 );
                append( sb, "The goal prefix that will appear before the \':\'.", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: ${project.build.directory}/generated-sources/plugin)", 2 );
                append( sb, "The directory where the generated HelpMojo file will be put.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "report".equals( goal ) )
        {
            append( sb, "plugin:report", 0 );
            append( sb, "Generates the Plugin\'s documentation report.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "goalPrefix", 2 );
                append( sb, "The goal prefix that will appear before the \':\'.", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: ${project.build.directory}/generated-site/xdoc)", 2 );
                append( sb, "Report output directory.", 3 );
                append( sb, "", 0 );

                append( sb, "requirements", 2 );
                append( sb, "Specify some requirements to execute this plugin. Example:\n<requirements>\n<maven>2.0</maven>\n<jdk>1.4</jdk>\n<memory>256m</memory>\n<diskSpace>1m</diskSpace>\n<others>\n<property>\n<name>SVN</name>\n<value>1.4.6</value>\n</property>\n</others>\n</requirements>\n", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "updateRegistry".equals( goal ) )
        {
            append( sb, "plugin:updateRegistry", 0 );
            append( sb, "Update the user plugin registry (if it\'s in use) to reflect the version we\'re installing.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "xdoc".equals( goal ) )
        {
            append( sb, "plugin:xdoc", 0 );
            append( sb, "Generate Xdoc files for the project mojos or goals.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "extractors", 2 );
                append( sb, "The names of extractors to use.\n>If not set, all extractors will be used. If set to an empty extractor name, no extractors will be used.\n\n>Example:\n\n>\n\n<!--\u00a0Use\u00a0all\u00a0extractors\u00a0-->\n<extractors/>\n<!--\u00a0Use\u00a0no\u00a0extractors\u00a0-->\n<extractors>\n<extractor/>\n</extractors>\n<!--\u00a0Use\u00a0only\u00a0bsh\u00a0extractor\u00a0-->\n<extractors>\n<extractor>bsh</extractor>\n</extractors>\n", 3 );
                append( sb, "", 0 );

                append( sb, "goalPrefix", 2 );
                append( sb, "The goal prefix that will appear before the \':\'.", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: ${project.build.directory}/generated-site/xdoc)", 2 );
                append( sb, "The directory where the generated Xdoc files will be put.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( getLog().isInfoEnabled() )
        {
            getLog().info( sb.toString() );
        }
    }

    /**
     * <p>Repeat a String <code>n</code> times to form a new string.</p>
     *
     * @param str String to repeat
     * @param repeat number of times to repeat str
     * @return String with repeated String
     * @throws NegativeArraySizeException if <code>repeat < 0</code>
     * @throws NullPointerException if str is <code>null</code>
     */
    private static String repeat( String str, int repeat )
    {
        StringBuffer buffer = new StringBuffer( repeat * str.length() );

        for ( int i = 0; i < repeat; i++ )
        {
            buffer.append( str );
        }

        return buffer.toString();
    }

    private void append( StringBuffer sb, String description, int indent )
    {
        for ( Iterator it = toLines( description, indent ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( '\n' );
        }
    }

    /** 
     * Splits the specified text into lines of convenient display length.
     * 
     * @param text The text to split into lines, must not be <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     * @return The sequence of display lines, never <code>null</code>.
     */
    private List toLines( String text, int indent )
    {
        List lines = new ArrayList();

        String ind = repeat( "\t", indent );
        String[] plainLines = text.split( "(\r\n)|(\r)|(\n)" );
        for ( int i = 0; i < plainLines.length; i++ )
        {
            toLines( lines, ind + plainLines[i] );
        }

        return lines;
    }

    /** 
     * Adds the specified line to the output sequence, performing line wrapping if necessary.
     * 
     * @param lines The sequence of display lines, must not be <code>null</code>.
     * @param line The line to add, must not be <code>null</code>.
     */
    private void toLines( List lines, String line )
    {
        int lineIndent = getIndentLevel( line );
        StringBuffer buf = new StringBuffer( 256 );
        String[] tokens = line.split( " +" );
        for ( int i = 0; i < tokens.length; i++ )
        {
            String token = tokens[i];
            if ( i > 0 )
            {
                if ( buf.length() + token.length() >= lineLength )
                {
                    lines.add( buf.toString() );
                    buf.setLength( 0 );
                    buf.append( repeat( " ", lineIndent * indentSize ) );
                }
                else
                {
                    buf.append( ' ' );
                }
            }
            for ( int j = 0; j < token.length(); j++ )
            {
                char c = token.charAt( j );
                if ( c == '\t' )
                {
                    buf.append( repeat( " ", indentSize - buf.length() % indentSize ) );
                }
                else if ( c == '\u00A0' )
                {
                    buf.append( ' ' );
                }
                else
                {
                    buf.append( c );
                }
            }
        }
        lines.add( buf.toString() );
    }

    /** 
     * Gets the indentation level of the specified line.
     * 
     * @param line The line whose indentation level should be retrieved, must not be <code>null</code>.
     * @return The indentation level of the line.
     */
    private static int getIndentLevel( String line )
    {
        int level = 0;
        for ( int i = 0; i < line.length() && line.charAt( i ) == '\t'; i++ )
        {
            level++;
        }
        for ( int i = level + 1; i <= level + 4 && i < line.length(); i++ )
        {
            if ( line.charAt( i ) == '\t' )
            {
                level++;
                break;
            }
        }
        return level;
    }
}
