/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.report.projectinfo;

import java.io.File;
import java.net.MalformedURLException;
import java.util.List;
import java.util.Locale;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.tools.SiteTool;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.Site;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.report.projectinfo.AbstractProjectInfoRenderer;
import org.apache.maven.report.projectinfo.AbstractProjectInfoReport;
import org.codehaus.plexus.i18n.I18N;

@Mojo(name="modules")
public class ModulesReport
extends AbstractProjectInfoReport {
    public boolean canGenerateReport() {
        boolean result = super.canGenerateReport();
        if (result && this.skipEmptyReport) {
            result = !this.isEmpty(this.getProject().getModel().getModules());
        }
        return result;
    }

    public void executeReport(Locale locale) {
        new ModulesRenderer(this.getSink(), this.getProject(), this.mavenProjectBuilder, this.localRepository, this.getI18N(locale), locale, this.siteTool).render();
    }

    public String getOutputName() {
        return "modules";
    }

    protected String getI18Nsection() {
        return "modules";
    }

    static class ModulesRenderer
    extends AbstractProjectInfoRenderer {
        protected MavenProject project;
        protected MavenProjectBuilder mavenProjectBuilder;
        protected ArtifactRepository localRepository;
        protected SiteTool siteTool;

        ModulesRenderer(Sink sink, MavenProject project, MavenProjectBuilder mavenProjectBuilder, ArtifactRepository localRepository, I18N i18n, Locale locale, SiteTool siteTool) {
            super(sink, i18n, locale);
            this.project = project;
            this.mavenProjectBuilder = mavenProjectBuilder;
            this.localRepository = localRepository;
            this.siteTool = siteTool;
        }

        protected String getI18Nsection() {
            return "modules";
        }

        public void renderBody() {
            List modules = this.project.getModel().getModules();
            if (modules == null || modules.isEmpty()) {
                this.startSection(this.getTitle());
                this.paragraph(this.getI18nString("nolist"));
                this.endSection();
                return;
            }
            this.startSection(this.getTitle());
            this.paragraph(this.getI18nString("intro"));
            this.startTable();
            String name = this.getI18nString("header.name");
            String description = this.getI18nString("header.description");
            this.tableHeader(new String[]{name, description});
            String baseUrl = ModulesRenderer.getDistMgmntSiteUrl(this.project);
            for (String module : modules) {
                Model moduleModel;
                File f = new File(this.project.getBasedir(), module + "/pom.xml");
                if (f.exists()) {
                    try {
                        moduleModel = this.mavenProjectBuilder.build(f, this.localRepository, null).getModel();
                    }
                    catch (ProjectBuildingException e) {
                        throw new IllegalStateException("Unable to read local module POM", e);
                    }
                } else {
                    moduleModel = new Model();
                    moduleModel.setName(module);
                    ModulesRenderer.setDistMgmntSiteUrl(moduleModel, module);
                }
                String moduleName = moduleModel.getName() == null ? moduleModel.getArtifactId() : moduleModel.getName();
                String moduleHref = this.getRelativeLink(baseUrl, ModulesRenderer.getDistMgmntSiteUrl(moduleModel), moduleModel.getArtifactId());
                this.tableRow(new String[]{this.linkedName(moduleName, moduleHref), moduleModel.getDescription()});
            }
            this.endTable();
            this.endSection();
        }

        private static void setDistMgmntSiteUrl(Model model, String url) {
            if (model.getDistributionManagement() == null) {
                model.setDistributionManagement(new DistributionManagement());
            }
            if (model.getDistributionManagement().getSite() == null) {
                model.getDistributionManagement().setSite(new Site());
            }
            model.getDistributionManagement().getSite().setUrl(url);
        }

        private static String getDistMgmntSiteUrl(MavenProject project) {
            return ModulesRenderer.getDistMgmntSiteUrl(project.getDistributionManagement());
        }

        private static String getDistMgmntSiteUrl(Model model) {
            return ModulesRenderer.getDistMgmntSiteUrl(model.getDistributionManagement());
        }

        private static String getDistMgmntSiteUrl(DistributionManagement distMgmnt) {
            if (distMgmnt != null && distMgmnt.getSite() != null && distMgmnt.getSite().getUrl() != null) {
                return ModulesRenderer.urlEncode(distMgmnt.getSite().getUrl());
            }
            return null;
        }

        private static String urlEncode(String url) {
            if (url == null) {
                return null;
            }
            try {
                return new File(url).toURI().toURL().toExternalForm();
            }
            catch (MalformedURLException ex) {
                return url;
            }
        }

        private String getRelativeLink(String baseUrl, String href, String defaultHref) {
            String selectedHref = href;
            if (selectedHref == null) {
                selectedHref = defaultHref;
            }
            if (baseUrl != null) {
                selectedHref = this.siteTool.getRelativePath(selectedHref, baseUrl);
            }
            selectedHref = selectedHref.endsWith("/") ? selectedHref.concat("index.html") : selectedHref.concat("/index.html");
            return selectedHref;
        }

        private String linkedName(String name, String link) {
            return "{" + name + ", ./" + link + "}";
        }
    }
}

