/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.report.projectinfo;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.report.projectinfo.AbstractProjectInfoRenderer;
import org.apache.maven.report.projectinfo.AbstractProjectInfoReport;
import org.apache.maven.report.projectinfo.ProjectInfoReportUtils;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.shared.artifact.filter.PatternExcludesArtifactFilter;
import org.codehaus.plexus.i18n.I18N;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="plugin-management", requiresDependencyResolution=ResolutionScope.TEST)
public class PluginManagementReport
extends AbstractProjectInfoReport {
    @Parameter
    private List<String> pluginManagementExcludes = null;

    public void executeReport(Locale locale) {
        PluginManagementRenderer r = new PluginManagementRenderer(this.getLog(), this.getSink(), locale, this.getI18N(locale), this.project.getPluginManagement().getPlugins(), this.project, this.projectBuilder, this.repositorySystem, this.getSession().getProjectBuildingRequest(), this.pluginManagementExcludes);
        r.render();
    }

    public String getOutputName() {
        return "plugin-management";
    }

    @Override
    protected String getI18Nsection() {
        return "plugin-management";
    }

    @Override
    public boolean canGenerateReport() {
        boolean result = super.canGenerateReport();
        if (result && this.skipEmptyReport) {
            result = this.getProject().getPluginManagement() != null && !this.isEmpty(this.project.getPluginManagement().getPlugins());
        }
        return result;
    }

    protected static class PluginManagementRenderer
    extends AbstractProjectInfoRenderer {
        private final Log log;
        private final List<Plugin> pluginManagement;
        private final MavenProject project;
        private final ProjectBuilder projectBuilder;
        private final RepositorySystem repositorySystem;
        private final ProjectBuildingRequest buildingRequest;
        private final PatternExcludesArtifactFilter patternExcludesArtifactFilter;

        public PluginManagementRenderer(Log log, Sink sink, Locale locale, I18N i18n, List<Plugin> plugins, MavenProject project, ProjectBuilder projectBuilder, RepositorySystem repositorySystem, ProjectBuildingRequest buildingRequest, List<String> excludes) {
            super(sink, i18n, locale);
            this.log = log;
            this.pluginManagement = plugins;
            this.project = project;
            this.projectBuilder = projectBuilder;
            this.repositorySystem = repositorySystem;
            this.buildingRequest = buildingRequest;
            this.patternExcludesArtifactFilter = new PatternExcludesArtifactFilter(excludes);
        }

        @Override
        protected String getI18Nsection() {
            return "plugin-management";
        }

        public void renderBody() {
            PluginManagement projectPluginManagement = this.project.getPluginManagement();
            if (projectPluginManagement == null || projectPluginManagement.getPlugins() == null || projectPluginManagement.getPlugins().isEmpty()) {
                this.startSection(this.getTitle());
                this.paragraph(this.getI18nString("nolist"));
                this.endSection();
                return;
            }
            this.renderSectionPluginManagement();
        }

        private void renderSectionPluginManagement() {
            String[] tableHeader = this.getPluginTableHeader();
            this.startSection(this.getTitle());
            Collections.sort(this.pluginManagement, this.getPluginComparator());
            this.startTable();
            this.tableHeader(tableHeader);
            DefaultProjectBuildingRequest buildRequest = new DefaultProjectBuildingRequest(this.buildingRequest);
            buildRequest.setRemoteRepositories(this.project.getPluginArtifactRepositories());
            buildRequest.setProcessPlugins(false);
            for (Plugin plugin : this.pluginManagement) {
                VersionRange versionRange = StringUtils.isEmpty((String)plugin.getVersion()) ? VersionRange.createFromVersion((String)"RELEASE") : VersionRange.createFromVersion((String)plugin.getVersion());
                Artifact pluginArtifact = this.repositorySystem.createProjectArtifact(plugin.getGroupId(), plugin.getArtifactId(), versionRange.toString());
                if (this.patternExcludesArtifactFilter.include(pluginArtifact)) {
                    try {
                        MavenProject pluginProject = this.projectBuilder.build(pluginArtifact, (ProjectBuildingRequest)buildRequest).getProject();
                        this.tableRow(this.getPluginRow(pluginProject.getGroupId(), pluginProject.getArtifactId(), pluginProject.getVersion(), pluginProject.getUrl()));
                    }
                    catch (ProjectBuildingException e) {
                        this.log.info((CharSequence)("Could not build project for " + plugin.getArtifactId()), (Throwable)e);
                        this.tableRow(this.getPluginRow(plugin.getGroupId(), plugin.getArtifactId(), plugin.getVersion(), null));
                    }
                    continue;
                }
                this.log.debug((CharSequence)("Excluding plugin " + pluginArtifact.getId() + " from report"));
            }
            this.endTable();
            this.endSection();
        }

        private String[] getPluginTableHeader() {
            String groupId = this.getI18nString("dependency-management", "column.groupId");
            String artifactId = this.getI18nString("dependency-management", "column.artifactId");
            String version = this.getI18nString("dependency-management", "column.version");
            return new String[]{groupId, artifactId, version};
        }

        private String[] getPluginRow(String groupId, String artifactId, String version, String link) {
            artifactId = ProjectInfoReportUtils.getArtifactIdCell(artifactId, link);
            return new String[]{groupId, artifactId, version};
        }

        private Comparator<Plugin> getPluginComparator() {
            return new Comparator<Plugin>(){

                @Override
                public int compare(Plugin a1, Plugin a2) {
                    int result = a1.getGroupId().compareTo(a2.getGroupId());
                    if (result == 0) {
                        result = a1.getArtifactId().compareTo(a2.getArtifactId());
                    }
                    return result;
                }
            };
        }
    }
}

