/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.shade.mojo;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.shade.Shader;
import org.apache.maven.plugins.shade.filter.SimpleFilter;
import org.apache.maven.plugins.shade.mojo.ArchiveFilter;
import org.apache.maven.plugins.shade.mojo.ArtifactSet;
import org.apache.maven.plugins.shade.mojo.PackageRelocation;
import org.apache.maven.plugins.shade.pom.PomWriter;
import org.apache.maven.plugins.shade.relocation.SimpleRelocator;
import org.apache.maven.plugins.shade.resource.ResourceTransformer;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.util.IOUtil;

public class ShadeMojo
extends AbstractMojo {
    private MavenProject project;
    private MavenProjectHelper projectHelper;
    private Shader shader;
    protected List remoteArtifactRepositories;
    protected ArtifactRepository localRepository;
    protected ArtifactFactory artifactFactory;
    protected ArtifactResolver artifactResolver;
    private ArtifactSet artifactSet;
    private PackageRelocation[] relocations;
    private ResourceTransformer[] transformers;
    private ArchiveFilter[] filters;
    private File outputDirectory;
    private String finalName;
    private String shadedArtifactId;
    private String shadedGroupFilter;
    private boolean shadedArtifactAttached;
    private boolean createDependencyReducedPom;
    private boolean keepDependenciesWithProvidedScope;
    private boolean promoteTransitiveDependencies;
    private String shadedClassifierName;
    private boolean createSourcesJar;

    public void execute() throws MojoExecutionException {
        File file;
        LinkedHashSet<File> artifacts = new LinkedHashSet<File>();
        LinkedHashSet<String> artifactIds = new LinkedHashSet<String>();
        LinkedHashSet<File> sourceArtifacts = new LinkedHashSet<File>();
        artifacts.add(this.project.getArtifact().getFile());
        if (this.createSourcesJar && (file = this.shadedSourcesArtifactFile()).exists()) {
            sourceArtifacts.add(file);
        }
        Iterator it = this.project.getArtifacts().iterator();
        while (it.hasNext()) {
            File file2;
            Artifact artifact = (Artifact)it.next();
            if (this.excludeArtifact(artifact)) {
                this.getLog().info((CharSequence)("Excluding " + artifact.getId() + " from the shaded jar."));
                continue;
            }
            this.getLog().info((CharSequence)("Including " + artifact.getId() + " in the shaded jar."));
            artifacts.add(artifact.getFile());
            artifactIds.add(this.getId(artifact));
            if (!this.createSourcesJar || (file2 = this.resolveArtifactSources(artifact)) == null) continue;
            sourceArtifacts.add(file2);
        }
        File outputJar = this.shadedArtifactFileWithClassifier();
        File sourcesJar = this.shadedSourceArtifactFileWithClassifier();
        try {
            List filters = this.getFilters();
            List relocators = this.getRelocators();
            List resourceTransformers = this.getResourceTrasformers();
            this.shader.shade(artifacts, outputJar, filters, relocators, resourceTransformers);
            if (this.createSourcesJar) {
                this.shader.shade(sourceArtifacts, sourcesJar, filters, relocators, resourceTransformers);
            }
            if (this.shadedArtifactAttached) {
                this.getLog().info((CharSequence)"Attaching shaded artifact.");
                this.projectHelper.attachArtifact(this.getProject(), "jar", this.shadedClassifierName, outputJar);
                if (this.createSourcesJar) {
                    this.projectHelper.attachArtifact(this.getProject(), "jar", this.shadedClassifierName + "-sources", sourcesJar);
                }
            } else {
                this.getLog().info((CharSequence)"Replacing original artifact with shaded artifact.");
                File file3 = this.shadedArtifactFile();
                this.replaceFile(file3, outputJar);
                if (this.createSourcesJar) {
                    file3 = this.shadedSourcesArtifactFile();
                    this.replaceFile(file3, sourcesJar);
                    this.projectHelper.attachArtifact(this.project, "jar", "sources", file3);
                }
                if (this.createDependencyReducedPom) {
                    this.createDependencyReducedPom(artifactIds);
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error creating shaded jar.", (Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceFile(File oldFile, File newFile) throws MojoExecutionException {
        FileInputStream fin;
        FileOutputStream fout;
        this.getLog().info((CharSequence)("Replacing " + oldFile + " with " + newFile));
        File origFile = new File(this.outputDirectory, "original-" + oldFile.getName());
        if (oldFile.exists() && !oldFile.renameTo(origFile)) {
            System.gc();
            System.gc();
            if (!oldFile.renameTo(origFile)) {
                try {
                    fout = new FileOutputStream(origFile);
                    fin = new FileInputStream(oldFile);
                    try {
                        IOUtil.copy((InputStream)fin, (OutputStream)fout);
                    }
                    finally {
                        IOUtil.close((InputStream)fin);
                        IOUtil.close((OutputStream)fout);
                    }
                }
                catch (IOException ex) {
                    this.getLog().warn((Throwable)ex);
                }
            }
        }
        if (!newFile.renameTo(oldFile)) {
            System.gc();
            System.gc();
            if (!newFile.renameTo(oldFile)) {
                try {
                    fout = new FileOutputStream(oldFile);
                    fin = new FileInputStream(newFile);
                    try {
                        IOUtil.copy((InputStream)fin, (OutputStream)fout);
                    }
                    finally {
                        IOUtil.close((InputStream)fin);
                        IOUtil.close((OutputStream)fout);
                    }
                }
                catch (IOException ex) {
                    throw new MojoExecutionException("Could not replace original artifact with shaded artifact!", (Exception)ex);
                }
            }
        }
    }

    private File resolveArtifactSources(Artifact artifact) {
        Artifact resolvedArtifact = this.artifactFactory.createArtifactWithClassifier(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), "java-source", "sources");
        try {
            this.artifactResolver.resolve(resolvedArtifact, this.remoteArtifactRepositories, this.localRepository);
        }
        catch (ArtifactNotFoundException e) {
        }
        catch (ArtifactResolutionException e) {
            this.getLog().warn((CharSequence)("Could not get sources for " + artifact));
        }
        if (resolvedArtifact.isResolved()) {
            return resolvedArtifact.getFile();
        }
        return null;
    }

    private boolean excludeArtifact(Artifact artifact) {
        String id = this.getId(artifact);
        if (this.artifactSet != null && this.artifactSet.getExcludes() == null && this.artifactSet.getIncludes() != null && !this.includedArtifacts().contains(id)) {
            return true;
        }
        if (this.excludedArtifacts().contains(id)) {
            return true;
        }
        return this.shadedGroupFilter != null && !artifact.getGroupId().startsWith(this.shadedGroupFilter);
    }

    private Set excludedArtifacts() {
        if (this.artifactSet != null && this.artifactSet.getExcludes() != null) {
            return this.artifactSet.getExcludes();
        }
        return Collections.EMPTY_SET;
    }

    private Set includedArtifacts() {
        if (this.artifactSet != null && this.artifactSet.getIncludes() != null) {
            return this.artifactSet.getIncludes();
        }
        return Collections.EMPTY_SET;
    }

    private List getRelocators() {
        ArrayList<SimpleRelocator> relocators = new ArrayList<SimpleRelocator>();
        if (this.relocations == null) {
            return relocators;
        }
        for (int i = 0; i < this.relocations.length; ++i) {
            PackageRelocation r = this.relocations[i];
            relocators.add(new SimpleRelocator(r.getPattern(), r.getShadedPattern(), r.getExcludes()));
        }
        return relocators;
    }

    private List getResourceTrasformers() {
        if (this.transformers == null) {
            return Collections.EMPTY_LIST;
        }
        return Arrays.asList(this.transformers);
    }

    private List getFilters() {
        ArrayList<SimpleFilter> filters = new ArrayList<SimpleFilter>();
        if (this.filters == null) {
            return filters;
        }
        HashMap<String, File> artifacts = new HashMap<String, File>();
        artifacts.put(this.getId(this.project.getArtifact()), this.project.getArtifact().getFile());
        Iterator it = this.project.getArtifacts().iterator();
        while (it.hasNext()) {
            Artifact artifact = (Artifact)it.next();
            artifacts.put(this.getId(artifact), artifact.getFile());
        }
        for (int i = 0; i < this.filters.length; ++i) {
            ArchiveFilter f = this.filters[i];
            File jar = (File)artifacts.get(f.getArtifact());
            if (jar == null) {
                this.getLog().info((CharSequence)("No artifact matching filter " + f.getArtifact()));
                continue;
            }
            filters.add(new SimpleFilter(jar, f.getIncludes(), f.getExcludes()));
        }
        return filters;
    }

    private File shadedArtifactFileWithClassifier() {
        Artifact artifact = this.project.getArtifact();
        String shadedName = this.shadedArtifactId + "-" + artifact.getVersion() + "-" + this.shadedClassifierName + "." + artifact.getArtifactHandler().getExtension();
        return new File(this.outputDirectory, shadedName);
    }

    private File shadedSourceArtifactFileWithClassifier() {
        Artifact artifact = this.project.getArtifact();
        String shadedName = this.shadedArtifactId + "-" + artifact.getVersion() + "-" + this.shadedClassifierName + "-sources." + artifact.getArtifactHandler().getExtension();
        return new File(this.outputDirectory, shadedName);
    }

    private File shadedArtifactFile() {
        Artifact artifact = this.project.getArtifact();
        String shadedName = this.finalName != null ? this.finalName + "." + artifact.getArtifactHandler().getExtension() : this.shadedArtifactId + "-" + artifact.getVersion() + "." + artifact.getArtifactHandler().getExtension();
        return new File(this.outputDirectory, shadedName);
    }

    private File shadedSourcesArtifactFile() {
        Artifact artifact = this.project.getArtifact();
        String shadedName = this.finalName != null ? this.finalName + "-sources." + artifact.getArtifactHandler().getExtension() : this.shadedArtifactId + "-" + artifact.getVersion() + "-sources." + artifact.getArtifactHandler().getExtension();
        return new File(this.outputDirectory, shadedName);
    }

    protected MavenProject getProject() {
        if (this.project.getExecutionProject() != null) {
            return this.project.getExecutionProject();
        }
        return this.project;
    }

    private void createDependencyReducedPom(Set artifactsToRemove) throws IOException {
        Model model = this.getProject().getOriginalModel();
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        boolean modified = false;
        ArrayList<Dependency> origDeps = this.getProject().getDependencies();
        if (this.promoteTransitiveDependencies) {
            origDeps = new ArrayList<Dependency>();
            Iterator it = this.project.getArtifacts().iterator();
            while (it.hasNext()) {
                Artifact artifact = (Artifact)it.next();
                Dependency dep = new Dependency();
                dep.setArtifactId(artifact.getArtifactId());
                if (artifact.hasClassifier()) {
                    dep.setClassifier(artifact.getClassifier());
                }
                dep.setGroupId(artifact.getGroupId());
                dep.setOptional(artifact.isOptional());
                dep.setScope(artifact.getScope());
                dep.setType(artifact.getType());
                dep.setVersion(artifact.getVersion());
                origDeps.add(dep);
            }
        }
        Iterator i = origDeps.iterator();
        while (i.hasNext()) {
            Dependency d = (Dependency)i.next();
            dependencies.add(d);
            String id = d.getGroupId() + ":" + d.getArtifactId();
            if (!artifactsToRemove.contains(id)) continue;
            modified = true;
            if (this.keepDependenciesWithProvidedScope) {
                d.setScope("provided");
                continue;
            }
            dependencies.remove(d);
        }
        if (modified) {
            model.setDependencies(dependencies);
            File f = new File(this.outputDirectory, "dependency-reduced-pom.xml");
            if (f.exists()) {
                f.delete();
            }
            FileWriter w = new FileWriter(f);
            PomWriter.write(w, model, true);
            ((Writer)w).close();
            this.project.setFile(f);
        }
    }

    private String getId(Artifact artifact) {
        return artifact.getGroupId() + ":" + artifact.getArtifactId();
    }
}

