/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.shade;

import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.commons.RemappingAnnotationAdapter;
import org.objectweb.asm.commons.RemappingClassAdapter;
import org.objectweb.asm.commons.RemappingFieldAdapter;
import org.objectweb.asm.commons.RemappingMethodAdapter;

class TempRemappingClassAdapter
extends RemappingClassAdapter {
    public TempRemappingClassAdapter(ClassVisitor cv, Remapper remapper) {
        super(cv, remapper);
    }

    protected MethodVisitor createRemappingMethodAdapter(int access, String newDesc, MethodVisitor mv) {
        return new MethodRemapVisitor(access, newDesc, mv, this.remapper);
    }

    protected FieldVisitor createRemappingFieldAdapter(FieldVisitor fv) {
        return new FieldRemapVisitor(fv, this.remapper);
    }

    private static class FieldRemapVisitor
    extends RemappingFieldAdapter {
        private final FieldVisitor fv;
        private final Remapper remapper;

        public FieldRemapVisitor(FieldVisitor fv, Remapper remapper) {
            super(fv, remapper);
            this.fv = fv;
            this.remapper = remapper;
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            AnnotationVisitor av = this.fv.visitAnnotation(this.remapper.mapDesc(desc), visible);
            return av == null ? null : new RemappingAnnotationAdapter(av, this.remapper);
        }
    }

    private static class MethodRemapVisitor
    extends RemappingMethodAdapter {
        public MethodRemapVisitor(int access, String desc, MethodVisitor mv, Remapper renamer) {
            super(access, desc, mv, renamer);
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            AnnotationVisitor av = this.mv.visitAnnotation(this.remapper.mapDesc(desc), visible);
            return av == null ? av : new RemappingAnnotationAdapter(av, this.remapper);
        }
    }
}

