/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.util.cli;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class StreamPumper
extends Thread {
    private BufferedReader in;
    private StreamConsumer consumer = null;
    private PrintWriter out = null;
    private static final int SIZE = 1024;
    boolean done;

    public StreamPumper(InputStream in) {
        this.in = new BufferedReader(new InputStreamReader(in), 1024);
    }

    public StreamPumper(InputStream in, StreamConsumer consumer) {
        this(in);
        this.consumer = consumer;
    }

    public StreamPumper(InputStream in, PrintWriter writer) {
        this(in);
        this.out = writer;
    }

    public StreamPumper(InputStream in, PrintWriter writer, StreamConsumer consumer) {
        this(in);
        this.out = writer;
        this.consumer = consumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            try {
                String s = this.in.readLine();
                while (s != null) {
                    this.consumeLine(s);
                    if (this.out != null) {
                        this.out.println(s);
                        this.out.flush();
                    }
                    s = this.in.readLine();
                }
                Object var3_3 = null;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                IOUtil.close((Reader)this.in);
                this.done = true;
                StreamPumper streamPumper2 = this;
                synchronized (streamPumper2) {
                    this.notifyAll();
                    return;
                }
            }
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            IOUtil.close((Reader)this.in);
            this.done = true;
            StreamPumper streamPumper = this;
            synchronized (streamPumper) {
                this.notifyAll();
                throw throwable;
            }
        }
        IOUtil.close((Reader)this.in);
        this.done = true;
        StreamPumper streamPumper = this;
        synchronized (streamPumper) {
            this.notifyAll();
            return;
        }
    }

    public void flush() {
        if (this.out != null) {
            this.out.flush();
        }
    }

    public void close() {
        IOUtil.close((Writer)this.out);
    }

    public boolean isDone() {
        return this.done;
    }

    private void consumeLine(String line) {
        if (this.consumer != null) {
            this.consumer.consumeLine(line);
        }
    }
}

