// =================== DO NOT EDIT THIS FILE ====================
// Generated by Modello 2.0.0,
// any modifications will be overwritten.
// ==============================================================

package org.apache.maven.shared.release.config;

/**
 * Class ModelloReleaseDescriptor.
 * 
 * @version $Revision$ $Date$
 */
@SuppressWarnings( "all" )
public class ModelloReleaseDescriptor
    implements java.io.Serializable
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * 
     *             The name of this release configuration
     *           .
     */
    private String name;

    /**
     * 
     *             The description of this release configuration
     *           .
     */
    private String description;

    /**
     * 
     *             The prefix of SCM modification messages
     *           .
     */
    private String ScmCommentPrefix = "[maven-release-manager] ";

    /**
     * 
     *             Get whether to use a shallow clone with no
     * history or a full clone containing the full history during
     * the
     *             release
     *           .
     */
    private boolean scmShallowClone = true;

    /**
     * 
     *             The SCM commit comment when setting pom.xml to
     * release
     *           .
     */
    private String scmReleaseCommitComment = "@{prefix} prepare release @{releaseLabel}";

    /**
     * 
     *             The SCM commit comment when setting pom.xml back
     * to development
     *           .
     */
    private String scmDevelopmentCommitComment = "@{prefix} prepare for next development iteration";

    /**
     * 
     *             The SCM commit comment when branching
     *           .
     */
    private String scmBranchCommitComment = "@{prefix} prepare branch @{releaseLabel}";

    /**
     * 
     *             The SCM commit comment when rolling back
     *           .
     */
    private String scmRollbackCommitComment = "@{prefix} rollback the release of @{releaseLabel}";

    /**
     * 
     *             This is a MavenSCM of where you're going to get
     * the sources to make the release with.
     *             Example:
     * scm:svn:https://svn.apache.org/repos/asf/maven/plugins/trunk/maven-release-plugin
     *           .
     */
    private String scmSourceUrl;

    /**
     * 
     *             Where you are going to put your tagged sources
     *             Example
     * https://svn.apache.org/repos/asf/maven/plugins/tags
     *           .
     */
    private String scmTagBase;

    /**
     * 
     *             Where you are going to put your branched sources
     *             Example
     * https://svn.apache.org/repos/asf/maven/plugins/branches
     *           .
     */
    private String scmBranchBase;

    /**
     * 
     *             tag or branch name: the identifier for the
     * tag/branch.
     *             Example: maven-release-plugin-2.0
     *           .
     */
    private String scmReleaseLabel;

    /**
     * 
     *             The id can be used to get the credentials by the
     * server-id from the settings.xml
     *           .
     */
    private String scmId;

    /**
     * 
     *             The user name to interact with the scm
     *           .
     */
    private String scmUsername;

    /**
     * 
     *             The password for the user interacting with the
     * scm
     *           .
     */
    private String scmPassword;

    /**
     * 
     *             Private key for an SSH based SCM repository.
     *           
     */
    private String scmPrivateKey;

    /**
     * 
     *             Pass phrase for the private key.
     *           
     */
    private String scmPrivateKeyPassPhrase;

    /**
     * 
     *             Whether to use edit mode when making SCM
     * modifications. This setting is disregarded
     *             if the SCM does not support edit mode, or if
     * edit mode is compulsory for the given SCM.
     *           
     */
    private boolean scmUseEditMode = false;

    /**
     * 
     *             Relative path of the project returned by the
     * checkout command.
     *           
     */
    private String scmRelativePathProjectDirectory;

    /**
     * 
     *             If updateDependencies is false, dependencies
     * version won't be updated to the next development version.
     *           
     */
    private boolean updateDependencies = true;

    /**
     * 
     *             Whether to use the release profile that adds
     * sources and javadocs to the released artifact, if
     * appropriate.
     *             If set to true, this will set the property
     * "performRelease" to true.
     *           
     */
    private boolean useReleaseProfile = true;

    /**
     * Field activateProfiles.
     */
    private java.util.List<String> activateProfiles;

    /**
     * 
     *             The directory where the release is performed.
     *           
     */
    private String workingDirectory;

    /**
     * 
     *             The directory where the tag will be checked out.
     *           
     */
    private String checkoutDirectory = "target/checkout";

    /**
     * 
     *             The last completed phase.
     *           
     */
    private String completedPhase;

    /**
     * 
     *             Whether to add the model schema to the top of
     * the rewritten POM if it wasn't there already.
     *             If <code>false</code> then the root element will
     * remain untouched.
     *           
     */
    private boolean addSchema = false;

    /**
     * 
     *             Whether to generate release POMs.
     *           
     */
    private boolean generateReleasePoms = false;

    /**
     * 
     *             Whether to use the parent pom version for
     * submodule versions.
     *           
     */
    private boolean autoVersionSubmodules = false;

    /**
     * 
     *             Whether the release process is interactive and
     * the release manager should be prompted to
     *             confirm values, or whether the defaults are used
     * regardless.
     *           
     */
    private boolean interactive = true;

    /**
     * 
     *             Whether a SNAPSHOT of the release plugin is
     * allowed.
     *           
     */
    private boolean snapshotReleasePluginAllowed = false;

    /**
     * 
     *             Additional arguments to pass to any executed
     * Maven process.
     *           
     */
    private String additionalArguments;

    /**
     * 
     *             The file name of the POM to pass to any executed
     * Maven process.
     *           
     */
    private String pomFileName;

    /**
     * Field checkModificationExcludes.
     */
    private java.util.List<String> checkModificationExcludes;

    /**
     * 
     *             The goals to execute in preparation for the
     * release.
     *           
     */
    private String preparationGoals;

    /**
     * 
     *             The goals to execute in on completion of
     * preparation for the release.
     *           
     */
    private String completionGoals;

    /**
     * 
     *             The goals to execute in perform phase for the
     * release.
     *           
     */
    private String performGoals;

    /**
     * 
     *             The commits must be done by modules or not. Set
     * it to true in case of flat directory structure.
     *           
     */
    private boolean commitByProject = false;

    /**
     * 
     *             Whether to create a branch instead of do a
     * release.
     *           
     */
    private boolean branchCreation = false;

    /**
     * 
     *             Whether to update branch POM versions.
     *           
     */
    private boolean updateBranchVersions = false;

    /**
     * 
     *             Whether to update working copy POM versions.
     *           
     */
    private boolean updateWorkingCopyVersions = true;

    /**
     * 
     *             Whether to update branch versions to SNAPSHOT.
     *           
     */
    private boolean updateVersionsToSnapshot = false;

    /**
     * 
     *             Whether to suppress a commit of changes to the
     * working copy before a tag or branch is created.
     *           
     */
    private boolean suppressCommitBeforeTagOrBranch = false;

    /**
     * 
     *             Wait the specified number of seconds before
     * creating a tag.
     *           
     */
    private int waitBeforeTagging = 0;

    /**
     * 
     *             Should timestamped SNAPSHOT dependencies be
     * allowed?  Default is to fail when any SNAPSHOT
     *               dependency is found.
     *           
     */
    private boolean allowTimestampedSnapshots = false;

    /**
     * 
     *             Default version to use for the tagged release or
     * the new branch.
     *           
     */
    private String defaultReleaseVersion;

    /**
     * 
     *             Default version to use for new working copy.
     *           
     */
    private String defaultDevelopmentVersion;

    /**
     * 
     *             The role-hint for the VersionPolicy
     * implementation used to calculate the project versions.
     *           
     */
    private String projectVersionPolicyId = "default";

    /**
     * 
     *             The role-hint for the NamingPolicy
     * implementation used to calculate the project branch and tag
     * names.
     *           
     */
    private String projectNamingPolicyId;

    /**
     * 
     *             The role-hint for the release Strategy
     * implementation.
     *           
     */
    private String releaseStrategyId = "default";

    /**
     * 
     *             NOTE : currently only implemented with svn scm.
     * Enable a workaround to prevent issue due to svn client &gt;
     * 1.5.0
     *             (https://issues.apache.org/jira/browse/SCM-406)
     *           .
     */
    private boolean remoteTagging = false;

    /**
     * 
     *             NOTE : currently only implemented with svn scm.
     * It contains the revision of the committed released pom to
     * remotely tag
     *             the source code with this revision.
     *           
     */
    private String scmReleasedPomRevision;

    /**
     * 
     *             Should distributed changes be pushed to the
     * central repository?
     *             For many distributed SCMs like Git, a change
     * like a commit is only stored in your local copy of the
     * repository.
     *             Pushing the change allows your to more easily
     * share it with other users.
     *           
     */
    private boolean pushChanges = true;

    /**
     * 
     *             If the scm provider should use local checkouts
     * via file://${basedir}
     *             instead of doing a clean checkout over the
     * network.
     *             This is very helpful for releasing large
     * projects!
     *           
     */
    private boolean localCheckout = false;

    /**
     * 
     *             Specifies the format for generating a tag name.
     * Property expansion is
     *             used with the optional prefix of project, where
     * properties are delimited
     *             with @{ and }
     *           .
     */
    private String scmTagNameFormat;

    /**
     * 
     *             Some SCMs may require a Work Item or a Task to
     * allow the changes to be pushed or delivered.
     *             This field allows you to specify that Work Item
     * or Task. It is optional, and only relevant
     *             if pushChanges is true.
     *           
     */
    private String workItem;

    /**
     * 
     *             Specifies whether unresolved SNAPSHOT
     * dependencies are automatically resolved.
     *             If set, it is used as the answer to use when
     * being asked how unresolved SNAPSHOT 
     *             dependencies should be resolved:
     *             <ul>
     *             <li>"all" or "0": resolve all kinds of
     * snapshots, ie. project, plugin, report and extension
     * dependencies</li>
     *             <li>"dependencies" or "1": resolve project
     * dependencies</li>
     *             <li>"plugins" or "2": resolve plugin
     * dependencies</li>
     *             <li>"reports" or "3": resolve report
     * dependencies</li>
     *             <li>"extensions" or "4": resolve extension
     * dependencies</li>
     *             </ul>
     *             Additionally this implies that the default
     * values for the dependency's release and next
     *             development version are used.
     *           
     */
    private String autoResolveSnapshots;

    /**
     * 
     *             Enable the "--pin-externals" option in svn copy
     * commands which is new in Subversion 1.9.
     *             NOTE : Currently only implemented with
     * Subversion.
     *             (https://issues.apache.org/jira/browse/SCM-805)
     *           .
     */
    private boolean pinExternals = false;

    /**
     * 
     *             If the scm provider should use sign tags, for
     * example for git-exe the '--sign' argument would be used.
     *           
     */
    private boolean scmSignTags = false;

    /**
     * 
     *             Specifies the line separator to use in the
     * pom.xml.
     *           
     */
    private String lineSeparator;

    /**
     * Field modelEncoding.
     */
    private String modelEncoding = "UTF-8";


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addActivateProfile.
     * 
     * @param string a string object.
     */
    public void addActivateProfile( String string )
    {
        getActivateProfiles().add( string );
    } //-- void addActivateProfile( String )

    /**
     * Method addCheckModificationExclude.
     * 
     * @param string a string object.
     */
    public void addCheckModificationExclude( String string )
    {
        getCheckModificationExcludes().add( string );
    } //-- void addCheckModificationExclude( String )

    /**
     * Method getActivateProfiles.
     * 
     * @return List
     */
    public java.util.List<String> getActivateProfiles()
    {
        if ( this.activateProfiles == null )
        {
            this.activateProfiles = new java.util.ArrayList<String>();
        }

        return this.activateProfiles;
    } //-- java.util.List<String> getActivateProfiles()

    /**
     * Get additional arguments to pass to any executed Maven
     * process.
     * 
     * @return String
     */
    public String getAdditionalArguments()
    {
        return this.additionalArguments;
    } //-- String getAdditionalArguments()

    /**
     * Get specifies whether unresolved SNAPSHOT dependencies are
     * automatically resolved.
     *             If set, it is used as the answer to use when
     * being asked how unresolved SNAPSHOT 
     *             dependencies should be resolved:
     *             <ul>
     *             <li>"all" or "0": resolve all kinds of
     * snapshots, ie. project, plugin, report and extension
     * dependencies</li>
     *             <li>"dependencies" or "1": resolve project
     * dependencies</li>
     *             <li>"plugins" or "2": resolve plugin
     * dependencies</li>
     *             <li>"reports" or "3": resolve report
     * dependencies</li>
     *             <li>"extensions" or "4": resolve extension
     * dependencies</li>
     *             </ul>
     *             Additionally this implies that the default
     * values for the dependency's release and next
     *             development version are used.
     * 
     * @return String
     */
    public String getAutoResolveSnapshots()
    {
        return this.autoResolveSnapshots;
    } //-- String getAutoResolveSnapshots()

    /**
     * Method getCheckModificationExcludes.
     * 
     * @return List
     */
    public java.util.List<String> getCheckModificationExcludes()
    {
        if ( this.checkModificationExcludes == null )
        {
            this.checkModificationExcludes = new java.util.ArrayList<String>();
        }

        return this.checkModificationExcludes;
    } //-- java.util.List<String> getCheckModificationExcludes()

    /**
     * Get the directory where the tag will be checked out.
     * 
     * @return String
     */
    public String getCheckoutDirectory()
    {
        return this.checkoutDirectory;
    } //-- String getCheckoutDirectory()

    /**
     * Get the last completed phase.
     * 
     * @return String
     */
    public String getCompletedPhase()
    {
        return this.completedPhase;
    } //-- String getCompletedPhase()

    /**
     * Get the goals to execute in on completion of preparation for
     * the release.
     * 
     * @return String
     */
    public String getCompletionGoals()
    {
        return this.completionGoals;
    } //-- String getCompletionGoals()

    /**
     * Get default version to use for new working copy.
     * 
     * @return String
     */
    public String getDefaultDevelopmentVersion()
    {
        return this.defaultDevelopmentVersion;
    } //-- String getDefaultDevelopmentVersion()

    /**
     * Get default version to use for the tagged release or the new
     * branch.
     * 
     * @return String
     */
    public String getDefaultReleaseVersion()
    {
        return this.defaultReleaseVersion;
    } //-- String getDefaultReleaseVersion()

    /**
     * Get the description of this release configuration.
     * 
     * @return String
     */
    public String getDescription()
    {
        return this.description;
    } //-- String getDescription()

    /**
     * Get specifies the line separator to use in the pom.xml.
     * 
     * @return String
     */
    public String getLineSeparator()
    {
        return this.lineSeparator;
    } //-- String getLineSeparator()

    /**
     * Get the modelEncoding field.
     * 
     * @return String
     */
    public String getModelEncoding()
    {
        return this.modelEncoding;
    } //-- String getModelEncoding()

    /**
     * Get the name of this release configuration.
     * 
     * @return String
     */
    public String getName()
    {
        return this.name;
    } //-- String getName()

    /**
     * Get the goals to execute in perform phase for the release.
     * 
     * @return String
     */
    public String getPerformGoals()
    {
        return this.performGoals;
    } //-- String getPerformGoals()

    /**
     * Get the file name of the POM to pass to any executed Maven
     * process.
     * 
     * @return String
     */
    public String getPomFileName()
    {
        return this.pomFileName;
    } //-- String getPomFileName()

    /**
     * Get the goals to execute in preparation for the release.
     * 
     * @return String
     */
    public String getPreparationGoals()
    {
        return this.preparationGoals;
    } //-- String getPreparationGoals()

    /**
     * Get the role-hint for the NamingPolicy implementation used
     * to calculate the project branch and tag names.
     * 
     * @return String
     */
    public String getProjectNamingPolicyId()
    {
        return this.projectNamingPolicyId;
    } //-- String getProjectNamingPolicyId()

    /**
     * Get the role-hint for the VersionPolicy implementation used
     * to calculate the project versions.
     * 
     * @return String
     */
    public String getProjectVersionPolicyId()
    {
        return this.projectVersionPolicyId;
    } //-- String getProjectVersionPolicyId()

    /**
     * Get the role-hint for the release Strategy implementation.
     * 
     * @return String
     */
    public String getReleaseStrategyId()
    {
        return this.releaseStrategyId;
    } //-- String getReleaseStrategyId()

    /**
     * Get where you are going to put your branched sources
     *             Example
     * https://svn.apache.org/repos/asf/maven/plugins/branches.
     * 
     * @return String
     */
    public String getScmBranchBase()
    {
        return this.scmBranchBase;
    } //-- String getScmBranchBase()

    /**
     * Get the SCM commit comment when branching.
     * 
     * @return String
     */
    public String getScmBranchCommitComment()
    {
        return this.scmBranchCommitComment;
    } //-- String getScmBranchCommitComment()

    /**
     * Get the prefix of SCM modification messages.
     * 
     * @return String
     */
    public String getScmCommentPrefix()
    {
        return this.ScmCommentPrefix;
    } //-- String getScmCommentPrefix()

    /**
     * Get the SCM commit comment when setting pom.xml back to
     * development.
     * 
     * @return String
     */
    public String getScmDevelopmentCommitComment()
    {
        return this.scmDevelopmentCommitComment;
    } //-- String getScmDevelopmentCommitComment()

    /**
     * Get the id can be used to get the credentials by the
     * server-id from the settings.xml.
     * 
     * @return String
     */
    public String getScmId()
    {
        return this.scmId;
    } //-- String getScmId()

    /**
     * Get the password for the user interacting with the scm.
     * 
     * @return String
     */
    public String getScmPassword()
    {
        return this.scmPassword;
    } //-- String getScmPassword()

    /**
     * Get private key for an SSH based SCM repository.
     * 
     * @return String
     */
    public String getScmPrivateKey()
    {
        return this.scmPrivateKey;
    } //-- String getScmPrivateKey()

    /**
     * Get pass phrase for the private key.
     * 
     * @return String
     */
    public String getScmPrivateKeyPassPhrase()
    {
        return this.scmPrivateKeyPassPhrase;
    } //-- String getScmPrivateKeyPassPhrase()

    /**
     * Get relative path of the project returned by the checkout
     * command.
     * 
     * @return String
     */
    public String getScmRelativePathProjectDirectory()
    {
        return this.scmRelativePathProjectDirectory;
    } //-- String getScmRelativePathProjectDirectory()

    /**
     * Get the SCM commit comment when setting pom.xml to release.
     * 
     * @return String
     */
    public String getScmReleaseCommitComment()
    {
        return this.scmReleaseCommitComment;
    } //-- String getScmReleaseCommitComment()

    /**
     * Get tag or branch name: the identifier for the tag/branch.
     *             Example: maven-release-plugin-2.0.
     * 
     * @return String
     */
    public String getScmReleaseLabel()
    {
        return this.scmReleaseLabel;
    } //-- String getScmReleaseLabel()

    /**
     * Get nOTE : currently only implemented with svn scm. It
     * contains the revision of the committed released pom to
     * remotely tag
     *             the source code with this revision.
     * 
     * @return String
     */
    public String getScmReleasedPomRevision()
    {
        return this.scmReleasedPomRevision;
    } //-- String getScmReleasedPomRevision()

    /**
     * Get the SCM commit comment when rolling back.
     * 
     * @return String
     */
    public String getScmRollbackCommitComment()
    {
        return this.scmRollbackCommitComment;
    } //-- String getScmRollbackCommitComment()

    /**
     * Get this is a MavenSCM of where you're going to get the
     * sources to make the release with.
     *             Example:
     * scm:svn:https://svn.apache.org/repos/asf/maven/plugins/trunk/maven-release-plugin.
     * 
     * @return String
     */
    public String getScmSourceUrl()
    {
        return this.scmSourceUrl;
    } //-- String getScmSourceUrl()

    /**
     * Get where you are going to put your tagged sources
     *             Example
     * https://svn.apache.org/repos/asf/maven/plugins/tags.
     * 
     * @return String
     */
    public String getScmTagBase()
    {
        return this.scmTagBase;
    } //-- String getScmTagBase()

    /**
     * Get specifies the format for generating a tag name. Property
     * expansion is
     *             used with the optional prefix of project, where
     * properties are delimited
     *             with @{ and }.
     * 
     * @return String
     */
    public String getScmTagNameFormat()
    {
        return this.scmTagNameFormat;
    } //-- String getScmTagNameFormat()

    /**
     * Get the user name to interact with the scm.
     * 
     * @return String
     */
    public String getScmUsername()
    {
        return this.scmUsername;
    } //-- String getScmUsername()

    /**
     * Get wait the specified number of seconds before creating a
     * tag.
     * 
     * @return int
     */
    public int getWaitBeforeTagging()
    {
        return this.waitBeforeTagging;
    } //-- int getWaitBeforeTagging()

    /**
     * Get some SCMs may require a Work Item or a Task to allow the
     * changes to be pushed or delivered.
     *             This field allows you to specify that Work Item
     * or Task. It is optional, and only relevant
     *             if pushChanges is true.
     * 
     * @return String
     */
    public String getWorkItem()
    {
        return this.workItem;
    } //-- String getWorkItem()

    /**
     * Get the directory where the release is performed.
     * 
     * @return String
     */
    public String getWorkingDirectory()
    {
        return this.workingDirectory;
    } //-- String getWorkingDirectory()

    /**
     * Get whether to add the model schema to the top of the
     * rewritten POM if it wasn't there already.
     *             If <code>false</code> then the root element will
     * remain untouched.
     * 
     * @return boolean
     */
    public boolean isAddSchema()
    {
        return this.addSchema;
    } //-- boolean isAddSchema()

    /**
     * Get should timestamped SNAPSHOT dependencies be allowed? 
     * Default is to fail when any SNAPSHOT
     *               dependency is found.
     * 
     * @return boolean
     */
    public boolean isAllowTimestampedSnapshots()
    {
        return this.allowTimestampedSnapshots;
    } //-- boolean isAllowTimestampedSnapshots()

    /**
     * Get whether to use the parent pom version for submodule
     * versions.
     * 
     * @return boolean
     */
    public boolean isAutoVersionSubmodules()
    {
        return this.autoVersionSubmodules;
    } //-- boolean isAutoVersionSubmodules()

    /**
     * Get whether to create a branch instead of do a release.
     * 
     * @return boolean
     */
    public boolean isBranchCreation()
    {
        return this.branchCreation;
    } //-- boolean isBranchCreation()

    /**
     * Get the commits must be done by modules or not. Set it to
     * true in case of flat directory structure.
     * 
     * @return boolean
     */
    public boolean isCommitByProject()
    {
        return this.commitByProject;
    } //-- boolean isCommitByProject()

    /**
     * Get whether to generate release POMs.
     * 
     * @return boolean
     */
    public boolean isGenerateReleasePoms()
    {
        return this.generateReleasePoms;
    } //-- boolean isGenerateReleasePoms()

    /**
     * Get whether the release process is interactive and the
     * release manager should be prompted to
     *             confirm values, or whether the defaults are used
     * regardless.
     * 
     * @return boolean
     */
    public boolean isInteractive()
    {
        return this.interactive;
    } //-- boolean isInteractive()

    /**
     * Get if the scm provider should use local checkouts via
     * file://${basedir}
     *             instead of doing a clean checkout over the
     * network.
     *             This is very helpful for releasing large
     * projects!
     * 
     * @return boolean
     */
    public boolean isLocalCheckout()
    {
        return this.localCheckout;
    } //-- boolean isLocalCheckout()

    /**
     * Get enable the "--pin-externals" option in svn copy commands
     * which is new in Subversion 1.9.
     *             NOTE : Currently only implemented with
     * Subversion.
     *             (https://issues.apache.org/jira/browse/SCM-805).
     * 
     * @return boolean
     */
    public boolean isPinExternals()
    {
        return this.pinExternals;
    } //-- boolean isPinExternals()

    /**
     * Get should distributed changes be pushed to the central
     * repository?
     *             For many distributed SCMs like Git, a change
     * like a commit is only stored in your local copy of the
     * repository.
     *             Pushing the change allows your to more easily
     * share it with other users.
     * 
     * @return boolean
     */
    public boolean isPushChanges()
    {
        return this.pushChanges;
    } //-- boolean isPushChanges()

    /**
     * Get nOTE : currently only implemented with svn scm. Enable a
     * workaround to prevent issue due to svn client &gt; 1.5.0
     *             (https://issues.apache.org/jira/browse/SCM-406).
     * 
     * @return boolean
     */
    public boolean isRemoteTagging()
    {
        return this.remoteTagging;
    } //-- boolean isRemoteTagging()

    /**
     * Get get whether to use a shallow clone with no history or a
     * full clone containing the full history during the
     *             release.
     * 
     * @return boolean
     */
    public boolean isScmShallowClone()
    {
        return this.scmShallowClone;
    } //-- boolean isScmShallowClone()

    /**
     * Get if the scm provider should use sign tags, for example
     * for git-exe the '--sign' argument would be used.
     * 
     * @return boolean
     */
    public boolean isScmSignTags()
    {
        return this.scmSignTags;
    } //-- boolean isScmSignTags()

    /**
     * Get whether to use edit mode when making SCM modifications.
     * This setting is disregarded
     *             if the SCM does not support edit mode, or if
     * edit mode is compulsory for the given SCM.
     * 
     * @return boolean
     */
    public boolean isScmUseEditMode()
    {
        return this.scmUseEditMode;
    } //-- boolean isScmUseEditMode()

    /**
     * Get whether a SNAPSHOT of the release plugin is allowed.
     * 
     * @return boolean
     */
    public boolean isSnapshotReleasePluginAllowed()
    {
        return this.snapshotReleasePluginAllowed;
    } //-- boolean isSnapshotReleasePluginAllowed()

    /**
     * Get whether to suppress a commit of changes to the working
     * copy before a tag or branch is created.
     * 
     * @return boolean
     */
    public boolean isSuppressCommitBeforeTagOrBranch()
    {
        return this.suppressCommitBeforeTagOrBranch;
    } //-- boolean isSuppressCommitBeforeTagOrBranch()

    /**
     * Get whether to update branch POM versions.
     * 
     * @return boolean
     */
    public boolean isUpdateBranchVersions()
    {
        return this.updateBranchVersions;
    } //-- boolean isUpdateBranchVersions()

    /**
     * Get if updateDependencies is false, dependencies version
     * won't be updated to the next development version.
     * 
     * @return boolean
     */
    public boolean isUpdateDependencies()
    {
        return this.updateDependencies;
    } //-- boolean isUpdateDependencies()

    /**
     * Get whether to update branch versions to SNAPSHOT.
     * 
     * @return boolean
     */
    public boolean isUpdateVersionsToSnapshot()
    {
        return this.updateVersionsToSnapshot;
    } //-- boolean isUpdateVersionsToSnapshot()

    /**
     * Get whether to update working copy POM versions.
     * 
     * @return boolean
     */
    public boolean isUpdateWorkingCopyVersions()
    {
        return this.updateWorkingCopyVersions;
    } //-- boolean isUpdateWorkingCopyVersions()

    /**
     * Get whether to use the release profile that adds sources and
     * javadocs to the released artifact, if appropriate.
     *             If set to true, this will set the property
     * "performRelease" to true.
     * 
     * @return boolean
     */
    public boolean isUseReleaseProfile()
    {
        return this.useReleaseProfile;
    } //-- boolean isUseReleaseProfile()

    /**
     * Method removeActivateProfile.
     * 
     * @param string a string object.
     */
    public void removeActivateProfile( String string )
    {
        getActivateProfiles().remove( string );
    } //-- void removeActivateProfile( String )

    /**
     * Method removeCheckModificationExclude.
     * 
     * @param string a string object.
     */
    public void removeCheckModificationExclude( String string )
    {
        getCheckModificationExcludes().remove( string );
    } //-- void removeCheckModificationExclude( String )

    /**
     * Set list of profiles to activate.
     * 
     * @param activateProfiles a activateProfiles object.
     */
    public void setActivateProfiles( java.util.List<String> activateProfiles )
    {
        this.activateProfiles = activateProfiles;
    } //-- void setActivateProfiles( java.util.List )

    /**
     * Set whether to add the model schema to the top of the
     * rewritten POM if it wasn't there already.
     *             If <code>false</code> then the root element will
     * remain untouched.
     * 
     * @param addSchema a addSchema object.
     */
    public void setAddSchema( boolean addSchema )
    {
        this.addSchema = addSchema;
    } //-- void setAddSchema( boolean )

    /**
     * Set additional arguments to pass to any executed Maven
     * process.
     * 
     * @param additionalArguments a additionalArguments object.
     */
    public void setAdditionalArguments( String additionalArguments )
    {
        this.additionalArguments = additionalArguments;
    } //-- void setAdditionalArguments( String )

    /**
     * Set should timestamped SNAPSHOT dependencies be allowed? 
     * Default is to fail when any SNAPSHOT
     *               dependency is found.
     * 
     * @param allowTimestampedSnapshots a allowTimestampedSnapshots
     * object.
     */
    public void setAllowTimestampedSnapshots( boolean allowTimestampedSnapshots )
    {
        this.allowTimestampedSnapshots = allowTimestampedSnapshots;
    } //-- void setAllowTimestampedSnapshots( boolean )

    /**
     * Set specifies whether unresolved SNAPSHOT dependencies are
     * automatically resolved.
     *             If set, it is used as the answer to use when
     * being asked how unresolved SNAPSHOT 
     *             dependencies should be resolved:
     *             <ul>
     *             <li>"all" or "0": resolve all kinds of
     * snapshots, ie. project, plugin, report and extension
     * dependencies</li>
     *             <li>"dependencies" or "1": resolve project
     * dependencies</li>
     *             <li>"plugins" or "2": resolve plugin
     * dependencies</li>
     *             <li>"reports" or "3": resolve report
     * dependencies</li>
     *             <li>"extensions" or "4": resolve extension
     * dependencies</li>
     *             </ul>
     *             Additionally this implies that the default
     * values for the dependency's release and next
     *             development version are used.
     * 
     * @param autoResolveSnapshots a autoResolveSnapshots object.
     */
    public void setAutoResolveSnapshots( String autoResolveSnapshots )
    {
        this.autoResolveSnapshots = autoResolveSnapshots;
    } //-- void setAutoResolveSnapshots( String )

    /**
     * Set whether to use the parent pom version for submodule
     * versions.
     * 
     * @param autoVersionSubmodules a autoVersionSubmodules object.
     */
    public void setAutoVersionSubmodules( boolean autoVersionSubmodules )
    {
        this.autoVersionSubmodules = autoVersionSubmodules;
    } //-- void setAutoVersionSubmodules( boolean )

    /**
     * Set whether to create a branch instead of do a release.
     * 
     * @param branchCreation a branchCreation object.
     */
    public void setBranchCreation( boolean branchCreation )
    {
        this.branchCreation = branchCreation;
    } //-- void setBranchCreation( boolean )

    /**
     * Set in some exceptions you want to allow changes to the
     * working copy. Changes
     *             to files listed here will not make the
     * ScmCheckModificationsPhase fail.
     * 
     * @param checkModificationExcludes a checkModificationExcludes
     * object.
     */
    public void setCheckModificationExcludes( java.util.List<String> checkModificationExcludes )
    {
        this.checkModificationExcludes = checkModificationExcludes;
    } //-- void setCheckModificationExcludes( java.util.List )

    /**
     * Set the directory where the tag will be checked out.
     * 
     * @param checkoutDirectory a checkoutDirectory object.
     */
    public void setCheckoutDirectory( String checkoutDirectory )
    {
        this.checkoutDirectory = checkoutDirectory;
    } //-- void setCheckoutDirectory( String )

    /**
     * Set the commits must be done by modules or not. Set it to
     * true in case of flat directory structure.
     * 
     * @param commitByProject a commitByProject object.
     */
    public void setCommitByProject( boolean commitByProject )
    {
        this.commitByProject = commitByProject;
    } //-- void setCommitByProject( boolean )

    /**
     * Set the last completed phase.
     * 
     * @param completedPhase a completedPhase object.
     */
    public void setCompletedPhase( String completedPhase )
    {
        this.completedPhase = completedPhase;
    } //-- void setCompletedPhase( String )

    /**
     * Set the goals to execute in on completion of preparation for
     * the release.
     * 
     * @param completionGoals a completionGoals object.
     */
    public void setCompletionGoals( String completionGoals )
    {
        this.completionGoals = completionGoals;
    } //-- void setCompletionGoals( String )

    /**
     * Set default version to use for new working copy.
     * 
     * @param defaultDevelopmentVersion a defaultDevelopmentVersion
     * object.
     */
    public void setDefaultDevelopmentVersion( String defaultDevelopmentVersion )
    {
        this.defaultDevelopmentVersion = defaultDevelopmentVersion;
    } //-- void setDefaultDevelopmentVersion( String )

    /**
     * Set default version to use for the tagged release or the new
     * branch.
     * 
     * @param defaultReleaseVersion a defaultReleaseVersion object.
     */
    public void setDefaultReleaseVersion( String defaultReleaseVersion )
    {
        this.defaultReleaseVersion = defaultReleaseVersion;
    } //-- void setDefaultReleaseVersion( String )

    /**
     * Set the description of this release configuration.
     * 
     * @param description a description object.
     */
    public void setDescription( String description )
    {
        this.description = description;
    } //-- void setDescription( String )

    /**
     * Set whether to generate release POMs.
     * 
     * @param generateReleasePoms a generateReleasePoms object.
     */
    public void setGenerateReleasePoms( boolean generateReleasePoms )
    {
        this.generateReleasePoms = generateReleasePoms;
    } //-- void setGenerateReleasePoms( boolean )

    /**
     * Set whether the release process is interactive and the
     * release manager should be prompted to
     *             confirm values, or whether the defaults are used
     * regardless.
     * 
     * @param interactive a interactive object.
     */
    public void setInteractive( boolean interactive )
    {
        this.interactive = interactive;
    } //-- void setInteractive( boolean )

    /**
     * Set specifies the line separator to use in the pom.xml.
     * 
     * @param lineSeparator a lineSeparator object.
     */
    public void setLineSeparator( String lineSeparator )
    {
        this.lineSeparator = lineSeparator;
    } //-- void setLineSeparator( String )

    /**
     * Set if the scm provider should use local checkouts via
     * file://${basedir}
     *             instead of doing a clean checkout over the
     * network.
     *             This is very helpful for releasing large
     * projects!
     * 
     * @param localCheckout a localCheckout object.
     */
    public void setLocalCheckout( boolean localCheckout )
    {
        this.localCheckout = localCheckout;
    } //-- void setLocalCheckout( boolean )

    /**
     * Set the modelEncoding field.
     * 
     * @param modelEncoding a modelEncoding object.
     */
    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    } //-- void setModelEncoding( String )

    /**
     * Set the name of this release configuration.
     * 
     * @param name a name object.
     */
    public void setName( String name )
    {
        this.name = name;
    } //-- void setName( String )

    /**
     * Set the goals to execute in perform phase for the release.
     * 
     * @param performGoals a performGoals object.
     */
    public void setPerformGoals( String performGoals )
    {
        this.performGoals = performGoals;
    } //-- void setPerformGoals( String )

    /**
     * Set enable the "--pin-externals" option in svn copy commands
     * which is new in Subversion 1.9.
     *             NOTE : Currently only implemented with
     * Subversion.
     *             (https://issues.apache.org/jira/browse/SCM-805).
     * 
     * @param pinExternals a pinExternals object.
     */
    public void setPinExternals( boolean pinExternals )
    {
        this.pinExternals = pinExternals;
    } //-- void setPinExternals( boolean )

    /**
     * Set the file name of the POM to pass to any executed Maven
     * process.
     * 
     * @param pomFileName a pomFileName object.
     */
    public void setPomFileName( String pomFileName )
    {
        this.pomFileName = pomFileName;
    } //-- void setPomFileName( String )

    /**
     * Set the goals to execute in preparation for the release.
     * 
     * @param preparationGoals a preparationGoals object.
     */
    public void setPreparationGoals( String preparationGoals )
    {
        this.preparationGoals = preparationGoals;
    } //-- void setPreparationGoals( String )

    /**
     * Set the role-hint for the NamingPolicy implementation used
     * to calculate the project branch and tag names.
     * 
     * @param projectNamingPolicyId a projectNamingPolicyId object.
     */
    public void setProjectNamingPolicyId( String projectNamingPolicyId )
    {
        this.projectNamingPolicyId = projectNamingPolicyId;
    } //-- void setProjectNamingPolicyId( String )

    /**
     * Set the role-hint for the VersionPolicy implementation used
     * to calculate the project versions.
     * 
     * @param projectVersionPolicyId a projectVersionPolicyId object
     */
    public void setProjectVersionPolicyId( String projectVersionPolicyId )
    {
        this.projectVersionPolicyId = projectVersionPolicyId;
    } //-- void setProjectVersionPolicyId( String )

    /**
     * Set should distributed changes be pushed to the central
     * repository?
     *             For many distributed SCMs like Git, a change
     * like a commit is only stored in your local copy of the
     * repository.
     *             Pushing the change allows your to more easily
     * share it with other users.
     * 
     * @param pushChanges a pushChanges object.
     */
    public void setPushChanges( boolean pushChanges )
    {
        this.pushChanges = pushChanges;
    } //-- void setPushChanges( boolean )

    /**
     * Set the role-hint for the release Strategy implementation.
     * 
     * @param releaseStrategyId a releaseStrategyId object.
     */
    public void setReleaseStrategyId( String releaseStrategyId )
    {
        this.releaseStrategyId = releaseStrategyId;
    } //-- void setReleaseStrategyId( String )

    /**
     * Set nOTE : currently only implemented with svn scm. Enable a
     * workaround to prevent issue due to svn client &gt; 1.5.0
     *             (https://issues.apache.org/jira/browse/SCM-406).
     * 
     * @param remoteTagging a remoteTagging object.
     */
    public void setRemoteTagging( boolean remoteTagging )
    {
        this.remoteTagging = remoteTagging;
    } //-- void setRemoteTagging( boolean )

    /**
     * Set where you are going to put your branched sources
     *             Example
     * https://svn.apache.org/repos/asf/maven/plugins/branches.
     * 
     * @param scmBranchBase a scmBranchBase object.
     */
    public void setScmBranchBase( String scmBranchBase )
    {
        this.scmBranchBase = scmBranchBase;
    } //-- void setScmBranchBase( String )

    /**
     * Set the SCM commit comment when branching.
     * 
     * @param scmBranchCommitComment a scmBranchCommitComment object
     */
    public void setScmBranchCommitComment( String scmBranchCommitComment )
    {
        this.scmBranchCommitComment = scmBranchCommitComment;
    } //-- void setScmBranchCommitComment( String )

    /**
     * Set the prefix of SCM modification messages.
     * 
     * @param ScmCommentPrefix a ScmCommentPrefix object.
     */
    public void setScmCommentPrefix( String ScmCommentPrefix )
    {
        this.ScmCommentPrefix = ScmCommentPrefix;
    } //-- void setScmCommentPrefix( String )

    /**
     * Set the SCM commit comment when setting pom.xml back to
     * development.
     * 
     * @param scmDevelopmentCommitComment a
     * scmDevelopmentCommitComment object.
     */
    public void setScmDevelopmentCommitComment( String scmDevelopmentCommitComment )
    {
        this.scmDevelopmentCommitComment = scmDevelopmentCommitComment;
    } //-- void setScmDevelopmentCommitComment( String )

    /**
     * Set the id can be used to get the credentials by the
     * server-id from the settings.xml.
     * 
     * @param scmId a scmId object.
     */
    public void setScmId( String scmId )
    {
        this.scmId = scmId;
    } //-- void setScmId( String )

    /**
     * Set the password for the user interacting with the scm.
     * 
     * @param scmPassword a scmPassword object.
     */
    public void setScmPassword( String scmPassword )
    {
        this.scmPassword = scmPassword;
    } //-- void setScmPassword( String )

    /**
     * Set private key for an SSH based SCM repository.
     * 
     * @param scmPrivateKey a scmPrivateKey object.
     */
    public void setScmPrivateKey( String scmPrivateKey )
    {
        this.scmPrivateKey = scmPrivateKey;
    } //-- void setScmPrivateKey( String )

    /**
     * Set pass phrase for the private key.
     * 
     * @param scmPrivateKeyPassPhrase a scmPrivateKeyPassPhrase
     * object.
     */
    public void setScmPrivateKeyPassPhrase( String scmPrivateKeyPassPhrase )
    {
        this.scmPrivateKeyPassPhrase = scmPrivateKeyPassPhrase;
    } //-- void setScmPrivateKeyPassPhrase( String )

    /**
     * Set relative path of the project returned by the checkout
     * command.
     * 
     * @param scmRelativePathProjectDirectory a
     * scmRelativePathProjectDirectory object.
     */
    public void setScmRelativePathProjectDirectory( String scmRelativePathProjectDirectory )
    {
        this.scmRelativePathProjectDirectory = scmRelativePathProjectDirectory;
    } //-- void setScmRelativePathProjectDirectory( String )

    /**
     * Set the SCM commit comment when setting pom.xml to release.
     * 
     * @param scmReleaseCommitComment a scmReleaseCommitComment
     * object.
     */
    public void setScmReleaseCommitComment( String scmReleaseCommitComment )
    {
        this.scmReleaseCommitComment = scmReleaseCommitComment;
    } //-- void setScmReleaseCommitComment( String )

    /**
     * Set tag or branch name: the identifier for the tag/branch.
     *             Example: maven-release-plugin-2.0.
     * 
     * @param scmReleaseLabel a scmReleaseLabel object.
     */
    public void setScmReleaseLabel( String scmReleaseLabel )
    {
        this.scmReleaseLabel = scmReleaseLabel;
    } //-- void setScmReleaseLabel( String )

    /**
     * Set nOTE : currently only implemented with svn scm. It
     * contains the revision of the committed released pom to
     * remotely tag
     *             the source code with this revision.
     * 
     * @param scmReleasedPomRevision a scmReleasedPomRevision object
     */
    public void setScmReleasedPomRevision( String scmReleasedPomRevision )
    {
        this.scmReleasedPomRevision = scmReleasedPomRevision;
    } //-- void setScmReleasedPomRevision( String )

    /**
     * Set the SCM commit comment when rolling back.
     * 
     * @param scmRollbackCommitComment a scmRollbackCommitComment
     * object.
     */
    public void setScmRollbackCommitComment( String scmRollbackCommitComment )
    {
        this.scmRollbackCommitComment = scmRollbackCommitComment;
    } //-- void setScmRollbackCommitComment( String )

    /**
     * Set get whether to use a shallow clone with no history or a
     * full clone containing the full history during the
     *             release.
     * 
     * @param scmShallowClone a scmShallowClone object.
     */
    public void setScmShallowClone( boolean scmShallowClone )
    {
        this.scmShallowClone = scmShallowClone;
    } //-- void setScmShallowClone( boolean )

    /**
     * Set if the scm provider should use sign tags, for example
     * for git-exe the '--sign' argument would be used.
     * 
     * @param scmSignTags a scmSignTags object.
     */
    public void setScmSignTags( boolean scmSignTags )
    {
        this.scmSignTags = scmSignTags;
    } //-- void setScmSignTags( boolean )

    /**
     * Set this is a MavenSCM of where you're going to get the
     * sources to make the release with.
     *             Example:
     * scm:svn:https://svn.apache.org/repos/asf/maven/plugins/trunk/maven-release-plugin.
     * 
     * @param scmSourceUrl a scmSourceUrl object.
     */
    public void setScmSourceUrl( String scmSourceUrl )
    {
        this.scmSourceUrl = scmSourceUrl;
    } //-- void setScmSourceUrl( String )

    /**
     * Set where you are going to put your tagged sources
     *             Example
     * https://svn.apache.org/repos/asf/maven/plugins/tags.
     * 
     * @param scmTagBase a scmTagBase object.
     */
    public void setScmTagBase( String scmTagBase )
    {
        this.scmTagBase = scmTagBase;
    } //-- void setScmTagBase( String )

    /**
     * Set specifies the format for generating a tag name. Property
     * expansion is
     *             used with the optional prefix of project, where
     * properties are delimited
     *             with @{ and }.
     * 
     * @param scmTagNameFormat a scmTagNameFormat object.
     */
    public void setScmTagNameFormat( String scmTagNameFormat )
    {
        this.scmTagNameFormat = scmTagNameFormat;
    } //-- void setScmTagNameFormat( String )

    /**
     * Set whether to use edit mode when making SCM modifications.
     * This setting is disregarded
     *             if the SCM does not support edit mode, or if
     * edit mode is compulsory for the given SCM.
     * 
     * @param scmUseEditMode a scmUseEditMode object.
     */
    public void setScmUseEditMode( boolean scmUseEditMode )
    {
        this.scmUseEditMode = scmUseEditMode;
    } //-- void setScmUseEditMode( boolean )

    /**
     * Set the user name to interact with the scm.
     * 
     * @param scmUsername a scmUsername object.
     */
    public void setScmUsername( String scmUsername )
    {
        this.scmUsername = scmUsername;
    } //-- void setScmUsername( String )

    /**
     * Set whether a SNAPSHOT of the release plugin is allowed.
     * 
     * @param snapshotReleasePluginAllowed a
     * snapshotReleasePluginAllowed object.
     */
    public void setSnapshotReleasePluginAllowed( boolean snapshotReleasePluginAllowed )
    {
        this.snapshotReleasePluginAllowed = snapshotReleasePluginAllowed;
    } //-- void setSnapshotReleasePluginAllowed( boolean )

    /**
     * Set whether to suppress a commit of changes to the working
     * copy before a tag or branch is created.
     * 
     * @param suppressCommitBeforeTagOrBranch a
     * suppressCommitBeforeTagOrBranch object.
     */
    public void setSuppressCommitBeforeTagOrBranch( boolean suppressCommitBeforeTagOrBranch )
    {
        this.suppressCommitBeforeTagOrBranch = suppressCommitBeforeTagOrBranch;
    } //-- void setSuppressCommitBeforeTagOrBranch( boolean )

    /**
     * Set whether to update branch POM versions.
     * 
     * @param updateBranchVersions a updateBranchVersions object.
     */
    public void setUpdateBranchVersions( boolean updateBranchVersions )
    {
        this.updateBranchVersions = updateBranchVersions;
    } //-- void setUpdateBranchVersions( boolean )

    /**
     * Set if updateDependencies is false, dependencies version
     * won't be updated to the next development version.
     * 
     * @param updateDependencies a updateDependencies object.
     */
    public void setUpdateDependencies( boolean updateDependencies )
    {
        this.updateDependencies = updateDependencies;
    } //-- void setUpdateDependencies( boolean )

    /**
     * Set whether to update branch versions to SNAPSHOT.
     * 
     * @param updateVersionsToSnapshot a updateVersionsToSnapshot
     * object.
     */
    public void setUpdateVersionsToSnapshot( boolean updateVersionsToSnapshot )
    {
        this.updateVersionsToSnapshot = updateVersionsToSnapshot;
    } //-- void setUpdateVersionsToSnapshot( boolean )

    /**
     * Set whether to update working copy POM versions.
     * 
     * @param updateWorkingCopyVersions a updateWorkingCopyVersions
     * object.
     */
    public void setUpdateWorkingCopyVersions( boolean updateWorkingCopyVersions )
    {
        this.updateWorkingCopyVersions = updateWorkingCopyVersions;
    } //-- void setUpdateWorkingCopyVersions( boolean )

    /**
     * Set whether to use the release profile that adds sources and
     * javadocs to the released artifact, if appropriate.
     *             If set to true, this will set the property
     * "performRelease" to true.
     * 
     * @param useReleaseProfile a useReleaseProfile object.
     */
    public void setUseReleaseProfile( boolean useReleaseProfile )
    {
        this.useReleaseProfile = useReleaseProfile;
    } //-- void setUseReleaseProfile( boolean )

    /**
     * Set wait the specified number of seconds before creating a
     * tag.
     * 
     * @param waitBeforeTagging a waitBeforeTagging object.
     */
    public void setWaitBeforeTagging( int waitBeforeTagging )
    {
        this.waitBeforeTagging = waitBeforeTagging;
    } //-- void setWaitBeforeTagging( int )

    /**
     * Set some SCMs may require a Work Item or a Task to allow the
     * changes to be pushed or delivered.
     *             This field allows you to specify that Work Item
     * or Task. It is optional, and only relevant
     *             if pushChanges is true.
     * 
     * @param workItem a workItem object.
     */
    public void setWorkItem( String workItem )
    {
        this.workItem = workItem;
    } //-- void setWorkItem( String )

    /**
     * Set the directory where the release is performed.
     * 
     * @param workingDirectory a workingDirectory object.
     */
    public void setWorkingDirectory( String workingDirectory )
    {
        this.workingDirectory = workingDirectory;
    } //-- void setWorkingDirectory( String )

    
    /**
     * Field resolvedSnapshotDependencies.
     */
    private java.util.Map<String, ReleaseStageVersions> resolvedSnapshotDependencies = new java.util.HashMap<>();

    /**
     * Field projectVersions
     */
    private java.util.Map<String, ReleaseStageVersions> projectVersions = new java.util.HashMap<>();
    
    /**
     * Field originalScmInfo.
     */
    private java.util.Map<String, org.apache.maven.model.Scm> originalScmInfo = new java.util.HashMap<>();
    
    
    java.util.Map<String, ReleaseStageVersions> getProjectVersions()
    {
        return projectVersions;
    }
    
    java.util.Map<String, org.apache.maven.model.Scm> getOriginalScmInfo()
    {
        return originalScmInfo;
    }
    
    /**
     * Method getResolvedSnapshotDependencies.
     * 
     * @return Map
     */
    java.util.Map<String, ReleaseStageVersions> getResolvedSnapshotDependencies()
    {
        return this.resolvedSnapshotDependencies;
    } //-- java.util.Map<String, ReleaseStageVersions> getResolvedSnapshotDependencies()

    public String getProjectReleaseVersion( String projectId )
    {
        if ( projectVersions.containsKey( projectId ) )
        {
            return projectVersions.get( projectId ).getRelease();
        }
        return null;
    }

    /**
     * Method addReleaseVersion.
     * 
     * @param projectId
     * @param version
     */
    public void addReleaseVersion( String projectId, String version )
    {
        computeIfAbsent( projectVersions, projectId ).setRelease( version ); 
    } //-- void addReleaseVersion( String, String )

    public String getProjectDevelopmentVersion( String projectId )
    {
        if ( projectVersions.containsKey( projectId ) )
        {
            return projectVersions.get( projectId ).getDevelopment();
        }
        return null;
    }

    /**
     * Method addDevelopmentVersion.
     * 
     * @param projectId
     * @param version
     */
    public void addDevelopmentVersion( String projectId, String version )
    {
        computeIfAbsent( projectVersions, projectId ).setDevelopment( version ); 
    } //-- void addDevelopmentVersion( String, String )

    /**
     * Method getOriginalScmInfo.
     * 
     * @return Scm
     */
    public org.apache.maven.model.Scm getOriginalScmInfo( String id )
    {
        return this.originalScmInfo.get( id );
    } //-- Scm getOriginalScmInfo( String)
    
    /**
     * Method hasOriginalScmInfo.
     * 
     * @return map contains
     */
    public boolean hasOriginalScmInfo( String id )
    {
        return this.originalScmInfo.containsKey( id );
    } //-- boolean hasOriginalScmInfo( String )

    /**
     * Method addOriginalScmInfo.
     * 
     * @param key
     * @param value
     */
    public void addOriginalScmInfo( String key, org.apache.maven.model.Scm value )
    {
        getOriginalScmInfo().put( key, value );
    } //-- void addOriginalScmInfo( String, org.apache.maven.model.Scm )

    public String getProjectOriginalVersion( String projectId )
    {
        if ( projectVersions.containsKey( projectId ) )
        {
            return projectVersions.get( projectId ).getOriginal();
        }
        return null;
    }
    
    public void addOriginalVersion( String projectId, String version )
    {
        computeIfAbsent( projectVersions, projectId ).setOriginal( version ); 
    }

    /**
     * Retrieve the release version for the resolved snapshot dependency.
     *
     */
    public String getDependencyDevelopmentVersion( String artifactConflictId )
    {
        if ( resolvedSnapshotDependencies.containsKey( artifactConflictId ) )
        {
            ReleaseStageVersions versionMap = resolvedSnapshotDependencies.get( artifactConflictId );
            return versionMap.getDevelopment();
        }
        return null;
    }

    /**
     * Retrieve the release version for the resolved snapshot dependency.
     *
     */
    public String getDependencyReleaseVersion( String artifactConflictId )
    {
        if ( resolvedSnapshotDependencies.containsKey( artifactConflictId ) )
        {
            ReleaseStageVersions versionMap = resolvedSnapshotDependencies.get( artifactConflictId );
            return versionMap.getRelease();
        }
        return null;
    }

    /**
     * Retrieve the original version for the resolved snapshot dependency.
     *
     */
    public String getDependencyOriginalVersion( String artifactConflictId )
    {
        if ( resolvedSnapshotDependencies.containsKey( artifactConflictId ) )
        {
            ReleaseStageVersions versionMap = resolvedSnapshotDependencies.get( artifactConflictId );
            return versionMap.getOriginal();
        }
        return null;
    }
    
    public void addDependencyOriginalVersion( String dependencyKey, String version )
    {
        computeIfAbsent( resolvedSnapshotDependencies, dependencyKey ).setOriginal( version );
    }

    public void addDependencyReleaseVersion( String dependencyKey, String version )
    {
        computeIfAbsent( resolvedSnapshotDependencies, dependencyKey ).setRelease( version );
    }

    public void addDependencyDevelopmentVersion( String dependencyKey, String version )
    {
        computeIfAbsent( resolvedSnapshotDependencies, dependencyKey ).setDevelopment( version );
    }
    
    private static ReleaseStageVersions computeIfAbsent( java.util.Map<String, ReleaseStageVersions> map, String key )
    {
        ReleaseStageVersions value = map.get( key );
        if ( value == null )
        {
            value = new ReleaseStageVersions();
            map.put( key, value );
        }
        return value;
    }

    @Override
    public boolean equals( Object obj )
    {
        if ( this == obj )
        {
            return true;
        }
        if ( obj == null || getClass() != obj.getClass() )
        {
            return false;
        }

        ModelloReleaseDescriptor that = (ModelloReleaseDescriptor) obj;

        if ( updateDependencies               != that.isUpdateDependencies()               ||
             useReleaseProfile                != that.isUseReleaseProfile()                ||
             autoVersionSubmodules            != that.isAutoVersionSubmodules()            ||
             snapshotReleasePluginAllowed     != that.isSnapshotReleasePluginAllowed()     ||
             commitByProject                  != that.isCommitByProject()                  ||
             branchCreation                   != that.isBranchCreation()                   ||
             updateBranchVersions             != that.isUpdateBranchVersions()             ||
             updateWorkingCopyVersions        != that.isUpdateWorkingCopyVersions()        ||
             suppressCommitBeforeTagOrBranch  != that.isSuppressCommitBeforeTagOrBranch()  ||
             updateVersionsToSnapshot         != that.isUpdateVersionsToSnapshot()         ||
             allowTimestampedSnapshots        != that.isAllowTimestampedSnapshots()        ||
             remoteTagging                    != that.isRemoteTagging()                    ||
             pinExternals                     != that.isPinExternals()                     ||
             localCheckout                    != that.isLocalCheckout()                    ||
             pushChanges                      != that.isPushChanges()
           )
           {
               return false;
           }

        if ( !java.util.Objects.equals( defaultDevelopmentVersion, that.getDefaultDevelopmentVersion() ) ||
             !java.util.Objects.equals( scmRelativePathProjectDirectory, that.getScmRelativePathProjectDirectory() ) ||
             !java.util.Objects.equals( checkoutDirectory, that.getCheckoutDirectory() ) ||
             !java.util.Objects.equals( performGoals, that.getPerformGoals() ) ||
             !java.util.Objects.equals( defaultReleaseVersion, that.getDefaultReleaseVersion() ) ||
             !java.util.Objects.equals( workItem, that.getWorkItem() ) ||
             !java.util.Objects.equals( scmReleasedPomRevision, that.getScmReleasedPomRevision() ) ||
             !java.util.Objects.equals( autoResolveSnapshots, that.getAutoResolveSnapshots() )
           )
        {
            return false;
        }

        if ( addSchema != that.isAddSchema() )
        {
            return false;
        }
        if ( generateReleasePoms != that.isGenerateReleasePoms() )
        {
            return false;
        }
        if ( interactive != that.isInteractive() )
        {
            return false;
        }
        if ( scmUseEditMode != that.isScmUseEditMode() )
        {
            return false;
        }
        if ( !java.util.Objects.equals( completedPhase, that.getCompletedPhase() ) )
        {
            return false;
        }
        if ( ( checkModificationExcludes == null || ( checkModificationExcludes != null && checkModificationExcludes.size() == 0) ) &&
            ( that.getCheckModificationExcludes() == null || ( that.getCheckModificationExcludes() != null && that.getCheckModificationExcludes().size() == 0 ) ) )
        {
            // Do nothing.  This is a Modello workaround
        }
        else
        {
            if ( checkModificationExcludes != null ? !checkModificationExcludes.equals( that.getCheckModificationExcludes() )
                : that.getCheckModificationExcludes() != null )
            {
                return false;
            }
        }
        if ( ( originalScmInfo == null || ( originalScmInfo != null && originalScmInfo.size() == 0 ) ) &&
            ( that.getOriginalScmInfo() == null || ( that.getOriginalScmInfo() != null && that.getOriginalScmInfo().size() == 0 ) ) )
        {
            // Do nothing.  This is a Modello workaround
        }
        else
        {
            if ( originalScmInfo != null ? !compareScmCollections( that.getOriginalScmInfo() ) : that.getOriginalScmInfo() != null )
            {
                return false;
            }
        }
        if ( !java.util.Objects.equals( additionalArguments, that.getAdditionalArguments() ) )
        {
            return false;
        }
        if ( !java.util.Objects.equals( preparationGoals, that.getPreparationGoals() ) )
        {
            return false;
        }
        if ( !java.util.Objects.equals( completionGoals, that.getCompletionGoals() ) )
        {
            return false;
        }
        if ( !java.util.Objects.equals( pomFileName, that.getPomFileName() ) )
        {
            return false;
        }
        if ( !java.util.Objects.equals( scmDevelopmentCommitComment, that.getScmDevelopmentCommitComment() ) )
        {
            return false;
        }
        if ( !java.util.Objects.equals( scmReleaseCommitComment, that.getScmReleaseCommitComment() ) )
        {
            return false;
        }
        if ( !java.util.Objects.equals( scmBranchCommitComment, that.getScmBranchCommitComment() ) )
        {
            return false;
        }
        if ( !java.util.Objects.equals( scmRollbackCommitComment, that.getScmRollbackCommitComment() ) )
        {
            return false;
        }
        if ( !java.util.Objects.equals( scmPrivateKeyPassPhrase, that.getScmPrivateKeyPassPhrase() ) )
        {
            return false;
        }
        if ( !java.util.Objects.equals( scmPassword, that.getScmPassword() ) )
        {
            return false;
        }
        if ( !java.util.Objects.equals( scmPrivateKey, that.getScmPrivateKey() ) )
        {
            return false;
        }
        if ( !java.util.Objects.equals( scmReleaseLabel, that.getScmReleaseLabel() ) )
        {
            return false;
        }
        if ( !java.util.Objects.equals( scmTagBase, that.getScmTagBase() ) )
        {
            return false;
        }
        if ( !java.util.Objects.equals( scmBranchBase, that.getScmBranchBase() ) )
        {
            return false;
        }
        if ( !java.util.Objects.equals( scmId, that.getScmId() ) )
        {
            return false;
        }
        if ( !java.util.Objects.equals( scmSourceUrl, that.getScmSourceUrl() ) )
        {
            return false;
        }
        if ( !java.util.Objects.equals( scmUsername, that.getScmUsername() ) )
        {
            return false;
        }
        if ( !java.util.Objects.equals( workingDirectory, that.getWorkingDirectory() ) )
        {
            return false;
        }
        if ( !java.util.Objects.equals( scmTagNameFormat, that.getScmTagNameFormat() ) )
        {
            return false;
        }
        if ( !java.util.Objects.deepEquals( projectVersions, that.getProjectVersions() ) )
        {
            return false;
        }

        return true;
    }

    private boolean compareScmCollections( java.util.Map<String, org.apache.maven.model.Scm> that )
    {
        // Must manually compare as Scm doesn't have an equals method
        if ( that == null && originalScmInfo == null )
        {
            return true;
        }

        if ( ( that == null && originalScmInfo != null ) || ( that != null && originalScmInfo == null ) )
        {
            return false;
        }

        if ( that.size() != originalScmInfo.size() )
        {
            return false;
        }

        for ( java.util.Iterator<java.util.Map.Entry<String, org.apache.maven.model.Scm>> i = originalScmInfo.entrySet().iterator(); i.hasNext(); )
        {
            java.util.Map.Entry<String, org.apache.maven.model.Scm> entry = i.next();

            org.apache.maven.model.Scm thatScm = that.get( entry.getKey() );

            org.apache.maven.model.Scm thisScm = entry.getValue();
            if ( thatScm == null && thisScm == null )
            {
                return true;
            }
            else if ( thatScm == null )
            {
                return false;
            }
            else if ( thisScm == null )
            {
                return true;
            }

            if ( thisScm.getConnection() != null ? !thisScm.getConnection().equals( thatScm.getConnection() )
                : thatScm.getConnection() != null )
            {
                return false;
            }
            if ( thisScm.getDeveloperConnection() != null ? !thisScm.getDeveloperConnection().equals(
                thatScm.getDeveloperConnection() ) : thatScm.getDeveloperConnection() != null )
            {
                return false;
            }
            if ( thisScm.getUrl() != null ? !thisScm.getUrl().equals( thatScm.getUrl() ) : thatScm.getUrl() != null )
            {
                return false;
            }
            if ( thisScm.getTag() != null ? !thisScm.getTag().equals( thatScm.getTag() ) : thatScm.getTag() != null )
            {
                return false;
            }

            if ( thisScm instanceof org.apache.maven.shared.release.scm.IdentifiedScm && thatScm instanceof org.apache.maven.shared.release.scm.IdentifiedScm )
            {
                org.apache.maven.shared.release.scm.IdentifiedScm thisIdentifiedScm = (org.apache.maven.shared.release.scm.IdentifiedScm) thisScm;
                org.apache.maven.shared.release.scm.IdentifiedScm thatIdentifiedScm = (org.apache.maven.shared.release.scm.IdentifiedScm) thatScm;
                if ( thisIdentifiedScm.getId() != null ? !thisIdentifiedScm.getId().equals( thatIdentifiedScm.getId() ) : thatIdentifiedScm.getId() != null )
                {
                    return false;
                }
            }
        }

        return true;
    }

    @Override
    public int hashCode()
    {
        int result = java.util.Objects.hashCode( completedPhase );
        result = 29 * result + java.util.Objects.hashCode( scmReleaseLabel );
        result = 29 * result + java.util.Objects.hashCode( additionalArguments );
        result = 29 * result + java.util.Objects.hashCode( preparationGoals );
        result = 29 * result + java.util.Objects.hashCode( completionGoals );
        result = 29 * result + java.util.Objects.hashCode( pomFileName );
        result = 29 * result + java.util.Objects.hashCode( checkModificationExcludes );
        result = 29 * result + java.util.Objects.hashCode( scmDevelopmentCommitComment );
        result = 29 * result + java.util.Objects.hashCode( scmReleaseCommitComment );
        result = 29 * result + java.util.Objects.hashCode( scmBranchCommitComment );
        result = 29 * result + java.util.Objects.hashCode( scmRollbackCommitComment );
        result = 29 * result + java.util.Objects.hashCode( scmTagBase );
        result = 29 * result + java.util.Objects.hashCode( scmBranchBase );
        result = 29 * result + java.util.Objects.hashCode( scmUsername );
        result = 29 * result + java.util.Objects.hashCode( scmPassword  );
        result = 29 * result + java.util.Objects.hashCode( scmId );
        result = 29 * result + java.util.Objects.hashCode( scmSourceUrl );
        result = 29 * result + java.util.Objects.hashCode( scmPrivateKey );
        result = 29 * result + java.util.Objects.hashCode( scmPrivateKeyPassPhrase );
        result = 29 * result + java.util.Objects.hashCode( workingDirectory );
        result = 29 * result + java.util.Objects.hashCode( scmUseEditMode );
        result = 29 * result + java.util.Objects.hashCode( addSchema );
        result = 29 * result + java.util.Objects.hashCode( generateReleasePoms );
        result = 29 * result + java.util.Objects.hashCode( interactive );
        result = 29 * result + java.util.Objects.hashCode( projectVersions );
        result = 29 * result + java.util.Objects.hashCode( originalScmInfo  );
        result = 29 * result + java.util.Objects.hashCode( updateDependencies );
        result = 29 * result + java.util.Objects.hashCode( useReleaseProfile );
        result = 29 * result + java.util.Objects.hashCode( autoVersionSubmodules );
        result = 29 * result + java.util.Objects.hashCode( snapshotReleasePluginAllowed );
        result = 29 * result + java.util.Objects.hashCode( commitByProject );
        result = 29 * result + java.util.Objects.hashCode( branchCreation );
        result = 29 * result + java.util.Objects.hashCode( updateBranchVersions );
        result = 29 * result + java.util.Objects.hashCode( updateWorkingCopyVersions );
        result = 29 * result + java.util.Objects.hashCode( suppressCommitBeforeTagOrBranch );
        result = 29 * result + java.util.Objects.hashCode( updateVersionsToSnapshot );
        result = 29 * result + java.util.Objects.hashCode( allowTimestampedSnapshots );
        result = 29 * result + java.util.Objects.hashCode( remoteTagging );
        result = 29 * result + java.util.Objects.hashCode( localCheckout );
        result = 29 * result + java.util.Objects.hashCode( pushChanges );
        result = 29 * result + java.util.Objects.hashCode( defaultDevelopmentVersion  );
        result = 29 * result + java.util.Objects.hashCode( scmRelativePathProjectDirectory );
        result = 29 * result + java.util.Objects.hashCode( checkoutDirectory );
        result = 29 * result + java.util.Objects.hashCode( performGoals );
        result = 29 * result + java.util.Objects.hashCode( defaultReleaseVersion );
        result = 29 * result + java.util.Objects.hashCode( scmReleasedPomRevision );
        result = 29 * result + java.util.Objects.hashCode( workItem );
        result = 29 * result + java.util.Objects.hashCode( autoResolveSnapshots );
        result = 29 * result + java.util.Objects.hashCode( pinExternals );

        return result;
    }

}
