/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.maven.scm.log.ScmLogger;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.StreamConsumer;

public abstract class AbstractConsumer
implements StreamConsumer {
    private ScmLogger logger;

    public AbstractConsumer(ScmLogger logger) {
        this.setLogger(logger);
    }

    public ScmLogger getLogger() {
        return this.logger;
    }

    public void setLogger(ScmLogger logger) {
        this.logger = logger;
    }

    protected Date parseDate(String date, String userPattern, String defaultPattern) {
        return this.parseDate(date, userPattern, defaultPattern, null);
    }

    protected Date parseDate(String date, String userPattern, String defaultPattern, Locale locale) {
        DateFormat format;
        String patternUsed = null;
        Locale localeUsed = null;
        if (StringUtils.isNotEmpty((String)userPattern)) {
            if (locale != null) {
                format = new SimpleDateFormat(userPattern, locale);
                localeUsed = locale;
            } else {
                format = new SimpleDateFormat(userPattern);
                localeUsed = Locale.getDefault();
            }
            patternUsed = userPattern;
        } else if (StringUtils.isNotEmpty((String)defaultPattern)) {
            if (locale != null) {
                format = new SimpleDateFormat(defaultPattern, locale);
                localeUsed = locale;
            } else {
                format = new SimpleDateFormat(defaultPattern);
                localeUsed = Locale.getDefault();
            }
            patternUsed = defaultPattern;
        } else {
            format = DateFormat.getDateInstance(3, Locale.ENGLISH);
            patternUsed = "DateFormat.SHORT";
            localeUsed = Locale.ENGLISH;
        }
        try {
            return format.parse(date);
        }
        catch (ParseException e) {
            if (this.getLogger() != null && this.getLogger().isWarnEnabled()) {
                this.getLogger().warn("skip ParseException: " + e.getMessage() + " during parsing date '" + date + "' with pattern '" + patternUsed + "' and locale '" + localeUsed + "'", e);
            }
            return null;
        }
    }
}

