/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.cvslib;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.log.ScmLogger;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class AbstractCvsConsumer
implements StreamConsumer {
    private List files = new ArrayList();
    private List allowedCodes = new ArrayList();
    private ScmLogger logger;

    public AbstractCvsConsumer(ScmLogger logger) {
        this.logger = logger;
    }

    public void consumeLine(String line) {
        if (line.length() < 3) {
            this.getLogger().warn("Unable to parse output from command: line length must be bigger than 3.");
        }
        String status = line.substring(0, 2);
        String file = line.substring(2);
        if (!this.allowedCodes.contains(status)) {
            this.getLogger().warn("Unexpected file status: '" + status.charAt(0) + "'.");
            return;
        }
        if (status.equals("U ")) {
            this.files.add(new ScmFile(file, ScmFileStatus.UPDATED));
        } else if (status.equals("P ")) {
            this.files.add(new ScmFile(file, ScmFileStatus.PATCHED));
        } else if (status.equals("C ")) {
            this.files.add(new ScmFile(file, ScmFileStatus.CONFLICT));
        } else {
            this.getLogger().warn("Unknown status: '" + status + "'.");
        }
    }

    protected ScmLogger getLogger() {
        return this.logger;
    }

    public List getFiles() {
        return this.files;
    }

    public void allowCode(char code) {
        this.allowedCodes.add(Character.toString(Character.toUpperCase(code)) + " ");
    }
}

