/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.cvslib.command.tag;

import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.tag.AbstractTagCommand;
import org.apache.maven.scm.command.tag.TagScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.cvslib.command.CvsCommand;
import org.apache.maven.scm.provider.cvslib.command.tag.CvsTagConsumer;
import org.apache.maven.scm.provider.cvslib.repository.CvsScmProviderRepository;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class CvsTagCommand
extends AbstractTagCommand
implements CvsCommand {
    public ScmResult executeTagCommand(ScmProviderRepository repo, ScmFileSet fileSet, String tag) throws ScmException {
        int exitCode;
        CvsScmProviderRepository repository = (CvsScmProviderRepository)repo;
        Commandline cl = new Commandline();
        cl.setExecutable("cvs");
        cl.setWorkingDirectory(fileSet.getBasedir().getAbsolutePath());
        cl.createArgument().setValue("-f");
        cl.createArgument().setValue("-d");
        cl.createArgument().setValue(repository.getCvsRoot());
        cl.createArgument().setValue("-q");
        cl.createArgument().setValue("tag");
        cl.createArgument().setValue("-F");
        cl.createArgument().setValue("-c");
        cl.createArgument().setValue(tag);
        CvsTagConsumer consumer = new CvsTagConsumer(this.getLogger());
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        this.getLogger().debug("Working directory: " + fileSet.getBasedir().getAbsolutePath());
        this.getLogger().debug("Command line: " + cl);
        try {
            exitCode = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)consumer, (StreamConsumer)stderr);
        }
        catch (CommandLineException ex) {
            throw new ScmException("Error while executing command.", (Throwable)ex);
        }
        if (exitCode != 0) {
            return new TagScmResult(cl.toString(), "The cvs tag command failed.", stderr.getOutput(), false);
        }
        return new TagScmResult(cl.toString(), consumer.getTaggedFiles());
    }
}

