/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.cvslib.repository;

import org.apache.maven.scm.provider.ScmProviderRepository;

public class CvsScmProviderRepository
extends ScmProviderRepository {
    private String cvsroot;
    private String transport;
    private String host;
    private int port;
    private String path;
    private String module;

    public CvsScmProviderRepository(String cvsroot, String transport, String user, String password, String host, String path, String module) {
        this(cvsroot, transport, user, password, host, -1, path, module);
    }

    public CvsScmProviderRepository(String cvsroot, String transport, String user, String password, String host, int port, String path, String module) {
        this.cvsroot = cvsroot;
        this.transport = transport;
        this.setUser(user);
        this.setPassword(password);
        this.host = host;
        this.port = port;
        this.path = path;
        this.module = module;
    }

    public String getCvsRoot() {
        String root = this.cvsroot;
        if (root != null && root.indexOf(":2401") > 0) {
            root = root.substring(0, root.indexOf(":2401")) + ":" + root.substring(root.indexOf(":2401") + 5);
        }
        return root;
    }

    public String getCvsRootForCvsPass() {
        return this.cvsroot;
    }

    public String getTransport() {
        return this.transport;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getPath() {
        return this.path;
    }

    public String getModule() {
        return this.module;
    }
}

