/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.perforce.command.checkin;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.List;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.checkin.AbstractCheckInCommand;
import org.apache.maven.scm.command.checkin.CheckInScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.perforce.PerforceScmProvider;
import org.apache.maven.scm.provider.perforce.command.PerforceCommand;
import org.apache.maven.scm.provider.perforce.command.checkin.PerforceCheckInConsumer;
import org.apache.maven.scm.provider.perforce.repository.PerforceScmProviderRepository;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.Commandline;

public class PerforceCheckInCommand
extends AbstractCheckInCommand
implements PerforceCommand {
    private static final String NEWLINE = "\r\n";

    protected CheckInScmResult executeCheckInCommand(ScmProviderRepository repo, ScmFileSet files, String message, ScmVersion version) throws ScmException {
        Commandline cl = PerforceCheckInCommand.createCommandLine((PerforceScmProviderRepository)repo, files.getBasedir());
        PerforceCheckInConsumer consumer = new PerforceCheckInConsumer();
        try {
            String line;
            this.getLogger().debug(PerforceScmProvider.clean("Executing " + cl.toString()));
            Process proc = cl.execute();
            OutputStream out = proc.getOutputStream();
            DataOutputStream dos = new DataOutputStream(out);
            PerforceScmProviderRepository prepo = (PerforceScmProviderRepository)repo;
            String changes = PerforceCheckInCommand.createChangeListSpecification(prepo, files, message, PerforceScmProvider.getRepoPath(this.getLogger(), prepo, files.getBasedir()));
            this.getLogger().debug("Sending changelist:\n" + changes);
            dos.write(changes.getBytes());
            dos.close();
            out.close();
            BufferedReader br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            while ((line = br.readLine()) != null) {
                this.getLogger().debug("Consuming: " + line);
                consumer.consumeLine(line);
            }
        }
        catch (CommandLineException e) {
            this.getLogger().error((Throwable)e);
        }
        catch (IOException e) {
            this.getLogger().error((Throwable)e);
        }
        return new CheckInScmResult(cl.toString(), consumer.isSuccess() ? "Checkin successful" : "Unable to submit", consumer.getOutput(), consumer.isSuccess());
    }

    public static Commandline createCommandLine(PerforceScmProviderRepository repo, File workingDirectory) {
        Commandline command = PerforceScmProvider.createP4Command(repo, workingDirectory);
        command.createArgument().setValue("submit");
        command.createArgument().setValue("-i");
        return command;
    }

    public static String createChangeListSpecification(PerforceScmProviderRepository repo, ScmFileSet files, String msg, String canonicalPath) {
        StringBuffer buf = new StringBuffer();
        buf.append("Change: new").append(NEWLINE).append(NEWLINE);
        buf.append("Description:").append(NEWLINE).append("\t").append(msg).append(NEWLINE).append(NEWLINE);
        buf.append("Files:").append(NEWLINE);
        try {
            HashSet<String> dupes = new HashSet<String>();
            File workingDir = files.getBasedir();
            String candir = workingDir.getCanonicalPath();
            List fs = files.getFileList();
            for (int i = 0; i < fs.size(); ++i) {
                File file = (File)fs.get(i);
                String canfile = file.getCanonicalPath();
                if (dupes.contains(canfile)) {
                    System.err.println("Skipping duplicate file: " + file);
                    continue;
                }
                dupes.add(canfile);
                if (canfile.startsWith(candir)) {
                    canfile = canfile.substring(candir.length() + 1);
                }
                buf.append("\t").append(canonicalPath).append("/").append(canfile.replace('\\', '/')).append(NEWLINE);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return buf.toString();
    }
}

