/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.perforce.command.status;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.command.status.AbstractStatusCommand;
import org.apache.maven.scm.command.status.StatusScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.perforce.PerforceScmProvider;
import org.apache.maven.scm.provider.perforce.command.PerforceCommand;
import org.apache.maven.scm.provider.perforce.command.PerforceVerbMapper;
import org.apache.maven.scm.provider.perforce.command.status.PerforceStatusConsumer;
import org.apache.maven.scm.provider.perforce.repository.PerforceScmProviderRepository;
import org.apache.regexp.RE;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.Commandline;

public class PerforceStatusCommand
extends AbstractStatusCommand
implements PerforceCommand {
    private String actualLocation;

    protected StatusScmResult executeStatusCommand(ScmProviderRepository repo, ScmFileSet files) throws ScmException {
        PerforceScmProviderRepository prepo = (PerforceScmProviderRepository)repo;
        this.actualLocation = PerforceScmProvider.getRepoPath(this.getLogger(), prepo, files.getBasedir());
        PerforceStatusConsumer consumer = new PerforceStatusConsumer();
        Commandline command = this.readOpened(prepo, files, consumer);
        if (consumer.isSuccess()) {
            List scmfiles = PerforceStatusCommand.createResults(this.actualLocation, consumer);
            return new StatusScmResult(command.toString(), scmfiles);
        }
        return new StatusScmResult(command.toString(), "Unable to get status", consumer.getOutput(), consumer.isSuccess());
    }

    public static List createResults(String repoPath, PerforceStatusConsumer consumer) {
        ArrayList<ScmFile> results = new ArrayList<ScmFile>();
        List files = consumer.getDepotfiles();
        RE re = new RE("([^#]+)#\\d+ - ([^ ]+) .*");
        Iterator it = files.iterator();
        while (it.hasNext()) {
            String filepath = (String)it.next();
            if (!re.match(filepath)) {
                System.err.println("Skipping " + filepath);
                continue;
            }
            String path = re.getParen(1);
            String verb = re.getParen(2);
            ScmFile scmfile = new ScmFile(path.substring(repoPath.length() + 1).trim(), PerforceVerbMapper.toStatus(verb));
            results.add(scmfile);
        }
        return results;
    }

    private Commandline readOpened(PerforceScmProviderRepository prepo, ScmFileSet files, PerforceStatusConsumer consumer) {
        Commandline cl = PerforceStatusCommand.createOpenedCommandLine(prepo, files.getBasedir(), this.actualLocation);
        try {
            String line;
            this.getLogger().debug(PerforceScmProvider.clean("Executing " + cl.toString()));
            Process proc = cl.execute();
            BufferedReader br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            while ((line = br.readLine()) != null) {
                this.getLogger().debug("Reading " + line);
                consumer.consumeLine(line);
            }
            br.close();
        }
        catch (CommandLineException e) {
            this.getLogger().error((Throwable)e);
        }
        catch (IOException e) {
            this.getLogger().error((Throwable)e);
        }
        return cl;
    }

    public static Commandline createOpenedCommandLine(PerforceScmProviderRepository repo, File workingDirectory, String location) {
        Commandline command = PerforceScmProvider.createP4Command(repo, workingDirectory);
        command.createArgument().setValue("opened");
        command.createArgument().setValue(PerforceScmProvider.getCanonicalRepoPath(location));
        return command;
    }
}

