/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.perforce.command.tag;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.List;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.tag.AbstractTagCommand;
import org.apache.maven.scm.command.tag.TagScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.perforce.PerforceScmProvider;
import org.apache.maven.scm.provider.perforce.command.PerforceCommand;
import org.apache.maven.scm.provider.perforce.command.PerforceInfoCommand;
import org.apache.maven.scm.provider.perforce.command.tag.PerforceTagConsumer;
import org.apache.maven.scm.provider.perforce.repository.PerforceScmProviderRepository;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.Commandline;

public class PerforceTagCommand
extends AbstractTagCommand
implements PerforceCommand {
    private String actualRepoLocation = null;
    private static final String NEWLINE = "\r\n";

    protected ScmResult executeTagCommand(ScmProviderRepository repo, ScmFileSet files, String tag, String message) throws ScmException {
        PerforceScmProviderRepository prepo = (PerforceScmProviderRepository)repo;
        this.actualRepoLocation = PerforceScmProvider.getRepoPath(this.getLogger(), prepo, files.getBasedir());
        PerforceTagConsumer consumer = new PerforceTagConsumer();
        this.createLabel(repo, files, tag, consumer, false);
        if (consumer.isSuccess()) {
            this.syncLabel(repo, files, tag, consumer);
        }
        if (consumer.isSuccess() && this.shouldLock()) {
            consumer = new PerforceTagConsumer();
            this.createLabel(repo, files, tag, consumer, true);
        }
        if (consumer.isSuccess()) {
            return new TagScmResult("p4 label -i", consumer.getTagged());
        }
        return new TagScmResult("p4 label -i", "Tag failed", consumer.getOutput(), false);
    }

    private boolean shouldLock() {
        return Boolean.valueOf(System.getProperty("maven.scm.locktag", "true"));
    }

    private void syncLabel(ScmProviderRepository repo, ScmFileSet files, String tag, PerforceTagConsumer consumer) {
        Commandline cl = PerforceTagCommand.createLabelsyncCommandLine((PerforceScmProviderRepository)repo, files.getBasedir(), files, tag);
        try {
            String line;
            this.getLogger().debug(PerforceScmProvider.clean("Executing: " + cl.toString()));
            Process proc = cl.execute();
            BufferedReader br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            while ((line = br.readLine()) != null) {
                this.getLogger().debug("Consuming: " + line);
                consumer.consumeLine(line);
            }
        }
        catch (CommandLineException e) {
            this.getLogger().error((Throwable)e);
        }
        catch (IOException e) {
            this.getLogger().error((Throwable)e);
        }
    }

    private void createLabel(ScmProviderRepository repo, ScmFileSet files, String tag, PerforceTagConsumer consumer, boolean lock) {
        Commandline cl = PerforceTagCommand.createLabelCommandLine((PerforceScmProviderRepository)repo, files.getBasedir());
        try {
            String line;
            this.getLogger().debug(PerforceScmProvider.clean("Executing: " + cl.toString()));
            Process proc = cl.execute();
            OutputStream out = proc.getOutputStream();
            DataOutputStream dos = new DataOutputStream(out);
            String label = this.createLabelSpecification((PerforceScmProviderRepository)repo, tag, lock);
            this.getLogger().debug("LabelSpec: \r\n" + label);
            dos.write(label.getBytes());
            dos.close();
            out.close();
            BufferedReader br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            while ((line = br.readLine()) != null) {
                this.getLogger().debug("Consuming: " + line);
                consumer.consumeLine(line);
            }
        }
        catch (CommandLineException e) {
            this.getLogger().error((Throwable)e);
        }
        catch (IOException e) {
            this.getLogger().error((Throwable)e);
        }
    }

    public static Commandline createLabelCommandLine(PerforceScmProviderRepository repo, File workingDirectory) {
        Commandline command = PerforceScmProvider.createP4Command(repo, workingDirectory);
        command.createArgument().setValue("label");
        command.createArgument().setValue("-i");
        return command;
    }

    public static Commandline createLabelsyncCommandLine(PerforceScmProviderRepository repo, File workingDirectory, ScmFileSet files, String tag) {
        Commandline command = PerforceScmProvider.createP4Command(repo, workingDirectory);
        command.createArgument().setValue("labelsync");
        command.createArgument().setValue("-l");
        command.createArgument().setValue(tag);
        List fs = files.getFileList();
        for (int i = 0; i < fs.size(); ++i) {
            File file = (File)fs.get(i);
            command.createArgument().setValue(file.getName());
        }
        return command;
    }

    public String createLabelSpecification(PerforceScmProviderRepository repo, String tag, boolean lock) {
        StringBuffer buf = new StringBuffer();
        buf.append("Label: ").append(tag).append(NEWLINE);
        buf.append("View: ").append(PerforceScmProvider.getCanonicalRepoPath(this.actualRepoLocation)).append(NEWLINE);
        String username = repo.getUser();
        if (username == null) {
            username = PerforceInfoCommand.getInfo(this.getLogger(), repo).getEntry("User name");
        }
        buf.append("Owner: ").append(username).append(NEWLINE);
        buf.append("Options: ").append(lock ? "" : "un").append("locked").append(NEWLINE);
        return buf.toString();
    }
}

