/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.booterclient;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.apache.maven.plugin.surefire.SurefireProperties;
import org.apache.maven.plugin.surefire.booterclient.ForkConfiguration;
import org.apache.maven.surefire.booter.ClassLoaderConfiguration;
import org.apache.maven.surefire.booter.ClasspathConfiguration;
import org.apache.maven.surefire.booter.KeyValueSource;
import org.apache.maven.surefire.booter.ProviderConfiguration;
import org.apache.maven.surefire.booter.StartupConfiguration;
import org.apache.maven.surefire.booter.SystemPropertyManager;
import org.apache.maven.surefire.report.ReporterConfiguration;
import org.apache.maven.surefire.testset.DirectoryScannerParameters;
import org.apache.maven.surefire.testset.RunOrderParameters;
import org.apache.maven.surefire.testset.TestArtifactInfo;
import org.apache.maven.surefire.testset.TestListResolver;
import org.apache.maven.surefire.testset.TestRequest;
import org.apache.maven.surefire.util.RunOrder;

class BooterSerializer {
    private final ForkConfiguration forkConfiguration;

    BooterSerializer(ForkConfiguration forkConfiguration) {
        this.forkConfiguration = forkConfiguration;
    }

    File serialize(KeyValueSource sourceProperties, ProviderConfiguration booterConfiguration, StartupConfiguration providerConfiguration, Object testSet, boolean readTestsFromInStream) throws IOException {
        RunOrderParameters runOrderParameters;
        DirectoryScannerParameters directoryScannerParameters;
        SurefireProperties properties = new SurefireProperties(sourceProperties);
        ClasspathConfiguration cp = providerConfiguration.getClasspathConfiguration();
        properties.setClasspath("classPathUrl.", cp.getTestClasspath());
        properties.setClasspath("surefireClassPathUrl.", cp.getProviderClasspath());
        properties.setProperty("enableAssertions", String.valueOf(cp.isEnableAssertions()));
        properties.setProperty("childDelegation", String.valueOf(cp.isChildDelegation()));
        TestArtifactInfo testNg = booterConfiguration.getTestArtifact();
        if (testNg != null) {
            properties.setProperty("testFwJarVersion", testNg.getVersion());
            properties.setNullableProperty("testFwJarClassifier", testNg.getClassifier());
        }
        properties.setProperty("preferTestsFromInStream", readTestsFromInStream);
        properties.setNullableProperty("forkTestSet", this.getTypeEncoded(testSet));
        TestRequest testSuiteDefinition = booterConfiguration.getTestSuiteDefinition();
        if (testSuiteDefinition != null) {
            properties.setProperty("testSuiteDefinitionTestSourceDirectory", testSuiteDefinition.getTestSourceDirectory());
            properties.addList(testSuiteDefinition.getSuiteXmlFiles(), "testSuiteXmlFiles");
            TestListResolver testFilter = testSuiteDefinition.getTestListResolver();
            properties.setProperty("requestedTest", testFilter == null ? "" : testFilter.getPluginParameterTest());
            properties.setNullableProperty("rerunFailingTestsCount", String.valueOf(testSuiteDefinition.getRerunFailingTestsCount()));
        }
        if ((directoryScannerParameters = booterConfiguration.getDirScannerParams()) != null) {
            properties.setProperty("failIfNoTests", String.valueOf(directoryScannerParameters.isFailIfNoTests()));
            properties.addList(directoryScannerParameters.getIncludes(), "includes");
            properties.addList(directoryScannerParameters.getExcludes(), "excludes");
            properties.addList(directoryScannerParameters.getSpecificTests(), "specificTest");
            properties.setProperty("testClassesDirectory", directoryScannerParameters.getTestClassesDirectory());
        }
        if ((runOrderParameters = booterConfiguration.getRunOrderParameters()) != null) {
            properties.setProperty("runOrder", RunOrder.asString((RunOrder[])runOrderParameters.getRunOrder()));
            properties.setProperty("runStatisticsFile", runOrderParameters.getRunStatisticsFile());
        }
        ReporterConfiguration reporterConfiguration = booterConfiguration.getReporterConfiguration();
        boolean rep = reporterConfiguration.isTrimStackTrace();
        properties.setProperty("isTrimStackTrace", rep);
        properties.setProperty("reportsDirectory", reporterConfiguration.getReportsDirectory());
        ClassLoaderConfiguration classLoaderConfig = providerConfiguration.getClassLoaderConfiguration();
        properties.setProperty("useSystemClassLoader", String.valueOf(classLoaderConfig.isUseSystemClassLoader()));
        properties.setProperty("useManifestOnlyJar", String.valueOf(classLoaderConfig.isUseManifestOnlyJar()));
        properties.setProperty("failIfNoTests", String.valueOf(booterConfiguration.isFailIfNoTests()));
        properties.setProperty("providerConfiguration", providerConfiguration.getProviderClassName());
        properties.setProperty("failFastCount", String.valueOf(booterConfiguration.getSkipAfterFailureCount()));
        properties.setProperty("shutdown", booterConfiguration.getShutdown().name());
        List mainCliOptions = booterConfiguration.getMainCliOptions();
        if (mainCliOptions != null) {
            properties.addList(mainCliOptions, "mainCliOptions");
        }
        properties.setNullableProperty("systemExitTimeout", String.valueOf(booterConfiguration.getSystemExitTimeout()));
        return SystemPropertyManager.writePropertiesFile((Properties)properties, (File)this.forkConfiguration.getTempDirectory(), (String)"surefire", (boolean)this.forkConfiguration.isDebug());
    }

    private String getTypeEncoded(Object value) {
        if (value == null) {
            return null;
        }
        String valueToUse = value instanceof Class ? ((Class)value).getName() : value.toString();
        return value.getClass().getName() + "|" + valueToUse;
    }
}

