/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.ajax.api;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.application.StateManager;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.component.html.ext.UIComponentPerspective;
import org.apache.myfaces.custom.ajax.api.AjaxComponent;
import org.apache.myfaces.custom.ajax.api.ComponentNotFoundException;
import org.apache.myfaces.custom.ajax.api.DeprecatedAjaxComponent;
import org.apache.myfaces.custom.ajax.util.AjaxRendererUtils;
import org.apache.myfaces.custom.inputAjax.HtmlCommandButtonAjax;
import org.apache.myfaces.custom.util.URIComponentUtils;
import org.apache.myfaces.shared_tomahawk.component.ExecuteOnCallback;
import org.apache.myfaces.shared_tomahawk.renderkit.RendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlResponseWriterImpl;
import org.apache.myfaces.shared_tomahawk.renderkit.html.util.FormInfo;

public class AjaxDecodePhaseListener
implements PhaseListener {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$myfaces$custom$ajax$api$AjaxDecodePhaseListener == null ? (class$org$apache$myfaces$custom$ajax$api$AjaxDecodePhaseListener = AjaxDecodePhaseListener.class$("org.apache.myfaces.custom.ajax.api.AjaxDecodePhaseListener")) : class$org$apache$myfaces$custom$ajax$api$AjaxDecodePhaseListener));
    static /* synthetic */ Class class$org$apache$myfaces$custom$ajax$api$AjaxDecodePhaseListener;

    public PhaseId getPhaseId() {
        return PhaseId.APPLY_REQUEST_VALUES;
    }

    public void beforePhase(PhaseEvent event) {
        log.debug((Object)"In AjaxDecodePhaseListener beforePhase");
        FacesContext context = event.getFacesContext();
        Map externalRequestMap = context.getExternalContext().getRequestParameterMap();
        if (externalRequestMap.containsKey("affectedAjaxComponent")) {
            String affectedAjaxComponent;
            UIViewRoot root = context.getViewRoot();
            UIComponent ajaxComponent = root.findComponent(affectedAjaxComponent = (String)context.getExternalContext().getRequestParameterMap().get("affectedAjaxComponent"));
            if (ajaxComponent instanceof UIComponentPerspective) {
                UIComponentPerspective componentPerspective = (UIComponentPerspective)ajaxComponent;
                ajaxComponent = (UIComponent)componentPerspective.executeOn(context, new ExecuteOnCallback(){

                    public Object execute(FacesContext facesContext, UIComponent ajaxComponent) {
                        AjaxDecodePhaseListener.this.handleAjaxRequest(ajaxComponent, facesContext);
                        return ajaxComponent;
                    }
                });
            } else {
                this.handleAjaxRequest(ajaxComponent, context);
            }
            StateManager stateManager = context.getApplication().getStateManager();
            if (!stateManager.isSavingStateInClient(context)) {
                stateManager.saveSerializedView(context);
            }
            context.responseComplete();
        }
    }

    private void handleAjaxRequest(UIComponent ajaxComponent, FacesContext facesContext) {
        String updateOnly = (String)facesContext.getExternalContext().getRequestParameterMap().get("updateOnly");
        if (updateOnly == null) {
            this.decodeAjax(ajaxComponent, facesContext);
            facesContext.getViewRoot().processApplication(facesContext);
        }
        this.encodeAjax(ajaxComponent, facesContext);
    }

    private void decodeAjax(UIComponent ajaxComponent, FacesContext context) {
        String affectedAjaxComponent = (String)context.getExternalContext().getRequestParameterMap().get("affectedAjaxComponent");
        if (ajaxComponent == null) {
            String msg = "Component with id [" + affectedAjaxComponent + "] not found in view tree.";
            log.error((Object)msg);
            throw new ComponentNotFoundException(msg);
        }
        log.debug((Object)("affectedAjaxComponent: " + ajaxComponent + " - " + ajaxComponent.getId()));
        if (ajaxComponent instanceof HtmlCommandButtonAjax) {
            FormInfo fi = RendererUtils.findNestingForm((UIComponent)ajaxComponent, (FacesContext)context);
            UIComponent form = fi.getForm();
            if (form != null) {
                form.processDecodes(context);
                form.processValidators(context);
                form.processUpdates(context);
            }
        } else if (ajaxComponent instanceof AjaxComponent) {
            try {
                ((AjaxComponent)ajaxComponent).decodeAjax(context);
            }
            catch (Exception e) {
                log.error((Object)"Exception while decoding ajax-request", (Throwable)e);
            }
        } else {
            log.error((Object)("Found component is no ajaxComponent : " + RendererUtils.getPathToComponent((UIComponent)ajaxComponent)));
        }
    }

    private void encodeAjax(UIComponent component, FacesContext context) {
        ServletResponse response = (ServletResponse)context.getExternalContext().getResponse();
        ServletRequest request = (ServletRequest)context.getExternalContext().getRequest();
        UIViewRoot viewRoot = context.getViewRoot();
        Map requestMap = context.getExternalContext().getRequestParameterMap();
        String charset = (String)requestMap.get("charset");
        response.setLocale(viewRoot.getLocale());
        if (component instanceof DeprecatedAjaxComponent) {
            try {
                String contentType = this.getContentType("text/xml", charset);
                response.setContentType(contentType);
                StringBuffer buff = new StringBuffer();
                buff.append("<?xml version=\"1.0\"?>\n");
                buff.append("<response>\n");
                PrintWriter out = response.getWriter();
                out.print(buff);
                context.setResponseWriter((ResponseWriter)new HtmlResponseWriterImpl((Writer)out, contentType, request.getCharacterEncoding()));
                if (component instanceof HtmlCommandButtonAjax) {
                    buff = new StringBuffer();
                    buff.append("<triggerComponent id=\"");
                    buff.append(component.getClientId(context));
                    buff.append("\" />\n");
                    out.print(buff);
                    FormInfo fi = RendererUtils.findNestingForm((UIComponent)component, (FacesContext)context);
                    UIComponent form = fi.getForm();
                    if (form != null) {
                        this.encodeChildren(form, context, requestMap);
                    }
                } else if (component instanceof AjaxComponent) {
                    ((AjaxComponent)component).encodeAjax(context);
                } else {
                    AjaxRendererUtils.encodeAjax(context, component);
                }
                out.print("</response>");
                out.flush();
            }
            catch (IOException e) {
                log.error((Object)"Exception while rendering ajax-response", (Throwable)e);
            }
        } else if (component instanceof AjaxComponent) {
            try {
                if (context.getResponseWriter() == null) {
                    String contentType = this.getContentType("text/html", charset);
                    response.setContentType(contentType);
                    PrintWriter writer = response.getWriter();
                    context.setResponseWriter((ResponseWriter)new HtmlResponseWriterImpl((Writer)writer, contentType, response.getCharacterEncoding()));
                }
                ((AjaxComponent)component).encodeAjax(context);
            }
            catch (IOException e) {
                log.error((Object)"Exception while rendering ajax-response", (Throwable)e);
            }
        }
    }

    private String getContentType(String contentType, String charset) {
        if (charset == null || charset.trim().length() == 0) {
            return contentType;
        }
        return contentType + ";charset=" + charset;
    }

    private void encodeChildren(UIComponent form, FacesContext context, Map requestMap) throws IOException {
        List formChildren = form.getChildren();
        for (int i = 0; i < formChildren.size(); ++i) {
            UIComponent uiComponent = (UIComponent)formChildren.get(i);
            if (requestMap.containsKey(uiComponent.getClientId(context))) {
                AjaxRendererUtils.encodeAjax(context, uiComponent);
            }
            this.encodeChildren(uiComponent, context, requestMap);
        }
    }

    public static String mapToString(Map map) {
        Set entries = map.entrySet();
        Iterator iter = entries.iterator();
        StringBuffer buff = new StringBuffer();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            buff.append("[" + entry.getKey() + "," + entry.getValue() + "]\n");
        }
        return buff.toString();
    }

    public static Object getValueForComponent(FacesContext context, UIComponent component) {
        Object encodedValue;
        String possibleClientId = component.getClientId(context);
        if (!context.getExternalContext().getRequestParameterMap().containsKey(possibleClientId)) {
            possibleClientId = (String)context.getExternalContext().getRequestParameterMap().get("affectedAjaxComponent");
            log.debug((Object)("affectedAjaxComponent: " + possibleClientId));
            UIViewRoot root = context.getViewRoot();
            UIComponent ajaxComponent = root.findComponent(possibleClientId);
            if (ajaxComponent instanceof UIComponentPerspective) {
                UIComponentPerspective componentPerspective = (UIComponentPerspective)ajaxComponent;
                ajaxComponent = (UIComponent)componentPerspective.executeOn(context, new ExecuteOnCallback(){

                    public Object execute(FacesContext facesContext, UIComponent uiComponent) {
                        return uiComponent;
                    }
                });
            }
            if (ajaxComponent != component) {
                log.error((Object)("No value found for this component : " + possibleClientId));
                return null;
            }
        }
        if ((encodedValue = context.getExternalContext().getRequestParameterMap().get(possibleClientId)) instanceof String) {
            return URIComponentUtils.decodeURIComponent((String)encodedValue);
        }
        return encodedValue;
    }

    public void afterPhase(PhaseEvent event) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

