/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.conversation;

import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.myfaces.custom.conversation.FakeMap;

public class ConversationExternalContext {
    private final Map requestMap;
    private final Map requestParameterMap;
    private final Map initParameterMap;

    protected ConversationExternalContext(Map initParameterMap, Map requestMap, Map requestParameterMap) {
        this.requestMap = requestMap;
        this.requestParameterMap = requestParameterMap;
        this.initParameterMap = initParameterMap;
    }

    public static ConversationExternalContext create(final ServletContext servletContext, final HttpServletRequest httpRequest) {
        FakeMap initParameterMap = new FakeMap(){

            public boolean containsKey(Object key) {
                return servletContext.getInitParameter((String)key) != null;
            }

            public Object get(Object key) {
                return servletContext.getInitParameter((String)key);
            }
        };
        FakeMap requestParameterMap = new FakeMap(){

            public boolean containsKey(Object key) {
                return httpRequest.getParameter((String)key) != null;
            }

            public Object get(Object key) {
                return httpRequest.getParameter((String)key);
            }
        };
        FakeMap requestMap = new FakeMap(){

            public boolean containsKey(Object key) {
                return httpRequest.getAttribute((String)key) != null;
            }

            public Object get(Object key) {
                return httpRequest.getAttribute((String)key);
            }

            public Object put(Object key, Object value) {
                Object prev = httpRequest.getAttribute((String)key);
                httpRequest.setAttribute((String)key, value);
                return prev;
            }
        };
        return new ConversationExternalContext(initParameterMap, requestMap, requestParameterMap);
    }

    public Map getRequestMap() {
        return this.requestMap;
    }

    public Map getRequestParameterMap() {
        return this.requestParameterMap;
    }

    public Map getInitParameterMap() {
        return this.initParameterMap;
    }
}

