/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.conversation;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.myfaces.custom.conversation.ConversationExternalContext;
import org.apache.myfaces.custom.conversation.ConversationManager;

public class ConversationServletFilter
implements Filter {
    public static final String CONVERSATION_FILTER_CALLED = "org.apache.myfaces.conversation.ConversationServletFilter.CALLED";
    private static final ThreadLocal externalContextTL = new ThreadLocal();
    private static final ThreadLocal conversationManagerTL = new ThreadLocal();
    private ServletContext servletContext;

    public void init(FilterConfig arg0) throws ServletException {
        this.servletContext = arg0.getServletContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        ConversationManager conversationManager = null;
        if (!Boolean.TRUE.equals(request.getAttribute(CONVERSATION_FILTER_CALLED))) {
            if (request instanceof HttpServletRequest) {
                HttpServletRequest httpRequest = (HttpServletRequest)request;
                externalContextTL.set(ConversationExternalContext.create(this.servletContext, httpRequest));
                HttpSession httpSession = httpRequest.getSession(false);
                if (httpSession != null && (conversationManager = ConversationManager.getInstance(httpSession)) != null) {
                    conversationManagerTL.set(conversationManager);
                    conversationManager.attachPersistence();
                }
            }
            request.setAttribute(CONVERSATION_FILTER_CALLED, (Object)Boolean.TRUE);
        }
        boolean ok = false;
        try {
            chain.doFilter(request, response);
            ok = true;
        }
        finally {
            if (conversationManager != null) {
                try {
                    if (!ok) {
                        conversationManager.purgePersistence();
                    } else {
                        conversationManager.detachPersistence();
                    }
                }
                finally {
                    externalContextTL.set(null);
                    conversationManagerTL.set(null);
                }
            }
        }
    }

    public void destroy() {
    }

    static ConversationExternalContext getConversationExternalContext() {
        return (ConversationExternalContext)externalContextTL.get();
    }

    static ConversationManager getConversationManager() {
        return (ConversationManager)conversationManagerTL.get();
    }
}

