/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.conversation;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import org.apache.myfaces.custom.conversation.AbstractConversationComponent;
import org.apache.myfaces.custom.conversation.ConversationUtils;
import org.apache.myfaces.custom.conversation.EndConversationMethodBindingFacade;
import org.apache.myfaces.shared_tomahawk.util.StringUtils;

public class UIEndConversation
extends AbstractConversationComponent {
    public static final String COMPONENT_TYPE = "org.apache.myfaces.EndConversation";
    private String onOutcome;
    private String errorOutcome;
    private Boolean restart;
    private MethodBinding restartAction;
    private boolean inited = false;

    public void encodeBegin(FacesContext context) throws IOException {
        super.encodeBegin(context);
        UICommand command = ConversationUtils.findParentCommand((UIComponent)this);
        if (command != null) {
            if (!this.inited) {
                MethodBinding original = command.getAction();
                command.setAction((MethodBinding)new EndConversationMethodBindingFacade(this.getName(), this.getOnOutcomes(), original, this.getErrorOutcome(), this.getRestart(), this.getRestartAction()));
                this.inited = true;
            }
        } else {
            ConversationUtils.endAndRestartConversation(context, this.getName(), this.getRestart(), this.getRestartAction());
        }
    }

    private Collection getOnOutcomes() {
        String onOutcome = this.getOnOutcome();
        if (onOutcome == null || onOutcome.trim().length() < 1) {
            return null;
        }
        return Arrays.asList(StringUtils.trim((String[])StringUtils.splitShortString((String)onOutcome, (char)',')));
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] states = (Object[])state;
        super.restoreState(context, states[0]);
        this.inited = (Boolean)states[1];
        this.onOutcome = (String)states[2];
        this.errorOutcome = (String)states[3];
        this.restart = (Boolean)states[4];
        this.restartAction = (MethodBinding)UIEndConversation.restoreAttachedState((FacesContext)context, (Object)states[5]);
    }

    public Object saveState(FacesContext context) {
        return new Object[]{super.saveState(context), this.inited ? Boolean.TRUE : Boolean.FALSE, this.onOutcome, this.errorOutcome, this.restart, UIEndConversation.saveAttachedState((FacesContext)context, (Object)this.restartAction)};
    }

    public String getOnOutcome() {
        if (this.onOutcome != null) {
            return this.onOutcome;
        }
        ValueBinding vb = this.getValueBinding("onOutcome");
        if (vb == null) {
            return null;
        }
        return (String)vb.getValue(this.getFacesContext());
    }

    public void setOnOutcome(String onOutcome) {
        this.onOutcome = onOutcome;
    }

    public String getErrorOutcome() {
        if (this.errorOutcome != null) {
            return this.errorOutcome;
        }
        ValueBinding vb = this.getValueBinding("errorOutcome");
        if (vb == null) {
            return null;
        }
        return (String)vb.getValue(this.getFacesContext());
    }

    public void setErrorOutcome(String errorOutcome) {
        this.errorOutcome = errorOutcome;
    }

    public Boolean getRestart() {
        if (this.restart != null) {
            return this.restart;
        }
        ValueBinding vb = this.getValueBinding("restart");
        if (vb == null) {
            return null;
        }
        return (Boolean)vb.getValue(this.getFacesContext());
    }

    public void setRestart(Boolean restart) {
        this.restart = restart;
    }

    public MethodBinding getRestartAction() {
        return this.restartAction;
    }

    public void setRestartAction(MethodBinding restartAction) {
        this.restartAction = restartAction;
    }
}

