/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.convertStringUtils;

import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;

public class StringUtilsConverter
implements Converter,
StateHolder {
    public static final String CONVERTER_ID = (class$org$apache$myfaces$custom$convertStringUtils$StringUtilsConverter == null ? (class$org$apache$myfaces$custom$convertStringUtils$StringUtilsConverter = StringUtilsConverter.class$("org.apache.myfaces.custom.convertStringUtils.StringUtilsConverter")) : class$org$apache$myfaces$custom$convertStringUtils$StringUtilsConverter).getName();
    protected boolean _transient;
    protected String format = null;
    protected Boolean trim = null;
    protected Integer maxLength = null;
    protected Boolean appendEllipsesDuringOutput = null;
    protected Boolean appendEllipsesDuringInput = null;
    static /* synthetic */ Class class$org$apache$myfaces$custom$convertStringUtils$StringUtilsConverter;

    public Object getAsObject(FacesContext context, UIComponent component, String value) throws ConverterException {
        return null == value ? null : this.format(value.toString(), false);
    }

    public String getAsString(FacesContext context, UIComponent component, Object value) throws ConverterException {
        return value == null ? "" : this.format(value.toString(), true);
    }

    private String format(String val, boolean duringOutput) throws ConverterException {
        boolean appendEllipses;
        String str = BooleanUtils.isTrue((Boolean)this.trim) ? val.trim() : val;
        if (StringUtils.isNotEmpty((String)this.format)) {
            if ("uppercase".equalsIgnoreCase(this.format)) {
                str = StringUtils.upperCase((String)str);
            } else if ("lowercase".equalsIgnoreCase(this.format)) {
                str = StringUtils.lowerCase((String)str);
            } else if ("capitalize".equalsIgnoreCase(this.format)) {
                str = WordUtils.capitalizeFully((String)str);
            } else {
                throw new ConverterException("Invalid format '" + this.format + "'");
            }
        }
        boolean bl = appendEllipses = duringOutput && null != this.appendEllipsesDuringOutput && this.appendEllipsesDuringOutput != false || false == duringOutput && null != this.appendEllipsesDuringInput && this.appendEllipsesDuringInput != false;
        if (appendEllipses) {
            if (null != this.maxLength && this.maxLength > 4) {
                str = StringUtils.abbreviate((String)str, (int)this.maxLength);
            }
        } else if (null != this.maxLength) {
            str = str.substring(0, this.maxLength);
        }
        return str;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this.format = (String)values[0];
        this.trim = (Boolean)values[1];
        this.maxLength = (Integer)values[2];
        this.appendEllipsesDuringOutput = (Boolean)values[3];
        this.appendEllipsesDuringInput = (Boolean)values[4];
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{this.format, this.trim, this.maxLength, this.appendEllipsesDuringOutput, this.appendEllipsesDuringInput};
        return values;
    }

    public boolean isTransient() {
        return this._transient;
    }

    public void setTransient(boolean _transient) {
        this._transient = _transient;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
    }

    public Boolean isAppendEllipsesDuringOutput() {
        return this.appendEllipsesDuringOutput;
    }

    public void setAppendEllipsesDuringOutput(Boolean appendEllipsesDuringOutput) {
        this.appendEllipsesDuringOutput = appendEllipsesDuringOutput;
    }

    public Boolean isAppendEllipsesDuringInput() {
        return this.appendEllipsesDuringInput;
    }

    public void setAppendEllipsesDuringInput(Boolean appendEllipsesDuringInput) {
        this.appendEllipsesDuringInput = appendEllipsesDuringInput;
    }

    public Boolean getTrim() {
        return this.trim;
    }

    public void setTrim(Boolean trim) {
        this.trim = trim;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

