/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.excelexport;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.ValueHolder;
import javax.faces.component.html.HtmlDataTable;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.myfaces.custom.util.ComponentUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.RendererUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class ExcelExportPhaseListener
implements PhaseListener {
    public void afterPhase(PhaseEvent phaseEvent) {
        FacesContext facesContext = phaseEvent.getFacesContext();
        Map map = facesContext.getExternalContext().getRequestParameterMap();
        if (map.containsKey("excelExportTableId")) {
            String tableId = (String)map.get("excelExportTableId");
            HtmlDataTable dataTable = (HtmlDataTable)ComponentUtils.findComponentById(facesContext, (UIComponent)facesContext.getViewRoot(), tableId);
            HSSFWorkbook generatedExcel = this.generateExcel(facesContext, dataTable);
            try {
                Object contextResponse = facesContext.getExternalContext().getResponse();
                if (contextResponse instanceof HttpServletResponse) {
                    this.writeExcelOutput(generatedExcel, (HttpServletResponse)contextResponse);
                } else if (contextResponse instanceof RenderResponse) {
                    this.writeExcelOutput(generatedExcel, (RenderResponse)contextResponse);
                }
                facesContext.getApplication().getStateManager().saveSerializedView(facesContext);
                facesContext.responseComplete();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void beforePhase(PhaseEvent phaseEvent) {
    }

    public PhaseId getPhaseId() {
        return PhaseId.RESTORE_VIEW;
    }

    private void writeExcelOutput(HSSFWorkbook workBook, HttpServletResponse response) throws IOException {
        response.setContentType("application/vnd.ms-excel");
        workBook.write((OutputStream)response.getOutputStream());
    }

    private void writeExcelOutput(HSSFWorkbook workBook, RenderResponse response) throws IOException {
        response.setContentType("application/vnd.ms-excel");
        workBook.write(response.getPortletOutputStream());
    }

    private List getColumns(HtmlDataTable table) {
        ArrayList<UIComponent> columns = new ArrayList<UIComponent>();
        for (int i = 0; i < table.getChildCount(); ++i) {
            UIComponent child = (UIComponent)table.getChildren().get(i);
            if (!(child instanceof UIColumn)) continue;
            columns.add(child);
        }
        return columns;
    }

    private HSSFWorkbook generateExcel(FacesContext facesContext, HtmlDataTable table) {
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet(table.getId());
        List columns = this.getColumns(table);
        int currentRowIndex = table.getRowIndex();
        this.addColumnHeaders(sheet, columns);
        this.addColumnValues(sheet, columns, table);
        table.setRowIndex(currentRowIndex);
        return workbook;
    }

    private void addColumnValue(HSSFRow rowHeader, UIComponent component, int index) {
        HSSFCell cell = rowHeader.createCell((short)index);
        cell.setEncoding((short)1);
        if (component instanceof ValueHolder) {
            String stringValue = RendererUtils.getStringValue((FacesContext)FacesContext.getCurrentInstance(), (UIComponent)component);
            cell.setCellValue(stringValue);
        }
    }

    private void addColumnHeaders(HSSFSheet sheet, List columns) {
        HSSFRow rowHeader = sheet.createRow(0);
        for (int i = 0; i < columns.size(); ++i) {
            UIColumn column = (UIColumn)columns.get(i);
            this.addColumnValue(rowHeader, column.getHeader(), i);
        }
    }

    private void addColumnValues(HSSFSheet sheet, List columns, HtmlDataTable dataTable) {
        for (int i = 0; i < dataTable.getRowCount(); ++i) {
            dataTable.setRowIndex(i);
            HSSFRow row = sheet.createRow(i + 1);
            for (int j = 0; j < columns.size(); ++j) {
                UIColumn column = (UIColumn)columns.get(j);
                this.addColumnValue(row, (UIComponent)column.getChildren().get(0), j);
            }
        }
    }
}

