/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.excelexport;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.commons.lang.StringUtils;
import org.apache.myfaces.custom.excelexport.ExcelExport;
import org.apache.myfaces.shared_tomahawk.renderkit.RendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRenderer;

public class ExcelExportRenderer
extends HtmlRenderer {
    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
        if (component.getChildCount() == 0) {
            return;
        }
        String tableId = ((ExcelExport)component).getFor();
        UIComponent child = (UIComponent)component.getChildren().get(0);
        if (!this.isDecorated(facesContext, child, tableId)) {
            this.decorateOnClick(facesContext, child, tableId);
        }
        RendererUtils.renderChildren((FacesContext)facesContext, (UIComponent)component);
    }

    private boolean isDecorated(FacesContext facesContext, UIComponent child, String tableId) {
        String onClick = (String)child.getAttributes().get("onclick");
        String jsCall = this.getJSCall(facesContext, tableId);
        return onClick != null && onClick.indexOf(jsCall) != -1;
    }

    private void decorateOnClick(FacesContext facesContext, UIComponent child, String tableId) {
        String jsCall = this.getJSCall(facesContext, tableId);
        String onclickEvent = (String)child.getAttributes().get("onclick");
        if (onclickEvent == null) {
            child.getAttributes().put("onclick", jsCall);
        } else {
            child.getAttributes().put("onclick", onclickEvent + ";" + jsCall);
        }
    }

    private String getJSCall(FacesContext facesContext, String tableId) {
        String viewId = StringUtils.split((String)facesContext.getViewRoot().getViewId(), (String)"\\.")[0];
        String contextPath = facesContext.getExternalContext().getRequestContextPath();
        return "window.open('" + contextPath + viewId + ".jsf?excelExportTableId=" + tableId + "');return false;";
    }
}

