/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.ppr;

import java.io.IOException;
import java.util.StringTokenizer;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.custom.dojo.DojoConfig;
import org.apache.myfaces.custom.dojo.DojoUtils;
import org.apache.myfaces.custom.ppr.PPRPanelGroup;
import org.apache.myfaces.renderkit.html.ext.HtmlGroupRenderer;
import org.apache.myfaces.renderkit.html.util.AddResource;
import org.apache.myfaces.renderkit.html.util.AddResourceFactory;
import org.apache.myfaces.shared_tomahawk.renderkit.RendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.util.FormInfo;

public class PPRPanelGroupRenderer
extends HtmlGroupRenderer {
    public static final String PPR_INITIALIZED = "org.apache.myfaces.ppr.INITIALIZED";
    public static final String PPR_RESPONSE = "org.apache.myfaces.ppr.RESPONSE";
    private static Log log = LogFactory.getLog((Class)(class$org$apache$myfaces$custom$ppr$PPRPanelGroupRenderer == null ? (class$org$apache$myfaces$custom$ppr$PPRPanelGroupRenderer = PPRPanelGroupRenderer.class$("org.apache.myfaces.custom.ppr.PPRPanelGroupRenderer")) : class$org$apache$myfaces$custom$ppr$PPRPanelGroupRenderer));
    private static final String MY_FACES_PPR_INITIALIZED = "/*MyFaces PPR initialized*/";
    private static final String ADD_PARTIAL_TRIGGER_FUNCTION = "addPartialTrigger";
    private static final String ADD_PARTIAL_TRIGGER_PATTERN_FUNCTION = "addPartialTriggerPattern";
    private static final String ADD_INLINE_LOADING_MESSAGE_FUNCTION = "addInlineLoadingMessage";
    private static final String PPR_JS_FILE = "ppr.js";
    private static final String MY_FACES_PPR_INIT_CODE = "new org.apache.myfaces.PPRCtrl";
    static /* synthetic */ Class class$org$apache$myfaces$custom$ppr$PPRPanelGroupRenderer;
    static /* synthetic */ Class class$org$apache$myfaces$custom$ppr$PPRPanelGroup;

    public void encodeJavaScript(FacesContext facesContext, PPRPanelGroup pprGroup) throws IOException {
        String inlineLoadingMessage;
        if (facesContext.getExternalContext().getRequestMap().containsKey(PPR_RESPONSE)) {
            return;
        }
        FormInfo fi = RendererUtils.findNestingForm((UIComponent)pprGroup, (FacesContext)facesContext);
        if (fi == null) {
            throw new FacesException("PPRPanelGroup must be embedded in a form.");
        }
        if (!facesContext.getExternalContext().getRequestMap().containsKey(PPR_INITIALIZED)) {
            facesContext.getExternalContext().getRequestMap().put(PPR_INITIALIZED, Boolean.TRUE);
            String javascriptLocation = (String)pprGroup.getAttributes().get("org.apache.myfaces.JAVASCRIPT_LOCATION");
            AddResource addResource = AddResourceFactory.getInstance((FacesContext)facesContext);
            DojoUtils.addMainInclude((FacesContext)facesContext, (UIComponent)pprGroup, (String)javascriptLocation, (DojoConfig)new DojoConfig());
            DojoUtils.addRequire((FacesContext)facesContext, (UIComponent)pprGroup, (String)"dojo.io.*");
            DojoUtils.addRequire((FacesContext)facesContext, (UIComponent)pprGroup, (String)"dojo.event.*");
            addResource.addInlineScriptAtPosition(facesContext, AddResource.HEADER_BEGIN, MY_FACES_PPR_INITIALIZED);
            addResource.addJavaScriptAtPosition(facesContext, AddResource.HEADER_BEGIN, class$org$apache$myfaces$custom$ppr$PPRPanelGroup == null ? (class$org$apache$myfaces$custom$ppr$PPRPanelGroup = PPRPanelGroupRenderer.class$("org.apache.myfaces.custom.ppr.PPRPanelGroup")) : class$org$apache$myfaces$custom$ppr$PPRPanelGroup, PPR_JS_FILE);
        }
        StringBuffer script = new StringBuffer();
        String pprCtrlReference = "dojo.byId('" + fi.getFormName() + "').myFacesPPRCtrl";
        if (!facesContext.getExternalContext().getRequestMap().containsKey("org.apache.myfaces.ppr.INITIALIZED." + fi.getFormName())) {
            facesContext.getExternalContext().getRequestMap().put("org.apache.myfaces.ppr.INITIALIZED." + fi.getFormName(), Boolean.TRUE);
            script.append(pprCtrlReference + "=" + MY_FACES_PPR_INIT_CODE + "('" + fi.getFormName() + "'," + pprGroup.getShowDebugMessages() + "," + pprGroup.getStateUpdate() + ");\n");
            if (pprGroup.getPeriodicalUpdate() != null) {
                script.append(pprCtrlReference + ".registerOnSubmitInterceptor();");
            }
            PPRPanelGroupRenderer.renderInlineScript(facesContext, (UIComponent)pprGroup, script.toString());
        }
        String clientId = pprGroup.getClientId(facesContext);
        if (pprGroup.getPeriodicalUpdate() != null) {
            script = new StringBuffer();
            script.append(pprCtrlReference + ".startPeriodicalUpdate(" + pprGroup.getPeriodicalUpdate() + ",'" + clientId + "');");
            PPRPanelGroupRenderer.renderInlineScript(facesContext, (UIComponent)pprGroup, script.toString());
        }
        String partialTriggers = pprGroup.getPartialTriggers();
        String partialTriggerPattern = pprGroup.getPartialTriggerPattern();
        if (partialTriggerPattern != null && partialTriggerPattern.trim().length() > 0) {
            script = new StringBuffer();
            script.append(pprCtrlReference + "." + ADD_PARTIAL_TRIGGER_PATTERN_FUNCTION + "('" + partialTriggerPattern + "','" + clientId + "');");
            PPRPanelGroupRenderer.renderInlineScript(facesContext, (UIComponent)pprGroup, script.toString());
        }
        if ((inlineLoadingMessage = pprGroup.getInlineLoadingMessage()) != null && inlineLoadingMessage.trim().length() > 0) {
            script = new StringBuffer();
            script.append(pprCtrlReference + "." + ADD_INLINE_LOADING_MESSAGE_FUNCTION + "('" + inlineLoadingMessage + "','" + clientId + "');");
            PPRPanelGroupRenderer.renderInlineScript(facesContext, (UIComponent)pprGroup, script.toString());
        }
        if (partialTriggers != null && partialTriggers.trim().length() > 0) {
            StringTokenizer st = new StringTokenizer(partialTriggers, ",; ", false);
            while (st.hasMoreTokens()) {
                String partialTriggerId = st.nextToken();
                UIComponent partialTriggerComponent = pprGroup.findComponent(partialTriggerId);
                if (partialTriggerComponent == null) {
                    partialTriggerComponent = FacesContext.getCurrentInstance().getViewRoot().findComponent(partialTriggerId);
                }
                if (partialTriggerComponent != null) {
                    String partialTriggerClientId = partialTriggerComponent.getClientId(facesContext);
                    script = new StringBuffer();
                    script.append(pprCtrlReference + "." + ADD_PARTIAL_TRIGGER_FUNCTION + "('" + partialTriggerClientId + "','" + clientId + "');");
                    PPRPanelGroupRenderer.renderInlineScript(facesContext, (UIComponent)pprGroup, script.toString());
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("PPRPanelGroupRenderer Component with id " + partialTriggerId + " not found!"));
            }
        }
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        if (uiComponent.getId() == null || uiComponent.getId().startsWith("_id")) {
            throw new IllegalArgumentException("'id' is a required attribute for the PPRPanelGroup");
        }
        super.encodeBegin(facesContext, uiComponent);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        PPRPanelGroup pprGroup;
        super.encodeEnd(facesContext, uiComponent);
        if (uiComponent instanceof PPRPanelGroup && ((pprGroup = (PPRPanelGroup)uiComponent).getPartialTriggers() != null && pprGroup.getPartialTriggers().length() > 0 || pprGroup.getPartialTriggerPattern() != null && pprGroup.getPartialTriggerPattern().length() > 0 || pprGroup.getPeriodicalUpdate() != null)) {
            this.encodeJavaScript(facesContext, pprGroup);
        }
    }

    private static void renderInlineScript(FacesContext facesContext, UIComponent component, String script) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("script", component);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write(script);
        writer.endElement("script");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

