/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.redirectTracker;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.custom.redirectTracker.RedirectTrackerContext;
import org.apache.myfaces.custom.redirectTracker.RedirectTrackerPolicy;
import org.apache.myfaces.shared_tomahawk.util.ClassUtils;

public class RedirectTrackerManager
implements Serializable {
    private static final String INIT_POLICY = "org.apache.myfaces.redirectTracker.POLICY";
    private static final String INIT_MAX_REDIRECTS = "org.apache.myfaces.redirectTracker.MAX_REDIRECTS";
    public static final int TRACK_REDIRECTS = 20;
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$myfaces$custom$redirectTracker$RedirectTrackerManager == null ? (class$org$apache$myfaces$custom$redirectTracker$RedirectTrackerManager = RedirectTrackerManager.class$("org.apache.myfaces.custom.redirectTracker.RedirectTrackerManager")) : class$org$apache$myfaces$custom$redirectTracker$RedirectTrackerManager));
    public static final String SESSION_KEY = (class$org$apache$myfaces$custom$redirectTracker$RedirectTrackerManager == null ? (class$org$apache$myfaces$custom$redirectTracker$RedirectTrackerManager = RedirectTrackerManager.class$("org.apache.myfaces.custom.redirectTracker.RedirectTrackerManager")) : class$org$apache$myfaces$custom$redirectTracker$RedirectTrackerManager).getName();
    public static final String REDIRECT_ARG = "_rtid";
    private final String redirectTrackerPolicy;
    private final int redirects;
    private final Map requestBeanMap = new TreeMap();
    private transient Map redirectEntryMap;
    private transient List redirectEntryList;
    private long requests = 0L;
    static /* synthetic */ Class class$org$apache$myfaces$custom$redirectTracker$RedirectTrackerManager;
    static /* synthetic */ Class class$org$apache$myfaces$custom$redirectTracker$policy$NoopRedirectTrackPolicy;

    public RedirectTrackerManager(int redirects, String redirectTrackerPolicy) {
        this.redirects = redirects;
        this.redirectTrackerPolicy = redirectTrackerPolicy;
    }

    protected void initRedirectEntryMap() {
        if (this.redirectEntryMap == null) {
            this.redirectEntryMap = new TreeMap();
            this.redirectEntryList = new ArrayList(this.redirects);
        }
    }

    public void processTrackedRequest(FacesContext facesContext) {
        Object rtid = facesContext.getExternalContext().getRequestParameterMap().get(REDIRECT_ARG);
        if (!this.isRedirectedRequest(rtid)) {
            return;
        }
        this.setupFaces(facesContext, rtid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isRedirectedRequest(Object rtid) {
        if (rtid == null) {
            return false;
        }
        this.initRedirectEntryMap();
        Map map = this.redirectEntryMap;
        synchronized (map) {
            return this.redirectEntryMap.containsKey(rtid);
        }
    }

    public static RedirectTrackerManager getInstance(FacesContext facesContext) {
        Map sessionMap = facesContext.getExternalContext().getSessionMap();
        if (sessionMap == null) {
            return null;
        }
        RedirectTrackerManager redirectManager = (RedirectTrackerManager)sessionMap.get(SESSION_KEY);
        if (redirectManager == null) {
            redirectManager = RedirectTrackerManager.createRedirectTrackerManager(facesContext);
            sessionMap.put(SESSION_KEY, redirectManager);
        }
        return redirectManager;
    }

    protected static RedirectTrackerManager createRedirectTrackerManager(FacesContext facesContext) {
        int numMaxRedirects;
        String maxRedirects;
        String initPolicy = facesContext.getExternalContext().getInitParameter(INIT_POLICY);
        if (initPolicy == null) {
            initPolicy = (class$org$apache$myfaces$custom$redirectTracker$policy$NoopRedirectTrackPolicy == null ? (class$org$apache$myfaces$custom$redirectTracker$policy$NoopRedirectTrackPolicy = RedirectTrackerManager.class$("org.apache.myfaces.custom.redirectTracker.policy.NoopRedirectTrackPolicy")) : class$org$apache$myfaces$custom$redirectTracker$policy$NoopRedirectTrackPolicy).getName();
            if (log.isInfoEnabled()) {
                log.info((Object)("No context init parameter 'org.apache.myfaces.redirectTracker.POLICY' found, using default value " + initPolicy));
            }
        }
        if ((maxRedirects = facesContext.getExternalContext().getInitParameter(INIT_MAX_REDIRECTS)) == null) {
            numMaxRedirects = 20;
            if (log.isInfoEnabled()) {
                log.info((Object)("No context init parameter 'org.apache.myfaces.redirectTracker.MAX_REDIRECTS' found, using default value " + numMaxRedirects));
            }
        } else {
            numMaxRedirects = Integer.parseInt(maxRedirects, 10);
        }
        return new RedirectTrackerManager(numMaxRedirects, initPolicy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String trackRedirect(FacesContext facesContext, String redirectPath) {
        long rtid = this.getNextRequestNo();
        String mapKey = Long.toString(rtid, 36);
        Entry entry = new Entry(mapKey);
        RedirectTrackerContext context = new RedirectTrackerContext(this, entry, facesContext);
        RedirectTrackerPolicy policy = this.getRedirectTrackerPolicy();
        redirectPath = policy.trackRedirect(context, redirectPath);
        this.clearSaveStateBean();
        if (!entry.hasCapturedData()) {
            return redirectPath;
        }
        this.initRedirectEntryMap();
        Map map = this.redirectEntryMap;
        synchronized (map) {
            this.redirectEntryMap.put(mapKey, entry);
            this.redirectEntryList.add(entry);
            while (this.redirectEntryList.size() > this.redirects) {
                Entry prevEntry = (Entry)this.redirectEntryList.remove(0);
                this.redirectEntryMap.remove(prevEntry.mapKey);
            }
        }
        if (redirectPath.indexOf(63) == -1) {
            return redirectPath + "?" + REDIRECT_ARG + "=" + mapKey;
        }
        return redirectPath + "&" + REDIRECT_ARG + "=" + mapKey;
    }

    protected RedirectTrackerPolicy getRedirectTrackerPolicy() {
        try {
            return (RedirectTrackerPolicy)ClassUtils.classForName((String)this.redirectTrackerPolicy).newInstance();
        }
        catch (InstantiationException e) {
            throw new FacesException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new FacesException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new FacesException((Throwable)e);
        }
    }

    protected void saveBeans(Entry entry) {
        entry.beanMap.putAll(this.requestBeanMap);
    }

    protected void saveBean(Entry entry, String name, Object value) {
        entry.beanMap.put(name, value);
    }

    public void addSaveStateBean(String expressionString, Object value) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("addSaveStateBean: " + expressionString + " value=" + value));
        }
        this.requestBeanMap.put(expressionString, value);
    }

    public void clearSaveStateBean() {
        this.requestBeanMap.clear();
    }

    protected void saveMessages(FacesContext facesContext, Entry entry) {
        Iterator iterClientIds = facesContext.getClientIdsWithMessages();
        while (iterClientIds.hasNext()) {
            String clientId = (String)iterClientIds.next();
            Iterator iterMessages = facesContext.getMessages(clientId);
            while (iterMessages.hasNext()) {
                Object message = iterMessages.next();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("saveMessage: " + message));
                }
                entry.addMessage(clientId, message);
            }
        }
    }

    protected void restoreMessages(FacesContext facesContext, Entry entry) {
        Iterator iterMessages = entry.getMessages();
        if (iterMessages == null) {
            return;
        }
        while (iterMessages.hasNext()) {
            MessageEntry message = (MessageEntry)iterMessages.next();
            facesContext.addMessage((String)message.clientId, (FacesMessage)message.message);
        }
    }

    protected void saveLocale(FacesContext facesContext, Entry entry) {
        if (facesContext.getViewRoot() != null && facesContext.getViewRoot().getLocale() != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("saveLocale: " + facesContext.getViewRoot().getLocale()));
            }
            entry.locale = facesContext.getViewRoot().getLocale();
        }
    }

    protected void restoreLocale(FacesContext facesContext, Entry entry) {
        if (entry.locale != null && facesContext.getViewRoot() != null) {
            facesContext.getViewRoot().setLocale(entry.locale);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setupFaces(FacesContext facesContext, Object rtid) {
        Entry entry;
        this.initRedirectEntryMap();
        Map map = this.redirectEntryMap;
        synchronized (map) {
            entry = (Entry)this.redirectEntryMap.get(rtid);
        }
        if (entry == null) {
            return;
        }
        this.restoreLocale(facesContext, entry);
        this.restoreMessages(facesContext, entry);
        this.restoreBeans(facesContext, entry);
    }

    protected void restoreBeans(FacesContext facesContext, Entry entry) {
        Iterator iterBeanMap = entry.beanMap.entrySet().iterator();
        while (iterBeanMap.hasNext()) {
            Map.Entry bean = iterBeanMap.next();
            String beanName = bean.getKey().toString();
            if (log.isDebugEnabled()) {
                log.debug((Object)("restore bean: " + beanName + " value=" + bean.getValue()));
            }
            if (beanName.startsWith("#{") && beanName.endsWith("}")) {
                ValueBinding vb = facesContext.getApplication().createValueBinding(bean.getKey().toString());
                vb.setValue(facesContext, bean.getValue());
                continue;
            }
            facesContext.getExternalContext().getRequestMap().put(beanName, bean.getValue());
            this.addSaveStateBean(beanName, bean.getValue());
        }
    }

    protected synchronized long getNextRequestNo() {
        ++this.requests;
        return this.requests;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class MessageEntry
    implements Serializable {
        private final Object clientId;
        private final Object message;

        public MessageEntry(Object clientId, Object message) {
            this.clientId = clientId;
            this.message = message;
        }
    }

    static class Entry
    implements Serializable {
        private final String mapKey;
        private List messages;
        private Map beanMap = new TreeMap();
        private Locale locale;

        private Entry(String mapKey) {
            this.mapKey = mapKey;
        }

        void addMessage(Object clientId, Object message) {
            if (this.messages == null) {
                this.messages = new ArrayList();
            }
            this.messages.add(new MessageEntry(clientId, message));
        }

        public Iterator getMessages() {
            if (this.messages == null) {
                return null;
            }
            return this.messages.iterator();
        }

        public boolean hasCapturedData() {
            return this.messages != null && this.messages.size() > 0 || this.beanMap != null && this.beanMap.size() > 0 || this.locale != null;
        }
    }
}

