/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.valueChangeNotifier;

import java.util.ArrayList;
import java.util.List;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ValueChangeEvent;
import javax.faces.event.ValueChangeListener;
import org.apache.myfaces.custom.valueChangeNotifier.RestoreStateCommand;
import org.apache.myfaces.custom.valueChangeNotifier.ValueChangeManager;

public class ValueChangeCollector
implements ValueChangeListener,
StateHolder {
    private String method = null;
    private boolean isTransient = false;

    public ValueChangeCollector() {
    }

    protected ValueChangeCollector(String method) {
        this.method = method;
    }

    public void processValueChange(ValueChangeEvent event) throws AbortProcessingException {
        UIComponent valueChangeComponent = event.getComponent();
        ArrayList restoreStateCommands = new ArrayList();
        this.collectStates(restoreStateCommands, valueChangeComponent);
        ValueChangeEvent clonedEvent = new ValueChangeEvent(event.getComponent(), event.getOldValue(), event.getNewValue());
        ValueChangeManager manager = ValueChangeManager.getManager(FacesContext.getCurrentInstance());
        manager.addEvent(this.method, clonedEvent, restoreStateCommands);
    }

    protected void collectStates(List restoreStateCommands, UIComponent component) {
        while (component != null) {
            if (component instanceof UIData) {
                final UIData data = (UIData)component;
                final int rowIndex = data.getRowIndex();
                restoreStateCommands.add(new RestoreStateCommand(){
                    int currentRowIndex;

                    public void saveCurrentState() {
                        this.currentRowIndex = data.getRowIndex();
                    }

                    public void restoreCurrentState() {
                        data.setRowIndex(this.currentRowIndex);
                    }

                    public void restoreEventState() {
                        data.setRowIndex(rowIndex);
                    }
                });
            }
            component = component.getParent();
        }
    }

    public Object saveState(FacesContext context) {
        return new Object[]{this.method};
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] o = (Object[])state;
        this.method = (String)o[0];
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public void setTransient(boolean isTransient) {
        this.isTransient = isTransient;
    }
}

