/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.selectOneRow;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.custom.selectOneRow.SelectOneRow;
import org.apache.myfaces.shared_tomahawk.config.MyfacesConfig;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HTML;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRenderer;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRendererUtils;

public class SelectOneRowRenderer
extends HtmlRenderer {
    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        if (component instanceof SelectOneRow && component.isRendered()) {
            SelectOneRow row = (SelectOneRow)component;
            String clientId = row.getClientId(facesContext);
            ResponseWriter writer = facesContext.getResponseWriter();
            writer.startElement("input", (UIComponent)row);
            writer.writeAttribute("type", (Object)"radio", null);
            writer.writeAttribute("name", (Object)row.getGroupName(), null);
            if (this.isDisabled(facesContext, row)) {
                writer.writeAttribute("disabled", (Object)"disabled", null);
            }
            writer.writeAttribute("id", (Object)clientId, null);
            if (this.isRowSelected((UIComponent)row)) {
                writer.writeAttribute("checked", (Object)"checked", null);
            }
            writer.writeAttribute("value", (Object)clientId, null);
            HtmlRendererUtils.renderHTMLAttributes(writer, (UIComponent)row, HTML.INPUT_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED);
            HtmlRendererUtils.renderHTMLAttributes(writer, (UIComponent)row, new String[]{"onclick"});
            writer.endElement("input");
        }
    }

    protected boolean isDisabled(FacesContext facesContext, SelectOneRow row) {
        boolean disabled = row.isDisabled();
        boolean readonly = row.isReadonly();
        if (!disabled && readonly) {
            disabled = MyfacesConfig.getCurrentInstance(facesContext.getExternalContext()).isReadonlyAsDisabledForSelect();
        }
        return disabled;
    }

    private boolean isRowSelected(UIComponent component) {
        UIInput input = (UIInput)component;
        Object value = input.getValue();
        int currentRowIndex = this.getCurrentRowIndex(component);
        return value != null && currentRowIndex == ((Long)value).intValue();
    }

    private int getCurrentRowIndex(UIComponent component) {
        UIData uidata = this.findUIData(component);
        if (uidata == null) {
            return -1;
        }
        return uidata.getRowIndex();
    }

    protected UIData findUIData(UIComponent uicomponent) {
        if (uicomponent == null) {
            return null;
        }
        if (uicomponent instanceof UIData) {
            return (UIData)uicomponent;
        }
        return this.findUIData(uicomponent.getParent());
    }

    public void decode(FacesContext context, UIComponent uiComponent) {
        if (!(uiComponent instanceof SelectOneRow)) {
            return;
        }
        if (!uiComponent.isRendered()) {
            return;
        }
        SelectOneRow row = (SelectOneRow)uiComponent;
        Map requestMap = context.getExternalContext().getRequestParameterMap();
        if (requestMap.containsKey(row.getGroupName())) {
            String postedValue = (String)requestMap.get(row.getGroupName());
            String clientId = row.getClientId(context);
            if (clientId.equals(postedValue)) {
                String[] postedValueArray = postedValue.split(":");
                String rowIndex = postedValueArray[postedValueArray.length - 2];
                Long newValue = Long.valueOf(rowIndex);
                row.setSubmittedValue(newValue);
                row.setValid(true);
            }
        }
    }
}

