/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared_tomahawk.renderkit.html;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.faces.FacesException;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIOutput;
import javax.faces.component.UISelectBoolean;
import javax.faces.component.UISelectMany;
import javax.faces.component.UISelectOne;
import javax.faces.component.html.HtmlDataTable;
import javax.faces.component.html.HtmlPanelGrid;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.model.SelectItem;
import javax.faces.model.SelectItemGroup;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.shared_tomahawk.component.DisplayValueOnlyCapable;
import org.apache.myfaces.shared_tomahawk.component.EscapeCapable;
import org.apache.myfaces.shared_tomahawk.config.MyfacesConfig;
import org.apache.myfaces.shared_tomahawk.renderkit.RendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HTML;
import org.apache.myfaces.shared_tomahawk.renderkit.html.util.FormInfo;
import org.apache.myfaces.shared_tomahawk.renderkit.html.util.HTMLEncoder;
import org.apache.myfaces.shared_tomahawk.renderkit.html.util.JavascriptUtils;

public final class HtmlRendererUtils {
    private static final Log log = LogFactory.getLog(HtmlRendererUtils.class);
    private static final String LINE_SEPARATOR = System.getProperty("line.separator", "\r\n");
    private static final char TABULATOR = '\t';
    public static final String HIDDEN_COMMANDLINK_FIELD_NAME = "_idcl";
    public static final String HIDDEN_COMMANDLINK_FIELD_NAME_MYFACES_OLD = "_link_hidden_";
    public static final String HIDDEN_COMMANDLINK_FIELD_NAME_TRINIDAD = "source";
    public static final String CLEAR_HIDDEN_FIELD_FN_NAME = "clearFormHiddenParams";
    public static final String SUBMIT_FORM_FN_NAME = "oamSubmitForm";
    public static final String ALLOW_CDATA_SECTION_ON = "org.apache.myfaces.ResponseWriter.CdataSectionOn";
    private static final String SET_HIDDEN_INPUT_FN_NAME = "oamSetHiddenInput";
    private static final String CLEAR_HIDDEN_INPUT_FN_NAME = "oamClearHiddenInput";
    private static final String AUTO_SCROLL_PARAM = "autoScroll";
    private static final String AUTO_SCROLL_FUNCTION = "getScrolling";
    private static final String FIRST_SUBMIT_SCRIPT_ON_PAGE = "org.apache.MyFaces.FIRST_SUBMIT_SCRIPT_ON_PAGE";
    public static final String NON_SUBMITTED_VALUE_WARNING = "There should always be a submitted value for an input if it is rendered, its form is submitted, and it was not originally rendered disabled or read-only.  You cannot submit a form after disabling an input element via javascript.  Consider setting read-only to true instead or resetting the disabled value back to false prior to form submission.";
    private static String HTML_CONTENT_TYPE = "text/html";
    private static String TEXT_ANY_CONTENT_TYPE = "text/*";
    private static String ANY_CONTENT_TYPE = "*/*";
    public static String DEFAULT_CHAR_ENCODING = "ISO-8859-1";
    private static String XHTML_CONTENT_TYPE = "application/xhtml+xml";
    private static String APPLICATION_XML_CONTENT_TYPE = "application/xml";
    private static String TEXT_XML_CONTENT_TYPE = "text/xml";

    private HtmlRendererUtils() {
    }

    public static void decodeUIInput(FacesContext facesContext, UIComponent component) {
        if (!(component instanceof EditableValueHolder)) {
            throw new IllegalArgumentException("Component " + component.getClientId(facesContext) + " is not an EditableValueHolder");
        }
        Map paramMap = facesContext.getExternalContext().getRequestParameterMap();
        String clientId = component.getClientId(facesContext);
        if (HtmlRendererUtils.isDisabledOrReadOnly(component)) {
            return;
        }
        if (paramMap.containsKey(clientId)) {
            ((EditableValueHolder)component).setSubmittedValue(paramMap.get(clientId));
        } else {
            log.warn((Object)("There should always be a submitted value for an input if it is rendered, its form is submitted, and it was not originally rendered disabled or read-only.  You cannot submit a form after disabling an input element via javascript.  Consider setting read-only to true instead or resetting the disabled value back to false prior to form submission. Component : " + RendererUtils.getPathToComponent(component)));
        }
    }

    public static void decodeUISelectBoolean(FacesContext facesContext, UIComponent component) {
        String clientId;
        if (!(component instanceof EditableValueHolder)) {
            throw new IllegalArgumentException("Component " + component.getClientId(facesContext) + " is not an EditableValueHolder");
        }
        if (HtmlRendererUtils.isDisabledOrReadOnly(component)) {
            return;
        }
        Map paramMap = facesContext.getExternalContext().getRequestParameterMap();
        if (paramMap.containsKey(clientId = component.getClientId(facesContext))) {
            String reqValue = (String)paramMap.get(clientId);
            if (reqValue.equalsIgnoreCase("on") || reqValue.equalsIgnoreCase("yes") || reqValue.equalsIgnoreCase("true")) {
                ((EditableValueHolder)component).setSubmittedValue((Object)Boolean.TRUE);
            } else {
                ((EditableValueHolder)component).setSubmittedValue((Object)Boolean.FALSE);
            }
        } else {
            ((EditableValueHolder)component).setSubmittedValue((Object)Boolean.FALSE);
        }
    }

    public static boolean isDisabledOrReadOnly(UIComponent component) {
        return HtmlRendererUtils.isDisplayValueOnly(component) || HtmlRendererUtils.isDisabled(component) || HtmlRendererUtils.isReadOnly(component);
    }

    public static boolean isDisabled(UIComponent component) {
        return HtmlRendererUtils.isTrue(component.getAttributes().get("disabled"));
    }

    public static boolean isReadOnly(UIComponent component) {
        return HtmlRendererUtils.isTrue(component.getAttributes().get("readonly"));
    }

    private static boolean isTrue(Object obj) {
        if (!(obj instanceof Boolean)) {
            return false;
        }
        return (Boolean)obj;
    }

    public static void decodeUISelectMany(FacesContext facesContext, UIComponent component) {
        if (!(component instanceof EditableValueHolder)) {
            throw new IllegalArgumentException("Component " + component.getClientId(facesContext) + " is not an EditableValueHolder");
        }
        Map paramValuesMap = facesContext.getExternalContext().getRequestParameterValuesMap();
        String clientId = component.getClientId(facesContext);
        if (HtmlRendererUtils.isDisabledOrReadOnly(component)) {
            return;
        }
        if (paramValuesMap.containsKey(clientId)) {
            String[] reqValues = (String[])paramValuesMap.get(clientId);
            ((EditableValueHolder)component).setSubmittedValue((Object)reqValues);
        } else {
            ((EditableValueHolder)component).setSubmittedValue((Object)new String[0]);
        }
    }

    public static void decodeUISelectOne(FacesContext facesContext, UIComponent component) {
        String clientId;
        if (!(component instanceof EditableValueHolder)) {
            throw new IllegalArgumentException("Component " + component.getClientId(facesContext) + " is not an EditableValueHolder");
        }
        if (HtmlRendererUtils.isDisabledOrReadOnly(component)) {
            return;
        }
        Map paramMap = facesContext.getExternalContext().getRequestParameterMap();
        if (paramMap.containsKey(clientId = component.getClientId(facesContext))) {
            ((EditableValueHolder)component).setSubmittedValue(paramMap.get(clientId));
        } else {
            ((EditableValueHolder)component).setSubmittedValue(RendererUtils.NOTHING);
        }
    }

    public static void renderListbox(FacesContext facesContext, UISelectOne selectOne, boolean disabled, int size) throws IOException {
        HtmlRendererUtils.internalRenderSelect(facesContext, (UIComponent)selectOne, disabled, size, false);
    }

    public static void renderListbox(FacesContext facesContext, UISelectMany selectMany, boolean disabled, int size) throws IOException {
        HtmlRendererUtils.internalRenderSelect(facesContext, (UIComponent)selectMany, disabled, size, true);
    }

    public static void renderMenu(FacesContext facesContext, UISelectOne selectOne, boolean disabled) throws IOException {
        HtmlRendererUtils.internalRenderSelect(facesContext, (UIComponent)selectOne, disabled, 1, false);
    }

    public static void renderMenu(FacesContext facesContext, UISelectMany selectMany, boolean disabled) throws IOException {
        HtmlRendererUtils.internalRenderSelect(facesContext, (UIComponent)selectMany, disabled, 1, true);
    }

    private static void internalRenderSelect(FacesContext facesContext, UIComponent uiComponent, boolean disabled, int size, boolean selectMany) throws IOException {
        Converter converter;
        List selectItemList;
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("select", uiComponent);
        HtmlRendererUtils.writeIdIfNecessary(writer, uiComponent, facesContext);
        writer.writeAttribute("name", (Object)uiComponent.getClientId(facesContext), null);
        if (selectMany) {
            writer.writeAttribute("multiple", (Object)"multiple", null);
            selectItemList = RendererUtils.getSelectItemList((UISelectMany)uiComponent);
            converter = HtmlRendererUtils.findUISelectManyConverterFailsafe(facesContext, uiComponent);
        } else {
            selectItemList = RendererUtils.getSelectItemList((UISelectOne)uiComponent);
            converter = HtmlRendererUtils.findUIOutputConverterFailSafe(facesContext, uiComponent);
        }
        if (size == Integer.MIN_VALUE) {
            writer.writeAttribute("size", (Object)Integer.toString(selectItemList.size()), null);
        } else {
            writer.writeAttribute("size", (Object)Integer.toString(size), null);
        }
        HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.SELECT_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED);
        if (disabled) {
            writer.writeAttribute("disabled", (Object)Boolean.TRUE, null);
        }
        if (HtmlRendererUtils.isReadOnly(uiComponent)) {
            writer.writeAttribute("readonly", (Object)"readonly", null);
        }
        Set lookupSet = HtmlRendererUtils.getSubmittedOrSelectedValuesAsSet(selectMany, uiComponent, facesContext, converter);
        HtmlRendererUtils.renderSelectOptions(facesContext, uiComponent, converter, lookupSet, selectItemList);
        writer.writeText((Object)"", null);
        writer.endElement("select");
    }

    public static Set getSubmittedOrSelectedValuesAsSet(boolean selectMany, UIComponent uiComponent, FacesContext facesContext, Converter converter) {
        Set<String> lookupSet;
        if (selectMany) {
            UISelectMany uiSelectMany = (UISelectMany)uiComponent;
            lookupSet = RendererUtils.getSubmittedValuesAsSet(facesContext, uiComponent, converter, uiSelectMany);
            if (lookupSet == null) {
                lookupSet = RendererUtils.getSelectedValuesAsSet(facesContext, uiComponent, converter, uiSelectMany);
            }
        } else {
            UISelectOne uiSelectOne = (UISelectOne)uiComponent;
            Object lookup = uiSelectOne.getSubmittedValue();
            if (lookup == null) {
                lookup = uiSelectOne.getValue();
                String lookupString = RendererUtils.getConvertedStringValue(facesContext, uiComponent, converter, lookup);
                lookupSet = Collections.singleton(lookupString);
            } else {
                lookupSet = RendererUtils.NOTHING.equals(lookup) ? Collections.EMPTY_SET : Collections.singleton(lookup);
            }
        }
        return lookupSet;
    }

    public static Converter findUISelectManyConverterFailsafe(FacesContext facesContext, UIComponent uiComponent) {
        Converter converter;
        try {
            converter = RendererUtils.findUISelectManyConverter(facesContext, (UISelectMany)uiComponent);
        }
        catch (FacesException e) {
            log.error((Object)("Error finding Converter for component with id " + uiComponent.getClientId(facesContext)), (Throwable)e);
            converter = null;
        }
        return converter;
    }

    public static Converter findUIOutputConverterFailSafe(FacesContext facesContext, UIComponent uiComponent) {
        Converter converter;
        try {
            converter = RendererUtils.findUIOutputConverter(facesContext, (UIOutput)uiComponent);
        }
        catch (FacesException e) {
            log.error((Object)("Error finding Converter for component with id " + uiComponent.getClientId(facesContext)), (Throwable)e);
            converter = null;
        }
        return converter;
    }

    public static void renderSelectOptions(FacesContext context, UIComponent component, Converter converter, Set lookupSet, List selectItemList) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        for (SelectItem selectItem : selectItemList) {
            boolean escape;
            boolean disabled;
            if (selectItem instanceof SelectItemGroup) {
                writer.startElement("optgroup", component);
                writer.writeAttribute("label", (Object)selectItem.getLabel(), null);
                SelectItem[] selectItems = ((SelectItemGroup)selectItem).getSelectItems();
                HtmlRendererUtils.renderSelectOptions(context, component, converter, lookupSet, Arrays.asList(selectItems));
                writer.endElement("optgroup");
                continue;
            }
            String itemStrValue = RendererUtils.getConvertedStringValue(context, component, converter, selectItem);
            writer.write(9);
            writer.startElement("option", component);
            if (itemStrValue != null) {
                writer.writeAttribute("value", (Object)itemStrValue, null);
            }
            if (lookupSet.contains(itemStrValue)) {
                writer.writeAttribute("selected", (Object)"selected", null);
            }
            if (disabled = selectItem.isDisabled()) {
                writer.writeAttribute("disabled", (Object)"disabled", null);
            }
            String labelClass = null;
            boolean componentDisabled = HtmlRendererUtils.isTrue(component.getAttributes().get("disabled"));
            labelClass = componentDisabled || disabled ? (String)component.getAttributes().get("disabledClass") : (String)component.getAttributes().get("enabledClass");
            if (labelClass != null) {
                writer.writeAttribute("class", (Object)labelClass, "labelClass");
            }
            if (component instanceof EscapeCapable) {
                escape = ((EscapeCapable)component).isEscape();
                if (escape && selectItem.isEscape()) {
                    writer.writeText((Object)selectItem.getLabel(), null);
                } else {
                    writer.write(selectItem.getLabel());
                }
            } else {
                escape = RendererUtils.getBooleanAttribute(component, "escape", false);
                if (escape || selectItem.isEscape()) {
                    writer.writeText((Object)selectItem.getLabel(), null);
                } else {
                    writer.write(selectItem.getLabel());
                }
            }
            writer.endElement("option");
        }
    }

    public static void writePrettyLineSeparator(FacesContext facesContext) throws IOException {
        if (MyfacesConfig.getCurrentInstance(facesContext.getExternalContext()).isPrettyHtml()) {
            facesContext.getResponseWriter().write(LINE_SEPARATOR);
        }
    }

    public static void writePrettyIndent(FacesContext facesContext) throws IOException {
        if (MyfacesConfig.getCurrentInstance(facesContext.getExternalContext()).isPrettyHtml()) {
            facesContext.getResponseWriter().write(9);
        }
    }

    public static boolean renderHTMLAttribute(ResponseWriter writer, String componentProperty, String attrName, Object value) throws IOException {
        if (!RendererUtils.isDefaultAttributeValue(value)) {
            String htmlAttrName = attrName.equals("styleClass") ? "class" : attrName;
            writer.writeAttribute(htmlAttrName, value, componentProperty);
            return true;
        }
        return false;
    }

    public static boolean renderHTMLAttribute(ResponseWriter writer, UIComponent component, String componentProperty, String htmlAttrName) throws IOException {
        Object value = component.getAttributes().get(componentProperty);
        return HtmlRendererUtils.renderHTMLAttribute(writer, componentProperty, htmlAttrName, value);
    }

    public static boolean renderHTMLAttributes(ResponseWriter writer, UIComponent component, String[] attributes) throws IOException {
        boolean somethingDone = false;
        for (String attrName : attributes) {
            if (!HtmlRendererUtils.renderHTMLAttribute(writer, component, attrName, attrName)) continue;
            somethingDone = true;
        }
        return somethingDone;
    }

    public static boolean renderHTMLAttributeWithOptionalStartElement(ResponseWriter writer, UIComponent component, String elementName, String attrName, Object value, boolean startElementWritten) throws IOException {
        if (!RendererUtils.isDefaultAttributeValue(value)) {
            if (!startElementWritten) {
                writer.startElement(elementName, component);
                startElementWritten = true;
            }
            HtmlRendererUtils.renderHTMLAttribute(writer, attrName, attrName, value);
        }
        return startElementWritten;
    }

    public static boolean renderHTMLAttributesWithOptionalStartElement(ResponseWriter writer, UIComponent component, String elementName, String[] attributes) throws IOException {
        boolean startElementWritten = false;
        for (String attrName : attributes) {
            Object value = component.getAttributes().get(attrName);
            if (RendererUtils.isDefaultAttributeValue(value)) continue;
            if (!startElementWritten) {
                writer.startElement(elementName, component);
                startElementWritten = true;
            }
            HtmlRendererUtils.renderHTMLAttribute(writer, attrName, attrName, value);
        }
        return startElementWritten;
    }

    public static boolean renderOptionalEndElement(ResponseWriter writer, UIComponent component, String elementName, String[] attributes) throws IOException {
        boolean endElementNeeded = false;
        for (String attrName : attributes) {
            Object value = component.getAttributes().get(attrName);
            if (RendererUtils.isDefaultAttributeValue(value)) continue;
            endElementNeeded = true;
            break;
        }
        if (endElementNeeded) {
            writer.endElement(elementName);
            return true;
        }
        return false;
    }

    public static void writeIdIfNecessary(ResponseWriter writer, UIComponent component, FacesContext facesContext) throws IOException {
        if (component.getId() != null && !component.getId().startsWith("j_id")) {
            writer.writeAttribute("id", (Object)component.getClientId(facesContext), null);
        }
    }

    public static void writeIdAndNameIfNecessary(ResponseWriter writer, UIComponent component, FacesContext facesContext) throws IOException {
        if (component.getId() != null && !component.getId().startsWith("j_id")) {
            String clientId = component.getClientId(facesContext);
            writer.writeAttribute("id", (Object)clientId, null);
            writer.writeAttribute("name", (Object)clientId, null);
        }
    }

    public static void renderDisplayValueOnlyForSelects(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        List selectItemList = null;
        Converter converter = null;
        boolean isSelectOne = false;
        if (uiComponent instanceof UISelectBoolean) {
            converter = HtmlRendererUtils.findUIOutputConverterFailSafe(facesContext, uiComponent);
            writer.startElement("span", uiComponent);
            HtmlRendererUtils.writeIdIfNecessary(writer, uiComponent, facesContext);
            HtmlRendererUtils.renderDisplayValueOnlyAttributes(uiComponent, writer);
            writer.writeText((Object)RendererUtils.getConvertedStringValue(facesContext, uiComponent, converter, ((UISelectBoolean)uiComponent).getValue()), "value");
            writer.endElement("span");
        } else {
            if (uiComponent instanceof UISelectMany) {
                isSelectOne = false;
                selectItemList = RendererUtils.getSelectItemList((UISelectMany)uiComponent);
                converter = HtmlRendererUtils.findUISelectManyConverterFailsafe(facesContext, uiComponent);
            } else if (uiComponent instanceof UISelectOne) {
                isSelectOne = true;
                selectItemList = RendererUtils.getSelectItemList((UISelectOne)uiComponent);
                converter = HtmlRendererUtils.findUIOutputConverterFailSafe(facesContext, uiComponent);
            }
            writer.startElement(isSelectOne ? "span" : "ul", uiComponent);
            HtmlRendererUtils.writeIdIfNecessary(writer, uiComponent, facesContext);
            HtmlRendererUtils.renderDisplayValueOnlyAttributes(uiComponent, writer);
            Set lookupSet = HtmlRendererUtils.getSubmittedOrSelectedValuesAsSet(uiComponent instanceof UISelectMany, uiComponent, facesContext, converter);
            HtmlRendererUtils.renderSelectOptionsAsText(facesContext, uiComponent, converter, lookupSet, selectItemList, isSelectOne);
            writer.writeText((Object)"", null);
            writer.endElement(isSelectOne ? "span" : "ul");
        }
    }

    public static void renderDisplayValueOnlyAttributes(UIComponent uiComponent, ResponseWriter writer) throws IOException {
        if (!(uiComponent instanceof DisplayValueOnlyCapable)) {
            log.error((Object)"Wrong type of uiComponent. needs DisplayValueOnlyCapable.");
            HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.COMMON_PASSTROUGH_ATTRIBUTES);
            return;
        }
        if (HtmlRendererUtils.getDisplayValueOnlyStyle(uiComponent) != null || HtmlRendererUtils.getDisplayValueOnlyStyleClass(uiComponent) != null) {
            if (HtmlRendererUtils.getDisplayValueOnlyStyle(uiComponent) != null) {
                writer.writeAttribute("style", (Object)HtmlRendererUtils.getDisplayValueOnlyStyle(uiComponent), null);
            } else if (uiComponent.getAttributes().get("style") != null) {
                writer.writeAttribute("style", uiComponent.getAttributes().get("style"), null);
            }
            if (HtmlRendererUtils.getDisplayValueOnlyStyleClass(uiComponent) != null) {
                writer.writeAttribute("class", (Object)HtmlRendererUtils.getDisplayValueOnlyStyleClass(uiComponent), null);
            } else if (uiComponent.getAttributes().get("styleClass") != null) {
                writer.writeAttribute("class", uiComponent.getAttributes().get("styleClass"), null);
            }
            HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.COMMON_PASSTROUGH_ATTRIBUTES_WITHOUT_STYLE);
        } else {
            HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.COMMON_PASSTROUGH_ATTRIBUTES);
        }
    }

    private static void renderSelectOptionsAsText(FacesContext context, UIComponent component, Converter converter, Set lookupSet, List selectItemList, boolean isSelectOne) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        for (SelectItem selectItem : selectItemList) {
            if (selectItem instanceof SelectItemGroup) {
                SelectItem[] selectItems = ((SelectItemGroup)selectItem).getSelectItems();
                HtmlRendererUtils.renderSelectOptionsAsText(context, component, converter, lookupSet, Arrays.asList(selectItems), isSelectOne);
                continue;
            }
            String itemStrValue = RendererUtils.getConvertedStringValue(context, component, converter, selectItem);
            if (!lookupSet.contains(itemStrValue)) continue;
            if (!isSelectOne) {
                writer.startElement("li", component);
            }
            writer.writeText((Object)selectItem.getLabel(), null);
            if (!isSelectOne) {
                writer.endElement("li");
            }
            if (!isSelectOne) continue;
            return;
        }
    }

    public static void renderTableCaption(FacesContext context, ResponseWriter writer, UIComponent component) throws IOException {
        String captionStyle;
        String captionClass;
        UIComponent captionFacet = component.getFacet("caption");
        if (captionFacet == null) {
            return;
        }
        if (component instanceof HtmlPanelGrid) {
            HtmlPanelGrid panelGrid = (HtmlPanelGrid)component;
            captionClass = panelGrid.getCaptionClass();
            captionStyle = panelGrid.getCaptionStyle();
        } else if (component instanceof HtmlDataTable) {
            HtmlDataTable dataTable = (HtmlDataTable)component;
            captionClass = dataTable.getCaptionClass();
            captionStyle = dataTable.getCaptionStyle();
        } else {
            captionClass = (String)component.getAttributes().get("captionClass");
            captionStyle = (String)component.getAttributes().get("captionStyle");
        }
        HtmlRendererUtils.writePrettyLineSeparator(context);
        writer.startElement("caption", component);
        if (captionClass != null) {
            writer.writeAttribute("class", (Object)captionClass, null);
        }
        if (captionStyle != null) {
            writer.writeAttribute("style", (Object)captionStyle, null);
        }
        RendererUtils.renderChild(context, captionFacet);
        writer.endElement("caption");
    }

    public static String getDisplayValueOnlyStyleClass(UIComponent component) {
        if (component instanceof DisplayValueOnlyCapable) {
            if (((DisplayValueOnlyCapable)component).getDisplayValueOnlyStyleClass() != null) {
                return ((DisplayValueOnlyCapable)component).getDisplayValueOnlyStyleClass();
            }
            UIComponent parent = component;
            while ((parent = parent.getParent()) != null) {
                if (!(parent instanceof DisplayValueOnlyCapable) || ((DisplayValueOnlyCapable)parent).getDisplayValueOnlyStyleClass() == null) continue;
                return ((DisplayValueOnlyCapable)parent).getDisplayValueOnlyStyleClass();
            }
        }
        return null;
    }

    public static String getDisplayValueOnlyStyle(UIComponent component) {
        if (component instanceof DisplayValueOnlyCapable) {
            if (((DisplayValueOnlyCapable)component).getDisplayValueOnlyStyle() != null) {
                return ((DisplayValueOnlyCapable)component).getDisplayValueOnlyStyle();
            }
            UIComponent parent = component;
            while ((parent = parent.getParent()) != null) {
                if (!(parent instanceof DisplayValueOnlyCapable) || ((DisplayValueOnlyCapable)parent).getDisplayValueOnlyStyle() == null) continue;
                return ((DisplayValueOnlyCapable)parent).getDisplayValueOnlyStyle();
            }
        }
        return null;
    }

    public static boolean isDisplayValueOnly(UIComponent component) {
        if (component instanceof DisplayValueOnlyCapable) {
            if (((DisplayValueOnlyCapable)component).isSetDisplayValueOnly()) {
                return ((DisplayValueOnlyCapable)component).isDisplayValueOnly();
            }
            UIComponent parent = component;
            while ((parent = parent.getParent()) != null) {
                if (!(parent instanceof DisplayValueOnlyCapable) || !((DisplayValueOnlyCapable)parent).isSetDisplayValueOnly()) continue;
                return ((DisplayValueOnlyCapable)parent).isDisplayValueOnly();
            }
        }
        return false;
    }

    public static void renderDisplayValueOnly(FacesContext facesContext, UIInput input) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("span", (UIComponent)input);
        HtmlRendererUtils.writeIdIfNecessary(writer, (UIComponent)input, facesContext);
        HtmlRendererUtils.renderDisplayValueOnlyAttributes((UIComponent)input, writer);
        String strValue = RendererUtils.getStringValue(facesContext, (UIComponent)input);
        writer.write(HTMLEncoder.encode(strValue, true, true));
        writer.endElement("span");
    }

    public static void appendClearHiddenCommandFormParamsFunctionCall(StringBuffer buf, String formName) {
        HtmlRendererUtils.appendClearHiddenCommandFormParamsFunctionCall(new ScriptContext(buf, false), formName);
    }

    private static void appendClearHiddenCommandFormParamsFunctionCall(ScriptContext context, String formName) {
        String functionName = HtmlRendererUtils.getClearHiddenCommandFormParamsFunctionName(formName);
        if (formName == null) {
            context.prettyLine();
            context.append("var clearFn = ");
            context.append(functionName);
            context.append(";");
            context.prettyLine();
            context.append("if(typeof window[clearFn] =='function')");
            context.append("{");
            context.append("window[clearFn](formName);");
            context.append("}");
        } else {
            context.prettyLine();
            context.append("if(typeof window.");
            context.append(functionName);
            context.append("=='function')");
            context.append("{");
            context.append(functionName).append("('").append(formName).append("');");
            context.append("}");
        }
    }

    public static void renderFormSubmitScript(FacesContext facesContext) throws IOException {
        Map map = facesContext.getExternalContext().getRequestMap();
        Boolean firstScript = (Boolean)map.get(FIRST_SUBMIT_SCRIPT_ON_PAGE);
        if (firstScript == null || firstScript.equals(Boolean.TRUE)) {
            map.put(FIRST_SUBMIT_SCRIPT_ON_PAGE, Boolean.FALSE);
            HtmlRendererUtils.renderFormSubmitScriptIfNecessary(facesContext);
        }
    }

    private static void renderFormSubmitScriptIfNecessary(FacesContext facesContext) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        ExternalContext externalContext = facesContext.getExternalContext();
        MyfacesConfig currentInstance = MyfacesConfig.getCurrentInstance(externalContext);
        boolean autoScroll = currentInstance.isAutoScroll();
        ScriptContext context = new ScriptContext(currentInstance.isPrettyHtml());
        context.prettyLine();
        context.increaseIndent();
        HtmlRendererUtils.prepareScript(context, autoScroll);
        writer.writeText((Object)context.toString(), null);
        writer.endElement("script");
    }

    private static void prepareScript(ScriptContext context, boolean autoScroll) {
        context.prettyLine();
        context.append("function ");
        context.append(SET_HIDDEN_INPUT_FN_NAME).append("(formname, name, value)");
        context.append("{");
        context.append("var form = document.forms[formname];");
        context.prettyLine();
        context.append("if(typeof form.elements[name]!='undefined' && form.elements[name].nodeName=='INPUT')");
        context.append("{");
        context.append("form.elements[name].value=value;");
        context.append("}");
        context.append("else");
        context.append("{");
        context.append("var newInput = document.createElement('input');");
        context.prettyLine();
        context.append("newInput.setAttribute('type','hidden');");
        context.prettyLine();
        context.append("newInput.setAttribute('id',name);");
        context.prettyLine();
        context.append("newInput.setAttribute('name',name);");
        context.prettyLine();
        context.append("newInput.setAttribute('value',value);");
        context.prettyLine();
        context.append("form.appendChild(newInput);");
        context.append("}");
        context.append("}");
        context.prettyLine();
        context.prettyLine();
        context.append("function ");
        context.append(CLEAR_HIDDEN_INPUT_FN_NAME).append("(formname, name, value)");
        context.append("{");
        context.append("var form = document.forms[formname];");
        context.prettyLine();
        context.append("var hInput = form.elements[name];");
        context.prettyLine();
        context.append("if(typeof hInput !='undefined')");
        context.append("{");
        context.append("form.removeChild(hInput);");
        context.append("}");
        context.append("}");
        context.prettyLine();
        context.append("function ");
        context.append(SUBMIT_FORM_FN_NAME).append("(formName, linkId, target, params)");
        context.append("{");
        HtmlRendererUtils.appendClearHiddenCommandFormParamsFunctionCall(context, null);
        if (autoScroll) {
            HtmlRendererUtils.appendAutoScrollAssignment(context, null);
        }
        context.prettyLine();
        context.append("var form = document.forms[formName];");
        context.prettyLine();
        if (JavascriptUtils.isSaveFormSubmitLinkIE(FacesContext.getCurrentInstance().getExternalContext())) {
            context.append("var agentString = navigator.userAgent.toLowerCase();");
            context.prettyLine();
            context.prettyLine();
            context.append("if (agentString.indexOf('msie') != -1)");
            context.append("{");
            context.append("if (!(agentString.indexOf('ppc') != -1 && agentString.indexOf('windows ce') != -1 && version >= 4.0))");
            context.append("{");
            context.append("window.external.AutoCompleteSaveForm(form);");
            context.append("}");
            context.append("}");
            context.prettyLine();
        }
        context.append("var oldTarget = form.target;");
        context.prettyLine();
        context.append("if(target != null)");
        context.append("{");
        context.prettyLine();
        context.append("form.target=target;");
        context.append("}");
        context.append("if((typeof params!='undefined') && params != null)");
        context.append("{");
        context.prettyLine();
        context.append("for(var i=0, param; (param = params[i]); i++)");
        context.append("{");
        context.append(SET_HIDDEN_INPUT_FN_NAME).append("(formName,param[0], param[1]);");
        context.append("}");
        context.append("}");
        context.prettyLine();
        context.append(SET_HIDDEN_INPUT_FN_NAME);
        context.append("(formName,formName +':'+'_idcl',linkId);");
        context.prettyLine();
        context.prettyLine();
        context.append("if(form.onsubmit)");
        context.append("{");
        context.append("var result=form.onsubmit();");
        context.prettyLine();
        context.append("if((typeof result=='undefined')||result)");
        context.append("{");
        context.append("try");
        context.append("{");
        context.append("form.submit();");
        context.append("}");
        context.append("catch(e){}");
        context.append("}");
        context.append("}");
        context.append("else ");
        context.append("{");
        context.append("try");
        context.append("{");
        context.append("form.submit();");
        context.append("}");
        context.append("catch(e){}");
        context.append("}");
        context.prettyLine();
        context.append("form.target=oldTarget;");
        context.prettyLine();
        context.append("if((typeof params!='undefined') && params != null)");
        context.append("{");
        context.prettyLine();
        context.append("for(var i=0, param; (param = params[i]); i++)");
        context.append("{");
        context.append(CLEAR_HIDDEN_INPUT_FN_NAME).append("(formName,param[0], param[1]);");
        context.append("}");
        context.append("}");
        context.prettyLine();
        context.append(CLEAR_HIDDEN_INPUT_FN_NAME);
        context.append("(formName,formName +':'+'_idcl',linkId);");
        context.append("return false;");
        context.append("}");
        context.prettyLineDecreaseIndent();
    }

    public static void appendAutoScrollAssignment(StringBuffer onClickValue, String formName) {
        HtmlRendererUtils.appendAutoScrollAssignment(new ScriptContext(onClickValue, false), formName);
    }

    private static void appendAutoScrollAssignment(ScriptContext scriptContext, String formName) {
        String formNameStr = formName == null ? "formName" : new StringBuffer("'").append(formName).append("'").toString();
        String paramName = new StringBuffer().append("'").append(AUTO_SCROLL_PARAM).append("'").toString();
        String value = new StringBuffer().append(AUTO_SCROLL_FUNCTION).append("()").toString();
        scriptContext.prettyLine();
        scriptContext.append("if(typeof window.getScrolling!='undefined')");
        scriptContext.append("{");
        scriptContext.append(SET_HIDDEN_INPUT_FN_NAME);
        scriptContext.append("(").append(formNameStr).append(",").append(paramName).append(",").append(value).append(");");
        scriptContext.append("}");
    }

    public static void renderAutoScrollHiddenInput(FacesContext facesContext, ResponseWriter writer) throws IOException {
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        writer.startElement("input", null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("name", (Object)AUTO_SCROLL_PARAM, null);
        writer.endElement("input");
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
    }

    public static void renderAutoScrollFunction(FacesContext facesContext, ResponseWriter writer) throws IOException {
        String scrolling;
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        ScriptContext script = new ScriptContext(MyfacesConfig.getCurrentInstance(facesContext.getExternalContext()).isPrettyHtml());
        script.prettyLineIncreaseIndent();
        script.append("function ");
        script.append(AUTO_SCROLL_FUNCTION);
        script.append("()");
        script.append("{");
        script.append("var x = 0; var y = 0;");
        script.append("if (self.pageXOffset || self.pageYOffset)");
        script.append("{");
        script.append("x = self.pageXOffset;");
        script.prettyLine();
        script.append("y = self.pageYOffset;");
        script.append("}");
        script.append(" else if ((document.documentElement && document.documentElement.scrollLeft)||(document.documentElement && document.documentElement.scrollTop))");
        script.append("{");
        script.append("x = document.documentElement.scrollLeft;");
        script.prettyLine();
        script.append("y = document.documentElement.scrollTop;");
        script.append("}");
        script.append(" else if (document.body) ");
        script.append("{");
        script.append("x = document.body.scrollLeft;");
        script.prettyLine();
        script.append("y = document.body.scrollTop;");
        script.append("}");
        script.append("return x + \",\" + y;");
        script.append("}");
        ExternalContext externalContext = facesContext.getExternalContext();
        String oldViewId = JavascriptUtils.getOldViewId(externalContext);
        if (oldViewId != null && oldViewId.equals(facesContext.getViewRoot().getViewId()) && (scrolling = (String)externalContext.getRequestParameterMap().get(AUTO_SCROLL_PARAM)) != null && scrolling.length() > 0) {
            int x = 0;
            int y = 0;
            int comma = scrolling.indexOf(44);
            if (comma == -1) {
                log.warn((Object)("Illegal autoscroll request parameter: " + scrolling));
            } else {
                try {
                    x = Integer.parseInt(scrolling.substring(0, comma));
                }
                catch (NumberFormatException e) {
                    log.warn((Object)("Error getting x offset for autoscroll feature. Bad param value: " + scrolling));
                    x = 0;
                }
                try {
                    y = Integer.parseInt(scrolling.substring(comma + 1));
                }
                catch (NumberFormatException e) {
                    log.warn((Object)("Error getting y offset for autoscroll feature. Bad param value: " + scrolling));
                    y = 0;
                }
            }
            script.append("window.scrollTo(").append(x).append(",").append(y).append(");\n");
        }
        writer.writeText((Object)script.toString(), null);
        writer.endElement("script");
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
    }

    public static boolean isAllowedCdataSection(FacesContext fc) {
        Boolean value = null;
        if (fc != null) {
            value = (Boolean)fc.getExternalContext().getRequestMap().get(ALLOW_CDATA_SECTION_ON);
        }
        return value != null && value != false;
    }

    public static void allowCdataSection(FacesContext fc, boolean cdataSectionAllowed) {
        fc.getExternalContext().getRequestMap().put(ALLOW_CDATA_SECTION_ON, cdataSectionAllowed);
    }

    public static void renderHiddenCommandFormParams(ResponseWriter writer, Set dummyFormParams) throws IOException {
        for (Object name : dummyFormParams) {
            HtmlRendererUtils.renderHiddenInputField(writer, name, null);
        }
    }

    public static void renderHiddenInputField(ResponseWriter writer, Object name, Object value) throws IOException {
        writer.startElement("input", null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("name", name, null);
        if (value != null) {
            writer.writeAttribute("value", value, null);
        }
        writer.endElement("input");
    }

    @Deprecated
    public static void renderLabel(ResponseWriter writer, UIComponent component, String forClientId, String labelValue, boolean disabled) throws IOException {
        writer.startElement("label", component);
        writer.writeAttribute("for", (Object)forClientId, null);
        String labelClass = null;
        labelClass = disabled ? (String)component.getAttributes().get("disabledClass") : (String)component.getAttributes().get("enabledClass");
        if (labelClass != null) {
            writer.writeAttribute("class", (Object)labelClass, "labelClass");
        }
        if (labelValue != null && labelValue.length() > 0) {
            writer.write("&#160;");
            writer.writeText((Object)labelValue, null);
        }
        writer.endElement("label");
    }

    public static void renderLabel(ResponseWriter writer, UIComponent component, String forClientId, SelectItem item, boolean disabled) throws IOException {
        writer.startElement("label", component);
        writer.writeAttribute("for", (Object)forClientId, null);
        String labelClass = null;
        labelClass = disabled ? (String)component.getAttributes().get("disabledClass") : (String)component.getAttributes().get("enabledClass");
        if (labelClass != null) {
            writer.writeAttribute("class", (Object)labelClass, "labelClass");
        }
        if (item.getLabel() != null && item.getLabel().length() > 0) {
            writer.write("&#160;");
            if (item.isEscape()) {
                writer.writeText((Object)item.getLabel(), null);
            } else {
                writer.write(item.getLabel());
            }
        }
        writer.endElement("label");
    }

    public static void renderClearHiddenCommandFormParamsFunction(ResponseWriter writer, String formName, Set dummyFormParams, String formTarget) throws IOException {
        String functionName = HtmlRendererUtils.getClearHiddenCommandFormParamsFunctionName(formName);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        StringBuffer script = new StringBuffer();
        script.append("function ");
        script.append(functionName);
        script.append("() {");
        if (dummyFormParams != null) {
            script.append("\n  var f = document.forms['");
            script.append(formName);
            script.append("'];");
            int i = 0;
            Iterator it = dummyFormParams.iterator();
            while (it.hasNext()) {
                String elemVarName = "elem" + i;
                script.append("\n  var ").append(elemVarName).append(" = ");
                script.append("f.elements['").append((String)it.next()).append("'];");
                script.append("\n  if (").append(elemVarName).append(".value != '') {");
                script.append("\n    " + elemVarName + ".value='';");
                script.append("\n  }");
                ++i;
            }
        }
        script.append("\n  f.target=");
        if (formTarget == null || formTarget.length() == 0) {
            script.append("'';");
        } else {
            script.append("'");
            script.append(formTarget);
            script.append("';");
        }
        script.append("\n}");
        script.append("\n");
        script.append(functionName);
        script.append("();");
        writer.writeText((Object)script.toString(), null);
        writer.endElement("script");
    }

    public static String getClearHiddenCommandFormParamsFunctionName(String formName) {
        if (formName == null) {
            return "'clearFormHiddenParams_'+formName.replace(/-/g, '\\$:').replace(/:/g,'_')";
        }
        return JavascriptUtils.getValidJavascriptNameAsInRI("clearFormHiddenParams_" + formName.replace(':', '_'));
    }

    public static String getClearHiddenCommandFormParamsFunctionNameMyfacesLegacy(String formName) {
        return "clear_" + JavascriptUtils.getValidJavascriptName(formName, false);
    }

    public static String getHiddenCommandLinkFieldName(FormInfo formInfo) {
        if (RendererUtils.isAdfOrTrinidadForm(formInfo.getForm())) {
            return HIDDEN_COMMANDLINK_FIELD_NAME_TRINIDAD;
        }
        return formInfo.getFormName() + ':' + HIDDEN_COMMANDLINK_FIELD_NAME;
    }

    public static String getHiddenCommandLinkFieldNameMyfacesOld(FormInfo formInfo) {
        return formInfo.getFormName() + ':' + HIDDEN_COMMANDLINK_FIELD_NAME_MYFACES_OLD;
    }

    public static String selectContentType(String contentTypeListString) {
        if (contentTypeListString == null) {
            FacesContext context = FacesContext.getCurrentInstance();
            if (context != null) {
                contentTypeListString = (String)context.getExternalContext().getRequestHeaderMap().get("Accept");
            }
            if (contentTypeListString == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"No content type list given, creating HtmlResponseWriterImpl with default content type.");
                }
                contentTypeListString = HTML_CONTENT_TYPE;
            }
        }
        List contentTypeList = HtmlRendererUtils.splitContentTypeListString(contentTypeListString);
        String[] supportedContentTypeArray = HtmlRendererUtils.getSupportedContentTypes();
        String selectedContentType = null;
        for (int i = 0; i < supportedContentTypeArray.length; ++i) {
            String supportedContentType = supportedContentTypeArray[i].trim();
            for (int j = 0; j < contentTypeList.size(); ++j) {
                String contentType = (String)contentTypeList.get(j);
                if (contentType.indexOf(supportedContentType) == -1) continue;
                if (HtmlRendererUtils.isHTMLContentType(contentType)) {
                    selectedContentType = HTML_CONTENT_TYPE;
                    break;
                }
                if (!HtmlRendererUtils.isXHTMLContentType(contentType)) break;
                selectedContentType = XHTML_CONTENT_TYPE;
                break;
            }
            if (selectedContentType != null) break;
        }
        if (selectedContentType == null) {
            throw new IllegalArgumentException("ContentTypeList does not contain a supported content type: " + contentTypeListString);
        }
        return selectedContentType;
    }

    public static String[] getSupportedContentTypes() {
        String[] supportedContentTypeArray = new String[]{HTML_CONTENT_TYPE, ANY_CONTENT_TYPE, XHTML_CONTENT_TYPE, APPLICATION_XML_CONTENT_TYPE, TEXT_XML_CONTENT_TYPE};
        return supportedContentTypeArray;
    }

    private static boolean isHTMLContentType(String contentType) {
        return contentType.indexOf(HTML_CONTENT_TYPE) != -1 || contentType.indexOf(ANY_CONTENT_TYPE) != -1 || contentType.indexOf(TEXT_ANY_CONTENT_TYPE) != -1;
    }

    public static boolean isXHTMLContentType(String contentType) {
        return contentType.indexOf(XHTML_CONTENT_TYPE) != -1 || contentType.indexOf(APPLICATION_XML_CONTENT_TYPE) != -1 || contentType.indexOf(TEXT_XML_CONTENT_TYPE) != -1;
    }

    private static List splitContentTypeListString(String contentTypeListString) {
        ArrayList<String> contentTypeList = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(contentTypeListString, ",");
        while (st.hasMoreTokens()) {
            String contentType = st.nextToken().trim();
            int semicolonIndex = contentType.indexOf(";");
            if (semicolonIndex != -1) {
                contentType = contentType.substring(0, semicolonIndex);
            }
            contentTypeList.add(contentType);
        }
        return contentTypeList;
    }

    public static String getJavascriptLocation(UIComponent component) {
        if (component == null) {
            return null;
        }
        return (String)component.getAttributes().get("org.apache.myfaces.JAVASCRIPT_LOCATION");
    }

    public static String getImageLocation(UIComponent component) {
        if (component == null) {
            return null;
        }
        return (String)component.getAttributes().get("org.apache.myfaces.IMAGE_LOCATION");
    }

    public static String getStyleLocation(UIComponent component) {
        if (component == null) {
            return null;
        }
        return (String)component.getAttributes().get("org.apache.myfaces.STYLE_LOCATION");
    }

    public static void renderViewStateJavascript(FacesContext facesContext, String hiddenId, String serializedState) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        ExternalContext externalContext = facesContext.getExternalContext();
        MyfacesConfig currentInstance = MyfacesConfig.getCurrentInstance(externalContext);
        ScriptContext context = new ScriptContext(currentInstance.isPrettyHtml());
        context.prettyLine();
        context.increaseIndent();
        context.append("function setViewState() {\n");
        context.append("\tvar state = '");
        context.append(serializedState);
        context.append("';\n");
        context.append("\tfor (var i = 0; i < document.forms.length; i++) {\n");
        context.append("\t\tdocument.forms[i]['" + hiddenId + "'].value = state;\n");
        context.append("\t}\n");
        context.append("}\n");
        context.append("setViewState();\n");
        context.decreaseIndent();
        writer.writeText((Object)context.toString(), null);
        writer.endElement("script");
    }

    public static class ScriptContext {
        private long currentIndentationLevel;
        private StringBuffer buffer = new StringBuffer();
        private boolean prettyPrint = false;
        private boolean automaticFormatting = true;

        public ScriptContext() {
        }

        public ScriptContext(boolean prettyPrint) {
            this.prettyPrint = prettyPrint;
        }

        public ScriptContext(StringBuffer buf, boolean prettyPrint) {
            this.prettyPrint = prettyPrint;
            this.buffer = buf;
        }

        public void increaseIndent() {
            ++this.currentIndentationLevel;
        }

        public void decreaseIndent() {
            --this.currentIndentationLevel;
            if (this.currentIndentationLevel < 0L) {
                this.currentIndentationLevel = 0L;
            }
        }

        public void prettyLine() {
            if (this.prettyPrint) {
                this.append(LINE_SEPARATOR);
                int i = 0;
                while ((long)i < this.getCurrentIndentationLevel()) {
                    this.append('\t');
                    ++i;
                }
            }
        }

        public void prettyLineIncreaseIndent() {
            this.increaseIndent();
            this.prettyLine();
        }

        public void prettyLineDecreaseIndent() {
            this.decreaseIndent();
            this.prettyLine();
        }

        public long getCurrentIndentationLevel() {
            return this.currentIndentationLevel;
        }

        public void setCurrentIndentationLevel(long currentIndentationLevel) {
            this.currentIndentationLevel = currentIndentationLevel;
        }

        public ScriptContext append(String str) {
            if (this.automaticFormatting && str.length() == 1) {
                boolean openBlock = str.equals("{");
                boolean closeBlock = str.equals("}");
                if (openBlock) {
                    this.prettyLine();
                } else if (closeBlock) {
                    this.prettyLineDecreaseIndent();
                }
                this.buffer.append(str);
                if (openBlock) {
                    this.prettyLineIncreaseIndent();
                } else if (closeBlock) {
                    this.prettyLine();
                }
            } else {
                this.buffer.append(str);
            }
            return this;
        }

        public ScriptContext append(char c) {
            this.buffer.append(c);
            return this;
        }

        public ScriptContext append(int i) {
            this.buffer.append(i);
            return this;
        }

        public String toString() {
            return this.buffer.toString();
        }
    }

    public static class LinkParameter {
        private String _name;
        private Object _value;

        public String getName() {
            return this._name;
        }

        public void setName(String name) {
            this._name = name;
        }

        public Object getValue() {
            return this._value;
        }

        public void setValue(Object value) {
            this._value = value;
        }
    }
}

